/**********************************************************************
 * $my_monitor1 example -- C source code using TF PLI routines
 *
 * C source to call the misctf routine asynchronously whenever an
 * argument to a system task/function changes value.
 *
 * For the book, "The Verilog PLI Handbook" by Stuart Sutherland
 *  Book copyright 1999, Kluwer Academic Publishers, Norwell, MA, USA
 *   Contact: www.wkap.il
 *  Example copyright 1998, Sutherland HDL Inc, Portland, Oregon, USA
 *   Contact: www.sutherland.com or (503) 692-0898
 *
 * Usage:
 * ------
 *   $my_monitor1(<signal_name>,<signal_name>,...);
 *
 * Routine definitions for a veriusertfs array:
 *  /* routine prototypes -/
 *   extern int PLIbook_MyMonitor1_calltf(),
 *              PLIbook_MyMonitor1_misctf();
 *  /* table entries -/
 *   {usertask,                       /* type of PLI routine -/
 *     0,                             /* user_data value -/
 *     0,                             /* checktf routine -/
 *     0,                             /* sizetf routine -/
 *     PLIbook_MyMonitor1_calltf,     /* calltf routine -/
 *     PLIbook_MyMonitor1_misctf,     /* misctf routine -/
 *     "$my_monitor1",                /* system task/function name -/
 *     1                              /* forward reference = true -/
 *   },
 *********************************************************************/

#include "veriuser.h"         /* IEEE 1364 PLI TF  routine library */

/**********************************************************************
 * calltf routine
 *********************************************************************/
int PLIbook_MyMonitor1_calltf() {
  tf_asynchon();  /* enable asynchronous misctf callbacks */
  return(0); 
}

/**********************************************************************
 * misctf routine
 *********************************************************************/
int PLIbook_MyMonitor1_misctf(int user_data, int reason, int paramvc)
{
  if (reason == REASON_PARAMVC) {
    io_printf("At %s: tfarg %d changed, new value is %s:\n",
              tf_strgettime(), paramvc, tf_strgetp(paramvc,'b')); 
  }
  return(0); 
}
/*********************************************************************/
