# For arch13 and above.
# RUN: llvm-mc -triple s390x-linux-gnu -mcpu=arch13 -show-encoding %s \
# RUN:   | FileCheck %s

#CHECK: dfltcc	%r2, %r2, %r2           # encoding: [0xb9,0x39,0x20,0x22]
#CHECK: dfltcc	%r2, %r8, %r15          # encoding: [0xb9,0x39,0xf0,0x28]
#CHECK: dfltcc	%r14, %r8, %r2          # encoding: [0xb9,0x39,0x20,0xe8]
#CHECK: dfltcc	%r6, %r8, %r10          # encoding: [0xb9,0x39,0xa0,0x68]

	dfltcc	%r2, %r2, %r2
	dfltcc	%r2, %r8, %r15
	dfltcc	%r14, %r8, %r2
	dfltcc	%r6, %r8, %r10

#CHECK: kdsa	%r0, %r2                # encoding: [0xb9,0x3a,0x00,0x02]
#CHECK: kdsa	%r0, %r14               # encoding: [0xb9,0x3a,0x00,0x0e]
#CHECK: kdsa	%r15, %r2               # encoding: [0xb9,0x3a,0x00,0xf2]
#CHECK: kdsa	%r7, %r10               # encoding: [0xb9,0x3a,0x00,0x7a]

	kdsa	%r0, %r2
	kdsa	%r0, %r14
	kdsa	%r15, %r2
	kdsa	%r7, %r10

#CHECK: vllebrzg %v0, 0                 # encoding: [0xe6,0x00,0x00,0x00,0x30,0x04]
#CHECK: vllebrzg %v0, 4095              # encoding: [0xe6,0x00,0x0f,0xff,0x30,0x04]
#CHECK: vllebrzg %v0, 0(%r15)           # encoding: [0xe6,0x00,0xf0,0x00,0x30,0x04]
#CHECK: vllebrzg %v0, 0(%r15,%r1)       # encoding: [0xe6,0x0f,0x10,0x00,0x30,0x04]
#CHECK: vllebrzg %v15, 0                # encoding: [0xe6,0xf0,0x00,0x00,0x30,0x04]
#CHECK: vllebrzg %v31, 0                # encoding: [0xe6,0xf0,0x00,0x00,0x38,0x04]
#CHECK: vllebrzg %v18, 1383(%r3,%r4)    # encoding: [0xe6,0x23,0x45,0x67,0x38,0x04]

	ldrv	%f0, 0
	ldrv	%f0, 4095
	ldrv	%f0, 0(%r15)
	ldrv	%f0, 0(%r15,%r1)
	ldrv	%f15, 0
	ldrv	%v31, 0
	ldrv	%v18, 0x567(%r3,%r4)

#CHECK: vllebrze %v0, 0                 # encoding: [0xe6,0x00,0x00,0x00,0x60,0x04]
#CHECK: vllebrze %v0, 4095              # encoding: [0xe6,0x00,0x0f,0xff,0x60,0x04]
#CHECK: vllebrze %v0, 0(%r15)           # encoding: [0xe6,0x00,0xf0,0x00,0x60,0x04]
#CHECK: vllebrze %v0, 0(%r15,%r1)       # encoding: [0xe6,0x0f,0x10,0x00,0x60,0x04]
#CHECK: vllebrze %v15, 0                # encoding: [0xe6,0xf0,0x00,0x00,0x60,0x04]
#CHECK: vllebrze %v31, 0                # encoding: [0xe6,0xf0,0x00,0x00,0x68,0x04]
#CHECK: vllebrze %v18, 1383(%r3,%r4)    # encoding: [0xe6,0x23,0x45,0x67,0x68,0x04]

	lerv	%f0, 0
	lerv	%f0, 4095
	lerv	%f0, 0(%r15)
	lerv	%f0, 0(%r15,%r1)
	lerv	%f15, 0
	lerv	%v31, 0
	lerv	%v18, 0x567(%r3,%r4)

#CHECK: mvcrl	0, 0                    # encoding: [0xe5,0x0a,0x00,0x00,0x00,0x00]
#CHECK: mvcrl	0(%r1), 0(%r2)          # encoding: [0xe5,0x0a,0x10,0x00,0x20,0x00]
#CHECK: mvcrl	160(%r1), 320(%r15)     # encoding: [0xe5,0x0a,0x10,0xa0,0xf1,0x40]
#CHECK: mvcrl	0(%r1), 4095            # encoding: [0xe5,0x0a,0x10,0x00,0x0f,0xff]
#CHECK: mvcrl	0(%r1), 4095(%r2)       # encoding: [0xe5,0x0a,0x10,0x00,0x2f,0xff]
#CHECK: mvcrl	0(%r1), 4095(%r15)      # encoding: [0xe5,0x0a,0x10,0x00,0xff,0xff]
#CHECK: mvcrl	0(%r1), 0               # encoding: [0xe5,0x0a,0x10,0x00,0x00,0x00]
#CHECK: mvcrl	0(%r15), 0              # encoding: [0xe5,0x0a,0xf0,0x00,0x00,0x00]
#CHECK: mvcrl	4095(%r1), 0            # encoding: [0xe5,0x0a,0x1f,0xff,0x00,0x00]
#CHECK: mvcrl	4095(%r15), 0           # encoding: [0xe5,0x0a,0xff,0xff,0x00,0x00]

	mvcrl	0, 0
	mvcrl	0(%r1), 0(%r2)
	mvcrl	160(%r1), 320(%r15)
	mvcrl	0(%r1), 4095
	mvcrl	0(%r1), 4095(%r2)
	mvcrl	0(%r1), 4095(%r15)
	mvcrl	0(%r1), 0
	mvcrl	0(%r15), 0
	mvcrl	4095(%r1), 0
	mvcrl	4095(%r15), 0

#CHECK: ncgrk	%r0, %r0, %r0           # encoding: [0xb9,0xe5,0x00,0x00]
#CHECK: ncgrk	%r0, %r0, %r15          # encoding: [0xb9,0xe5,0xf0,0x00]
#CHECK: ncgrk	%r0, %r15, %r0          # encoding: [0xb9,0xe5,0x00,0x0f]
#CHECK: ncgrk	%r15, %r0, %r0          # encoding: [0xb9,0xe5,0x00,0xf0]
#CHECK: ncgrk	%r7, %r8, %r9           # encoding: [0xb9,0xe5,0x90,0x78]

	ncgrk	%r0,%r0,%r0
	ncgrk	%r0,%r0,%r15
	ncgrk	%r0,%r15,%r0
	ncgrk	%r15,%r0,%r0
	ncgrk	%r7,%r8,%r9

#CHECK: ncrk	%r0, %r0, %r0           # encoding: [0xb9,0xf5,0x00,0x00]
#CHECK: ncrk	%r0, %r0, %r15          # encoding: [0xb9,0xf5,0xf0,0x00]
#CHECK: ncrk	%r0, %r15, %r0          # encoding: [0xb9,0xf5,0x00,0x0f]
#CHECK: ncrk	%r15, %r0, %r0          # encoding: [0xb9,0xf5,0x00,0xf0]
#CHECK: ncrk	%r7, %r8, %r9           # encoding: [0xb9,0xf5,0x90,0x78]

	ncrk	%r0,%r0,%r0
	ncrk	%r0,%r0,%r15
	ncrk	%r0,%r15,%r0
	ncrk	%r15,%r0,%r0
	ncrk	%r7,%r8,%r9

#CHECK: nngrk	%r0, %r0, %r0           # encoding: [0xb9,0x64,0x00,0x00]
#CHECK: nngrk	%r0, %r0, %r15          # encoding: [0xb9,0x64,0xf0,0x00]
#CHECK: nngrk	%r0, %r15, %r0          # encoding: [0xb9,0x64,0x00,0x0f]
#CHECK: nngrk	%r15, %r0, %r0          # encoding: [0xb9,0x64,0x00,0xf0]
#CHECK: nngrk	%r7, %r8, %r9           # encoding: [0xb9,0x64,0x90,0x78]

	nngrk	%r0,%r0,%r0
	nngrk	%r0,%r0,%r15
	nngrk	%r0,%r15,%r0
	nngrk	%r15,%r0,%r0
	nngrk	%r7,%r8,%r9

#CHECK: nnrk	%r0, %r0, %r0           # encoding: [0xb9,0x74,0x00,0x00]
#CHECK: nnrk	%r0, %r0, %r15          # encoding: [0xb9,0x74,0xf0,0x00]
#CHECK: nnrk	%r0, %r15, %r0          # encoding: [0xb9,0x74,0x00,0x0f]
#CHECK: nnrk	%r15, %r0, %r0          # encoding: [0xb9,0x74,0x00,0xf0]
#CHECK: nnrk	%r7, %r8, %r9           # encoding: [0xb9,0x74,0x90,0x78]

	nnrk	%r0,%r0,%r0
	nnrk	%r0,%r0,%r15
	nnrk	%r0,%r15,%r0
	nnrk	%r15,%r0,%r0
	nnrk	%r7,%r8,%r9

#CHECK: nogrk	%r0, %r0, %r0           # encoding: [0xb9,0x66,0x00,0x00]
#CHECK: nogrk	%r0, %r0, %r15          # encoding: [0xb9,0x66,0xf0,0x00]
#CHECK: nogrk	%r0, %r15, %r0          # encoding: [0xb9,0x66,0x00,0x0f]
#CHECK: nogrk	%r15, %r0, %r0          # encoding: [0xb9,0x66,0x00,0xf0]
#CHECK: nogrk	%r7, %r8, %r9           # encoding: [0xb9,0x66,0x90,0x78]

	nogrk	%r0,%r0,%r0
	nogrk	%r0,%r0,%r15
	nogrk	%r0,%r15,%r0
	nogrk	%r15,%r0,%r0
	nogrk	%r7,%r8,%r9

#CHECK: nork	%r0, %r0, %r0           # encoding: [0xb9,0x76,0x00,0x00]
#CHECK: nork	%r0, %r0, %r15          # encoding: [0xb9,0x76,0xf0,0x00]
#CHECK: nork	%r0, %r15, %r0          # encoding: [0xb9,0x76,0x00,0x0f]
#CHECK: nork	%r15, %r0, %r0          # encoding: [0xb9,0x76,0x00,0xf0]
#CHECK: nork	%r7, %r8, %r9           # encoding: [0xb9,0x76,0x90,0x78]

	nork	%r0,%r0,%r0
	nork	%r0,%r0,%r15
	nork	%r0,%r15,%r0
	nork	%r15,%r0,%r0
	nork	%r7,%r8,%r9

#CHECK: nxgrk	%r0, %r0, %r0           # encoding: [0xb9,0x67,0x00,0x00]
#CHECK: nxgrk	%r0, %r0, %r15          # encoding: [0xb9,0x67,0xf0,0x00]
#CHECK: nxgrk	%r0, %r15, %r0          # encoding: [0xb9,0x67,0x00,0x0f]
#CHECK: nxgrk	%r15, %r0, %r0          # encoding: [0xb9,0x67,0x00,0xf0]
#CHECK: nxgrk	%r7, %r8, %r9           # encoding: [0xb9,0x67,0x90,0x78]

	nxgrk	%r0,%r0,%r0
	nxgrk	%r0,%r0,%r15
	nxgrk	%r0,%r15,%r0
	nxgrk	%r15,%r0,%r0
	nxgrk	%r7,%r8,%r9

#CHECK: nxrk	%r0, %r0, %r0           # encoding: [0xb9,0x77,0x00,0x00]
#CHECK: nxrk	%r0, %r0, %r15          # encoding: [0xb9,0x77,0xf0,0x00]
#CHECK: nxrk	%r0, %r15, %r0          # encoding: [0xb9,0x77,0x00,0x0f]
#CHECK: nxrk	%r15, %r0, %r0          # encoding: [0xb9,0x77,0x00,0xf0]
#CHECK: nxrk	%r7, %r8, %r9           # encoding: [0xb9,0x77,0x90,0x78]

	nxrk	%r0,%r0,%r0
	nxrk	%r0,%r0,%r15
	nxrk	%r0,%r15,%r0
	nxrk	%r15,%r0,%r0
	nxrk	%r7,%r8,%r9

#CHECK: ocgrk	%r0, %r0, %r0           # encoding: [0xb9,0x65,0x00,0x00]
#CHECK: ocgrk	%r0, %r0, %r15          # encoding: [0xb9,0x65,0xf0,0x00]
#CHECK: ocgrk	%r0, %r15, %r0          # encoding: [0xb9,0x65,0x00,0x0f]
#CHECK: ocgrk	%r15, %r0, %r0          # encoding: [0xb9,0x65,0x00,0xf0]
#CHECK: ocgrk	%r7, %r8, %r9           # encoding: [0xb9,0x65,0x90,0x78]

	ocgrk	%r0,%r0,%r0
	ocgrk	%r0,%r0,%r15
	ocgrk	%r0,%r15,%r0
	ocgrk	%r15,%r0,%r0
	ocgrk	%r7,%r8,%r9

#CHECK: ocrk	%r0, %r0, %r0           # encoding: [0xb9,0x75,0x00,0x00]
#CHECK: ocrk	%r0, %r0, %r15          # encoding: [0xb9,0x75,0xf0,0x00]
#CHECK: ocrk	%r0, %r15, %r0          # encoding: [0xb9,0x75,0x00,0x0f]
#CHECK: ocrk	%r15, %r0, %r0          # encoding: [0xb9,0x75,0x00,0xf0]
#CHECK: ocrk	%r7, %r8, %r9           # encoding: [0xb9,0x75,0x90,0x78]

	ocrk	%r0,%r0,%r0
	ocrk	%r0,%r0,%r15
	ocrk	%r0,%r15,%r0
	ocrk	%r15,%r0,%r0
	ocrk	%r7,%r8,%r9

#CHECK: popcnt	%r0, %r0                # encoding: [0xb9,0xe1,0x00,0x00]
#CHECK: popcnt	%r0, %r15               # encoding: [0xb9,0xe1,0x00,0x0f]
#CHECK: popcnt	%r14, %r0               # encoding: [0xb9,0xe1,0x00,0xe0]
#CHECK: popcnt	%r6, %r8                # encoding: [0xb9,0xe1,0x00,0x68]
#CHECK: popcnt	%r4, %r13, 1            # encoding: [0xb9,0xe1,0x10,0x4d]
#CHECK: popcnt	%r4, %r13, 15           # encoding: [0xb9,0xe1,0xf0,0x4d]

	popcnt	%r0, %r0
	popcnt	%r0, %r15
	popcnt	%r14, %r0
	popcnt	%r6, %r8
	popcnt	%r4, %r13, 1
	popcnt	%r4, %r13, 15

#CHECK: selgr	%r0, %r0, %r0, 0        # encoding: [0xb9,0xe3,0x00,0x00]
#CHECK: selgr	%r0, %r0, %r0, 15       # encoding: [0xb9,0xe3,0x0f,0x00]
#CHECK: selgr	%r0, %r0, %r15, 0       # encoding: [0xb9,0xe3,0xf0,0x00]
#CHECK: selgr	%r0, %r15, %r0, 0       # encoding: [0xb9,0xe3,0x00,0x0f]
#CHECK: selgr	%r15, %r0, %r0, 0       # encoding: [0xb9,0xe3,0x00,0xf0]
#CHECK: selgr	%r7, %r8, %r9, 10       # encoding: [0xb9,0xe3,0x9a,0x78]

	selgr	%r0, %r0, %r0, 0
	selgr	%r0, %r0, %r0, 15
	selgr	%r0, %r0, %r15, 0
	selgr	%r0, %r15, %r0, 0
	selgr	%r15, %r0, %r0, 0
	selgr	%r7, %r8, %r9, 10

#CHECK: selgro   %r1, %r2, %r3          # encoding: [0xb9,0xe3,0x31,0x12]
#CHECK: selgrh   %r1, %r2, %r3          # encoding: [0xb9,0xe3,0x32,0x12]
#CHECK: selgrp   %r1, %r2, %r3          # encoding: [0xb9,0xe3,0x32,0x12]
#CHECK: selgrnle %r1, %r2, %r3          # encoding: [0xb9,0xe3,0x33,0x12]
#CHECK: selgrl   %r1, %r2, %r3          # encoding: [0xb9,0xe3,0x34,0x12]
#CHECK: selgrm   %r1, %r2, %r3          # encoding: [0xb9,0xe3,0x34,0x12]
#CHECK: selgrnhe %r1, %r2, %r3          # encoding: [0xb9,0xe3,0x35,0x12]
#CHECK: selgrlh  %r1, %r2, %r3          # encoding: [0xb9,0xe3,0x36,0x12]
#CHECK: selgrne  %r1, %r2, %r3          # encoding: [0xb9,0xe3,0x37,0x12]
#CHECK: selgrnz  %r1, %r2, %r3          # encoding: [0xb9,0xe3,0x37,0x12]
#CHECK: selgre   %r1, %r2, %r3          # encoding: [0xb9,0xe3,0x38,0x12]
#CHECK: selgrz   %r1, %r2, %r3          # encoding: [0xb9,0xe3,0x38,0x12]
#CHECK: selgrnlh %r1, %r2, %r3          # encoding: [0xb9,0xe3,0x39,0x12]
#CHECK: selgrhe  %r1, %r2, %r3          # encoding: [0xb9,0xe3,0x3a,0x12]
#CHECK: selgrnl  %r1, %r2, %r3          # encoding: [0xb9,0xe3,0x3b,0x12]
#CHECK: selgrnm  %r1, %r2, %r3          # encoding: [0xb9,0xe3,0x3b,0x12]
#CHECK: selgrle  %r1, %r2, %r3          # encoding: [0xb9,0xe3,0x3c,0x12]
#CHECK: selgrnh  %r1, %r2, %r3          # encoding: [0xb9,0xe3,0x3d,0x12]
#CHECK: selgrnp  %r1, %r2, %r3          # encoding: [0xb9,0xe3,0x3d,0x12]
#CHECK: selgrno  %r1, %r2, %r3          # encoding: [0xb9,0xe3,0x3e,0x12]

	selgro   %r1, %r2, %r3
	selgrh   %r1, %r2, %r3
	selgrp   %r1, %r2, %r3
	selgrnle %r1, %r2, %r3
	selgrl   %r1, %r2, %r3
	selgrm   %r1, %r2, %r3
	selgrnhe %r1, %r2, %r3
	selgrlh  %r1, %r2, %r3
	selgrne  %r1, %r2, %r3
	selgrnz  %r1, %r2, %r3
	selgre   %r1, %r2, %r3
	selgrz   %r1, %r2, %r3
	selgrnlh %r1, %r2, %r3
	selgrhe  %r1, %r2, %r3
	selgrnl  %r1, %r2, %r3
	selgrnm  %r1, %r2, %r3
	selgrle  %r1, %r2, %r3
	selgrnh  %r1, %r2, %r3
	selgrnp  %r1, %r2, %r3
	selgrno  %r1, %r2, %r3

#CHECK: selfhr	%r0, %r0, %r0, 0         # encoding: [0xb9,0xc0,0x00,0x00]
#CHECK: selfhr	%r0, %r0, %r0, 15        # encoding: [0xb9,0xc0,0x0f,0x00]
#CHECK: selfhr	%r0, %r0, %r15, 0        # encoding: [0xb9,0xc0,0xf0,0x00]
#CHECK: selfhr	%r0, %r15, %r0, 0        # encoding: [0xb9,0xc0,0x00,0x0f]
#CHECK: selfhr	%r15, %r0, %r0, 0        # encoding: [0xb9,0xc0,0x00,0xf0]
#CHECK: selfhr	%r7, %r8, %r9, 10        # encoding: [0xb9,0xc0,0x9a,0x78]

	selfhr	%r0, %r0, %r0, 0
	selfhr	%r0, %r0, %r0, 15
	selfhr	%r0, %r0, %r15, 0
	selfhr	%r0, %r15, %r0, 0
	selfhr	%r15, %r0, %r0, 0
	selfhr	%r7, %r8, %r9, 10

#CHECK: selfhro   %r1, %r2, %r3         # encoding: [0xb9,0xc0,0x31,0x12]
#CHECK: selfhrh   %r1, %r2, %r3         # encoding: [0xb9,0xc0,0x32,0x12]
#CHECK: selfhrp   %r1, %r2, %r3         # encoding: [0xb9,0xc0,0x32,0x12]
#CHECK: selfhrnle %r1, %r2, %r3         # encoding: [0xb9,0xc0,0x33,0x12]
#CHECK: selfhrl   %r1, %r2, %r3         # encoding: [0xb9,0xc0,0x34,0x12]
#CHECK: selfhrm   %r1, %r2, %r3         # encoding: [0xb9,0xc0,0x34,0x12]
#CHECK: selfhrnhe %r1, %r2, %r3         # encoding: [0xb9,0xc0,0x35,0x12]
#CHECK: selfhrlh  %r1, %r2, %r3         # encoding: [0xb9,0xc0,0x36,0x12]
#CHECK: selfhrne  %r1, %r2, %r3         # encoding: [0xb9,0xc0,0x37,0x12]
#CHECK: selfhrnz  %r1, %r2, %r3         # encoding: [0xb9,0xc0,0x37,0x12]
#CHECK: selfhre   %r1, %r2, %r3         # encoding: [0xb9,0xc0,0x38,0x12]
#CHECK: selfhrz   %r1, %r2, %r3         # encoding: [0xb9,0xc0,0x38,0x12]
#CHECK: selfhrnlh %r1, %r2, %r3         # encoding: [0xb9,0xc0,0x39,0x12]
#CHECK: selfhrhe  %r1, %r2, %r3         # encoding: [0xb9,0xc0,0x3a,0x12]
#CHECK: selfhrnl  %r1, %r2, %r3         # encoding: [0xb9,0xc0,0x3b,0x12]
#CHECK: selfhrnm  %r1, %r2, %r3         # encoding: [0xb9,0xc0,0x3b,0x12]
#CHECK: selfhrle  %r1, %r2, %r3         # encoding: [0xb9,0xc0,0x3c,0x12]
#CHECK: selfhrnh  %r1, %r2, %r3         # encoding: [0xb9,0xc0,0x3d,0x12]
#CHECK: selfhrnp  %r1, %r2, %r3         # encoding: [0xb9,0xc0,0x3d,0x12]
#CHECK: selfhrno  %r1, %r2, %r3         # encoding: [0xb9,0xc0,0x3e,0x12]

	selfhro   %r1, %r2, %r3
	selfhrh   %r1, %r2, %r3
	selfhrp   %r1, %r2, %r3
	selfhrnle %r1, %r2, %r3
	selfhrl   %r1, %r2, %r3
	selfhrm   %r1, %r2, %r3
	selfhrnhe %r1, %r2, %r3
	selfhrlh  %r1, %r2, %r3
	selfhrne  %r1, %r2, %r3
	selfhrnz  %r1, %r2, %r3
	selfhre   %r1, %r2, %r3
	selfhrz   %r1, %r2, %r3
	selfhrnlh %r1, %r2, %r3
	selfhrhe  %r1, %r2, %r3
	selfhrnl  %r1, %r2, %r3
	selfhrnm  %r1, %r2, %r3
	selfhrle  %r1, %r2, %r3
	selfhrnh  %r1, %r2, %r3
	selfhrnp  %r1, %r2, %r3
	selfhrno  %r1, %r2, %r3

#CHECK: selr	%r0, %r0, %r0, 0        # encoding: [0xb9,0xf0,0x00,0x00]
#CHECK: selr	%r0, %r0, %r0, 15       # encoding: [0xb9,0xf0,0x0f,0x00]
#CHECK: selr	%r0, %r0, %r15, 0       # encoding: [0xb9,0xf0,0xf0,0x00]
#CHECK: selr	%r0, %r15, %r0, 0       # encoding: [0xb9,0xf0,0x00,0x0f]
#CHECK: selr	%r15, %r0, %r0, 0       # encoding: [0xb9,0xf0,0x00,0xf0]
#CHECK: selr	%r7, %r8, %r9, 10       # encoding: [0xb9,0xf0,0x9a,0x78]

	selr	%r0, %r0, %r0, 0
	selr	%r0, %r0, %r0, 15
	selr	%r0, %r0, %r15, 0
	selr	%r0, %r15, %r0, 0
	selr	%r15, %r0, %r0, 0
	selr	%r7, %r8, %r9, 10

#CHECK: selro   %r1, %r2, %r3           # encoding: [0xb9,0xf0,0x31,0x12]
#CHECK: selrh   %r1, %r2, %r3           # encoding: [0xb9,0xf0,0x32,0x12]
#CHECK: selrp   %r1, %r2, %r3           # encoding: [0xb9,0xf0,0x32,0x12]
#CHECK: selrnle %r1, %r2, %r3           # encoding: [0xb9,0xf0,0x33,0x12]
#CHECK: selrl   %r1, %r2, %r3           # encoding: [0xb9,0xf0,0x34,0x12]
#CHECK: selrm   %r1, %r2, %r3           # encoding: [0xb9,0xf0,0x34,0x12]
#CHECK: selrnhe %r1, %r2, %r3           # encoding: [0xb9,0xf0,0x35,0x12]
#CHECK: selrlh  %r1, %r2, %r3           # encoding: [0xb9,0xf0,0x36,0x12]
#CHECK: selrne  %r1, %r2, %r3           # encoding: [0xb9,0xf0,0x37,0x12]
#CHECK: selrnz  %r1, %r2, %r3           # encoding: [0xb9,0xf0,0x37,0x12]
#CHECK: selre   %r1, %r2, %r3           # encoding: [0xb9,0xf0,0x38,0x12]
#CHECK: selrz   %r1, %r2, %r3           # encoding: [0xb9,0xf0,0x38,0x12]
#CHECK: selrnlh %r1, %r2, %r3           # encoding: [0xb9,0xf0,0x39,0x12]
#CHECK: selrhe  %r1, %r2, %r3           # encoding: [0xb9,0xf0,0x3a,0x12]
#CHECK: selrnl  %r1, %r2, %r3           # encoding: [0xb9,0xf0,0x3b,0x12]
#CHECK: selrnm  %r1, %r2, %r3           # encoding: [0xb9,0xf0,0x3b,0x12]
#CHECK: selrle  %r1, %r2, %r3           # encoding: [0xb9,0xf0,0x3c,0x12]
#CHECK: selrnh  %r1, %r2, %r3           # encoding: [0xb9,0xf0,0x3d,0x12]
#CHECK: selrnp  %r1, %r2, %r3           # encoding: [0xb9,0xf0,0x3d,0x12]
#CHECK: selrno  %r1, %r2, %r3           # encoding: [0xb9,0xf0,0x3e,0x12]

	selro   %r1, %r2, %r3
	selrh   %r1, %r2, %r3
	selrp   %r1, %r2, %r3
	selrnle %r1, %r2, %r3
	selrl   %r1, %r2, %r3
	selrm   %r1, %r2, %r3
	selrnhe %r1, %r2, %r3
	selrlh  %r1, %r2, %r3
	selrne  %r1, %r2, %r3
	selrnz  %r1, %r2, %r3
	selre   %r1, %r2, %r3
	selrz   %r1, %r2, %r3
	selrnlh %r1, %r2, %r3
	selrhe  %r1, %r2, %r3
	selrnl  %r1, %r2, %r3
	selrnm  %r1, %r2, %r3
	selrle  %r1, %r2, %r3
	selrnh  %r1, %r2, %r3
	selrnp  %r1, %r2, %r3
	selrno  %r1, %r2, %r3

#CHECK: sortl	%r2, %r2                # encoding: [0xb9,0x38,0x00,0x22]
#CHECK: sortl	%r2, %r14               # encoding: [0xb9,0x38,0x00,0x2e]
#CHECK: sortl	%r14, %r2               # encoding: [0xb9,0x38,0x00,0xe2]
#CHECK: sortl	%r6, %r10               # encoding: [0xb9,0x38,0x00,0x6a]

	sortl	%r2, %r2
	sortl	%r2, %r14
	sortl	%r14, %r2
	sortl	%r6, %r10

#CHECK: vstebrg %v0, 0, 0               # encoding: [0xe6,0x00,0x00,0x00,0x00,0x0a]
#CHECK: vstebrg %v0, 4095, 0            # encoding: [0xe6,0x00,0x0f,0xff,0x00,0x0a]
#CHECK: vstebrg %v0, 0(%r15), 0         # encoding: [0xe6,0x00,0xf0,0x00,0x00,0x0a]
#CHECK: vstebrg %v0, 0(%r15,%r1), 0     # encoding: [0xe6,0x0f,0x10,0x00,0x00,0x0a]
#CHECK: vstebrg %v15, 0, 0              # encoding: [0xe6,0xf0,0x00,0x00,0x00,0x0a]
#CHECK: vstebrg %v31, 0, 0              # encoding: [0xe6,0xf0,0x00,0x00,0x08,0x0a]
#CHECK: vstebrg %v18, 1383(%r3,%r4), 0  # encoding: [0xe6,0x23,0x45,0x67,0x08,0x0a]

	stdrv	%f0, 0
	stdrv	%f0, 4095
	stdrv	%f0, 0(%r15)
	stdrv	%f0, 0(%r15,%r1)
	stdrv	%f15, 0
	stdrv	%v31, 0
	stdrv	%v18, 0x567(%r3,%r4)

#CHECK: vstebrf %v0, 0, 0               # encoding: [0xe6,0x00,0x00,0x00,0x00,0x0b]
#CHECK: vstebrf %v0, 4095, 0            # encoding: [0xe6,0x00,0x0f,0xff,0x00,0x0b]
#CHECK: vstebrf %v0, 0(%r15), 0         # encoding: [0xe6,0x00,0xf0,0x00,0x00,0x0b]
#CHECK: vstebrf %v0, 0(%r15,%r1), 0     # encoding: [0xe6,0x0f,0x10,0x00,0x00,0x0b]
#CHECK: vstebrf %v15, 0, 0              # encoding: [0xe6,0xf0,0x00,0x00,0x00,0x0b]
#CHECK: vstebrf %v31, 0, 0              # encoding: [0xe6,0xf0,0x00,0x00,0x08,0x0b]
#CHECK: vstebrf %v18, 1383(%r3,%r4), 0  # encoding: [0xe6,0x23,0x45,0x67,0x08,0x0b]

	sterv	%f0, 0
	sterv	%f0, 4095
	sterv	%f0, 0(%r15)
	sterv	%f0, 0(%r15,%r1)
	sterv	%f15, 0
	sterv	%v31, 0
	sterv	%v18, 0x567(%r3,%r4)

#CHECK: vcefb   %v0, %v0, 0, 0          # encoding: [0xe7,0x00,0x00,0x00,0x20,0xc3]
#CHECK: vcefb   %v0, %v0, 0, 15         # encoding: [0xe7,0x00,0x00,0xf0,0x20,0xc3]
#CHECK: vcefb   %v0, %v0, 4, 0          # encoding: [0xe7,0x00,0x00,0x04,0x20,0xc3]
#CHECK: vcefb   %v0, %v0, 12, 0         # encoding: [0xe7,0x00,0x00,0x0c,0x20,0xc3]
#CHECK: vcefb   %v0, %v31, 0, 0         # encoding: [0xe7,0x0f,0x00,0x00,0x24,0xc3]
#CHECK: vcefb   %v31, %v0, 0, 0         # encoding: [0xe7,0xf0,0x00,0x00,0x28,0xc3]
#CHECK: vcefb   %v14, %v17, 4, 10       # encoding: [0xe7,0xe1,0x00,0xa4,0x24,0xc3]

	vcefb	%v0, %v0, 0, 0
	vcefb	%v0, %v0, 0, 15
	vcefb	%v0, %v0, 4, 0
	vcefb	%v0, %v0, 12, 0
	vcefb	%v0, %v31, 0, 0
	vcefb	%v31, %v0, 0, 0
	vcefb	%v14, %v17, 4, 10

#CHECK: vcelfb  %v0, %v0, 0, 0          # encoding: [0xe7,0x00,0x00,0x00,0x20,0xc1]
#CHECK: vcelfb  %v0, %v0, 0, 15         # encoding: [0xe7,0x00,0x00,0xf0,0x20,0xc1]
#CHECK: vcelfb  %v0, %v0, 4, 0          # encoding: [0xe7,0x00,0x00,0x04,0x20,0xc1]
#CHECK: vcelfb  %v0, %v0, 12, 0         # encoding: [0xe7,0x00,0x00,0x0c,0x20,0xc1]
#CHECK: vcelfb  %v0, %v31, 0, 0         # encoding: [0xe7,0x0f,0x00,0x00,0x24,0xc1]
#CHECK: vcelfb  %v31, %v0, 0, 0         # encoding: [0xe7,0xf0,0x00,0x00,0x28,0xc1]
#CHECK: vcelfb  %v14, %v17, 4, 10       # encoding: [0xe7,0xe1,0x00,0xa4,0x24,0xc1]

	vcelfb	%v0, %v0, 0, 0
	vcelfb	%v0, %v0, 0, 15
	vcelfb	%v0, %v0, 4, 0
	vcelfb	%v0, %v0, 12, 0
	vcelfb	%v0, %v31, 0, 0
	vcelfb	%v31, %v0, 0, 0
	vcelfb	%v14, %v17, 4, 10

#CHECK: vcfeb   %v0, %v0, 0, 0          # encoding: [0xe7,0x00,0x00,0x00,0x20,0xc2]
#CHECK: vcfeb   %v0, %v0, 0, 15         # encoding: [0xe7,0x00,0x00,0xf0,0x20,0xc2]
#CHECK: vcfeb   %v0, %v0, 4, 0          # encoding: [0xe7,0x00,0x00,0x04,0x20,0xc2]
#CHECK: vcfeb   %v0, %v0, 12, 0         # encoding: [0xe7,0x00,0x00,0x0c,0x20,0xc2]
#CHECK: vcfeb   %v0, %v31, 0, 0         # encoding: [0xe7,0x0f,0x00,0x00,0x24,0xc2]
#CHECK: vcfeb   %v31, %v0, 0, 0         # encoding: [0xe7,0xf0,0x00,0x00,0x28,0xc2]
#CHECK: vcfeb   %v14, %v17, 4, 10       # encoding: [0xe7,0xe1,0x00,0xa4,0x24,0xc2]

	vcfeb	%v0, %v0, 0, 0
	vcfeb	%v0, %v0, 0, 15
	vcfeb	%v0, %v0, 4, 0
	vcfeb	%v0, %v0, 12, 0
	vcfeb	%v0, %v31, 0, 0
	vcfeb	%v31, %v0, 0, 0
	vcfeb	%v14, %v17, 4, 10

#CHECK: vcfpl   %v0, %v0, 0, 0, 0       # encoding: [0xe7,0x00,0x00,0x00,0x00,0xc1]
#CHECK: vcfpl   %v0, %v0, 15, 0, 0      # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xc1]
#CHECK: vcfpl   %v0, %v0, 0, 0, 15      # encoding: [0xe7,0x00,0x00,0xf0,0x00,0xc1]
#CHECK: vcfpl   %v0, %v0, 0, 4, 0       # encoding: [0xe7,0x00,0x00,0x04,0x00,0xc1]
#CHECK: vcfpl   %v0, %v0, 0, 12, 0      # encoding: [0xe7,0x00,0x00,0x0c,0x00,0xc1]
#CHECK: vcfpl   %v0, %v31, 0, 0, 0      # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xc1]
#CHECK: vcfpl   %v31, %v0, 0, 0, 0      # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xc1]
#CHECK: vcfpl   %v14, %v17, 11, 4, 10   # encoding: [0xe7,0xe1,0x00,0xa4,0xb4,0xc1]

	vcfpl	%v0, %v0, 0, 0, 0
	vcfpl	%v0, %v0, 15, 0, 0
	vcfpl	%v0, %v0, 0, 0, 15
	vcfpl	%v0, %v0, 0, 4, 0
	vcfpl	%v0, %v0, 0, 12, 0
	vcfpl	%v0, %v31, 0, 0, 0
	vcfpl	%v31, %v0, 0, 0, 0
	vcfpl	%v14, %v17, 11, 4, 10

#CHECK: vcfps   %v0, %v0, 0, 0, 0       # encoding: [0xe7,0x00,0x00,0x00,0x00,0xc3]
#CHECK: vcfps   %v0, %v0, 15, 0, 0      # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xc3]
#CHECK: vcfps   %v0, %v0, 0, 0, 15      # encoding: [0xe7,0x00,0x00,0xf0,0x00,0xc3]
#CHECK: vcfps   %v0, %v0, 0, 4, 0       # encoding: [0xe7,0x00,0x00,0x04,0x00,0xc3]
#CHECK: vcfps   %v0, %v0, 0, 12, 0      # encoding: [0xe7,0x00,0x00,0x0c,0x00,0xc3]
#CHECK: vcfps   %v0, %v31, 0, 0, 0      # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xc3]
#CHECK: vcfps   %v31, %v0, 0, 0, 0      # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xc3]
#CHECK: vcfps   %v14, %v17, 11, 4, 10   # encoding: [0xe7,0xe1,0x00,0xa4,0xb4,0xc3]

	vcfps	%v0, %v0, 0, 0, 0
	vcfps	%v0, %v0, 15, 0, 0
	vcfps	%v0, %v0, 0, 0, 15
	vcfps	%v0, %v0, 0, 4, 0
	vcfps	%v0, %v0, 0, 12, 0
	vcfps	%v0, %v31, 0, 0, 0
	vcfps	%v31, %v0, 0, 0, 0
	vcfps	%v14, %v17, 11, 4, 10

#CHECK: vclfeb  %v0, %v0, 0, 0          # encoding: [0xe7,0x00,0x00,0x00,0x20,0xc0]
#CHECK: vclfeb  %v0, %v0, 0, 15         # encoding: [0xe7,0x00,0x00,0xf0,0x20,0xc0]
#CHECK: vclfeb  %v0, %v0, 4, 0          # encoding: [0xe7,0x00,0x00,0x04,0x20,0xc0]
#CHECK: vclfeb  %v0, %v0, 12, 0         # encoding: [0xe7,0x00,0x00,0x0c,0x20,0xc0]
#CHECK: vclfeb  %v0, %v31, 0, 0         # encoding: [0xe7,0x0f,0x00,0x00,0x24,0xc0]
#CHECK: vclfeb  %v31, %v0, 0, 0         # encoding: [0xe7,0xf0,0x00,0x00,0x28,0xc0]
#CHECK: vclfeb  %v14, %v17, 4, 10       # encoding: [0xe7,0xe1,0x00,0xa4,0x24,0xc0]

	vclfeb	%v0, %v0, 0, 0
	vclfeb	%v0, %v0, 0, 15
	vclfeb	%v0, %v0, 4, 0
	vclfeb	%v0, %v0, 12, 0
	vclfeb	%v0, %v31, 0, 0
	vclfeb	%v31, %v0, 0, 0
	vclfeb	%v14, %v17, 4, 10

#CHECK: vclfp   %v0, %v0, 0, 0, 0       # encoding: [0xe7,0x00,0x00,0x00,0x00,0xc0]
#CHECK: vclfp   %v0, %v0, 15, 0, 0      # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xc0]
#CHECK: vclfp   %v0, %v0, 0, 0, 15      # encoding: [0xe7,0x00,0x00,0xf0,0x00,0xc0]
#CHECK: vclfp   %v0, %v0, 0, 4, 0       # encoding: [0xe7,0x00,0x00,0x04,0x00,0xc0]
#CHECK: vclfp   %v0, %v0, 0, 12, 0      # encoding: [0xe7,0x00,0x00,0x0c,0x00,0xc0]
#CHECK: vclfp   %v0, %v31, 0, 0, 0      # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xc0]
#CHECK: vclfp   %v31, %v0, 0, 0, 0      # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xc0]
#CHECK: vclfp   %v14, %v17, 11, 4, 10   # encoding: [0xe7,0xe1,0x00,0xa4,0xb4,0xc0]

	vclfp	%v0, %v0, 0, 0, 0
	vclfp	%v0, %v0, 15, 0, 0
	vclfp	%v0, %v0, 0, 0, 15
	vclfp	%v0, %v0, 0, 4, 0
	vclfp	%v0, %v0, 0, 12, 0
	vclfp	%v0, %v31, 0, 0, 0
	vclfp	%v31, %v0, 0, 0, 0
	vclfp	%v14, %v17, 11, 4, 10

#CHECK: vcsfp   %v0, %v0, 0, 0, 0       # encoding: [0xe7,0x00,0x00,0x00,0x00,0xc2]
#CHECK: vcsfp   %v0, %v0, 15, 0, 0      # encoding: [0xe7,0x00,0x00,0x00,0xf0,0xc2]
#CHECK: vcsfp   %v0, %v0, 0, 0, 15      # encoding: [0xe7,0x00,0x00,0xf0,0x00,0xc2]
#CHECK: vcsfp   %v0, %v0, 0, 4, 0       # encoding: [0xe7,0x00,0x00,0x04,0x00,0xc2]
#CHECK: vcsfp   %v0, %v0, 0, 12, 0      # encoding: [0xe7,0x00,0x00,0x0c,0x00,0xc2]
#CHECK: vcsfp   %v0, %v31, 0, 0, 0      # encoding: [0xe7,0x0f,0x00,0x00,0x04,0xc2]
#CHECK: vcsfp   %v31, %v0, 0, 0, 0      # encoding: [0xe7,0xf0,0x00,0x00,0x08,0xc2]
#CHECK: vcsfp   %v14, %v17, 11, 4, 10   # encoding: [0xe7,0xe1,0x00,0xa4,0xb4,0xc2]

	vcsfp	%v0, %v0, 0, 0, 0
	vcsfp	%v0, %v0, 15, 0, 0
	vcsfp	%v0, %v0, 0, 0, 15
	vcsfp	%v0, %v0, 0, 4, 0
	vcsfp	%v0, %v0, 0, 12, 0
	vcsfp	%v0, %v31, 0, 0, 0
	vcsfp	%v31, %v0, 0, 0, 0
	vcsfp	%v14, %v17, 11, 4, 10

#CHECK: vcvb	%r0, %v0, 0, 15        # encoding: [0xe6,0x00,0x00,0x0f,0x00,0x50]
#CHECK: vcvb	%r3, %v18, 4, 6        # encoding: [0xe6,0x32,0x00,0x46,0x04,0x50]

	vcvb	%r0, %v0, 0, 15
	vcvb	%r3, %v18, 4, 6

#CHECK: vcvbg	%r0, %v0, 0, 15        # encoding: [0xe6,0x00,0x00,0x0f,0x00,0x52]
#CHECK: vcvbg	%r3, %v18, 4, 6        # encoding: [0xe6,0x32,0x00,0x46,0x04,0x52]

	vcvbg	%r0, %v0, 0, 15
	vcvbg	%r3, %v18, 4, 6

#CHECK: vlbr   %v0, 0, 0               # encoding: [0xe6,0x00,0x00,0x00,0x00,0x06]
#CHECK: vlbr   %v0, 0, 15              # encoding: [0xe6,0x00,0x00,0x00,0xf0,0x06]
#CHECK: vlbr   %v0, 4095, 0            # encoding: [0xe6,0x00,0x0f,0xff,0x00,0x06]
#CHECK: vlbr   %v0, 0(%r15), 0         # encoding: [0xe6,0x00,0xf0,0x00,0x00,0x06]
#CHECK: vlbr   %v0, 0(%r15,%r1), 0     # encoding: [0xe6,0x0f,0x10,0x00,0x00,0x06]
#CHECK: vlbr   %v15, 0, 0              # encoding: [0xe6,0xf0,0x00,0x00,0x00,0x06]
#CHECK: vlbr   %v31, 0, 0              # encoding: [0xe6,0xf0,0x00,0x00,0x08,0x06]
#CHECK: vlbr   %v18, 1383(%r3,%r4), 11 # encoding: [0xe6,0x23,0x45,0x67,0xb8,0x06]

	vlbr	%v0, 0, 0
	vlbr	%v0, 0, 15
	vlbr	%v0, 4095, 0
	vlbr	%v0, 0(%r15), 0
	vlbr	%v0, 0(%r15,%r1), 0
	vlbr	%v15, 0, 0
	vlbr	%v31, 0, 0
	vlbr	%v18, 0x567(%r3,%r4), 11

#CHECK: vlbrf  %v0, 0                  # encoding: [0xe6,0x00,0x00,0x00,0x20,0x06]
#CHECK: vlbrf  %v0, 4095               # encoding: [0xe6,0x00,0x0f,0xff,0x20,0x06]
#CHECK: vlbrf  %v0, 0(%r15)            # encoding: [0xe6,0x00,0xf0,0x00,0x20,0x06]
#CHECK: vlbrf  %v0, 0(%r15,%r1)        # encoding: [0xe6,0x0f,0x10,0x00,0x20,0x06]
#CHECK: vlbrf  %v15, 0                 # encoding: [0xe6,0xf0,0x00,0x00,0x20,0x06]
#CHECK: vlbrf  %v31, 0                 # encoding: [0xe6,0xf0,0x00,0x00,0x28,0x06]
#CHECK: vlbrf  %v18, 1383(%r3,%r4)     # encoding: [0xe6,0x23,0x45,0x67,0x28,0x06]

	vlbrf	%v0, 0
	vlbrf	%v0, 4095
	vlbrf	%v0, 0(%r15)
	vlbrf	%v0, 0(%r15,%r1)
	vlbrf	%v15, 0
	vlbrf	%v31, 0
	vlbrf	%v18, 0x567(%r3,%r4)

#CHECK: vlbrg  %v0, 0                  # encoding: [0xe6,0x00,0x00,0x00,0x30,0x06]
#CHECK: vlbrg  %v0, 4095               # encoding: [0xe6,0x00,0x0f,0xff,0x30,0x06]
#CHECK: vlbrg  %v0, 0(%r15)            # encoding: [0xe6,0x00,0xf0,0x00,0x30,0x06]
#CHECK: vlbrg  %v0, 0(%r15,%r1)        # encoding: [0xe6,0x0f,0x10,0x00,0x30,0x06]
#CHECK: vlbrg  %v15, 0                 # encoding: [0xe6,0xf0,0x00,0x00,0x30,0x06]
#CHECK: vlbrg  %v31, 0                 # encoding: [0xe6,0xf0,0x00,0x00,0x38,0x06]
#CHECK: vlbrg  %v18, 1383(%r3,%r4)     # encoding: [0xe6,0x23,0x45,0x67,0x38,0x06]

	vlbrg	%v0, 0
	vlbrg	%v0, 4095
	vlbrg	%v0, 0(%r15)
	vlbrg	%v0, 0(%r15,%r1)
	vlbrg	%v15, 0
	vlbrg	%v31, 0
	vlbrg	%v18, 0x567(%r3,%r4)

#CHECK: vlbrh  %v0, 0                  # encoding: [0xe6,0x00,0x00,0x00,0x10,0x06]
#CHECK: vlbrh  %v0, 4095               # encoding: [0xe6,0x00,0x0f,0xff,0x10,0x06]
#CHECK: vlbrh  %v0, 0(%r15)            # encoding: [0xe6,0x00,0xf0,0x00,0x10,0x06]
#CHECK: vlbrh  %v0, 0(%r15,%r1)        # encoding: [0xe6,0x0f,0x10,0x00,0x10,0x06]
#CHECK: vlbrh  %v15, 0                 # encoding: [0xe6,0xf0,0x00,0x00,0x10,0x06]
#CHECK: vlbrh  %v31, 0                 # encoding: [0xe6,0xf0,0x00,0x00,0x18,0x06]
#CHECK: vlbrh  %v18, 1383(%r3,%r4)     # encoding: [0xe6,0x23,0x45,0x67,0x18,0x06]

	vlbrh	%v0, 0
	vlbrh	%v0, 4095
	vlbrh	%v0, 0(%r15)
	vlbrh	%v0, 0(%r15,%r1)
	vlbrh	%v15, 0
	vlbrh	%v31, 0
	vlbrh	%v18, 0x567(%r3,%r4)

#CHECK: vlbrq  %v0, 0                  # encoding: [0xe6,0x00,0x00,0x00,0x40,0x06]
#CHECK: vlbrq  %v0, 4095               # encoding: [0xe6,0x00,0x0f,0xff,0x40,0x06]
#CHECK: vlbrq  %v0, 0(%r15)            # encoding: [0xe6,0x00,0xf0,0x00,0x40,0x06]
#CHECK: vlbrq  %v0, 0(%r15,%r1)        # encoding: [0xe6,0x0f,0x10,0x00,0x40,0x06]
#CHECK: vlbrq  %v15, 0                 # encoding: [0xe6,0xf0,0x00,0x00,0x40,0x06]
#CHECK: vlbrq  %v31, 0                 # encoding: [0xe6,0xf0,0x00,0x00,0x48,0x06]
#CHECK: vlbrq  %v18, 1383(%r3,%r4)     # encoding: [0xe6,0x23,0x45,0x67,0x48,0x06]

	vlbrq	%v0, 0
	vlbrq	%v0, 4095
	vlbrq	%v0, 0(%r15)
	vlbrq	%v0, 0(%r15,%r1)
	vlbrq	%v15, 0
	vlbrq	%v31, 0
	vlbrq	%v18, 0x567(%r3,%r4)

#CHECK: vlbrrep %v0, 0, 0              # encoding: [0xe6,0x00,0x00,0x00,0x00,0x05]
#CHECK: vlbrrep %v0, 0, 15             # encoding: [0xe6,0x00,0x00,0x00,0xf0,0x05]
#CHECK: vlbrrep %v0, 4095, 0           # encoding: [0xe6,0x00,0x0f,0xff,0x00,0x05]
#CHECK: vlbrrep %v0, 0(%r15), 0        # encoding: [0xe6,0x00,0xf0,0x00,0x00,0x05]
#CHECK: vlbrrep %v0, 0(%r15,%r1), 0    # encoding: [0xe6,0x0f,0x10,0x00,0x00,0x05]
#CHECK: vlbrrep %v15, 0, 0             # encoding: [0xe6,0xf0,0x00,0x00,0x00,0x05]
#CHECK: vlbrrep %v31, 0, 0             # encoding: [0xe6,0xf0,0x00,0x00,0x08,0x05]
#CHECK: vlbrrep %v18, 1383(%r3,%r4), 11 # encoding: [0xe6,0x23,0x45,0x67,0xb8,0x05]

	vlbrrep  %v0, 0, 0
	vlbrrep  %v0, 0, 15
	vlbrrep  %v0, 4095, 0
	vlbrrep  %v0, 0(%r15), 0
	vlbrrep  %v0, 0(%r15,%r1), 0
	vlbrrep  %v15, 0, 0
	vlbrrep  %v31, 0, 0
	vlbrrep  %v18, 0x567(%r3,%r4), 11

#CHECK: vlbrrepf %v0, 0                # encoding: [0xe6,0x00,0x00,0x00,0x20,0x05]
#CHECK: vlbrrepf %v0, 4095             # encoding: [0xe6,0x00,0x0f,0xff,0x20,0x05]
#CHECK: vlbrrepf %v0, 0(%r15)          # encoding: [0xe6,0x00,0xf0,0x00,0x20,0x05]
#CHECK: vlbrrepf %v0, 0(%r15,%r1)      # encoding: [0xe6,0x0f,0x10,0x00,0x20,0x05]
#CHECK: vlbrrepf %v15, 0               # encoding: [0xe6,0xf0,0x00,0x00,0x20,0x05]
#CHECK: vlbrrepf %v31, 0               # encoding: [0xe6,0xf0,0x00,0x00,0x28,0x05]
#CHECK: vlbrrepf %v18, 1383(%r3,%r4)   # encoding: [0xe6,0x23,0x45,0x67,0x28,0x05]

	vlbrrepf %v0, 0
	vlbrrepf %v0, 4095
	vlbrrepf %v0, 0(%r15)
	vlbrrepf %v0, 0(%r15,%r1)
	vlbrrepf %v15, 0
	vlbrrepf %v31, 0
	vlbrrepf %v18, 0x567(%r3,%r4)

#CHECK: vlbrrepg %v0, 0                # encoding: [0xe6,0x00,0x00,0x00,0x30,0x05]
#CHECK: vlbrrepg %v0, 4095             # encoding: [0xe6,0x00,0x0f,0xff,0x30,0x05]
#CHECK: vlbrrepg %v0, 0(%r15)          # encoding: [0xe6,0x00,0xf0,0x00,0x30,0x05]
#CHECK: vlbrrepg %v0, 0(%r15,%r1)      # encoding: [0xe6,0x0f,0x10,0x00,0x30,0x05]
#CHECK: vlbrrepg %v15, 0               # encoding: [0xe6,0xf0,0x00,0x00,0x30,0x05]
#CHECK: vlbrrepg %v31, 0               # encoding: [0xe6,0xf0,0x00,0x00,0x38,0x05]
#CHECK: vlbrrepg %v18, 1383(%r3,%r4)   # encoding: [0xe6,0x23,0x45,0x67,0x38,0x05]

	vlbrrepg %v0, 0
	vlbrrepg %v0, 4095
	vlbrrepg %v0, 0(%r15)
	vlbrrepg %v0, 0(%r15,%r1)
	vlbrrepg %v15, 0
	vlbrrepg %v31, 0
	vlbrrepg %v18, 0x567(%r3,%r4)

#CHECK: vlbrreph %v0, 0                # encoding: [0xe6,0x00,0x00,0x00,0x10,0x05]
#CHECK: vlbrreph %v0, 4095             # encoding: [0xe6,0x00,0x0f,0xff,0x10,0x05]
#CHECK: vlbrreph %v0, 0(%r15)          # encoding: [0xe6,0x00,0xf0,0x00,0x10,0x05]
#CHECK: vlbrreph %v0, 0(%r15,%r1)      # encoding: [0xe6,0x0f,0x10,0x00,0x10,0x05]
#CHECK: vlbrreph %v15, 0               # encoding: [0xe6,0xf0,0x00,0x00,0x10,0x05]
#CHECK: vlbrreph %v31, 0               # encoding: [0xe6,0xf0,0x00,0x00,0x18,0x05]
#CHECK: vlbrreph %v18, 1383(%r3,%r4)   # encoding: [0xe6,0x23,0x45,0x67,0x18,0x05]

	vlbrreph %v0, 0
	vlbrreph %v0, 4095
	vlbrreph %v0, 0(%r15)
	vlbrreph %v0, 0(%r15,%r1)
	vlbrreph %v15, 0
	vlbrreph %v31, 0
	vlbrreph %v18, 0x567(%r3,%r4)

#CHECK: vlebrf  %v0, 0, 0               # encoding: [0xe6,0x00,0x00,0x00,0x00,0x03]
#CHECK: vlebrf  %v0, 0, 3               # encoding: [0xe6,0x00,0x00,0x00,0x30,0x03]
#CHECK: vlebrf  %v0, 4095, 0            # encoding: [0xe6,0x00,0x0f,0xff,0x00,0x03]
#CHECK: vlebrf  %v0, 0(%r15), 0         # encoding: [0xe6,0x00,0xf0,0x00,0x00,0x03]
#CHECK: vlebrf  %v0, 0(%r15,%r1), 0     # encoding: [0xe6,0x0f,0x10,0x00,0x00,0x03]
#CHECK: vlebrf  %v15, 0, 0              # encoding: [0xe6,0xf0,0x00,0x00,0x00,0x03]
#CHECK: vlebrf  %v31, 0, 0              # encoding: [0xe6,0xf0,0x00,0x00,0x08,0x03]
#CHECK: vlebrf  %v18, 1383(%r3,%r4), 2  # encoding: [0xe6,0x23,0x45,0x67,0x28,0x03]

	vlebrf	%v0, 0, 0
	vlebrf	%v0, 0, 3
	vlebrf	%v0, 4095, 0
	vlebrf	%v0, 0(%r15), 0
	vlebrf	%v0, 0(%r15,%r1), 0
	vlebrf	%v15, 0, 0
	vlebrf	%v31, 0, 0
	vlebrf	%v18, 1383(%r3,%r4), 2

#CHECK: vlebrg  %v0, 0, 0               # encoding: [0xe6,0x00,0x00,0x00,0x00,0x02]
#CHECK: vlebrg  %v0, 0, 1               # encoding: [0xe6,0x00,0x00,0x00,0x10,0x02]
#CHECK: vlebrg  %v0, 4095, 0            # encoding: [0xe6,0x00,0x0f,0xff,0x00,0x02]
#CHECK: vlebrg  %v0, 0(%r15), 0         # encoding: [0xe6,0x00,0xf0,0x00,0x00,0x02]
#CHECK: vlebrg  %v0, 0(%r15,%r1), 0     # encoding: [0xe6,0x0f,0x10,0x00,0x00,0x02]
#CHECK: vlebrg  %v15, 0, 0              # encoding: [0xe6,0xf0,0x00,0x00,0x00,0x02]
#CHECK: vlebrg  %v31, 0, 0              # encoding: [0xe6,0xf0,0x00,0x00,0x08,0x02]
#CHECK: vlebrg  %v18, 1383(%r3,%r4), 1  # encoding: [0xe6,0x23,0x45,0x67,0x18,0x02]

	vlebrg	%v0, 0, 0
	vlebrg	%v0, 0, 1
	vlebrg	%v0, 4095, 0
	vlebrg	%v0, 0(%r15), 0
	vlebrg	%v0, 0(%r15,%r1), 0
	vlebrg	%v15, 0, 0
	vlebrg	%v31, 0, 0
	vlebrg	%v18, 1383(%r3,%r4), 1

#CHECK: vlebrh  %v0, 0, 0               # encoding: [0xe6,0x00,0x00,0x00,0x00,0x01]
#CHECK: vlebrh  %v0, 0, 7               # encoding: [0xe6,0x00,0x00,0x00,0x70,0x01]
#CHECK: vlebrh  %v0, 4095, 0            # encoding: [0xe6,0x00,0x0f,0xff,0x00,0x01]
#CHECK: vlebrh  %v0, 0(%r15), 0         # encoding: [0xe6,0x00,0xf0,0x00,0x00,0x01]
#CHECK: vlebrh  %v0, 0(%r15,%r1), 0     # encoding: [0xe6,0x0f,0x10,0x00,0x00,0x01]
#CHECK: vlebrh  %v15, 0, 0              # encoding: [0xe6,0xf0,0x00,0x00,0x00,0x01]
#CHECK: vlebrh  %v31, 0, 0              # encoding: [0xe6,0xf0,0x00,0x00,0x08,0x01]
#CHECK: vlebrh  %v18, 1383(%r3,%r4), 4  # encoding: [0xe6,0x23,0x45,0x67,0x48,0x01]

	vlebrh	%v0, 0, 0
	vlebrh	%v0, 0, 7
	vlebrh	%v0, 4095, 0
	vlebrh	%v0, 0(%r15), 0
	vlebrh	%v0, 0(%r15,%r1), 0
	vlebrh	%v15, 0, 0
	vlebrh	%v31, 0, 0
	vlebrh	%v18, 1383(%r3,%r4), 4

#CHECK: vler   %v0, 0, 0               # encoding: [0xe6,0x00,0x00,0x00,0x00,0x07]
#CHECK: vler   %v0, 0, 15              # encoding: [0xe6,0x00,0x00,0x00,0xf0,0x07]
#CHECK: vler   %v0, 4095, 0            # encoding: [0xe6,0x00,0x0f,0xff,0x00,0x07]
#CHECK: vler   %v0, 0(%r15), 0         # encoding: [0xe6,0x00,0xf0,0x00,0x00,0x07]
#CHECK: vler   %v0, 0(%r15,%r1), 0     # encoding: [0xe6,0x0f,0x10,0x00,0x00,0x07]
#CHECK: vler   %v15, 0, 0              # encoding: [0xe6,0xf0,0x00,0x00,0x00,0x07]
#CHECK: vler   %v31, 0, 0              # encoding: [0xe6,0xf0,0x00,0x00,0x08,0x07]
#CHECK: vler   %v18, 1383(%r3,%r4), 11 # encoding: [0xe6,0x23,0x45,0x67,0xb8,0x07]

	vler	%v0, 0, 0
	vler	%v0, 0, 15
	vler	%v0, 4095, 0
	vler	%v0, 0(%r15), 0
	vler	%v0, 0(%r15,%r1), 0
	vler	%v15, 0, 0
	vler	%v31, 0, 0
	vler	%v18, 0x567(%r3,%r4), 11

#CHECK: vlerf  %v0, 0                  # encoding: [0xe6,0x00,0x00,0x00,0x20,0x07]
#CHECK: vlerf  %v0, 4095               # encoding: [0xe6,0x00,0x0f,0xff,0x20,0x07]
#CHECK: vlerf  %v0, 0(%r15)            # encoding: [0xe6,0x00,0xf0,0x00,0x20,0x07]
#CHECK: vlerf  %v0, 0(%r15,%r1)        # encoding: [0xe6,0x0f,0x10,0x00,0x20,0x07]
#CHECK: vlerf  %v15, 0                 # encoding: [0xe6,0xf0,0x00,0x00,0x20,0x07]
#CHECK: vlerf  %v31, 0                 # encoding: [0xe6,0xf0,0x00,0x00,0x28,0x07]
#CHECK: vlerf  %v18, 1383(%r3,%r4)     # encoding: [0xe6,0x23,0x45,0x67,0x28,0x07]

	vlerf	%v0, 0
	vlerf	%v0, 4095
	vlerf	%v0, 0(%r15)
	vlerf	%v0, 0(%r15,%r1)
	vlerf	%v15, 0
	vlerf	%v31, 0
	vlerf	%v18, 0x567(%r3,%r4)

#CHECK: vlerg  %v0, 0                  # encoding: [0xe6,0x00,0x00,0x00,0x30,0x07]
#CHECK: vlerg  %v0, 4095               # encoding: [0xe6,0x00,0x0f,0xff,0x30,0x07]
#CHECK: vlerg  %v0, 0(%r15)            # encoding: [0xe6,0x00,0xf0,0x00,0x30,0x07]
#CHECK: vlerg  %v0, 0(%r15,%r1)        # encoding: [0xe6,0x0f,0x10,0x00,0x30,0x07]
#CHECK: vlerg  %v15, 0                 # encoding: [0xe6,0xf0,0x00,0x00,0x30,0x07]
#CHECK: vlerg  %v31, 0                 # encoding: [0xe6,0xf0,0x00,0x00,0x38,0x07]
#CHECK: vlerg  %v18, 1383(%r3,%r4)     # encoding: [0xe6,0x23,0x45,0x67,0x38,0x07]

	vlerg	%v0, 0
	vlerg	%v0, 4095
	vlerg	%v0, 0(%r15)
	vlerg	%v0, 0(%r15,%r1)
	vlerg	%v15, 0
	vlerg	%v31, 0
	vlerg	%v18, 0x567(%r3,%r4)

#CHECK: vlerh  %v0, 0                  # encoding: [0xe6,0x00,0x00,0x00,0x10,0x07]
#CHECK: vlerh  %v0, 4095               # encoding: [0xe6,0x00,0x0f,0xff,0x10,0x07]
#CHECK: vlerh  %v0, 0(%r15)            # encoding: [0xe6,0x00,0xf0,0x00,0x10,0x07]
#CHECK: vlerh  %v0, 0(%r15,%r1)        # encoding: [0xe6,0x0f,0x10,0x00,0x10,0x07]
#CHECK: vlerh  %v15, 0                 # encoding: [0xe6,0xf0,0x00,0x00,0x10,0x07]
#CHECK: vlerh  %v31, 0                 # encoding: [0xe6,0xf0,0x00,0x00,0x18,0x07]
#CHECK: vlerh  %v18, 1383(%r3,%r4)     # encoding: [0xe6,0x23,0x45,0x67,0x18,0x07]

	vlerh	%v0, 0
	vlerh	%v0, 4095
	vlerh	%v0, 0(%r15)
	vlerh	%v0, 0(%r15,%r1)
	vlerh	%v15, 0
	vlerh	%v31, 0
	vlerh	%v18, 0x567(%r3,%r4)

#CHECK: vllebrz   %v0, 0, 0               # encoding: [0xe6,0x00,0x00,0x00,0x00,0x04]
#CHECK: vllebrz   %v0, 0, 15              # encoding: [0xe6,0x00,0x00,0x00,0xf0,0x04]
#CHECK: vllebrz   %v0, 4095, 0            # encoding: [0xe6,0x00,0x0f,0xff,0x00,0x04]
#CHECK: vllebrz   %v0, 0(%r15), 0         # encoding: [0xe6,0x00,0xf0,0x00,0x00,0x04]
#CHECK: vllebrz   %v0, 0(%r15,%r1), 0     # encoding: [0xe6,0x0f,0x10,0x00,0x00,0x04]
#CHECK: vllebrz   %v15, 0, 0              # encoding: [0xe6,0xf0,0x00,0x00,0x00,0x04]
#CHECK: vllebrz   %v31, 0, 0              # encoding: [0xe6,0xf0,0x00,0x00,0x08,0x04]
#CHECK: vllebrz   %v18, 1383(%r3,%r4), 11 # encoding: [0xe6,0x23,0x45,0x67,0xb8,0x04]

	vllebrz	%v0, 0, 0
	vllebrz	%v0, 0, 15
	vllebrz	%v0, 4095, 0
	vllebrz	%v0, 0(%r15), 0
	vllebrz	%v0, 0(%r15,%r1), 0
	vllebrz	%v15, 0, 0
	vllebrz	%v31, 0, 0
	vllebrz	%v18, 0x567(%r3,%r4), 11

#CHECK: vllebrze  %v0, 0                  # encoding: [0xe6,0x00,0x00,0x00,0x60,0x04]
#CHECK: vllebrze  %v0, 4095               # encoding: [0xe6,0x00,0x0f,0xff,0x60,0x04]
#CHECK: vllebrze  %v0, 0(%r15)            # encoding: [0xe6,0x00,0xf0,0x00,0x60,0x04]
#CHECK: vllebrze  %v0, 0(%r15,%r1)        # encoding: [0xe6,0x0f,0x10,0x00,0x60,0x04]
#CHECK: vllebrze  %v15, 0                 # encoding: [0xe6,0xf0,0x00,0x00,0x60,0x04]
#CHECK: vllebrze  %v31, 0                 # encoding: [0xe6,0xf0,0x00,0x00,0x68,0x04]
#CHECK: vllebrze  %v18, 1383(%r3,%r4)     # encoding: [0xe6,0x23,0x45,0x67,0x68,0x04]

	vllebrze	%v0, 0
	vllebrze	%v0, 4095
	vllebrze	%v0, 0(%r15)
	vllebrze	%v0, 0(%r15,%r1)
	vllebrze	%v15, 0
	vllebrze	%v31, 0
	vllebrze	%v18, 0x567(%r3,%r4)

#CHECK: vllebrzf  %v0, 0                  # encoding: [0xe6,0x00,0x00,0x00,0x20,0x04]
#CHECK: vllebrzf  %v0, 4095               # encoding: [0xe6,0x00,0x0f,0xff,0x20,0x04]
#CHECK: vllebrzf  %v0, 0(%r15)            # encoding: [0xe6,0x00,0xf0,0x00,0x20,0x04]
#CHECK: vllebrzf  %v0, 0(%r15,%r1)        # encoding: [0xe6,0x0f,0x10,0x00,0x20,0x04]
#CHECK: vllebrzf  %v15, 0                 # encoding: [0xe6,0xf0,0x00,0x00,0x20,0x04]
#CHECK: vllebrzf  %v31, 0                 # encoding: [0xe6,0xf0,0x00,0x00,0x28,0x04]
#CHECK: vllebrzf  %v18, 1383(%r3,%r4)     # encoding: [0xe6,0x23,0x45,0x67,0x28,0x04]

	vllebrzf	%v0, 0
	vllebrzf	%v0, 4095
	vllebrzf	%v0, 0(%r15)
	vllebrzf	%v0, 0(%r15,%r1)
	vllebrzf	%v15, 0
	vllebrzf	%v31, 0
	vllebrzf	%v18, 0x567(%r3,%r4)

#CHECK: vllebrzg  %v0, 0                  # encoding: [0xe6,0x00,0x00,0x00,0x30,0x04]
#CHECK: vllebrzg  %v0, 4095               # encoding: [0xe6,0x00,0x0f,0xff,0x30,0x04]
#CHECK: vllebrzg  %v0, 0(%r15)            # encoding: [0xe6,0x00,0xf0,0x00,0x30,0x04]
#CHECK: vllebrzg  %v0, 0(%r15,%r1)        # encoding: [0xe6,0x0f,0x10,0x00,0x30,0x04]
#CHECK: vllebrzg  %v15, 0                 # encoding: [0xe6,0xf0,0x00,0x00,0x30,0x04]
#CHECK: vllebrzg  %v31, 0                 # encoding: [0xe6,0xf0,0x00,0x00,0x38,0x04]
#CHECK: vllebrzg  %v18, 1383(%r3,%r4)     # encoding: [0xe6,0x23,0x45,0x67,0x38,0x04]

	vllebrzg	%v0, 0
	vllebrzg	%v0, 4095
	vllebrzg	%v0, 0(%r15)
	vllebrzg	%v0, 0(%r15,%r1)
	vllebrzg	%v15, 0
	vllebrzg	%v31, 0
	vllebrzg	%v18, 0x567(%r3,%r4)

#CHECK: vllebrzh  %v0, 0                  # encoding: [0xe6,0x00,0x00,0x00,0x10,0x04]
#CHECK: vllebrzh  %v0, 4095               # encoding: [0xe6,0x00,0x0f,0xff,0x10,0x04]
#CHECK: vllebrzh  %v0, 0(%r15)            # encoding: [0xe6,0x00,0xf0,0x00,0x10,0x04]
#CHECK: vllebrzh  %v0, 0(%r15,%r1)        # encoding: [0xe6,0x0f,0x10,0x00,0x10,0x04]
#CHECK: vllebrzh  %v15, 0                 # encoding: [0xe6,0xf0,0x00,0x00,0x10,0x04]
#CHECK: vllebrzh  %v31, 0                 # encoding: [0xe6,0xf0,0x00,0x00,0x18,0x04]
#CHECK: vllebrzh  %v18, 1383(%r3,%r4)     # encoding: [0xe6,0x23,0x45,0x67,0x18,0x04]

	vllebrzh	%v0, 0
	vllebrzh	%v0, 4095
	vllebrzh	%v0, 0(%r15)
	vllebrzh	%v0, 0(%r15,%r1)
	vllebrzh	%v15, 0
	vllebrzh	%v31, 0
	vllebrzh	%v18, 0x567(%r3,%r4)

#CHECK: vsld    %v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x00,0x86]
#CHECK: vsld    %v0, %v0, %v0, 255      # encoding: [0xe7,0x00,0x00,0xff,0x00,0x86]
#CHECK: vsld    %v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x86]
#CHECK: vsld    %v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x86]
#CHECK: vsld    %v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x86]
#CHECK: vsld    %v13, %v17, %v21, 121   # encoding: [0xe7,0xd1,0x50,0x79,0x06,0x86]

	vsld	%v0, %v0, %v0, 0
	vsld	%v0, %v0, %v0, 255
	vsld	%v0, %v0, %v31, 0
	vsld	%v0, %v31, %v0, 0
	vsld	%v31, %v0, %v0, 0
	vsld 	%v13, %v17, %v21, 0x79

#CHECK: vsrd    %v0, %v0, %v0, 0        # encoding: [0xe7,0x00,0x00,0x00,0x00,0x87]
#CHECK: vsrd    %v0, %v0, %v0, 255      # encoding: [0xe7,0x00,0x00,0xff,0x00,0x87]
#CHECK: vsrd    %v0, %v0, %v31, 0       # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x87]
#CHECK: vsrd    %v0, %v31, %v0, 0       # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x87]
#CHECK: vsrd    %v31, %v0, %v0, 0       # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x87]
#CHECK: vsrd    %v13, %v17, %v21, 121   # encoding: [0xe7,0xd1,0x50,0x79,0x06,0x87]

	vsrd	%v0, %v0, %v0, 0
	vsrd	%v0, %v0, %v0, 255
	vsrd	%v0, %v0, %v31, 0
	vsrd	%v0, %v31, %v0, 0
	vsrd	%v31, %v0, %v0, 0
	vsrd 	%v13, %v17, %v21, 0x79

#CHECK: vstbr   %v0, 0, 0               # encoding: [0xe6,0x00,0x00,0x00,0x00,0x0e]
#CHECK: vstbr   %v0, 0, 15              # encoding: [0xe6,0x00,0x00,0x00,0xf0,0x0e]
#CHECK: vstbr   %v0, 4095, 0            # encoding: [0xe6,0x00,0x0f,0xff,0x00,0x0e]
#CHECK: vstbr   %v0, 0(%r15), 0         # encoding: [0xe6,0x00,0xf0,0x00,0x00,0x0e]
#CHECK: vstbr   %v0, 0(%r15,%r1), 0     # encoding: [0xe6,0x0f,0x10,0x00,0x00,0x0e]
#CHECK: vstbr   %v15, 0, 0              # encoding: [0xe6,0xf0,0x00,0x00,0x00,0x0e]
#CHECK: vstbr   %v31, 0, 0              # encoding: [0xe6,0xf0,0x00,0x00,0x08,0x0e]
#CHECK: vstbr   %v18, 1383(%r3,%r4), 11 # encoding: [0xe6,0x23,0x45,0x67,0xb8,0x0e]

	vstbr	%v0, 0, 0
	vstbr	%v0, 0, 15
	vstbr	%v0, 4095, 0
	vstbr	%v0, 0(%r15), 0
	vstbr	%v0, 0(%r15,%r1), 0
	vstbr	%v15, 0, 0
	vstbr	%v31, 0, 0
	vstbr	%v18, 0x567(%r3,%r4), 11

#CHECK: vstbrf  %v0, 0                  # encoding: [0xe6,0x00,0x00,0x00,0x20,0x0e]
#CHECK: vstbrf  %v0, 4095               # encoding: [0xe6,0x00,0x0f,0xff,0x20,0x0e]
#CHECK: vstbrf  %v0, 0(%r15)            # encoding: [0xe6,0x00,0xf0,0x00,0x20,0x0e]
#CHECK: vstbrf  %v0, 0(%r15,%r1)        # encoding: [0xe6,0x0f,0x10,0x00,0x20,0x0e]
#CHECK: vstbrf  %v15, 0                 # encoding: [0xe6,0xf0,0x00,0x00,0x20,0x0e]
#CHECK: vstbrf  %v31, 0                 # encoding: [0xe6,0xf0,0x00,0x00,0x28,0x0e]
#CHECK: vstbrf  %v18, 1383(%r3,%r4)     # encoding: [0xe6,0x23,0x45,0x67,0x28,0x0e]

	vstbrf	%v0, 0
	vstbrf	%v0, 4095
	vstbrf	%v0, 0(%r15)
	vstbrf	%v0, 0(%r15,%r1)
	vstbrf	%v15, 0
	vstbrf	%v31, 0
	vstbrf	%v18, 0x567(%r3,%r4)

#CHECK: vstbrg  %v0, 0                  # encoding: [0xe6,0x00,0x00,0x00,0x30,0x0e]
#CHECK: vstbrg  %v0, 4095               # encoding: [0xe6,0x00,0x0f,0xff,0x30,0x0e]
#CHECK: vstbrg  %v0, 0(%r15)            # encoding: [0xe6,0x00,0xf0,0x00,0x30,0x0e]
#CHECK: vstbrg  %v0, 0(%r15,%r1)        # encoding: [0xe6,0x0f,0x10,0x00,0x30,0x0e]
#CHECK: vstbrg  %v15, 0                 # encoding: [0xe6,0xf0,0x00,0x00,0x30,0x0e]
#CHECK: vstbrg  %v31, 0                 # encoding: [0xe6,0xf0,0x00,0x00,0x38,0x0e]
#CHECK: vstbrg  %v18, 1383(%r3,%r4)     # encoding: [0xe6,0x23,0x45,0x67,0x38,0x0e]

	vstbrg	%v0, 0
	vstbrg	%v0, 4095
	vstbrg	%v0, 0(%r15)
	vstbrg	%v0, 0(%r15,%r1)
	vstbrg	%v15, 0
	vstbrg	%v31, 0
	vstbrg	%v18, 0x567(%r3,%r4)

#CHECK: vstbrh  %v0, 0                  # encoding: [0xe6,0x00,0x00,0x00,0x10,0x0e]
#CHECK: vstbrh  %v0, 4095               # encoding: [0xe6,0x00,0x0f,0xff,0x10,0x0e]
#CHECK: vstbrh  %v0, 0(%r15)            # encoding: [0xe6,0x00,0xf0,0x00,0x10,0x0e]
#CHECK: vstbrh  %v0, 0(%r15,%r1)        # encoding: [0xe6,0x0f,0x10,0x00,0x10,0x0e]
#CHECK: vstbrh  %v15, 0                 # encoding: [0xe6,0xf0,0x00,0x00,0x10,0x0e]
#CHECK: vstbrh  %v31, 0                 # encoding: [0xe6,0xf0,0x00,0x00,0x18,0x0e]
#CHECK: vstbrh  %v18, 1383(%r3,%r4)     # encoding: [0xe6,0x23,0x45,0x67,0x18,0x0e]

	vstbrh	%v0, 0
	vstbrh	%v0, 4095
	vstbrh	%v0, 0(%r15)
	vstbrh	%v0, 0(%r15,%r1)
	vstbrh	%v15, 0
	vstbrh	%v31, 0
	vstbrh	%v18, 0x567(%r3,%r4)

#CHECK: vstbrq  %v0, 0                  # encoding: [0xe6,0x00,0x00,0x00,0x40,0x0e]
#CHECK: vstbrq  %v0, 4095               # encoding: [0xe6,0x00,0x0f,0xff,0x40,0x0e]
#CHECK: vstbrq  %v0, 0(%r15)            # encoding: [0xe6,0x00,0xf0,0x00,0x40,0x0e]
#CHECK: vstbrq  %v0, 0(%r15,%r1)        # encoding: [0xe6,0x0f,0x10,0x00,0x40,0x0e]
#CHECK: vstbrq  %v15, 0                 # encoding: [0xe6,0xf0,0x00,0x00,0x40,0x0e]
#CHECK: vstbrq  %v31, 0                 # encoding: [0xe6,0xf0,0x00,0x00,0x48,0x0e]
#CHECK: vstbrq  %v18, 1383(%r3,%r4)     # encoding: [0xe6,0x23,0x45,0x67,0x48,0x0e]

	vstbrq	%v0, 0
	vstbrq	%v0, 4095
	vstbrq	%v0, 0(%r15)
	vstbrq	%v0, 0(%r15,%r1)
	vstbrq	%v15, 0
	vstbrq	%v31, 0
	vstbrq	%v18, 0x567(%r3,%r4)

#CHECK: vstebrf  %v0, 0, 0               # encoding: [0xe6,0x00,0x00,0x00,0x00,0x0b]
#CHECK: vstebrf  %v0, 0, 3               # encoding: [0xe6,0x00,0x00,0x00,0x30,0x0b]
#CHECK: vstebrf  %v0, 4095, 0            # encoding: [0xe6,0x00,0x0f,0xff,0x00,0x0b]
#CHECK: vstebrf  %v0, 0(%r15), 0         # encoding: [0xe6,0x00,0xf0,0x00,0x00,0x0b]
#CHECK: vstebrf  %v0, 0(%r15,%r1), 0     # encoding: [0xe6,0x0f,0x10,0x00,0x00,0x0b]
#CHECK: vstebrf  %v15, 0, 0              # encoding: [0xe6,0xf0,0x00,0x00,0x00,0x0b]
#CHECK: vstebrf  %v31, 0, 0              # encoding: [0xe6,0xf0,0x00,0x00,0x08,0x0b]
#CHECK: vstebrf  %v18, 1383(%r3,%r4), 2  # encoding: [0xe6,0x23,0x45,0x67,0x28,0x0b]

	vstebrf	%v0, 0, 0
	vstebrf	%v0, 0, 3
	vstebrf	%v0, 4095, 0
	vstebrf	%v0, 0(%r15), 0
	vstebrf	%v0, 0(%r15,%r1), 0
	vstebrf	%v15, 0, 0
	vstebrf	%v31, 0, 0
	vstebrf	%v18, 1383(%r3,%r4), 2

#CHECK: vstebrg  %v0, 0, 0               # encoding: [0xe6,0x00,0x00,0x00,0x00,0x0a]
#CHECK: vstebrg  %v0, 0, 1               # encoding: [0xe6,0x00,0x00,0x00,0x10,0x0a]
#CHECK: vstebrg  %v0, 4095, 0            # encoding: [0xe6,0x00,0x0f,0xff,0x00,0x0a]
#CHECK: vstebrg  %v0, 0(%r15), 0         # encoding: [0xe6,0x00,0xf0,0x00,0x00,0x0a]
#CHECK: vstebrg  %v0, 0(%r15,%r1), 0     # encoding: [0xe6,0x0f,0x10,0x00,0x00,0x0a]
#CHECK: vstebrg  %v15, 0, 0              # encoding: [0xe6,0xf0,0x00,0x00,0x00,0x0a]
#CHECK: vstebrg  %v31, 0, 0              # encoding: [0xe6,0xf0,0x00,0x00,0x08,0x0a]
#CHECK: vstebrg  %v18, 1383(%r3,%r4), 1  # encoding: [0xe6,0x23,0x45,0x67,0x18,0x0a]

	vstebrg	%v0, 0, 0
	vstebrg	%v0, 0, 1
	vstebrg	%v0, 4095, 0
	vstebrg	%v0, 0(%r15), 0
	vstebrg	%v0, 0(%r15,%r1), 0
	vstebrg	%v15, 0, 0
	vstebrg	%v31, 0, 0
	vstebrg	%v18, 1383(%r3,%r4), 1

#CHECK: vstebrh  %v0, 0, 0               # encoding: [0xe6,0x00,0x00,0x00,0x00,0x09]
#CHECK: vstebrh  %v0, 0, 7               # encoding: [0xe6,0x00,0x00,0x00,0x70,0x09]
#CHECK: vstebrh  %v0, 4095, 0            # encoding: [0xe6,0x00,0x0f,0xff,0x00,0x09]
#CHECK: vstebrh  %v0, 0(%r15), 0         # encoding: [0xe6,0x00,0xf0,0x00,0x00,0x09]
#CHECK: vstebrh  %v0, 0(%r15,%r1), 0     # encoding: [0xe6,0x0f,0x10,0x00,0x00,0x09]
#CHECK: vstebrh  %v15, 0, 0              # encoding: [0xe6,0xf0,0x00,0x00,0x00,0x09]
#CHECK: vstebrh  %v31, 0, 0              # encoding: [0xe6,0xf0,0x00,0x00,0x08,0x09]
#CHECK: vstebrh  %v18, 1383(%r3,%r4), 4  # encoding: [0xe6,0x23,0x45,0x67,0x48,0x09]

	vstebrh	%v0, 0, 0
	vstebrh	%v0, 0, 7
	vstebrh	%v0, 4095, 0
	vstebrh	%v0, 0(%r15), 0
	vstebrh	%v0, 0(%r15,%r1), 0
	vstebrh	%v15, 0, 0
	vstebrh	%v31, 0, 0
	vstebrh	%v18, 1383(%r3,%r4), 4

#CHECK: vster   %v0, 0, 0               # encoding: [0xe6,0x00,0x00,0x00,0x00,0x0f]
#CHECK: vster   %v0, 0, 15              # encoding: [0xe6,0x00,0x00,0x00,0xf0,0x0f]
#CHECK: vster   %v0, 4095, 0            # encoding: [0xe6,0x00,0x0f,0xff,0x00,0x0f]
#CHECK: vster   %v0, 0(%r15), 0         # encoding: [0xe6,0x00,0xf0,0x00,0x00,0x0f]
#CHECK: vster   %v0, 0(%r15,%r1), 0     # encoding: [0xe6,0x0f,0x10,0x00,0x00,0x0f]
#CHECK: vster   %v15, 0, 0              # encoding: [0xe6,0xf0,0x00,0x00,0x00,0x0f]
#CHECK: vster   %v31, 0, 0              # encoding: [0xe6,0xf0,0x00,0x00,0x08,0x0f]
#CHECK: vster   %v18, 1383(%r3,%r4), 11 # encoding: [0xe6,0x23,0x45,0x67,0xb8,0x0f]

	vster	%v0, 0, 0
	vster	%v0, 0, 15
	vster	%v0, 4095, 0
	vster	%v0, 0(%r15), 0
	vster	%v0, 0(%r15,%r1), 0
	vster	%v15, 0, 0
	vster	%v31, 0, 0
	vster	%v18, 0x567(%r3,%r4), 11

#CHECK: vsterf  %v0, 0                  # encoding: [0xe6,0x00,0x00,0x00,0x20,0x0f]
#CHECK: vsterf  %v0, 4095               # encoding: [0xe6,0x00,0x0f,0xff,0x20,0x0f]
#CHECK: vsterf  %v0, 0(%r15)            # encoding: [0xe6,0x00,0xf0,0x00,0x20,0x0f]
#CHECK: vsterf  %v0, 0(%r15,%r1)        # encoding: [0xe6,0x0f,0x10,0x00,0x20,0x0f]
#CHECK: vsterf  %v15, 0                 # encoding: [0xe6,0xf0,0x00,0x00,0x20,0x0f]
#CHECK: vsterf  %v31, 0                 # encoding: [0xe6,0xf0,0x00,0x00,0x28,0x0f]
#CHECK: vsterf  %v18, 1383(%r3,%r4)     # encoding: [0xe6,0x23,0x45,0x67,0x28,0x0f]

	vsterf	%v0, 0
	vsterf	%v0, 4095
	vsterf	%v0, 0(%r15)
	vsterf	%v0, 0(%r15,%r1)
	vsterf	%v15, 0
	vsterf	%v31, 0
	vsterf	%v18, 0x567(%r3,%r4)

#CHECK: vsterg  %v0, 0                  # encoding: [0xe6,0x00,0x00,0x00,0x30,0x0f]
#CHECK: vsterg  %v0, 4095               # encoding: [0xe6,0x00,0x0f,0xff,0x30,0x0f]
#CHECK: vsterg  %v0, 0(%r15)            # encoding: [0xe6,0x00,0xf0,0x00,0x30,0x0f]
#CHECK: vsterg  %v0, 0(%r15,%r1)        # encoding: [0xe6,0x0f,0x10,0x00,0x30,0x0f]
#CHECK: vsterg  %v15, 0                 # encoding: [0xe6,0xf0,0x00,0x00,0x30,0x0f]
#CHECK: vsterg  %v31, 0                 # encoding: [0xe6,0xf0,0x00,0x00,0x38,0x0f]
#CHECK: vsterg  %v18, 1383(%r3,%r4)     # encoding: [0xe6,0x23,0x45,0x67,0x38,0x0f]

	vsterg	%v0, 0
	vsterg	%v0, 4095
	vsterg	%v0, 0(%r15)
	vsterg	%v0, 0(%r15,%r1)
	vsterg	%v15, 0
	vsterg	%v31, 0
	vsterg	%v18, 0x567(%r3,%r4)

#CHECK: vsterh  %v0, 0                  # encoding: [0xe6,0x00,0x00,0x00,0x10,0x0f]
#CHECK: vsterh  %v0, 4095               # encoding: [0xe6,0x00,0x0f,0xff,0x10,0x0f]
#CHECK: vsterh  %v0, 0(%r15)            # encoding: [0xe6,0x00,0xf0,0x00,0x10,0x0f]
#CHECK: vsterh  %v0, 0(%r15,%r1)        # encoding: [0xe6,0x0f,0x10,0x00,0x10,0x0f]
#CHECK: vsterh  %v15, 0                 # encoding: [0xe6,0xf0,0x00,0x00,0x10,0x0f]
#CHECK: vsterh  %v31, 0                 # encoding: [0xe6,0xf0,0x00,0x00,0x18,0x0f]
#CHECK: vsterh  %v18, 1383(%r3,%r4)     # encoding: [0xe6,0x23,0x45,0x67,0x18,0x0f]

	vsterh	%v0, 0
	vsterh	%v0, 4095
	vsterh	%v0, 0(%r15)
	vsterh	%v0, 0(%r15,%r1)
	vsterh	%v15, 0
	vsterh	%v31, 0
	vsterh	%v18, 0x567(%r3,%r4)

#CHECK: vstrs    %v0, %v0, %v0, %v0, 0, 0    # encoding: [0xe7,0x00,0x00,0x00,0x00,0x8b]
#CHECK: vstrs    %v0, %v0, %v0, %v0, 15, 0   # encoding: [0xe7,0x00,0x0f,0x00,0x00,0x8b]
#CHECK: vstrs    %v0, %v0, %v0, %v0, 0, 0    # encoding: [0xe7,0x00,0x00,0x00,0x00,0x8b]
#CHECK: vstrs    %v0, %v0, %v0, %v0, 15, 0   # encoding: [0xe7,0x00,0x0f,0x00,0x00,0x8b]
#CHECK: vstrs    %v0, %v0, %v0, %v0, 0, 12   # encoding: [0xe7,0x00,0x00,0xc0,0x00,0x8b]
#CHECK: vstrs    %v0, %v0, %v0, %v15, 0, 0   # encoding: [0xe7,0x00,0x00,0x00,0xf0,0x8b]
#CHECK: vstrs    %v0, %v0, %v0, %v31, 0, 0   # encoding: [0xe7,0x00,0x00,0x00,0xf1,0x8b]
#CHECK: vstrs    %v0, %v0, %v15, %v0, 0, 0   # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x8b]
#CHECK: vstrs    %v0, %v0, %v31, %v0, 0, 0   # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x8b]
#CHECK: vstrs    %v0, %v15, %v0, %v0, 0, 0   # encoding: [0xe7,0x0f,0x00,0x00,0x00,0x8b]
#CHECK: vstrs    %v0, %v31, %v0, %v0, 0, 0   # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x8b]
#CHECK: vstrs    %v15, %v0, %v0, %v0, 0, 0   # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x8b]
#CHECK: vstrs    %v31, %v0, %v0, %v0, 0, 0   # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x8b]
#CHECK: vstrs    %v18, %v3, %v20, %v5, 11, 4 # encoding: [0xe7,0x23,0x4b,0x40,0x5a,0x8b]
#CHECK: vstrs    %v18, %v3, %v20, %v5, 0, 15 # encoding: [0xe7,0x23,0x40,0xf0,0x5a,0x8b]

        vstrs    %v0, %v0, %v0, %v0, 0
        vstrs    %v0, %v0, %v0, %v0, 15
        vstrs    %v0, %v0, %v0, %v0, 0, 0
        vstrs    %v0, %v0, %v0, %v0, 15, 0
        vstrs    %v0, %v0, %v0, %v0, 0, 12
        vstrs    %v0, %v0, %v0, %v15, 0
        vstrs    %v0, %v0, %v0, %v31, 0
        vstrs    %v0, %v0, %v15, %v0, 0
        vstrs    %v0, %v0, %v31, %v0, 0
        vstrs    %v0, %v15, %v0, %v0, 0
        vstrs    %v0, %v31, %v0, %v0, 0
        vstrs    %v15, %v0, %v0, %v0, 0
        vstrs    %v31, %v0, %v0, %v0, 0
        vstrs    %v18, %v3, %v20, %v5, 11, 4
        vstrs    %v18, %v3, %v20, %v5, 0, 15

#CHECK: vstrsb   %v0, %v0, %v0, %v0, 0       # encoding: [0xe7,0x00,0x00,0x00,0x00,0x8b]
#CHECK: vstrsb   %v0, %v0, %v0, %v0, 0       # encoding: [0xe7,0x00,0x00,0x00,0x00,0x8b]
#CHECK: vstrsb   %v0, %v0, %v0, %v0, 12      # encoding: [0xe7,0x00,0x00,0xc0,0x00,0x8b]
#CHECK: vstrsb   %v0, %v0, %v0, %v15, 0      # encoding: [0xe7,0x00,0x00,0x00,0xf0,0x8b]
#CHECK: vstrsb   %v0, %v0, %v0, %v31, 0      # encoding: [0xe7,0x00,0x00,0x00,0xf1,0x8b]
#CHECK: vstrsb   %v0, %v0, %v15, %v0, 0      # encoding: [0xe7,0x00,0xf0,0x00,0x00,0x8b]
#CHECK: vstrsb   %v0, %v0, %v31, %v0, 0      # encoding: [0xe7,0x00,0xf0,0x00,0x02,0x8b]
#CHECK: vstrsb   %v0, %v15, %v0, %v0, 0      # encoding: [0xe7,0x0f,0x00,0x00,0x00,0x8b]
#CHECK: vstrsb   %v0, %v31, %v0, %v0, 0      # encoding: [0xe7,0x0f,0x00,0x00,0x04,0x8b]
#CHECK: vstrsb   %v15, %v0, %v0, %v0, 0      # encoding: [0xe7,0xf0,0x00,0x00,0x00,0x8b]
#CHECK: vstrsb   %v31, %v0, %v0, %v0, 0      # encoding: [0xe7,0xf0,0x00,0x00,0x08,0x8b]
#CHECK: vstrsb   %v18, %v3, %v20, %v5, 4     # encoding: [0xe7,0x23,0x40,0x40,0x5a,0x8b]
#CHECK: vstrsb   %v18, %v3, %v20, %v5, 15    # encoding: [0xe7,0x23,0x40,0xf0,0x5a,0x8b]
#CHECK: vstrszb  %v18, %v3, %v20, %v5        # encoding: [0xe7,0x23,0x40,0x20,0x5a,0x8b]

        vstrsb   %v0, %v0, %v0, %v0
        vstrsb   %v0, %v0, %v0, %v0, 0
        vstrsb   %v0, %v0, %v0, %v0, 12
        vstrsb   %v0, %v0, %v0, %v15
        vstrsb   %v0, %v0, %v0, %v31
        vstrsb   %v0, %v0, %v15, %v0
        vstrsb   %v0, %v0, %v31, %v0
        vstrsb   %v0, %v15, %v0, %v0
        vstrsb   %v0, %v31, %v0, %v0
        vstrsb   %v15, %v0, %v0, %v0
        vstrsb   %v31, %v0, %v0, %v0
        vstrsb   %v18, %v3, %v20, %v5, 4
        vstrsb   %v18, %v3, %v20, %v5, 15
        vstrszb  %v18, %v3, %v20, %v5

#CHECK: vstrsf   %v0, %v0, %v0, %v0, 0       # encoding: [0xe7,0x00,0x02,0x00,0x00,0x8b]
#CHECK: vstrsf   %v0, %v0, %v0, %v0, 0       # encoding: [0xe7,0x00,0x02,0x00,0x00,0x8b]
#CHECK: vstrsf   %v0, %v0, %v0, %v0, 12      # encoding: [0xe7,0x00,0x02,0xc0,0x00,0x8b]
#CHECK: vstrsf   %v0, %v0, %v0, %v15, 0      # encoding: [0xe7,0x00,0x02,0x00,0xf0,0x8b]
#CHECK: vstrsf   %v0, %v0, %v0, %v31, 0      # encoding: [0xe7,0x00,0x02,0x00,0xf1,0x8b]
#CHECK: vstrsf   %v0, %v0, %v15, %v0, 0      # encoding: [0xe7,0x00,0xf2,0x00,0x00,0x8b]
#CHECK: vstrsf   %v0, %v0, %v31, %v0, 0      # encoding: [0xe7,0x00,0xf2,0x00,0x02,0x8b]
#CHECK: vstrsf   %v0, %v15, %v0, %v0, 0      # encoding: [0xe7,0x0f,0x02,0x00,0x00,0x8b]
#CHECK: vstrsf   %v0, %v31, %v0, %v0, 0      # encoding: [0xe7,0x0f,0x02,0x00,0x04,0x8b]
#CHECK: vstrsf   %v15, %v0, %v0, %v0, 0      # encoding: [0xe7,0xf0,0x02,0x00,0x00,0x8b]
#CHECK: vstrsf   %v31, %v0, %v0, %v0, 0      # encoding: [0xe7,0xf0,0x02,0x00,0x08,0x8b]
#CHECK: vstrsf   %v18, %v3, %v20, %v5, 4     # encoding: [0xe7,0x23,0x42,0x40,0x5a,0x8b]
#CHECK: vstrsf   %v18, %v3, %v20, %v5, 15    # encoding: [0xe7,0x23,0x42,0xf0,0x5a,0x8b]
#CHECK: vstrszf  %v18, %v3, %v20, %v5        # encoding: [0xe7,0x23,0x42,0x20,0x5a,0x8b]

        vstrsf   %v0, %v0, %v0, %v0
        vstrsf   %v0, %v0, %v0, %v0, 0
        vstrsf   %v0, %v0, %v0, %v0, 12
        vstrsf   %v0, %v0, %v0, %v15
        vstrsf   %v0, %v0, %v0, %v31
        vstrsf   %v0, %v0, %v15, %v0
        vstrsf   %v0, %v0, %v31, %v0
        vstrsf   %v0, %v15, %v0, %v0
        vstrsf   %v0, %v31, %v0, %v0
        vstrsf   %v15, %v0, %v0, %v0
        vstrsf   %v31, %v0, %v0, %v0
        vstrsf   %v18, %v3, %v20, %v5, 4
        vstrsf   %v18, %v3, %v20, %v5, 15
        vstrszf  %v18, %v3, %v20, %v5

#CHECK: vstrsh   %v0, %v0, %v0, %v0, 0       # encoding: [0xe7,0x00,0x01,0x00,0x00,0x8b]
#CHECK: vstrsh   %v0, %v0, %v0, %v0, 0       # encoding: [0xe7,0x00,0x01,0x00,0x00,0x8b]
#CHECK: vstrsh   %v0, %v0, %v0, %v0, 12      # encoding: [0xe7,0x00,0x01,0xc0,0x00,0x8b]
#CHECK: vstrsh   %v0, %v0, %v0, %v15, 0      # encoding: [0xe7,0x00,0x01,0x00,0xf0,0x8b]
#CHECK: vstrsh   %v0, %v0, %v0, %v31, 0      # encoding: [0xe7,0x00,0x01,0x00,0xf1,0x8b]
#CHECK: vstrsh   %v0, %v0, %v15, %v0, 0      # encoding: [0xe7,0x00,0xf1,0x00,0x00,0x8b]
#CHECK: vstrsh   %v0, %v0, %v31, %v0, 0      # encoding: [0xe7,0x00,0xf1,0x00,0x02,0x8b]
#CHECK: vstrsh   %v0, %v15, %v0, %v0, 0      # encoding: [0xe7,0x0f,0x01,0x00,0x00,0x8b]
#CHECK: vstrsh   %v0, %v31, %v0, %v0, 0      # encoding: [0xe7,0x0f,0x01,0x00,0x04,0x8b]
#CHECK: vstrsh   %v15, %v0, %v0, %v0, 0      # encoding: [0xe7,0xf0,0x01,0x00,0x00,0x8b]
#CHECK: vstrsh   %v31, %v0, %v0, %v0, 0      # encoding: [0xe7,0xf0,0x01,0x00,0x08,0x8b]
#CHECK: vstrsh   %v18, %v3, %v20, %v5, 4     # encoding: [0xe7,0x23,0x41,0x40,0x5a,0x8b]
#CHECK: vstrsh   %v18, %v3, %v20, %v5, 15    # encoding: [0xe7,0x23,0x41,0xf0,0x5a,0x8b]
#CHECK: vstrszh  %v18, %v3, %v20, %v5        # encoding: [0xe7,0x23,0x41,0x20,0x5a,0x8b]

        vstrsh   %v0, %v0, %v0, %v0
        vstrsh   %v0, %v0, %v0, %v0, 0
        vstrsh   %v0, %v0, %v0, %v0, 12
        vstrsh   %v0, %v0, %v0, %v15
        vstrsh   %v0, %v0, %v0, %v31
        vstrsh   %v0, %v0, %v15, %v0
        vstrsh   %v0, %v0, %v31, %v0
        vstrsh   %v0, %v15, %v0, %v0
        vstrsh   %v0, %v31, %v0, %v0
        vstrsh   %v15, %v0, %v0, %v0
        vstrsh   %v31, %v0, %v0, %v0
        vstrsh   %v18, %v3, %v20, %v5, 4
        vstrsh   %v18, %v3, %v20, %v5, 15
        vstrszh  %v18, %v3, %v20, %v5

#CHECK: wcefb   %f0, %f0, 0, 0          # encoding: [0xe7,0x00,0x00,0x08,0x20,0xc3]
#CHECK: wcefb   %f0, %f0, 0, 0          # encoding: [0xe7,0x00,0x00,0x08,0x20,0xc3]
#CHECK: wcefb   %f0, %f0, 0, 15         # encoding: [0xe7,0x00,0x00,0xf8,0x20,0xc3]
#CHECK: wcefb   %f0, %f0, 4, 0          # encoding: [0xe7,0x00,0x00,0x0c,0x20,0xc3]
#CHECK: wcefb   %f0, %f0, 12, 0         # encoding: [0xe7,0x00,0x00,0x0c,0x20,0xc3]
#CHECK: wcefb   %f0, %v31, 0, 0         # encoding: [0xe7,0x0f,0x00,0x08,0x24,0xc3]
#CHECK: wcefb   %v31, %f0, 0, 0         # encoding: [0xe7,0xf0,0x00,0x08,0x28,0xc3]
#CHECK: wcefb   %f14, %v17, 4, 10       # encoding: [0xe7,0xe1,0x00,0xac,0x24,0xc3]

	wcefb	%v0, %v0, 0, 0
	wcefb   %f0, %f0, 0, 0
 	wcefb	%v0, %v0, 0, 15
	wcefb	%v0, %v0, 4, 0
	wcefb	%v0, %v0, 12, 0
	wcefb	%v0, %v31, 0, 0
	wcefb	%v31, %v0, 0, 0
	wcefb	%v14, %v17, 4, 10

#CHECK: wcelfb  %f0, %f0, 0, 0          # encoding: [0xe7,0x00,0x00,0x08,0x20,0xc1]
#CHECK: wcelfb  %f0, %f0, 0, 0          # encoding: [0xe7,0x00,0x00,0x08,0x20,0xc1]
#CHECK: wcelfb  %f0, %f0, 0, 15         # encoding: [0xe7,0x00,0x00,0xf8,0x20,0xc1]
#CHECK: wcelfb  %f0, %f0, 4, 0          # encoding: [0xe7,0x00,0x00,0x0c,0x20,0xc1]
#CHECK: wcelfb  %f0, %f0, 12, 0         # encoding: [0xe7,0x00,0x00,0x0c,0x20,0xc1]
#CHECK: wcelfb  %f0, %v31, 0, 0         # encoding: [0xe7,0x0f,0x00,0x08,0x24,0xc1]
#CHECK: wcelfb  %v31, %f0, 0, 0         # encoding: [0xe7,0xf0,0x00,0x08,0x28,0xc1]
#CHECK: wcelfb  %f14, %v17, 4, 10       # encoding: [0xe7,0xe1,0x00,0xac,0x24,0xc1]

	wcelfb	%v0, %v0, 0, 0
	wcelfb  %f0, %f0, 0, 0
 	wcelfb	%v0, %v0, 0, 15
	wcelfb	%v0, %v0, 4, 0
	wcelfb	%v0, %v0, 12, 0
	wcelfb	%v0, %v31, 0, 0
	wcelfb	%v31, %v0, 0, 0
	wcelfb	%v14, %v17, 4, 10

#CHECK: wcfeb   %f0, %f0, 0, 0          # encoding: [0xe7,0x00,0x00,0x08,0x20,0xc2]
#CHECK: wcfeb   %f0, %f0, 0, 0          # encoding: [0xe7,0x00,0x00,0x08,0x20,0xc2]
#CHECK: wcfeb   %f0, %f0, 0, 15         # encoding: [0xe7,0x00,0x00,0xf8,0x20,0xc2]
#CHECK: wcfeb   %f0, %f0, 4, 0          # encoding: [0xe7,0x00,0x00,0x0c,0x20,0xc2]
#CHECK: wcfeb   %f0, %f0, 12, 0         # encoding: [0xe7,0x00,0x00,0x0c,0x20,0xc2]
#CHECK: wcfeb   %f0, %v31, 0, 0         # encoding: [0xe7,0x0f,0x00,0x08,0x24,0xc2]
#CHECK: wcfeb   %v31, %f0, 0, 0         # encoding: [0xe7,0xf0,0x00,0x08,0x28,0xc2]
#CHECK: wcfeb   %f14, %v17, 4, 10       # encoding: [0xe7,0xe1,0x00,0xac,0x24,0xc2]

	wcfeb	%v0, %v0, 0, 0
	wcfeb  	%f0, %f0, 0, 0
 	wcfeb	%v0, %v0, 0, 15
	wcfeb	%v0, %v0, 4, 0
	wcfeb	%v0, %v0, 12, 0
	wcfeb	%v0, %v31, 0, 0
	wcfeb	%v31, %v0, 0, 0
	wcfeb	%v14, %v17, 4, 10

#CHECK: wclfeb  %f0, %f0, 0, 0          # encoding: [0xe7,0x00,0x00,0x08,0x20,0xc0]
#CHECK: wclfeb  %f0, %f0, 0, 0          # encoding: [0xe7,0x00,0x00,0x08,0x20,0xc0]
#CHECK: wclfeb  %f0, %f0, 0, 15         # encoding: [0xe7,0x00,0x00,0xf8,0x20,0xc0]
#CHECK: wclfeb  %f0, %f0, 4, 0          # encoding: [0xe7,0x00,0x00,0x0c,0x20,0xc0]
#CHECK: wclfeb  %f0, %f0, 12, 0         # encoding: [0xe7,0x00,0x00,0x0c,0x20,0xc0]
#CHECK: wclfeb  %f0, %v31, 0, 0         # encoding: [0xe7,0x0f,0x00,0x08,0x24,0xc0]
#CHECK: wclfeb  %v31, %f0, 0, 0         # encoding: [0xe7,0xf0,0x00,0x08,0x28,0xc0]
#CHECK: wclfeb  %f14, %v17, 4, 10       # encoding: [0xe7,0xe1,0x00,0xac,0x24,0xc0]

	wclfeb	%v0, %v0, 0, 0
	wclfeb  %f0, %f0, 0, 0
 	wclfeb	%v0, %v0, 0, 15
	wclfeb	%v0, %v0, 4, 0
	wclfeb	%v0, %v0, 12, 0
	wclfeb	%v0, %v31, 0, 0
	wclfeb	%v31, %v0, 0, 0
	wclfeb	%v14, %v17, 4, 10

