// Copyright 2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License"). You may not
// use this file except in compliance with the License. A copy of the
// License is located at
//
// http://aws.amazon.com/apache2.0/
//
// or in the "license" file accompanying this file. This file is distributed
// on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
// either express or implied. See the License for the specific language governing
// permissions and limitations under the License.
// Code generated by mockery v1.0.0
package mocks

import (
	time "time"

	log "github.com/aws/amazon-ssm-agent/agent/log"
	ssm "github.com/aws/aws-sdk-go/service/ssm"
	mock "github.com/stretchr/testify/mock"
)

// Service is an autogenerated mock type for the Service type
type Service struct {
	mock.Mock
}

// CancelCommand provides a mock function with given fields: _a0, commandID, instanceIDs
func (_m *Service) CancelCommand(_a0 log.T, commandID string, instanceIDs []string) (*ssm.CancelCommandOutput, error) {
	ret := _m.Called(_a0, commandID, instanceIDs)

	var r0 *ssm.CancelCommandOutput
	if rf, ok := ret.Get(0).(func(log.T, string, []string) *ssm.CancelCommandOutput); ok {
		r0 = rf(_a0, commandID, instanceIDs)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*ssm.CancelCommandOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(log.T, string, []string) error); ok {
		r1 = rf(_a0, commandID, instanceIDs)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// CreateDocument provides a mock function with given fields: _a0, docName, docContent
func (_m *Service) CreateDocument(_a0 log.T, docName string, docContent string) (*ssm.CreateDocumentOutput, error) {
	ret := _m.Called(_a0, docName, docContent)

	var r0 *ssm.CreateDocumentOutput
	if rf, ok := ret.Get(0).(func(log.T, string, string) *ssm.CreateDocumentOutput); ok {
		r0 = rf(_a0, docName, docContent)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*ssm.CreateDocumentOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(log.T, string, string) error); ok {
		r1 = rf(_a0, docName, docContent)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// DeleteDocument provides a mock function with given fields: _a0, instanceID
func (_m *Service) DeleteDocument(_a0 log.T, instanceID string) (*ssm.DeleteDocumentOutput, error) {
	ret := _m.Called(_a0, instanceID)

	var r0 *ssm.DeleteDocumentOutput
	if rf, ok := ret.Get(0).(func(log.T, string) *ssm.DeleteDocumentOutput); ok {
		r0 = rf(_a0, instanceID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*ssm.DeleteDocumentOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(log.T, string) error); ok {
		r1 = rf(_a0, instanceID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// DescribeAssociation provides a mock function with given fields: _a0, instanceID, docName
func (_m *Service) DescribeAssociation(_a0 log.T, instanceID string, docName string) (*ssm.DescribeAssociationOutput, error) {
	ret := _m.Called(_a0, instanceID, docName)

	var r0 *ssm.DescribeAssociationOutput
	if rf, ok := ret.Get(0).(func(log.T, string, string) *ssm.DescribeAssociationOutput); ok {
		r0 = rf(_a0, instanceID, docName)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*ssm.DescribeAssociationOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(log.T, string, string) error); ok {
		r1 = rf(_a0, instanceID, docName)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetDecryptedParameters provides a mock function with given fields: _a0, paramNames
func (_m *Service) GetDecryptedParameters(_a0 log.T, paramNames []string) (*ssm.GetParametersOutput, error) {
	ret := _m.Called(_a0, paramNames)

	var r0 *ssm.GetParametersOutput
	if rf, ok := ret.Get(0).(func(log.T, []string) *ssm.GetParametersOutput); ok {
		r0 = rf(_a0, paramNames)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*ssm.GetParametersOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(log.T, []string) error); ok {
		r1 = rf(_a0, paramNames)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetDocument provides a mock function with given fields: _a0, docName, docVersion
func (_m *Service) GetDocument(_a0 log.T, docName string, docVersion string) (*ssm.GetDocumentOutput, error) {
	ret := _m.Called(_a0, docName, docVersion)

	var r0 *ssm.GetDocumentOutput
	if rf, ok := ret.Get(0).(func(log.T, string, string) *ssm.GetDocumentOutput); ok {
		r0 = rf(_a0, docName, docVersion)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*ssm.GetDocumentOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(log.T, string, string) error); ok {
		r1 = rf(_a0, docName, docVersion)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetParameters provides a mock function with given fields: _a0, paramNames
func (_m *Service) GetParameters(_a0 log.T, paramNames []string) (*ssm.GetParametersOutput, error) {
	ret := _m.Called(_a0, paramNames)

	var r0 *ssm.GetParametersOutput
	if rf, ok := ret.Get(0).(func(log.T, []string) *ssm.GetParametersOutput); ok {
		r0 = rf(_a0, paramNames)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*ssm.GetParametersOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(log.T, []string) error); ok {
		r1 = rf(_a0, paramNames)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ListAssociations provides a mock function with given fields: _a0, instanceID
func (_m *Service) ListAssociations(_a0 log.T, instanceID string) (*ssm.ListAssociationsOutput, error) {
	ret := _m.Called(_a0, instanceID)

	var r0 *ssm.ListAssociationsOutput
	if rf, ok := ret.Get(0).(func(log.T, string) *ssm.ListAssociationsOutput); ok {
		r0 = rf(_a0, instanceID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*ssm.ListAssociationsOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(log.T, string) error); ok {
		r1 = rf(_a0, instanceID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ListCommandInvocations provides a mock function with given fields: _a0, instanceID, commandID
func (_m *Service) ListCommandInvocations(_a0 log.T, instanceID string, commandID string) (*ssm.ListCommandInvocationsOutput, error) {
	ret := _m.Called(_a0, instanceID, commandID)

	var r0 *ssm.ListCommandInvocationsOutput
	if rf, ok := ret.Get(0).(func(log.T, string, string) *ssm.ListCommandInvocationsOutput); ok {
		r0 = rf(_a0, instanceID, commandID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*ssm.ListCommandInvocationsOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(log.T, string, string) error); ok {
		r1 = rf(_a0, instanceID, commandID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ListCommands provides a mock function with given fields: _a0, instanceID
func (_m *Service) ListCommands(_a0 log.T, instanceID string) (*ssm.ListCommandsOutput, error) {
	ret := _m.Called(_a0, instanceID)

	var r0 *ssm.ListCommandsOutput
	if rf, ok := ret.Get(0).(func(log.T, string) *ssm.ListCommandsOutput); ok {
		r0 = rf(_a0, instanceID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*ssm.ListCommandsOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(log.T, string) error); ok {
		r1 = rf(_a0, instanceID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// ListInstanceAssociations provides a mock function with given fields: _a0, instanceID, nextToken
func (_m *Service) ListInstanceAssociations(_a0 log.T, instanceID string, nextToken *string) (*ssm.ListInstanceAssociationsOutput, error) {
	ret := _m.Called(_a0, instanceID, nextToken)

	var r0 *ssm.ListInstanceAssociationsOutput
	if rf, ok := ret.Get(0).(func(log.T, string, *string) *ssm.ListInstanceAssociationsOutput); ok {
		r0 = rf(_a0, instanceID, nextToken)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*ssm.ListInstanceAssociationsOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(log.T, string, *string) error); ok {
		r1 = rf(_a0, instanceID, nextToken)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// PutComplianceItems provides a mock function with given fields: _a0, executionTime, executionType, executionId, instanceId, complianceType, itemContentHash, items
func (_m *Service) PutComplianceItems(_a0 log.T, executionTime *time.Time, executionType string, executionId string, instanceId string, complianceType string, itemContentHash string, items []*ssm.ComplianceItemEntry) (*ssm.PutComplianceItemsOutput, error) {
	ret := _m.Called(_a0, executionTime, executionType, executionId, instanceId, complianceType, itemContentHash, items)

	var r0 *ssm.PutComplianceItemsOutput
	if rf, ok := ret.Get(0).(func(log.T, *time.Time, string, string, string, string, string, []*ssm.ComplianceItemEntry) *ssm.PutComplianceItemsOutput); ok {
		r0 = rf(_a0, executionTime, executionType, executionId, instanceId, complianceType, itemContentHash, items)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*ssm.PutComplianceItemsOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(log.T, *time.Time, string, string, string, string, string, []*ssm.ComplianceItemEntry) error); ok {
		r1 = rf(_a0, executionTime, executionType, executionId, instanceId, complianceType, itemContentHash, items)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// SendCommand provides a mock function with given fields: _a0, documentName, instanceIDs, parameters, timeoutSeconds, outputS3BucketName, outputS3KeyPrefix
func (_m *Service) SendCommand(_a0 log.T, documentName string, instanceIDs []string, parameters map[string][]*string, timeoutSeconds *int64, outputS3BucketName *string, outputS3KeyPrefix *string) (*ssm.SendCommandOutput, error) {
	ret := _m.Called(_a0, documentName, instanceIDs, parameters, timeoutSeconds, outputS3BucketName, outputS3KeyPrefix)

	var r0 *ssm.SendCommandOutput
	if rf, ok := ret.Get(0).(func(log.T, string, []string, map[string][]*string, *int64, *string, *string) *ssm.SendCommandOutput); ok {
		r0 = rf(_a0, documentName, instanceIDs, parameters, timeoutSeconds, outputS3BucketName, outputS3KeyPrefix)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*ssm.SendCommandOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(log.T, string, []string, map[string][]*string, *int64, *string, *string) error); ok {
		r1 = rf(_a0, documentName, instanceIDs, parameters, timeoutSeconds, outputS3BucketName, outputS3KeyPrefix)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UpdateAssociationStatus provides a mock function with given fields: _a0, instanceID, name, associationStatus
func (_m *Service) UpdateAssociationStatus(_a0 log.T, instanceID string, name string, associationStatus *ssm.AssociationStatus) (*ssm.UpdateAssociationStatusOutput, error) {
	ret := _m.Called(_a0, instanceID, name, associationStatus)

	var r0 *ssm.UpdateAssociationStatusOutput
	if rf, ok := ret.Get(0).(func(log.T, string, string, *ssm.AssociationStatus) *ssm.UpdateAssociationStatusOutput); ok {
		r0 = rf(_a0, instanceID, name, associationStatus)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*ssm.UpdateAssociationStatusOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(log.T, string, string, *ssm.AssociationStatus) error); ok {
		r1 = rf(_a0, instanceID, name, associationStatus)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UpdateEmptyInstanceInformation provides a mock function with given fields: agentName
func (_m *Service) UpdateEmptyInstanceInformation(_a0 log.T, agentVersion string, agentName string) (*ssm.UpdateInstanceInformationOutput, error) {
	ret := _m.Called(_a0, agentVersion, agentName)

	var r0 *ssm.UpdateInstanceInformationOutput
	if rf, ok := ret.Get(0).(func(log.T, string, string) *ssm.UpdateInstanceInformationOutput); ok {
		r0 = rf(_a0, agentVersion, agentName)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*ssm.UpdateInstanceInformationOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(log.T, string, string) error); ok {
		r1 = rf(_a0, agentVersion, agentName)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UpdateInstanceAssociationStatus provides a mock function with given fields: _a0, associationID, instanceID, executionResult
func (_m *Service) UpdateInstanceAssociationStatus(_a0 log.T, associationID string, instanceID string, executionResult *ssm.InstanceAssociationExecutionResult) (*ssm.UpdateInstanceAssociationStatusOutput, error) {
	ret := _m.Called(_a0, associationID, instanceID, executionResult)

	var r0 *ssm.UpdateInstanceAssociationStatusOutput
	if rf, ok := ret.Get(0).(func(log.T, string, string, *ssm.InstanceAssociationExecutionResult) *ssm.UpdateInstanceAssociationStatusOutput); ok {
		r0 = rf(_a0, associationID, instanceID, executionResult)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*ssm.UpdateInstanceAssociationStatusOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(log.T, string, string, *ssm.InstanceAssociationExecutionResult) error); ok {
		r1 = rf(_a0, associationID, instanceID, executionResult)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// UpdateInstanceInformation provides a mock function with given fields: _a0, agentVersion, agentStatus, agentName
func (_m *Service) UpdateInstanceInformation(_a0 log.T, agentVersion string, agentStatus string, agentName string) (*ssm.UpdateInstanceInformationOutput, error) {
	ret := _m.Called(_a0, agentVersion, agentStatus, agentName)

	var r0 *ssm.UpdateInstanceInformationOutput
	if rf, ok := ret.Get(0).(func(log.T, string, string, string) *ssm.UpdateInstanceInformationOutput); ok {
		r0 = rf(_a0, agentVersion, agentStatus, agentName)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*ssm.UpdateInstanceInformationOutput)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(log.T, string, string, string) error); ok {
		r1 = rf(_a0, agentVersion, agentStatus, agentName)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}
