package org.python.modules;

import org.python.core.*;

/**
 * This file contains autogenerated error codes from:<br/>
 *  <b>Python 2.2.1 (#5, Oct 7 2002, 09:20:38) [GCC 2.96 20000731 (Red Hat Linux 7.1 2.96-97)]</b>
 *
 * @author brian zimmer
 * @version 2.2.1
 * @copyright 2002 brian zimmer
 */
public final class errno implements ClassDictInit {

    private errno() {}

    public static final int EPERM                     = 1;
    public static final int ENOENT                    = 2;
    public static final int ESRCH                     = 3;
    public static final int EINTR                     = 4;
    public static final int EIO                       = 5;
    public static final int ENXIO                     = 6;
    public static final int E2BIG                     = 7;
    public static final int ENOEXEC                   = 8;
    public static final int EBADF                     = 9;
    public static final int ECHILD                    = 10;
    public static final int EAGAIN                    = 11;
    public static final int EWOULDBLOCK               = 11;
    public static final int ENOMEM                    = 12;
    public static final int EACCES                    = 13;
    public static final int EFAULT                    = 14;
    public static final int ENOTBLK                   = 15;
    public static final int EBUSY                     = 16;
    public static final int EEXIST                    = 17;
    public static final int EXDEV                     = 18;
    public static final int ENODEV                    = 19;
    public static final int ENOTDIR                   = 20;
    public static final int EISDIR                    = 21;
    public static final int EINVAL                    = 22;
    public static final int ENFILE                    = 23;
    public static final int EMFILE                    = 24;
    public static final int ENOTTY                    = 25;
    public static final int ETXTBSY                   = 26;
    public static final int EFBIG                     = 27;
    public static final int ENOSPC                    = 28;
    public static final int ESPIPE                    = 29;
    public static final int EROFS                     = 30;
    public static final int EMLINK                    = 31;
    public static final int EPIPE                     = 32;
    public static final int EDOM                      = 33;
    public static final int ERANGE                    = 34;
    public static final int EDEADLK                   = 35;
    public static final int EDEADLOCK                 = 35;
    public static final int ENAMETOOLONG              = 36;
    public static final int ENOLCK                    = 37;
    public static final int ENOSYS                    = 38;
    public static final int ENOTEMPTY                 = 39;
    public static final int ELOOP                     = 40;
    public static final int ENOMSG                    = 42;
    public static final int EIDRM                     = 43;
    public static final int ECHRNG                    = 44;
    public static final int EL2NSYNC                  = 45;
    public static final int EL3HLT                    = 46;
    public static final int EL3RST                    = 47;
    public static final int ELNRNG                    = 48;
    public static final int EUNATCH                   = 49;
    public static final int ENOCSI                    = 50;
    public static final int EL2HLT                    = 51;
    public static final int EBADE                     = 52;
    public static final int EBADR                     = 53;
    public static final int EXFULL                    = 54;
    public static final int ENOANO                    = 55;
    public static final int EBADRQC                   = 56;
    public static final int EBADSLT                   = 57;
    public static final int EBFONT                    = 59;
    public static final int ENOSTR                    = 60;
    public static final int ENODATA                   = 61;
    public static final int ETIME                     = 62;
    public static final int ENOSR                     = 63;
    public static final int ENONET                    = 64;
    public static final int ENOPKG                    = 65;
    public static final int EREMOTE                   = 66;
    public static final int ENOLINK                   = 67;
    public static final int EADV                      = 68;
    public static final int ESRMNT                    = 69;
    public static final int ECOMM                     = 70;
    public static final int EPROTO                    = 71;
    public static final int EMULTIHOP                 = 72;
    public static final int EDOTDOT                   = 73;
    public static final int EBADMSG                   = 74;
    public static final int EOVERFLOW                 = 75;
    public static final int ENOTUNIQ                  = 76;
    public static final int EBADFD                    = 77;
    public static final int EREMCHG                   = 78;
    public static final int ELIBACC                   = 79;
    public static final int ELIBBAD                   = 80;
    public static final int ELIBSCN                   = 81;
    public static final int ELIBMAX                   = 82;
    public static final int ELIBEXEC                  = 83;
    public static final int EILSEQ                    = 84;
    public static final int ERESTART                  = 85;
    public static final int ESTRPIPE                  = 86;
    public static final int EUSERS                    = 87;
    public static final int ENOTSOCK                  = 88;
    public static final int EDESTADDRREQ              = 89;
    public static final int EMSGSIZE                  = 90;
    public static final int EPROTOTYPE                = 91;
    public static final int ENOPROTOOPT               = 92;
    public static final int EPROTONOSUPPORT           = 93;
    public static final int ESOCKTNOSUPPORT           = 94;
    public static final int EOPNOTSUPP                = 95;
    public static final int EPFNOSUPPORT              = 96;
    public static final int EAFNOSUPPORT              = 97;
    public static final int EADDRINUSE                = 98;
    public static final int EADDRNOTAVAIL             = 99;
    public static final int ENETDOWN                  = 100;
    public static final int ENETUNREACH               = 101;
    public static final int ENETRESET                 = 102;
    public static final int ECONNABORTED              = 103;
    public static final int ECONNRESET                = 104;
    public static final int ENOBUFS                   = 105;
    public static final int EISCONN                   = 106;
    public static final int ENOTCONN                  = 107;
    public static final int ESHUTDOWN                 = 108;
    public static final int ETOOMANYREFS              = 109;
    public static final int ETIMEDOUT                 = 110;
    public static final int ECONNREFUSED              = 111;
    public static final int EHOSTDOWN                 = 112;
    public static final int EHOSTUNREACH              = 113;
    public static final int EALREADY                  = 114;
    public static final int EINPROGRESS               = 115;
    public static final int ESTALE                    = 116;
    public static final int EUCLEAN                   = 117;
    public static final int ENOTNAM                   = 118;
    public static final int ENAVAIL                   = 119;
    public static final int EISNAM                    = 120;
    public static final int EREMOTEIO                 = 121;
    public static final int EDQUOT                    = 122;

    // AMAK: Starting a new series of jython specific error numbers
    public static final int ESOCKISBLOCKING           = 20000;
    public static final int EGETADDRINFOFAILED        = 20001;

    public static final PyObject errorcode = new PyDictionary();
    private static final PyObject strerror = new PyDictionary();

    public static void classDictInit(PyObject dict) throws PyIgnoreMethodTag {
        addcode(dict, EPERM, "EPERM", "Operation not permitted");
        addcode(dict, ENOENT, "ENOENT", "No such file or directory");
        addcode(dict, ESRCH, "ESRCH", "No such process");
        addcode(dict, EINTR, "EINTR", "Interrupted system call");
        addcode(dict, EIO, "EIO", "Input/output error");
        addcode(dict, ENXIO, "ENXIO", "Device not configured");
        addcode(dict, E2BIG, "E2BIG", "Argument list too long");
        addcode(dict, ENOEXEC, "ENOEXEC", "Exec format error");
        addcode(dict, EBADF, "EBADF", "Bad file descriptor");
        addcode(dict, ECHILD, "ECHILD", "No child processes");
        addcode(dict, EAGAIN, "EAGAIN", "Resource temporarily unavailable");
        addcode(dict, EWOULDBLOCK, "EWOULDBLOCK", "Resource temporarily unavailable");
        addcode(dict, ENOMEM, "ENOMEM", "Cannot allocate memory");
        addcode(dict, EACCES, "EACCES", "Permission denied");
        addcode(dict, EFAULT, "EFAULT", "Bad address");
        addcode(dict, ENOTBLK, "ENOTBLK", "Block device required");
        addcode(dict, EBUSY, "EBUSY", "Device or resource busy");
        addcode(dict, EEXIST, "EEXIST", "File exists");
        addcode(dict, EXDEV, "EXDEV", "Invalid cross-device link");
        addcode(dict, ENODEV, "ENODEV", "No such device");
        addcode(dict, ENOTDIR, "ENOTDIR", "Not a directory");
        addcode(dict, EISDIR, "EISDIR", "Is a directory");
        addcode(dict, EINVAL, "EINVAL", "Invalid argument");
        addcode(dict, ENFILE, "ENFILE", "Too many open files in system");
        addcode(dict, EMFILE, "EMFILE", "Too many open files");
        addcode(dict, ENOTTY, "ENOTTY", "Inappropriate ioctl for device");
        addcode(dict, ETXTBSY, "ETXTBSY", "Text file busy");
        addcode(dict, EFBIG, "EFBIG", "File too large");
        addcode(dict, ENOSPC, "ENOSPC", "No space left on device");
        addcode(dict, ESPIPE, "ESPIPE", "Illegal seek");
        addcode(dict, EROFS, "EROFS", "Read-only file system");
        addcode(dict, EMLINK, "EMLINK", "Too many links");
        addcode(dict, EPIPE, "EPIPE", "Broken pipe");
        addcode(dict, EDOM, "EDOM", "Numerical argument out of domain");
        addcode(dict, ERANGE, "ERANGE", "Numerical result out of range");
        addcode(dict, EDEADLK, "EDEADLK", "Resource deadlock avoided");
        addcode(dict, EDEADLOCK, "EDEADLOCK", "Resource deadlock avoided");
        addcode(dict, ENAMETOOLONG, "ENAMETOOLONG", "File name too long");
        addcode(dict, ENOLCK, "ENOLCK", "No locks available");
        addcode(dict, ENOSYS, "ENOSYS", "Function not implemented");
        addcode(dict, ENOTEMPTY, "ENOTEMPTY", "Directory not empty");
        addcode(dict, ELOOP, "ELOOP", "Too many levels of symbolic links");
        addcode(dict, ENOMSG, "ENOMSG", "No message of desired type");
        addcode(dict, EIDRM, "EIDRM", "Identifier removed");
        addcode(dict, ECHRNG, "ECHRNG", "Channel number out of range");
        addcode(dict, EL2NSYNC, "EL2NSYNC", "Level 2 not synchronized");
        addcode(dict, EL3HLT, "EL3HLT", "Level 3 halted");
        addcode(dict, EL3RST, "EL3RST", "Level 3 reset");
        addcode(dict, ELNRNG, "ELNRNG", "Link number out of range");
        addcode(dict, EUNATCH, "EUNATCH", "Protocol driver not attached");
        addcode(dict, ENOCSI, "ENOCSI", "No CSI structure available");
        addcode(dict, EL2HLT, "EL2HLT", "Level 2 halted");
        addcode(dict, EBADE, "EBADE", "Invalid exchange");
        addcode(dict, EBADR, "EBADR", "Invalid request descriptor");
        addcode(dict, EXFULL, "EXFULL", "Exchange full");
        addcode(dict, ENOANO, "ENOANO", "No anode");
        addcode(dict, EBADRQC, "EBADRQC", "Invalid request code");
        addcode(dict, EBADSLT, "EBADSLT", "Invalid slot");
        addcode(dict, EBFONT, "EBFONT", "Bad font file format");
        addcode(dict, ENOSTR, "ENOSTR", "Device not a stream");
        addcode(dict, ENODATA, "ENODATA", "No data available");
        addcode(dict, ETIME, "ETIME", "Timer expired");
        addcode(dict, ENOSR, "ENOSR", "Out of streams resources");
        addcode(dict, ENONET, "ENONET", "Machine is not on the network");
        addcode(dict, ENOPKG, "ENOPKG", "Package not installed");
        addcode(dict, EREMOTE, "EREMOTE", "Object is remote");
        addcode(dict, ENOLINK, "ENOLINK", "Link has been severed");
        addcode(dict, EADV, "EADV", "Advertise error");
        addcode(dict, ESRMNT, "ESRMNT", "Srmount error");
        addcode(dict, ECOMM, "ECOMM", "Communication error on send");
        addcode(dict, EPROTO, "EPROTO", "Protocol error");
        addcode(dict, EMULTIHOP, "EMULTIHOP", "Multihop attempted");
        addcode(dict, EDOTDOT, "EDOTDOT", "RFS specific error");
        addcode(dict, EBADMSG, "EBADMSG", "Bad message");
        addcode(dict, EOVERFLOW, "EOVERFLOW", "Value too large for defined data type");
        addcode(dict, ENOTUNIQ, "ENOTUNIQ", "Name not unique on network");
        addcode(dict, EBADFD, "EBADFD", "File descriptor in bad state");
        addcode(dict, EREMCHG, "EREMCHG", "Remote address changed");
        addcode(dict, ELIBACC, "ELIBACC", "Can not access a needed shared library");
        addcode(dict, ELIBBAD, "ELIBBAD", "Accessing a corrupted shared library");
        addcode(dict, ELIBSCN, "ELIBSCN", ".lib section in a.out corrupted");
        addcode(dict, ELIBMAX, "ELIBMAX", "Attempting to link in too many shared libraries");
        addcode(dict, ELIBEXEC, "ELIBEXEC", "Cannot exec a shared library directly");
        addcode(dict, EILSEQ, "EILSEQ", "Invalid or incomplete multibyte or wide character");
        addcode(dict, ERESTART, "ERESTART", "Interrupted system call should be restarted");
        addcode(dict, ESTRPIPE, "ESTRPIPE", "Streams pipe error");
        addcode(dict, EUSERS, "EUSERS", "Too many users");
        addcode(dict, ENOTSOCK, "ENOTSOCK", "Socket operation on non-socket");
        addcode(dict, EDESTADDRREQ, "EDESTADDRREQ", "Destination address required");
        addcode(dict, EMSGSIZE, "EMSGSIZE", "Message too long");
        addcode(dict, EPROTOTYPE, "EPROTOTYPE", "Protocol wrong type for socket");
        addcode(dict, ENOPROTOOPT, "ENOPROTOOPT", "Protocol not available");
        addcode(dict, EPROTONOSUPPORT, "EPROTONOSUPPORT", "Protocol not supported");
        addcode(dict, ESOCKTNOSUPPORT, "ESOCKTNOSUPPORT", "Socket type not supported");
        addcode(dict, EOPNOTSUPP, "EOPNOTSUPP", "Operation not supported");
        addcode(dict, EPFNOSUPPORT, "EPFNOSUPPORT", "Protocol family not supported");
        addcode(dict, EAFNOSUPPORT, "EAFNOSUPPORT", "Address family not supported by protocol");
        addcode(dict, EADDRINUSE, "EADDRINUSE", "Address already in use");
        addcode(dict, EADDRNOTAVAIL, "EADDRNOTAVAIL", "Cannot assign requested address");
        addcode(dict, ENETDOWN, "ENETDOWN", "Network is down");
        addcode(dict, ENETUNREACH, "ENETUNREACH", "Network is unreachable");
        addcode(dict, ENETRESET, "ENETRESET", "Network dropped connection on reset");
        addcode(dict, ECONNABORTED, "ECONNABORTED", "Software caused connection abort");
        addcode(dict, ECONNRESET, "ECONNRESET", "Connection reset by peer");
        addcode(dict, ENOBUFS, "ENOBUFS", "No buffer space available");
        addcode(dict, EISCONN, "EISCONN", "Transport endpoint is already connected");
        addcode(dict, ENOTCONN, "ENOTCONN", "Transport endpoint is not connected");
        addcode(dict, ESHUTDOWN, "ESHUTDOWN", "Cannot send after transport endpoint shutdown");
        addcode(dict, ETOOMANYREFS, "ETOOMANYREFS", "Too many references: cannot splice");
        addcode(dict, ETIMEDOUT, "ETIMEDOUT", "Connection timed out");
        addcode(dict, ECONNREFUSED, "ECONNREFUSED", "Connection refused");
        addcode(dict, EHOSTDOWN, "EHOSTDOWN", "Host is down");
        addcode(dict, EHOSTUNREACH, "EHOSTUNREACH", "No route to host");
        addcode(dict, EALREADY, "EALREADY", "Operation already in progress");
        addcode(dict, EINPROGRESS, "EINPROGRESS", "Operation now in progress");
        addcode(dict, ESTALE, "ESTALE", "Stale NFS file handle");
        addcode(dict, EUCLEAN, "EUCLEAN", "Structure needs cleaning");
        addcode(dict, ENOTNAM, "ENOTNAM", "Not a XENIX named type file");
        addcode(dict, ENAVAIL, "ENAVAIL", "No XENIX semaphores available");
        addcode(dict, EISNAM, "EISNAM", "Is a named type file");
        addcode(dict, EREMOTEIO, "EREMOTEIO", "Remote I/O error");
        addcode(dict, EDQUOT, "EDQUOT", "Disk quota exceeded");

        // AMAK: starting a new series of jython specific errors
        addcode(dict, ESOCKISBLOCKING, "ESOCKISBLOCKING", "Socket is in blocking mode");
        addcode(dict, EGETADDRINFOFAILED, "EGETADDRINFOFAILED", "getaddrinfo failed");
    }

    public static PyObject strerror(PyObject error) {
        return strerror.__getitem__(error);
    }

    private static void addcode(PyObject dict, int errno,
                                String err, String msg) {
        PyObject errno_o = Py.newInteger(errno);
        PyObject err_o = Py.newString(err);
        strerror.__setitem__(errno_o, Py.newString(msg));
        errorcode.__setitem__(errno_o, err_o);
        dict.__setitem__(err_o, errno_o);
    }
}
