// Copyright (c) Corporation for National Research Initiatives
package org.python.core;

/**
 * Common methods for all generated proxy classes.
 *
 * Proxies classes are created whenever a python class inherit
 * from a java class. Instances of such a python class consists
 * of two objects
 * <ul>
 * <li>An instance of the proxy class. The _getPyInstance() will
 *     return a reference to the PyInstance.
 * <li>An instance of PyInstance. The PyInstance.javaProxy contain
 *     a reference to the proxy class instance.
 * </ul>
 *
 * All proxy classes, both dynamicly generated and staticly
 * generated by jythonc implements this interface.
 */

// This interface should be applicable to ANY class
// Choose names that are extremely unlikely to have conflicts
public interface PyProxy
{
    /**
     * Associate an PyInstance with this proxy instance.
     * This is done during construction and initialization
     * of the proxy instance.
     */
    abstract public void _setPyInstance(PyInstance proxy);

    /**
     * Return the associated PyInstance instance.
     */
    abstract public PyInstance _getPyInstance();

    /**
     * Associate an system state with this proxy instance.
     * This is done during construction and initialization
     * of the proxy instance.
     */
    abstract public void _setPySystemState(PySystemState ss);

    /**
     * Return the associated system state.
     */
    abstract public PySystemState _getPySystemState();

    /**
     * Initialize the proxy instance. If the proxy have not
     * been initialized already, this call will call the
     * python constructor with the auplied arguments.
     * <p>
     * In some situations is it necesary to call the __initProxy__
     * method from the java superclass ctor before the ctor makes
     * call to methods that is overriden in python.
     * <p>
     * In most sitation the __initProxy__ is called automticly
     * by the jython runtime.
     */
    abstract public void __initProxy__(Object[] args);
}
