// Copyright 2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License"). You may not
// use this file except in compliance with the License. A copy of the
// License is located at
//
// http://aws.amazon.com/apache2.0/
//
// or in the "license" file accompanying this file. This file is distributed
// on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
// either express or implied. See the License for the specific language governing
// permissions and limitations under the License.

package mocks

import mock "github.com/stretchr/testify/mock"

// IKMSService is an autogenerated mock type for the IKMSService type
type IKMSService struct {
	mock.Mock
}

// Decrypt provides a mock function with given fields: cipherTextBlob, encryptionContext
func (_m *IKMSService) Decrypt(cipherTextBlob []byte, encryptionContext map[string]*string, keyId string) ([]byte, error) {
	ret := _m.Called(cipherTextBlob, encryptionContext, keyId)

	var r0 []byte
	if rf, ok := ret.Get(0).(func([]byte, map[string]*string, string) []byte); ok {
		r0 = rf(cipherTextBlob, encryptionContext, keyId)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]byte)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func([]byte, map[string]*string, string) error); ok {
		r1 = rf(cipherTextBlob, encryptionContext, keyId)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}
