/* automatically generated by rust-bindgen 0.65.1 */


// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0


#![allow(unused_imports, non_camel_case_types)]

use libc::{iovec, FILE, off_t};

use crate::api::*;


extern "C" {
    #[doc = " Used to indicate that an attempt to renegotiate encountered\n application data which the application should process before\n continuing the handshake."]
    pub static S2N_BLOCKED_ON_APPLICATION_DATA: s2n_blocked_status::Type;
}
pub mod s2n_renegotiate_response {
    #[doc = " Indicates how a renegotiation request should be handled."]
    pub type Type = ::libc::c_uint;
    pub const RENEGOTIATE_IGNORE: Type = 0;
    pub const RENEGOTIATE_REJECT: Type = 1;
    pub const RENEGOTIATE_ACCEPT: Type = 2;
}
#[doc = " Callback function to handle requests for renegotiation.\n\n s2n-tls calls this method when a client receives a request from the server\n to renegotiate the connection. If the server makes multiple requests,\n s2n-tls will call this method multiple times.\n\n Applications should use the `response` value to indicate how the request\n should be handled. If `response` is set to `S2N_RENEGOTIATE_IGNORE`\n or `S2N_RENEGOTIATE_REJECT`, no further application involvement is required.\n\n If `response` is set to `S2N_RENEGOTIATE_ACCEPT`, then the application should\n handle renegotiation. The application should stop calling s2n_send and s2n_recv,\n wipe the connection with s2n_renegotiate_wipe, and then call s2n_renegotiate\n until the handshake is complete.\n\n @param conn A pointer to the connection object.\n @param context Context for the callback function.\n @param response How the request should be handled.\n @returns S2N_SUCCESS on success, S2N_FAILURE on error."]
pub type s2n_renegotiate_request_cb = ::core::option::Option<
    unsafe extern "C" fn(
        conn: *mut s2n_connection,
        context: *mut ::libc::c_void,
        response: *mut s2n_renegotiate_response::Type,
    ) -> ::libc::c_int,
>;
extern "C" {
    #[doc = " Sets a method to be called when the client receives a request to renegotiate.\n\n @param config A pointer to the config object.\n @param callback The function to be called when a renegotiation request is received.\n @param context Context to be passed to the callback function.\n @returns S2N_SUCCESS on success, S2N_FAILURE on error."]
    pub fn s2n_config_set_renegotiate_request_cb(
        config: *mut s2n_config,
        callback: s2n_renegotiate_request_cb,
        context: *mut ::libc::c_void,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Reset the connection so that it can be renegotiated.\n\n Similar to `s2n_connection_wipe`, this method resets a connection so that it can be used again.\n However, unlike `s2n_connection_wipe`, it retains enough state from the previous connection\n that the connection can continue to send and receive data encrypted with the old keys.\n\n The application MUST handle any incomplete IO before calling this method. The last call to `s2n_send` must\n have succeeded, and `s2n_peek` must return zero. If there is any data in the send or receive buffers,\n this method will fail.\n\n The application MUST repeat any connection-specific setup after calling this method. This method\n cannot distinguish between internal connection state and configuration state set by the application,\n so it wipes all state not directly related to handling encrypted records. For example,\n if the application originally called `s2n_connection_set_blinding` on the connection,\n then the application will need to call `s2n_connection_set_blinding` again after `s2n_renegotiate_wipe`.\n\n The connection-specific setup methods the application does not need to call again are:\n - Methods to set the file descriptors\n   (`s2n_connection_set_fd`, `s2n_connection_set_read_fd`, `s2n_connection_set_write_fd`)\n - Methods to set the send callback\n   (`s2n_connection_set_send_cb`, `s2n_connection_set_send_ctx`)\n - Methods to set the recv callback\n   (`s2n_connection_set_recv_cb`, `s2n_connection_set_recv_ctx`)\n\n @note This method MUST be called before s2n_renegotiate.\n @note Calling this method on a server connection will fail. s2n-tls servers do not support renegotiation.\n\n @param conn A pointer to the connection object.\n @returns S2N_SUCCESS on success, S2N_FAILURE on error."]
    pub fn s2n_renegotiate_wipe(conn: *mut s2n_connection) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Perform a new handshake on an already established connection.\n\n This method should be called like `s2n_negotiate`, with the same handling of return values,\n error types, and blocked statuses.\n\n However, unlike the initial handshake performed by `s2n_negotiate`, the renegotiation\n handshake can encounter valid application data. In that case, this method will fail\n with an error of type S2N_ERR_T_BLOCKED, set the `blocked` field to `S2N_BLOCKED_ON_APPLICATION_DATA`,\n copy the data to `app_data_buf`, and set `app_data_size` to the size of the data.\n The application should handle the data in `app_data_buf` before calling s2n_renegotiate again.\n\n @note s2n_renegotiate_wipe MUST be called before this method.\n @note Calling this method on a server connection will fail. s2n-tls servers do not support renegotiation.\n\n @param conn A pointer to the connection object.\n @param app_data_buf A pointer to a buffer that s2n will copy application data read into.\n @param app_data_buf_size The size of `app_data_buf`.\n @param app_data_size The number of application data bytes read.\n @param blocked A pointer which will be set to the blocked status.\n @returns S2N_SUCCESS if the handshake completed. S2N_FAILURE if the handshake encountered an error or is blocked."]
    pub fn s2n_renegotiate(
        conn: *mut s2n_connection,
        app_data_buf: *mut u8,
        app_data_buf_size: isize,
        app_data_size: *mut isize,
        blocked: *mut s2n_blocked_status::Type,
    ) -> ::libc::c_int;
}
