/* automatically generated by rust-bindgen 0.65.1 */


// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0


#![allow(unused_imports, non_camel_case_types)]

use libc::{iovec, FILE, off_t};

use crate::api::*;


#[doc = " @file crl.h\n\n The following APIs enable applications to determine if a received certificate has been revoked by its CA, via\n Certificate Revocation Lists (CRLs). Please see the CRL Validation section in the usage guide for more information.\n\n The CRL APIs are currently considered unstable, since they have been recently added to s2n-tls. After gaining more\n confidence in the correctness and usability of these APIs, they will be made stable.\n"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct s2n_crl_lookup {
    _unused: [u8; 0],
}
#[doc = " A callback which can be implemented to provide s2n-tls with CRLs to use for CRL validation.\n\n This callback is triggered once for each certificate received during the handshake. To provide s2n-tls with a CRL for\n the certificate, use `s2n_crl_lookup_set()`. To ignore the certificate and not provide a CRL, use\n `s2n_crl_lookup_ignore()`.\n\n This callback can be synchronous or asynchronous. For asynchronous behavior, return success without calling\n `s2n_crl_lookup_set()` or `s2n_crl_lookup_ignore()`. `s2n_negotiate()` will return S2N_BLOCKED_ON_APPLICATION_INPUT\n until one of these functions is called for each invoked callback.\n\n @param lookup The CRL lookup for the given certificate.\n @param context Context for the callback function.\n @returns 0 on success, -1 on failure."]
pub type s2n_crl_lookup_callback = ::core::option::Option<
    unsafe extern "C" fn(
        lookup: *mut s2n_crl_lookup,
        context: *mut ::libc::c_void,
    ) -> ::libc::c_int,
>;
extern "C" {
    #[doc = " Set a callback to provide CRLs to use for CRL validation.\n\n @param config A pointer to the connection config\n @param s2n_crl_lookup_callback The function to be called for each received certificate.\n @param context Context to be passed to the callback function.\n @return S2N_SUCCESS on success, S2N_FAILURE on failure"]
    pub fn s2n_config_set_crl_lookup_cb(
        config: *mut s2n_config,
        callback: s2n_crl_lookup_callback,
        context: *mut ::libc::c_void,
    ) -> ::libc::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct s2n_crl {
    _unused: [u8; 0],
}
extern "C" {
    #[doc = " Allocates a new `s2n_crl` struct.\n\n Use `s2n_crl_load_pem()` to load the struct with a CRL pem.\n\n The allocated struct must be freed with `s2n_crl_free()`.\n\n @return A pointer to the allocated `s2n_crl` struct."]
    pub fn s2n_crl_new() -> *mut s2n_crl;
}
extern "C" {
    #[doc = " Loads a CRL with pem data.\n\n @param crl The CRL to load with the PEM data.\n @param pem The PEM data to load `crl` with.\n @param len The length of the pem data.\n @return S2N_SUCCESS on success, S2N_FAILURE on error."]
    pub fn s2n_crl_load_pem(crl: *mut s2n_crl, pem: *mut u8, len: usize) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Frees a CRL.\n\n Frees an allocated `s2n_crl` and sets `crl` to NULL.\n\n @param crl The CRL to free.\n @return S2N_SUCCESS on success, S2N_FAILURE on error."]
    pub fn s2n_crl_free(crl: *mut *mut s2n_crl) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Retrieves the issuer hash of a CRL.\n\n This function can be used to find the CRL associated with a certificate received in the s2n_crl_lookup callback. The\n hash value, `hash`, corresponds with the issuer hash of a certificate, retrieved via\n `s2n_crl_lookup_get_cert_issuer_hash()`.\n\n @param crl The CRL to obtain the hash value of.\n @param hash A pointer that will be set to the hash value.\n @return S2N_SUCCESS on success. S2N_FAILURE on failure"]
    pub fn s2n_crl_get_issuer_hash(crl: *mut s2n_crl, hash: *mut u64) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Determines if the CRL is currently active.\n\n CRLs contain a thisUpdate field, which specifies the date at which the CRL becomes valid. This function can be called\n to check thisUpdate relative to the current time. If the thisUpdate date is in the past, the CRL is considered\n active.\n\n @param crl The CRL to validate.\n @return S2N_SUCCESS if `crl` is active, S2N_FAILURE if `crl` is not active, or the active status cannot be determined."]
    pub fn s2n_crl_validate_active(crl: *mut s2n_crl) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Determines if the CRL has expired.\n\n CRLs contain a nextUpdate field, which specifies the date at which the CRL becomes expired. This function can be\n called to check nextUpdate relative to the current time. If the nextUpdate date is in the future, the CRL has not\n expired.\n\n If the CRL does not contain a thisUpdate field, the CRL is assumed to never expire.\n\n @param crl The CRL to validate.\n @return S2N_SUCCESS if `crl` has not expired, S2N_FAILURE if `crl` has expired, or the expiration status cannot be determined."]
    pub fn s2n_crl_validate_not_expired(crl: *mut s2n_crl) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Retrieves the issuer hash of the certificate.\n\n The CRL lookup callback is triggered once for each received certificate. This function is used to get the issuer hash\n of this certificate. The hash value, `hash`, corresponds with the issuer hash of the CRL, retrieved via\n `s2n_crl_get_issuer_hash()`.\n\n @param lookup The CRL lookup for the given certificate.\n @param hash A pointer that will be set to the hash value.\n @return S2N_SUCCESS on success, S2N_FAILURE on failure."]
    pub fn s2n_crl_lookup_get_cert_issuer_hash(
        lookup: *mut s2n_crl_lookup,
        hash: *mut u64,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Provide s2n-tls with a CRL from the CRL lookup callback.\n\n A return function for `s2n_crl_lookup_cb`. This function should be used from within the CRL lookup callback to\n provide s2n-tls with a CRL for the given certificate. The provided CRL will be included in the list of CRLs to use\n when validating the certificate chain.\n\n To skip providing a CRL from the callback, use `s2n_crl_lookup_ignore()`.\n\n @param lookup The CRL lookup for the given certificate.\n @param crl The CRL to include in the list of CRLs used to validate the certificate chain.\n @return S2N_SUCCESS on success, S2N_FAILURE on failure."]
    pub fn s2n_crl_lookup_set(lookup: *mut s2n_crl_lookup, crl: *mut s2n_crl) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Skip providing a CRL from the CRL lookup callback.\n\n A return function for `s2n_crl_lookup_cb`. This function should be used from within the CRL lookup callback to ignore\n the certificate, and skip providing s2n-tls with a CRL.\n\n If a certificate is ignored, and is ultimately included in the chain of trust, certificate chain validation will\n fail with a S2N_ERR_CRL_LOOKUP_FAILED error. However, if the certificate is extraneous and not included in the chain\n of trust, validation is able to proceed.\n\n @param lookup The CRL lookup for the given certificate.\n @return S2N_SUCCESS on success, S2N_FAILURE on failure."]
    pub fn s2n_crl_lookup_ignore(lookup: *mut s2n_crl_lookup) -> ::libc::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct s2n_cert_validation_info {
    _unused: [u8; 0],
}
#[doc = " A callback which can be implemented to perform additional validation on received certificates.\n\n The cert validation callback is invoked after receiving and validating the peer's certificate chain. The callback\n can be used by clients to validate server certificates, or by servers to validate client certificates in the case of\n mutual auth. Note that any validation performed by applications in the callback is in addition to the certificate\n validation already performed by s2n-tls.\n\n Applications can use either of the following APIs from within the callback to retrieve the peer's certificate chain\n and perform validation before proceeding with the handshake:\n  - `s2n_connection_get_peer_cert_chain()`\n  - `s2n_connection_get_client_cert_chain()`\n\n If the validation performed in the callback is successful, `s2n_cert_validation_accept()` MUST be called to allow\n `s2n_negotiate()` to continue the handshake. If the validation is unsuccessful, `s2n_cert_validation_reject()`\n MUST be called, which will cause `s2n_negotiate()` to error. The behavior of `s2n_negotiate()` is undefined if\n neither `s2n_cert_validation_accept()` or `s2n_cert_validation_reject()` are called.\n\n The `info` parameter is passed to the callback in order to call APIs specific to the cert validation callback, like\n `s2n_cert_validation_accept()` and `s2n_cert_validation_reject()`. The `info` argument is only valid for the\n lifetime of the callback, and must not be used after the callback has finished.\n\n After calling `s2n_cert_validation_reject()`, `s2n_negotiate()` will fail with a protocol error indicating that\n the cert has been rejected from the callback. If more information regarding an application's custom validation\n failure is required, consider adding an error code field to the custom connection context. See\n `s2n_connection_set_ctx()` and `s2n_connection_get_ctx()` for how to set and retrieve custom connection contexts.\n\n @param conn The connection object from which the callback was invoked.\n @param info The cert validation info object used to call cert validation APIs.\n @param context Application data provided to the callback function via `s2n_config_set_cert_validation_cb()`.\n @returns 0 on success, -1 on failure."]
pub type s2n_cert_validation_callback = ::core::option::Option<
    unsafe extern "C" fn(
        conn: *mut s2n_connection,
        info: *mut s2n_cert_validation_info,
        context: *mut ::libc::c_void,
    ) -> ::libc::c_int,
>;
extern "C" {
    #[doc = " Sets a callback to perform additional validation on received certificates.\n\n @param config The associated connection config.\n @param callback The cert validation callback to set.\n @param context Optional application data passed to the callback function.\n @returns S2N_SUCCESS on success, S2N_FAILURE on failure."]
    pub fn s2n_config_set_cert_validation_cb(
        config: *mut s2n_config,
        callback: s2n_cert_validation_callback,
        context: *mut ::libc::c_void,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Indicates that the validation performed in the cert validation callback was successful.\n\n `s2n_cert_validation_accept()` should be called from within the cert validation callback to allow `s2n_negotiate()`\n to continue the handshake.\n\n This function must not be called outside of the cert validation callback.\n\n @param info The cert validation info object for the associated callback.\n @returns S2N_SUCCESS on success, S2N_FAILURE on failure."]
    pub fn s2n_cert_validation_accept(info: *mut s2n_cert_validation_info) -> ::libc::c_int;
}
extern "C" {
    #[doc = " Indicates that the validation performed in the cert validation callback was unsuccessful.\n\n `s2n_cert_validation_reject()` should be called from within the cert validation callback to cause `s2n_negotiate()`\n to error.\n\n This function must not be called outside of the cert validation callback.\n\n @param info The cert validation info object for the associated callback.\n @returns S2N_SUCCESS on success, S2N_FAILURE on failure."]
    pub fn s2n_cert_validation_reject(info: *mut s2n_cert_validation_info) -> ::libc::c_int;
}
