use crate::inc::inc::BigFloatInc;

pub(crate) const CBRT_VALUES: [BigFloatInc; 1090] = [
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3491, 6551, 4657, 9194, 6350, 1007, 8924, 2778, 3361, 5888, 4641],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [9973, 7060, 4555, 2758, 4720, 1357, 1310, 5732, 7642, 354, 5848],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1769, 3034, 793, 3993, 3246, 2659, 2188, 1695, 82, 3295, 6694],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [5162, 3834, 1444, 1596, 5667, 5964, 2115, 773, 9728, 629, 7368],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [4666, 1957, 4130, 3615, 8196, 5852, 3737, 997, 5984, 52, 7937],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [1657, 2401, 2943, 607, 7514, 5709, 4284, 7492, 5301, 3266, 8434],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [3602, 6823, 7140, 5287, 9552, 9268, 842, 6007, 1742, 400, 8879],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [6982, 3102, 9315, 8388, 2701, 2015, 7848, 5557, 6722, 1776, 9283],
    },
    BigFloatInc {
        sign: 1,
        e: -43,
        n: 44,
        m: [8948, 6127, 6917, 3506, 7844, 9932, 5785, 6297, 4605, 8938, 9654],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1000],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [7119, 1730, 161, 97, 5225, 1358, 1592, 6367, 1545, 2801, 1032],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [4351, 733, 6305, 1654, 2222, 4774, 660, 2611, 6918, 6585, 1062],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [9360, 9552, 9124, 5208, 912, 1913, 8451, 1105, 8306, 3928, 1091],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [9449, 692, 9022, 3277, 9662, 121, 7766, 1396, 4208, 6889, 1118],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [9069, 8915, 7700, 9396, 2211, 804, 8678, 3331, 4255, 7142, 1144],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [1994, 1412, 6911, 551, 4944, 271, 4262, 5146, 9528, 6070, 1169],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [5726, 6901, 622, 6018, 7218, 5552, 9430, 7336, 9192, 4831, 1193],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [5341, 3975, 6048, 5475, 8999, 7968, 369, 4680, 9911, 4403, 1216],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [9072, 1068, 7372, 909, 3583, 943, 8225, 170, 2963, 5623, 1238],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [2515, 570, 2835, 2782, 607, 6721, 1647, 4873, 4989, 9210, 1259],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [9526, 583, 9620, 6334, 533, 4641, 2552, 7494, 6498, 5791, 1280],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [8470, 6001, 9617, 7167, 1149, 1023, 9988, 1386, 4685, 5914, 1300],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [8794, 7576, 3872, 3, 9331, 9144, 3976, 5912, 2179, 61, 1320],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [8354, 6606, 6158, 2798, 8649, 6531, 437, 4339, 16, 8659, 1338],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [5539, 2402, 4460, 8397, 4734, 5904, 2857, 7453, 829, 2088, 1357],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [7322, 9372, 4664, 8247, 8938, 5182, 107, 4141, 6707, 688, 1375],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [4047, 2965, 3397, 2758, 2905, 2302, 6677, 3833, 5008, 4766, 1392],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [2296, 5734, 9708, 2656, 9633, 5108, 3841, 2978, 4641, 4597, 1409],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [1368, 1993, 9821, 2735, 3115, 3598, 7264, 2408, 4714, 431, 1426],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [8692, 8391, 958, 7801, 8310, 2163, 3823, 7408, 7030, 2495, 1442],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [2038, 2931, 3952, 7254, 2077, 7802, 6271, 6711, 3582, 997, 1458],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [9032, 8766, 2288, 4319, 9133, 1192, 6423, 6154, 9945, 6125, 1473],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [8, 9589, 6244, 5276, 681, 3315, 4495, 3827, 5295, 8055, 1488],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [2966, 389, 5802, 2899, 1351, 2746, 7741, 4974, 9620, 6945, 1503],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [7270, 7790, 3481, 2528, 4789, 1040, 2597, 7831, 8593, 2944, 1518],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [1881, 8717, 1836, 8659, 1056, 9725, 2131, 7106, 6478, 6188, 1532],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [7944, 2242, 5489, 1353, 4857, 2152, 4537, 2035, 7377, 6803, 1546],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [6498, 9731, 811, 2708, 8443, 2287, 7964, 7884, 5070, 4907, 1560],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [5691, 5282, 8541, 6409, 6675, 671, 5095, 1443, 1663, 609, 1574],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [4933, 391, 826, 2723, 5639, 5170, 4747, 8199, 5196, 4010, 1587],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [4681, 1823, 2169, 6236, 6291, 2274, 2738, 3155, 6388, 5206, 1600],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [4952, 2278, 4535, 4822, 2236, 5884, 7640, 4543, 4602, 4286, 1613],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [4898, 7932, 9120, 2945, 6494, 8900, 6954, 9168, 3167, 1333, 1626],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [2068, 6678, 5994, 2571, 4257, 5901, 6387, 1291, 4120, 6425, 1638],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [4423, 8423, 4247, 2045, 4976, 3730, 3419, 7313, 2444, 9636, 1650],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [5370, 4343, 8955, 3472, 6207, 3511, 7677, 765, 9884, 1034, 1663],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [6108, 4190, 8000, 6114, 7616, 1188, 809, 2234, 8360, 686, 1675],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [2331, 6480, 4588, 8121, 9502, 9141, 4856, 3498, 3060, 8653, 1686],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [7782, 3913, 2114, 2031, 5259, 8670, 6067, 1810, 5224, 4992, 1698],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [551, 9868, 6010, 5438, 8872, 5310, 9893, 6696, 4667, 9759, 1709],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [4522, 9171, 3876, 1812, 6646, 2539, 9147, 6315, 2072, 3006, 1721],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [8383, 8578, 1598, 7036, 4004, 9186, 5318, 1805, 1068, 4782, 1732],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [467, 6635, 9398, 3103, 701, 2270, 3063, 5128, 126, 5134, 1743],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [2992, 7118, 5366, 827, 2416, 407, 6393, 7719, 4292, 4106, 1754],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [3633, 2170, 4765, 4241, 6296, 9798, 5010, 3031, 6766, 1741, 1765],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [6720, 1364, 5428, 5057, 7910, 5853, 4168, 5201, 348, 8080, 1775],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [1015, 5136, 7569, 5858, 7472, 4690, 5699, 8056, 8770, 3159, 1786],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [8692, 2196, 6178, 4728, 8162, 7589, 6991, 3052, 7914, 7017, 1796],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [4854, 8797, 9527, 7837, 1888, 6303, 6127, 1189, 6932, 9688, 1806],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [2105, 2428, 6050, 3272, 1756, 9121, 6588, 2139, 9283, 1205, 1817],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [1555, 3648, 571, 6266, 5392, 6278, 5787, 3520, 3686, 1601, 1827],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [7532, 4440, 1606, 2372, 3659, 8011, 7206, 4227, 5001, 905, 1837],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [6309, 5034, 5541, 8627, 5814, 5020, 4145, 7833, 5044, 9147, 1846],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [5396, 620, 7863, 3677, 540, 6403, 5569, 5111, 3344, 6355, 1856],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [5627, 9350, 7053, 6782, 5303, 8257, 1214, 8624, 7840, 2555, 1866],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [2642, 3119, 8278, 200, 295, 7559, 4656, 6903, 5536, 7774, 1875],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [5105, 5902, 322, 8719, 4556, 5584, 578, 986, 3102, 2036, 1885],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [9342, 1072, 3715, 4032, 7778, 8650, 1785, 1819, 7437, 5364, 1894],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [3806, 4630, 3603, 9339, 2693, 8410, 2298, 3303, 6196, 7782, 1903],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [4390, 2862, 6028, 5487, 6839, 9911, 1011, 2389, 8277, 9311, 1912],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [8804, 748, 1975, 1426, 5279, 3820, 3554, 4671, 4277, 9973, 1921],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [5790, 5225, 3383, 8701, 5568, 1986, 5157, 1259, 6921, 9787, 1930],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [1074, 758, 2460, 2856, 4772, 7168, 804, 333, 1458, 8774, 1939],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [3715, 3960, 6852, 9004, 8121, 7872, 7566, 4657, 6037, 6951, 1948],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [8411, 2465, 3571, 2058, 8030, 1246, 7977, 4431, 2058, 4338, 1957],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [4166, 3806, 3541, 8703, 9619, 5618, 19, 3117, 4498, 951, 1966],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [5880, 3844, 5062, 8851, 9763, 6348, 8098, 2366, 2221, 6808, 1974],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [2484, 5345, 5726, 5006, 253, 8430, 7268, 774, 8268, 1924, 1983],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [7624, 3440, 9646, 6134, 6602, 606, 772, 9913, 128, 6317, 1991],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2000],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [2531, 9910, 9237, 9197, 7973, 4797, 5656, 6508, 5024, 2988, 2008],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [4902, 3366, 8946, 4914, 2864, 8907, 3977, 8104, 7521, 5296, 2016],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [4294, 8235, 6138, 2278, 9539, 8738, 738, 5457, 5200, 6938, 2024],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [6513, 7523, 221, 4306, 4079, 5348, 8575, 9706, 1362, 7927, 2032],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [6383, 2603, 2148, 6130, 806, 8289, 352, 8674, 5095, 8275, 2040],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [3500, 7292, 9737, 5943, 6494, 2165, 2351, 8266, 1451, 7996, 2048],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [8790, 4291, 925, 6534, 179, 5045, 3314, 5963, 1620, 7101, 2056],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [4238, 3461, 322, 194, 450, 2717, 3184, 2734, 3091, 5602, 2064],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [1564, 9540, 733, 4559, 6898, 3809, 9041, 9260, 9805, 3510, 2072],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [8053, 6337, 8538, 3578, 6824, 3005, 1145, 1904, 2305, 838, 2080],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [2858, 8071, 7496, 6598, 8400, 3352, 9505, 3448, 7866, 7594, 2087],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [7606, 1310, 8136, 1660, 5006, 9117, 5813, 3294, 634, 3791, 2095],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [3478, 8255, 3228, 7216, 244, 6560, 5198, 1420, 1746, 9437, 2102],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [9213, 1714, 1114, 9247, 2913, 6363, 8760, 149, 9449, 4542, 2110],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [8052, 3493, 5096, 1089, 6212, 4907, 5819, 7446, 9212, 9117, 2117],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [8702, 1466, 2610, 3309, 4444, 9548, 1320, 5222, 3836, 3171, 2125],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [2707, 6857, 9173, 6674, 9127, 6359, 8411, 5886, 3550, 6712, 2132],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [3754, 5960, 4837, 9870, 2002, 7040, 225, 159, 6113, 9749, 2139],
    },
    BigFloatInc {
        sign: 1,
        e: -42,
        n: 44,
        m: [2916, 3405, 6667, 2787, 1591, 6839, 1755, 8941, 6901, 2291, 2147],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1000],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [2515, 570, 2835, 2782, 607, 6721, 1647, 4873, 4989, 9210, 1259],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [8692, 8391, 958, 7801, 8310, 2163, 3823, 7408, 7030, 2495, 1442],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [4933, 391, 826, 2723, 5639, 5170, 4747, 8199, 5196, 4010, 1587],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [551, 9868, 6010, 5438, 8872, 5310, 9893, 6696, 4667, 9759, 1709],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [2105, 2428, 6050, 3272, 1756, 9121, 6588, 2139, 9283, 1205, 1817],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [4390, 2862, 6028, 5487, 6839, 9911, 1011, 2389, 8277, 9311, 1912],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2000],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [8053, 6337, 8538, 3578, 6824, 3005, 1145, 1904, 2305, 838, 2080],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [3449, 5259, 5049, 5193, 3566, 5929, 7217, 1883, 9003, 4346, 2154],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [6991, 6518, 5719, 7221, 3376, 6536, 5211, 9315, 9056, 9800, 2223],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [8138, 7831, 5401, 8793, 4423, 1608, 7356, 6663, 8510, 4284, 2289],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [8420, 6915, 1452, 9569, 6339, 1, 4895, 757, 8772, 3346, 2351],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [5813, 5354, 7289, 6032, 9667, 2836, 9861, 5229, 6417, 1422, 2410],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [4845, 2735, 8904, 1545, 1323, 9161, 1014, 470, 7433, 2120, 2466],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [5029, 1140, 5670, 5564, 1214, 3442, 3295, 9746, 9978, 8420, 2519],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [9016, 6427, 2611, 7397, 7208, 5318, 3554, 8235, 9065, 2815, 2571],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [4276, 239, 9627, 4419, 1280, 4166, 6071, 8896, 9420, 7413, 2620],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [8786, 5095, 3033, 9708, 7371, 3962, 8673, 1944, 4872, 4016, 2668],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [1078, 4805, 8920, 6794, 9469, 1808, 5715, 4906, 1659, 4176, 2714],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [7121, 2252, 2158, 3585, 1108, 6579, 6694, 1120, 7638, 9241, 2758],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [7982, 7585, 9401, 6658, 7385, 6567, 1206, 5387, 3065, 393, 2802],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [1652, 2764, 5185, 9586, 9400, 9543, 4776, 1565, 7985, 8669, 2843],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [7385, 6783, 1917, 5602, 6621, 4327, 7646, 4816, 4061, 4991, 2884],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [4986, 8530, 2277, 1379, 7360, 678, 655, 2866, 3821, 177, 2924],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [3574, 7566, 3853, 3418, 2189, 7306, 5086, 7370, 6840, 4960, 2962],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3000],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [4540, 5581, 6963, 5056, 9578, 2080, 5194, 5662, 7187, 5889, 3036],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [7832, 5502, 9748, 1055, 7982, 1263, 2933, 5847, 2568, 3168, 3072],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [9068, 2854, 8636, 5223, 2427, 7766, 8668, 3858, 595, 2325, 3107],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [8597, 6350, 4992, 4627, 5896, 9307, 44, 1393, 5239, 3806, 3141],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [9866, 782, 1652, 5446, 1278, 341, 9495, 6398, 393, 8021, 3174],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [8517, 1361, 2011, 7195, 5171, 5251, 4875, 5826, 2999, 5343, 3207],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [3790, 378, 2970, 2720, 9924, 7146, 3840, 7483, 127, 6118, 3239],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [9031, 4098, 3134, 3925, 6902, 2480, 7282, 8589, 1018, 663, 3271],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [8846, 6846, 8495, 4090, 9952, 7460, 6838, 4626, 4889, 9272, 3301],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [6167, 4409, 1900, 1851, 505, 9545, 2600, 5953, 5164, 2218, 3332],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [5790, 7406, 6344, 8105, 8566, 4055, 3148, 8963, 679, 9754, 3361],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [8361, 3262, 9673, 9945, 725, 5467, 7619, 4166, 4301, 2114, 3391],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [1102, 9736, 2021, 877, 7745, 621, 9787, 3393, 9335, 9518, 3419],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [9929, 7169, 8961, 2607, 3864, 9742, 3840, 2730, 4038, 2172, 3448],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [8385, 4004, 3743, 45, 5219, 3986, 7867, 6449, 4488, 266, 3476],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [7568, 7248, 2973, 1891, 3758, 1433, 1706, 6724, 6038, 3980, 3503],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [7266, 4340, 9530, 8482, 2592, 9597, 21, 6063, 3532, 3483, 3530],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [869, 4978, 1158, 2389, 4622, 615, 8060, 62, 449, 8933, 3556],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [8206, 2154, 6627, 5806, 3674, 8696, 4853, 5946, 7101, 478, 3583],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [5517, 4905, 9261, 9588, 7295, 5251, 6892, 8694, 8013, 8260, 3608],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [4209, 4856, 2100, 6545, 3512, 8242, 3177, 4279, 8566, 2411, 3634],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [1037, 3487, 826, 1194, 3310, 3807, 5172, 2971, 1002, 3057, 3659],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [2581, 1917, 722, 5798, 2833, 7982, 6057, 386, 9864, 314, 3684],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [8858, 555, 3742, 8887, 3519, 3881, 4726, 6189, 6926, 4297, 3708],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [1254, 8701, 4107, 3565, 607, 6515, 2429, 7248, 5681, 5111, 3732],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [6791, 9094, 1951, 593, 9632, 1210, 66, 1072, 5422, 2857, 3756],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [7544, 1710, 8505, 8346, 1821, 163, 4943, 4619, 4968, 7631, 3779],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [7156, 7288, 1519, 8487, 5473, 4673, 6185, 1391, 6076, 9524, 3802],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [8781, 5724, 2056, 975, 3679, 9823, 2023, 4778, 6554, 8623, 3825],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [4055, 7128, 2531, 5250, 259, 229, 687, 6805, 3127, 5011, 3848],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [3405, 991, 174, 3448, 4226, 1331, 7472, 7796, 4062, 8766, 3870],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [7896, 3992, 8924, 1497, 4757, 6148, 5464, 3260, 1587, 9964, 3892],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [6822, 4931, 7142, 4116, 6060, 2493, 5954, 8863, 4116, 8676, 3914],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [5559, 8638, 4785, 321, 1373, 2885, 1958, 2173, 8310, 4971, 3936],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [2496, 6173, 2610, 194, 8479, 3614, 4789, 405, 968, 8916, 3957],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [2720, 8484, 6557, 7487, 7987, 6452, 8596, 6391, 789, 572, 3979],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4000],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [9866, 9806, 8875, 4314, 4514, 8654, 9760, 9057, 5858, 7257, 4020],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [3098, 3372, 6211, 6342, 74, 199, 2708, 2190, 2062, 2400, 4041],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [585, 6419, 2596, 7992, 1585, 8206, 7890, 5679, 44, 5481, 4061],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [2766, 5207, 4296, 2260, 1613, 6578, 705, 7348, 191, 6551, 4081],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [1058, 7650, 7480, 1418, 4982, 4718, 5218, 2347, 2970, 5659, 4101],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [5227, 810, 1335, 3664, 9117, 7748, 8193, 8556, 9980, 2852, 4121],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [3508, 8159, 7183, 3255, 8809, 451, 2500, 2853, 4942, 8177, 4140],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [6107, 2675, 7077, 7157, 3648, 6011, 2290, 3808, 4610, 1676, 4160],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [9944, 8013, 6776, 9087, 6348, 5637, 8920, 1231, 9638, 3391, 4179],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [679, 95, 2015, 6652, 8592, 5329, 7221, 8407, 5380, 3364, 4198],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [5828, 6200, 6471, 303, 8757, 2854, 2142, 8746, 2650, 1633, 4217],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [6104, 6987, 192, 2179, 2424, 9815, 1638, 4893, 8425, 8235, 4235],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [4079, 2960, 1670, 1244, 8662, 7336, 7760, 5005, 6511, 3208, 4254],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [7089, 8916, 9085, 2424, 8529, 8772, 8249, 7916, 8169, 6586, 4272],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [1977, 755, 7094, 4542, 4233, 2831, 1116, 6207, 2702, 8404, 4290],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [6899, 518, 99, 387, 7133, 1858, 4435, 3767, 8006, 8693, 4308],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [6078, 5175, 2876, 3403, 4932, 6491, 1469, 2225, 1092, 7487, 4326],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [6042, 7193, 7592, 545, 546, 2235, 9017, 8611, 8576, 4814, 4344],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [4932, 692, 4781, 6759, 9476, 1397, 5647, 4837, 7145, 706, 4362],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [25, 9980, 7571, 3724, 3531, 1980, 2657, 7889, 3988, 5191, 4379],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [8838, 598, 4186, 5384, 792, 921, 2758, 8179, 7215, 8296, 4396],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [2765, 2305, 5132, 6533, 1438, 5164, 7724, 2103, 6244, 49, 4414],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [6489, 8924, 8745, 9886, 3155, 2945, 1592, 3634, 2169, 476, 4431],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [3982, 3037, 1439, 4443, 6753, 3072, 423, 8631, 8113, 9601, 4447],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [9792, 5067, 6949, 742, 8481, 3396, 6334, 4537, 9558, 7450, 4464],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [7500, 1166, 7947, 385, 2014, 4748, 7087, 7164, 4655, 4047, 4481],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [4506, 9683, 5732, 3073, 794, 9156, 7963, 5414, 4527, 9414, 4497],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [5552, 1457, 8714, 6645, 2702, 4506, 3794, 4001, 3547, 3574, 4514],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [792, 6062, 8706, 4405, 7700, 3927, 7770, 3492, 9608, 6548, 4530],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [6097, 6350, 8471, 3212, 1541, 192, 8938, 6343, 4377, 8359, 4546],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [2176, 7254, 2817, 3004, 5906, 6393, 7275, 6966, 3538, 9026, 4562],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [6277, 5663, 803, 7587, 8847, 3216, 4712, 3327, 7021, 8569, 4578],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [9755, 9120, 898, 4223, 6464, 9429, 8060, 7039, 9220, 7008, 4594],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [3756, 2498, 7493, 9406, 6097, 7469, 5696, 8446, 9205, 4362, 4610],
    },
    BigFloatInc {
        sign: 1,
        e: -41,
        n: 44,
        m: [1938, 4622, 8409, 7912, 2369, 9236, 7930, 2741, 918, 650, 4626],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [3449, 5259, 5049, 5193, 3566, 5929, 7217, 1883, 9003, 4346, 2154],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [1078, 4805, 8920, 6794, 9469, 1808, 5715, 4906, 1659, 4176, 2714],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [9068, 2854, 8636, 5223, 2427, 7766, 8668, 3858, 595, 2325, 3107],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [1102, 9736, 2021, 877, 7745, 621, 9787, 3393, 9335, 9518, 3419],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [2581, 1917, 722, 5798, 2833, 7982, 6057, 386, 9864, 314, 3684],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [6822, 4931, 7142, 4116, 6060, 2493, 5954, 8863, 4116, 8676, 3914],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [5227, 810, 1335, 3664, 9117, 7748, 8193, 8556, 9980, 2852, 4121],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [6899, 518, 99, 387, 7133, 1858, 4435, 3767, 8006, 8693, 4308],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [7500, 1166, 7947, 385, 2014, 4748, 7087, 7164, 4655, 4047, 4481],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [3491, 6551, 4657, 9194, 6350, 1007, 8924, 2778, 3361, 5888, 4641],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [9538, 308, 6371, 3399, 8647, 6000, 9707, 2783, 5706, 4198, 4791],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [9690, 5470, 7808, 3091, 2646, 8322, 2029, 940, 4866, 4241, 4932],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [9836, 3642, 4591, 1940, 17, 241, 2694, 886, 1910, 7970, 5065],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [8003, 5537, 4409, 6014, 5248, 9445, 261, 1104, 185, 4941, 5192],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [1756, 3667, 1525, 8273, 1110, 3871, 3302, 3055, 4591, 2928, 5313],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [2155, 9610, 7840, 3589, 8939, 3617, 1430, 9813, 3318, 8352, 5428],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [3952, 3724, 8255, 4951, 8145, 7416, 2107, 4464, 5675, 6582, 5539],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [5026, 7987, 7482, 877, 6362, 6531, 9464, 6170, 7328, 2161, 5646],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [637, 1999, 2981, 3393, 1923, 7383, 7621, 4830, 7894, 8970, 5748],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [9973, 7060, 4555, 2758, 4720, 1357, 1310, 5732, 7642, 354, 5848],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [6183, 2243, 1108, 8746, 7950, 6784, 8021, 3129, 5276, 9219, 5943],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [6477, 1463, 3113, 302, 4799, 1856, 8905, 7685, 3679, 8107, 6036],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [9343, 6739, 2094, 1603, 5737, 5950, 7794, 8416, 7522, 9256, 6126],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [8136, 5709, 7272, 447, 4855, 5532, 7337, 7717, 1190, 4650, 6214],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [2573, 2851, 4175, 3911, 3036, 3605, 8238, 4365, 4947, 6052, 6299],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [2864, 3317, 5130, 4681, 2770, 2629, 4759, 9907, 9885, 5042, 6382],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [348, 5778, 5148, 5580, 699, 7788, 1652, 5651, 7009, 3040, 6463],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [8063, 8197, 6268, 7850, 3804, 4961, 4564, 7179, 2037, 1326, 6542],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [7903, 3223, 43, 8609, 5872, 8191, 3455, 6229, 4802, 1059, 6619],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [1769, 3034, 793, 3993, 3246, 2659, 2188, 1695, 82, 3295, 6694],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [4762, 2146, 5053, 8479, 3852, 6408, 4529, 7007, 5210, 8994, 6767],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [2204, 9472, 4043, 1754, 5490, 1243, 9574, 6787, 8670, 9037, 6839],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [6961, 6349, 6184, 7531, 926, 1496, 2721, 1184, 3001, 4232, 6910],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [7198, 1969, 6208, 6733, 3366, 2222, 3998, 8887, 4690, 5320, 6979],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [1480, 8671, 8542, 3284, 8166, 5544, 9207, 4891, 3206, 2987, 7047],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [1738, 9956, 2316, 4778, 9244, 1230, 6120, 125, 898, 7866, 7113],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [5099, 1448, 3892, 2427, 8858, 2634, 9360, 8318, 5206, 543, 7179],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [3198, 1366, 117, 9117, 7141, 6185, 7099, 1740, 4344, 1564, 7243],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [4106, 2438, 3990, 833, 943, 7611, 4754, 2803, 7406, 1435, 7306],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [5162, 3834, 1444, 1596, 5667, 5964, 2115, 773, 9728, 629, 7368],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [1506, 7042, 9734, 1657, 6388, 7447, 2154, 6565, 4144, 9588, 7428],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [630, 654, 7036, 9408, 7943, 6891, 1978, 8507, 8721, 8723, 7488],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [9140, 5302, 6715, 6485, 8333, 241, 7376, 7574, 1428, 8423, 7547],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [4312, 4577, 3039, 6974, 947, 9347, 2370, 2783, 2152, 9049, 7605],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [9407, 3585, 9184, 3295, 5284, 8625, 659, 5531, 2393, 943, 7663],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [4991, 2985, 3088, 5707, 4235, 7095, 5526, 1641, 2936, 4426, 7719],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [367, 762, 90, 3517, 7640, 6121, 6564, 2586, 9734, 9800, 7774],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [3644, 9863, 4284, 8233, 2120, 4987, 1908, 7727, 8233, 7352, 7829],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [5765, 3172, 1284, 789, 4739, 1020, 8187, 5242, 6310, 7351, 7883],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [4666, 1957, 4130, 3615, 8196, 5852, 3737, 997, 5984, 52, 7937],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [3578, 8400, 1094, 2607, 113, 9303, 9868, 4012, 4045, 5697, 7989],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [9733, 9613, 7751, 8629, 9028, 7308, 9521, 8115, 1717, 4515, 8041],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [3062, 1495, 1095, 7598, 1204, 6902, 8298, 6455, 3456, 6723, 8092],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [3233, 4415, 6761, 384, 8409, 5426, 7145, 4719, 4978, 2528, 8143],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [339, 3391, 9973, 2857, 1286, 9507, 1937, 6458, 600, 2127, 8193],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [454, 1621, 2670, 7328, 8234, 5497, 6387, 7113, 9961, 5705, 8242],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [9965, 3281, 2754, 8726, 3593, 4000, 3716, 9697, 4184, 3443, 8291],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [9209, 1554, 3158, 4593, 665, 3985, 6442, 2606, 1540, 5509, 8339],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [1387, 1686, 7361, 3888, 9653, 3860, 3792, 7142, 2652, 2065, 8387],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [1657, 2401, 2943, 607, 7514, 5709, 4284, 7492, 5301, 3266, 8434],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [9798, 2629, 108, 3351, 3291, 7411, 9283, 8113, 8848, 9260, 8480],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [5924, 6048, 848, 8587, 5161, 2259, 6919, 1597, 8328, 189, 8527],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [8147, 6166, 3059, 102, 953, 7575, 7011, 3395, 8231, 6188, 8572],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [3798, 1037, 198, 774, 4266, 3717, 8870, 7534, 6012, 7387, 8617],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [1916, 2894, 7994, 5180, 23, 5932, 6594, 9027, 5340, 3910, 8662],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [1938, 3006, 6485, 2498, 1247, 7634, 8755, 3611, 9117, 5876, 8706],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [7968, 8740, 8850, 9899, 4109, 7687, 2677, 3274, 2283, 3401, 8750],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [7675, 1197, 8372, 768, 1585, 1842, 5516, 6358, 4431, 6593, 8793],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [8487, 3208, 5370, 8830, 6088, 8313, 623, 3612, 2240, 5559, 8836],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [3602, 6823, 7140, 5287, 9552, 9268, 842, 6007, 1742, 400, 8879],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [4254, 3705, 323, 8815, 420, 6752, 2015, 6347, 445, 1214, 8921],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [5000, 2333, 5894, 771, 4028, 9496, 4174, 4329, 9311, 8094, 8962],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [6264, 4632, 4228, 1816, 1413, 5572, 3412, 3701, 4609, 1133, 9004],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [5254, 6096, 9943, 6938, 4504, 1607, 8016, 274, 9651, 416, 9045],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [523, 2141, 251, 6363, 8781, 5605, 2944, 698, 6416, 6029, 9085],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [4353, 4508, 5635, 6008, 1812, 2787, 4551, 3933, 7077, 8052, 9125],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [6353, 6941, 558, 7083, 1370, 6092, 8662, 222, 5433, 6564, 9165],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [4446, 6538, 9389, 9780, 7602, 6790, 3690, 5888, 8251, 1640, 9205],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [4201, 4239, 5454, 2121, 4549, 557, 1027, 6482, 6537, 3354, 9244],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [6982, 3102, 9315, 8388, 2701, 2015, 7848, 5557, 6722, 1776, 9283],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [7205, 8564, 5908, 5671, 7282, 3298, 6006, 1576, 1786, 6975, 9321],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [2055, 8067, 5204, 1987, 1499, 9815, 330, 1157, 2314, 9016, 9359],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [2887, 4458, 6940, 507, 8215, 1795, 8653, 2973, 7495, 7963, 9397],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [8051, 7356, 379, 9657, 8687, 4105, 7146, 3066, 6063, 3879, 9435],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [6708, 5364, 8575, 161, 8892, 3253, 8929, 9095, 7185, 6823, 9472],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [2928, 402, 5930, 7769, 7748, 1632, 3900, 8150, 1305, 6854, 9509],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [4011, 5588, 9618, 937, 6880, 8517, 2742, 40, 936, 4027, 9546],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [9077, 617, 2742, 6799, 7294, 2001, 9415, 5567, 1412, 8397, 9582],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [4439, 306, 8560, 375, 3477, 3443, 3954, 7046, 1607, 17, 9619],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [8948, 6127, 6917, 3506, 7844, 9932, 5785, 6297, 4605, 8938, 9654],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [6595, 4548, 1715, 55, 1494, 1602, 3550, 3501, 8343, 5210, 9690],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [2474, 3702, 8666, 3057, 7156, 7894, 6813, 8559, 6218, 8882, 9725],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [3685, 3875, 5712, 4968, 2561, 1196, 1153, 5076, 7668, 0, 9761],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [3631, 4790, 9548, 5191, 5672, 9305, 9382, 5614, 8715, 8610, 9795],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [832, 9032, 7706, 3516, 8099, 8094, 97, 5585, 2491, 4757, 9830],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [9379, 941, 5617, 6183, 5292, 6644, 4059, 1880, 9732, 8482, 9864],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [5566, 2833, 299, 427, 2873, 7473, 3852, 1293, 9249, 9829, 9898],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [4175, 5685, 5045, 1392, 7930, 4360, 6651, 2686, 8379, 8838, 9932],
    },
    BigFloatInc {
        sign: 1,
        e: -40,
        n: 44,
        m: [9381, 7483, 8303, 6476, 4240, 4417, 6379, 5963, 3412, 5549, 9966],
    },
    BigFloatInc {
        sign: 1,
        e: -39,
        n: 44,
        m: [3491, 6551, 4657, 9194, 6350, 1007, 8924, 2778, 3361, 5888, 4641],
    },
    BigFloatInc {
        sign: 1,
        e: -39,
        n: 44,
        m: [9973, 7060, 4555, 2758, 4720, 1357, 1310, 5732, 7642, 354, 5848],
    },
    BigFloatInc {
        sign: 1,
        e: -39,
        n: 44,
        m: [1769, 3034, 793, 3993, 3246, 2659, 2188, 1695, 82, 3295, 6694],
    },
    BigFloatInc {
        sign: 1,
        e: -39,
        n: 44,
        m: [5162, 3834, 1444, 1596, 5667, 5964, 2115, 773, 9728, 629, 7368],
    },
    BigFloatInc {
        sign: 1,
        e: -39,
        n: 44,
        m: [4666, 1957, 4130, 3615, 8196, 5852, 3737, 997, 5984, 52, 7937],
    },
    BigFloatInc {
        sign: 1,
        e: -39,
        n: 44,
        m: [1657, 2401, 2943, 607, 7514, 5709, 4284, 7492, 5301, 3266, 8434],
    },
    BigFloatInc {
        sign: 1,
        e: -39,
        n: 44,
        m: [3602, 6823, 7140, 5287, 9552, 9268, 842, 6007, 1742, 400, 8879],
    },
    BigFloatInc {
        sign: 1,
        e: -39,
        n: 44,
        m: [6982, 3102, 9315, 8388, 2701, 2015, 7848, 5557, 6722, 1776, 9283],
    },
    BigFloatInc {
        sign: 1,
        e: -39,
        n: 44,
        m: [8948, 6127, 6917, 3506, 7844, 9932, 5785, 6297, 4605, 8938, 9654],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1000],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [7119, 1730, 161, 97, 5225, 1358, 1592, 6367, 1545, 2801, 1032],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [4351, 733, 6305, 1654, 2222, 4774, 660, 2611, 6918, 6585, 1062],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [9360, 9552, 9124, 5208, 912, 1913, 8451, 1105, 8306, 3928, 1091],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [9449, 692, 9022, 3277, 9662, 121, 7766, 1396, 4208, 6889, 1118],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [9069, 8915, 7700, 9396, 2211, 804, 8678, 3331, 4255, 7142, 1144],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [1994, 1412, 6911, 551, 4944, 271, 4262, 5146, 9528, 6070, 1169],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [5726, 6901, 622, 6018, 7218, 5552, 9430, 7336, 9192, 4831, 1193],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [5341, 3975, 6048, 5475, 8999, 7968, 369, 4680, 9911, 4403, 1216],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [9072, 1068, 7372, 909, 3583, 943, 8225, 170, 2963, 5623, 1238],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [2515, 570, 2835, 2782, 607, 6721, 1647, 4873, 4989, 9210, 1259],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [9526, 583, 9620, 6334, 533, 4641, 2552, 7494, 6498, 5791, 1280],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [8470, 6001, 9617, 7167, 1149, 1023, 9988, 1386, 4685, 5914, 1300],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [8794, 7576, 3872, 3, 9331, 9144, 3976, 5912, 2179, 61, 1320],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [8354, 6606, 6158, 2798, 8649, 6531, 437, 4339, 16, 8659, 1338],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [5539, 2402, 4460, 8397, 4734, 5904, 2857, 7453, 829, 2088, 1357],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [7322, 9372, 4664, 8247, 8938, 5182, 107, 4141, 6707, 688, 1375],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [4047, 2965, 3397, 2758, 2905, 2302, 6677, 3833, 5008, 4766, 1392],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [2296, 5734, 9708, 2656, 9633, 5108, 3841, 2978, 4641, 4597, 1409],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [1368, 1993, 9821, 2735, 3115, 3598, 7264, 2408, 4714, 431, 1426],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [8692, 8391, 958, 7801, 8310, 2163, 3823, 7408, 7030, 2495, 1442],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [2038, 2931, 3952, 7254, 2077, 7802, 6271, 6711, 3582, 997, 1458],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [9032, 8766, 2288, 4319, 9133, 1192, 6423, 6154, 9945, 6125, 1473],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [8, 9589, 6244, 5276, 681, 3315, 4495, 3827, 5295, 8055, 1488],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [2966, 389, 5802, 2899, 1351, 2746, 7741, 4974, 9620, 6945, 1503],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [7270, 7790, 3481, 2528, 4789, 1040, 2597, 7831, 8593, 2944, 1518],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [1881, 8717, 1836, 8659, 1056, 9725, 2131, 7106, 6478, 6188, 1532],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [7944, 2242, 5489, 1353, 4857, 2152, 4537, 2035, 7377, 6803, 1546],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [6498, 9731, 811, 2708, 8443, 2287, 7964, 7884, 5070, 4907, 1560],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [5691, 5282, 8541, 6409, 6675, 671, 5095, 1443, 1663, 609, 1574],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [4933, 391, 826, 2723, 5639, 5170, 4747, 8199, 5196, 4010, 1587],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [4681, 1823, 2169, 6236, 6291, 2274, 2738, 3155, 6388, 5206, 1600],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [4952, 2278, 4535, 4822, 2236, 5884, 7640, 4543, 4602, 4286, 1613],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [4898, 7932, 9120, 2945, 6494, 8900, 6954, 9168, 3167, 1333, 1626],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [2068, 6678, 5994, 2571, 4257, 5901, 6387, 1291, 4120, 6425, 1638],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [4423, 8423, 4247, 2045, 4976, 3730, 3419, 7313, 2444, 9636, 1650],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [5370, 4343, 8955, 3472, 6207, 3511, 7677, 765, 9884, 1034, 1663],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [6108, 4190, 8000, 6114, 7616, 1188, 809, 2234, 8360, 686, 1675],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [2331, 6480, 4588, 8121, 9502, 9141, 4856, 3498, 3060, 8653, 1686],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [7782, 3913, 2114, 2031, 5259, 8670, 6067, 1810, 5224, 4992, 1698],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [551, 9868, 6010, 5438, 8872, 5310, 9893, 6696, 4667, 9759, 1709],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [4522, 9171, 3876, 1812, 6646, 2539, 9147, 6315, 2072, 3006, 1721],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [8383, 8578, 1598, 7036, 4004, 9186, 5318, 1805, 1068, 4782, 1732],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [467, 6635, 9398, 3103, 701, 2270, 3063, 5128, 126, 5134, 1743],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [2992, 7118, 5366, 827, 2416, 407, 6393, 7719, 4292, 4106, 1754],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [3633, 2170, 4765, 4241, 6296, 9798, 5010, 3031, 6766, 1741, 1765],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [6720, 1364, 5428, 5057, 7910, 5853, 4168, 5201, 348, 8080, 1775],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [1015, 5136, 7569, 5858, 7472, 4690, 5699, 8056, 8770, 3159, 1786],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [8692, 2196, 6178, 4728, 8162, 7589, 6991, 3052, 7914, 7017, 1796],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [4854, 8797, 9527, 7837, 1888, 6303, 6127, 1189, 6932, 9688, 1806],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [2105, 2428, 6050, 3272, 1756, 9121, 6588, 2139, 9283, 1205, 1817],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [1555, 3648, 571, 6266, 5392, 6278, 5787, 3520, 3686, 1601, 1827],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [7532, 4440, 1606, 2372, 3659, 8011, 7206, 4227, 5001, 905, 1837],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [6309, 5034, 5541, 8627, 5814, 5020, 4145, 7833, 5044, 9147, 1846],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [5396, 620, 7863, 3677, 540, 6403, 5569, 5111, 3344, 6355, 1856],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [5627, 9350, 7053, 6782, 5303, 8257, 1214, 8624, 7840, 2555, 1866],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [2642, 3119, 8278, 200, 295, 7559, 4656, 6903, 5536, 7774, 1875],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [5105, 5902, 322, 8719, 4556, 5584, 578, 986, 3102, 2036, 1885],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [9342, 1072, 3715, 4032, 7778, 8650, 1785, 1819, 7437, 5364, 1894],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [3806, 4630, 3603, 9339, 2693, 8410, 2298, 3303, 6196, 7782, 1903],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [4390, 2862, 6028, 5487, 6839, 9911, 1011, 2389, 8277, 9311, 1912],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [8804, 748, 1975, 1426, 5279, 3820, 3554, 4671, 4277, 9973, 1921],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [5790, 5225, 3383, 8701, 5568, 1986, 5157, 1259, 6921, 9787, 1930],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [1074, 758, 2460, 2856, 4772, 7168, 804, 333, 1458, 8774, 1939],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [3715, 3960, 6852, 9004, 8121, 7872, 7566, 4657, 6037, 6951, 1948],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [8411, 2465, 3571, 2058, 8030, 1246, 7977, 4431, 2058, 4338, 1957],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [4166, 3806, 3541, 8703, 9619, 5618, 19, 3117, 4498, 951, 1966],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [5880, 3844, 5062, 8851, 9763, 6348, 8098, 2366, 2221, 6808, 1974],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [2484, 5345, 5726, 5006, 253, 8430, 7268, 774, 8268, 1924, 1983],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [7624, 3440, 9646, 6134, 6602, 606, 772, 9913, 128, 6317, 1991],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2000],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [2531, 9910, 9237, 9197, 7973, 4797, 5656, 6508, 5024, 2988, 2008],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [4902, 3366, 8946, 4914, 2864, 8907, 3977, 8104, 7521, 5296, 2016],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [4294, 8235, 6138, 2278, 9539, 8738, 738, 5457, 5200, 6938, 2024],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [6513, 7523, 221, 4306, 4079, 5348, 8575, 9706, 1362, 7927, 2032],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [6383, 2603, 2148, 6130, 806, 8289, 352, 8674, 5095, 8275, 2040],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [3500, 7292, 9737, 5943, 6494, 2165, 2351, 8266, 1451, 7996, 2048],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [8790, 4291, 925, 6534, 179, 5045, 3314, 5963, 1620, 7101, 2056],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [4238, 3461, 322, 194, 450, 2717, 3184, 2734, 3091, 5602, 2064],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [1564, 9540, 733, 4559, 6898, 3809, 9041, 9260, 9805, 3510, 2072],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [8053, 6337, 8538, 3578, 6824, 3005, 1145, 1904, 2305, 838, 2080],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [2858, 8071, 7496, 6598, 8400, 3352, 9505, 3448, 7866, 7594, 2087],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [7606, 1310, 8136, 1660, 5006, 9117, 5813, 3294, 634, 3791, 2095],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [3478, 8255, 3228, 7216, 244, 6560, 5198, 1420, 1746, 9437, 2102],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [9213, 1714, 1114, 9247, 2913, 6363, 8760, 149, 9449, 4542, 2110],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [8052, 3493, 5096, 1089, 6212, 4907, 5819, 7446, 9212, 9117, 2117],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [8702, 1466, 2610, 3309, 4444, 9548, 1320, 5222, 3836, 3171, 2125],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [2707, 6857, 9173, 6674, 9127, 6359, 8411, 5886, 3550, 6712, 2132],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [3754, 5960, 4837, 9870, 2002, 7040, 225, 159, 6113, 9749, 2139],
    },
    BigFloatInc {
        sign: 1,
        e: -38,
        n: 44,
        m: [2916, 3405, 6667, 2787, 1591, 6839, 1755, 8941, 6901, 2291, 2147],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1000],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [2515, 570, 2835, 2782, 607, 6721, 1647, 4873, 4989, 9210, 1259],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [8692, 8391, 958, 7801, 8310, 2163, 3823, 7408, 7030, 2495, 1442],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [4933, 391, 826, 2723, 5639, 5170, 4747, 8199, 5196, 4010, 1587],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [551, 9868, 6010, 5438, 8872, 5310, 9893, 6696, 4667, 9759, 1709],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [2105, 2428, 6050, 3272, 1756, 9121, 6588, 2139, 9283, 1205, 1817],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [4390, 2862, 6028, 5487, 6839, 9911, 1011, 2389, 8277, 9311, 1912],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2000],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [8053, 6337, 8538, 3578, 6824, 3005, 1145, 1904, 2305, 838, 2080],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [3449, 5259, 5049, 5193, 3566, 5929, 7217, 1883, 9003, 4346, 2154],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [6991, 6518, 5719, 7221, 3376, 6536, 5211, 9315, 9056, 9800, 2223],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [8138, 7831, 5401, 8793, 4423, 1608, 7356, 6663, 8510, 4284, 2289],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [8420, 6915, 1452, 9569, 6339, 1, 4895, 757, 8772, 3346, 2351],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [5813, 5354, 7289, 6032, 9667, 2836, 9861, 5229, 6417, 1422, 2410],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [4845, 2735, 8904, 1545, 1323, 9161, 1014, 470, 7433, 2120, 2466],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [5029, 1140, 5670, 5564, 1214, 3442, 3295, 9746, 9978, 8420, 2519],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [9016, 6427, 2611, 7397, 7208, 5318, 3554, 8235, 9065, 2815, 2571],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [4276, 239, 9627, 4419, 1280, 4166, 6071, 8896, 9420, 7413, 2620],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [8786, 5095, 3033, 9708, 7371, 3962, 8673, 1944, 4872, 4016, 2668],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [1078, 4805, 8920, 6794, 9469, 1808, 5715, 4906, 1659, 4176, 2714],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [7121, 2252, 2158, 3585, 1108, 6579, 6694, 1120, 7638, 9241, 2758],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [7982, 7585, 9401, 6658, 7385, 6567, 1206, 5387, 3065, 393, 2802],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [1652, 2764, 5185, 9586, 9400, 9543, 4776, 1565, 7985, 8669, 2843],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [7385, 6783, 1917, 5602, 6621, 4327, 7646, 4816, 4061, 4991, 2884],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [4986, 8530, 2277, 1379, 7360, 678, 655, 2866, 3821, 177, 2924],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [3574, 7566, 3853, 3418, 2189, 7306, 5086, 7370, 6840, 4960, 2962],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3000],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [4540, 5581, 6963, 5056, 9578, 2080, 5194, 5662, 7187, 5889, 3036],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [7832, 5502, 9748, 1055, 7982, 1263, 2933, 5847, 2568, 3168, 3072],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [9068, 2854, 8636, 5223, 2427, 7766, 8668, 3858, 595, 2325, 3107],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [8597, 6350, 4992, 4627, 5896, 9307, 44, 1393, 5239, 3806, 3141],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [9866, 782, 1652, 5446, 1278, 341, 9495, 6398, 393, 8021, 3174],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [8517, 1361, 2011, 7195, 5171, 5251, 4875, 5826, 2999, 5343, 3207],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [3790, 378, 2970, 2720, 9924, 7146, 3840, 7483, 127, 6118, 3239],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [9031, 4098, 3134, 3925, 6902, 2480, 7282, 8589, 1018, 663, 3271],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [8846, 6846, 8495, 4090, 9952, 7460, 6838, 4626, 4889, 9272, 3301],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [6167, 4409, 1900, 1851, 505, 9545, 2600, 5953, 5164, 2218, 3332],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [5790, 7406, 6344, 8105, 8566, 4055, 3148, 8963, 679, 9754, 3361],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [8361, 3262, 9673, 9945, 725, 5467, 7619, 4166, 4301, 2114, 3391],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [1102, 9736, 2021, 877, 7745, 621, 9787, 3393, 9335, 9518, 3419],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [9929, 7169, 8961, 2607, 3864, 9742, 3840, 2730, 4038, 2172, 3448],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [8385, 4004, 3743, 45, 5219, 3986, 7867, 6449, 4488, 266, 3476],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [7568, 7248, 2973, 1891, 3758, 1433, 1706, 6724, 6038, 3980, 3503],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [7266, 4340, 9530, 8482, 2592, 9597, 21, 6063, 3532, 3483, 3530],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [869, 4978, 1158, 2389, 4622, 615, 8060, 62, 449, 8933, 3556],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [8206, 2154, 6627, 5806, 3674, 8696, 4853, 5946, 7101, 478, 3583],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [5517, 4905, 9261, 9588, 7295, 5251, 6892, 8694, 8013, 8260, 3608],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [4209, 4856, 2100, 6545, 3512, 8242, 3177, 4279, 8566, 2411, 3634],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [1037, 3487, 826, 1194, 3310, 3807, 5172, 2971, 1002, 3057, 3659],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [2581, 1917, 722, 5798, 2833, 7982, 6057, 386, 9864, 314, 3684],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [8858, 555, 3742, 8887, 3519, 3881, 4726, 6189, 6926, 4297, 3708],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [1254, 8701, 4107, 3565, 607, 6515, 2429, 7248, 5681, 5111, 3732],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [6791, 9094, 1951, 593, 9632, 1210, 66, 1072, 5422, 2857, 3756],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [7544, 1710, 8505, 8346, 1821, 163, 4943, 4619, 4968, 7631, 3779],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [7156, 7288, 1519, 8487, 5473, 4673, 6185, 1391, 6076, 9524, 3802],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [8781, 5724, 2056, 975, 3679, 9823, 2023, 4778, 6554, 8623, 3825],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [4055, 7128, 2531, 5250, 259, 229, 687, 6805, 3127, 5011, 3848],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [3405, 991, 174, 3448, 4226, 1331, 7472, 7796, 4062, 8766, 3870],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [7896, 3992, 8924, 1497, 4757, 6148, 5464, 3260, 1587, 9964, 3892],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [6822, 4931, 7142, 4116, 6060, 2493, 5954, 8863, 4116, 8676, 3914],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [5559, 8638, 4785, 321, 1373, 2885, 1958, 2173, 8310, 4971, 3936],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [2496, 6173, 2610, 194, 8479, 3614, 4789, 405, 968, 8916, 3957],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [2720, 8484, 6557, 7487, 7987, 6452, 8596, 6391, 789, 572, 3979],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4000],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [9866, 9806, 8875, 4314, 4514, 8654, 9760, 9057, 5858, 7257, 4020],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [3098, 3372, 6211, 6342, 74, 199, 2708, 2190, 2062, 2400, 4041],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [585, 6419, 2596, 7992, 1585, 8206, 7890, 5679, 44, 5481, 4061],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [2766, 5207, 4296, 2260, 1613, 6578, 705, 7348, 191, 6551, 4081],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [1058, 7650, 7480, 1418, 4982, 4718, 5218, 2347, 2970, 5659, 4101],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [5227, 810, 1335, 3664, 9117, 7748, 8193, 8556, 9980, 2852, 4121],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [3508, 8159, 7183, 3255, 8809, 451, 2500, 2853, 4942, 8177, 4140],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [6107, 2675, 7077, 7157, 3648, 6011, 2290, 3808, 4610, 1676, 4160],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [9944, 8013, 6776, 9087, 6348, 5637, 8920, 1231, 9638, 3391, 4179],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [679, 95, 2015, 6652, 8592, 5329, 7221, 8407, 5380, 3364, 4198],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [5828, 6200, 6471, 303, 8757, 2854, 2142, 8746, 2650, 1633, 4217],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [6104, 6987, 192, 2179, 2424, 9815, 1638, 4893, 8425, 8235, 4235],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [4079, 2960, 1670, 1244, 8662, 7336, 7760, 5005, 6511, 3208, 4254],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [7089, 8916, 9085, 2424, 8529, 8772, 8249, 7916, 8169, 6586, 4272],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [1977, 755, 7094, 4542, 4233, 2831, 1116, 6207, 2702, 8404, 4290],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [6899, 518, 99, 387, 7133, 1858, 4435, 3767, 8006, 8693, 4308],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [6078, 5175, 2876, 3403, 4932, 6491, 1469, 2225, 1092, 7487, 4326],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [6042, 7193, 7592, 545, 546, 2235, 9017, 8611, 8576, 4814, 4344],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [4932, 692, 4781, 6759, 9476, 1397, 5647, 4837, 7145, 706, 4362],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [25, 9980, 7571, 3724, 3531, 1980, 2657, 7889, 3988, 5191, 4379],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [8838, 598, 4186, 5384, 792, 921, 2758, 8179, 7215, 8296, 4396],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [2765, 2305, 5132, 6533, 1438, 5164, 7724, 2103, 6244, 49, 4414],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [6489, 8924, 8745, 9886, 3155, 2945, 1592, 3634, 2169, 476, 4431],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [3982, 3037, 1439, 4443, 6753, 3072, 423, 8631, 8113, 9601, 4447],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [9792, 5067, 6949, 742, 8481, 3396, 6334, 4537, 9558, 7450, 4464],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [7500, 1166, 7947, 385, 2014, 4748, 7087, 7164, 4655, 4047, 4481],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [4506, 9683, 5732, 3073, 794, 9156, 7963, 5414, 4527, 9414, 4497],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [5552, 1457, 8714, 6645, 2702, 4506, 3794, 4001, 3547, 3574, 4514],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [792, 6062, 8706, 4405, 7700, 3927, 7770, 3492, 9608, 6548, 4530],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [6097, 6350, 8471, 3212, 1541, 192, 8938, 6343, 4377, 8359, 4546],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [2176, 7254, 2817, 3004, 5906, 6393, 7275, 6966, 3538, 9026, 4562],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [6277, 5663, 803, 7587, 8847, 3216, 4712, 3327, 7021, 8569, 4578],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [9755, 9120, 898, 4223, 6464, 9429, 8060, 7039, 9220, 7008, 4594],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [3756, 2498, 7493, 9406, 6097, 7469, 5696, 8446, 9205, 4362, 4610],
    },
    BigFloatInc {
        sign: 1,
        e: -37,
        n: 44,
        m: [1938, 4622, 8409, 7912, 2369, 9236, 7930, 2741, 918, 650, 4626],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [3449, 5259, 5049, 5193, 3566, 5929, 7217, 1883, 9003, 4346, 2154],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [1078, 4805, 8920, 6794, 9469, 1808, 5715, 4906, 1659, 4176, 2714],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [9068, 2854, 8636, 5223, 2427, 7766, 8668, 3858, 595, 2325, 3107],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [1102, 9736, 2021, 877, 7745, 621, 9787, 3393, 9335, 9518, 3419],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [2581, 1917, 722, 5798, 2833, 7982, 6057, 386, 9864, 314, 3684],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [6822, 4931, 7142, 4116, 6060, 2493, 5954, 8863, 4116, 8676, 3914],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [5227, 810, 1335, 3664, 9117, 7748, 8193, 8556, 9980, 2852, 4121],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [6899, 518, 99, 387, 7133, 1858, 4435, 3767, 8006, 8693, 4308],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [7500, 1166, 7947, 385, 2014, 4748, 7087, 7164, 4655, 4047, 4481],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [3491, 6551, 4657, 9194, 6350, 1007, 8924, 2778, 3361, 5888, 4641],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [9538, 308, 6371, 3399, 8647, 6000, 9707, 2783, 5706, 4198, 4791],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [9690, 5470, 7808, 3091, 2646, 8322, 2029, 940, 4866, 4241, 4932],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [9836, 3642, 4591, 1940, 17, 241, 2694, 886, 1910, 7970, 5065],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [8003, 5537, 4409, 6014, 5248, 9445, 261, 1104, 185, 4941, 5192],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [1756, 3667, 1525, 8273, 1110, 3871, 3302, 3055, 4591, 2928, 5313],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [2155, 9610, 7840, 3589, 8939, 3617, 1430, 9813, 3318, 8352, 5428],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [3952, 3724, 8255, 4951, 8145, 7416, 2107, 4464, 5675, 6582, 5539],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [5026, 7987, 7482, 877, 6362, 6531, 9464, 6170, 7328, 2161, 5646],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [637, 1999, 2981, 3393, 1923, 7383, 7621, 4830, 7894, 8970, 5748],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [9973, 7060, 4555, 2758, 4720, 1357, 1310, 5732, 7642, 354, 5848],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [6183, 2243, 1108, 8746, 7950, 6784, 8021, 3129, 5276, 9219, 5943],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [6477, 1463, 3113, 302, 4799, 1856, 8905, 7685, 3679, 8107, 6036],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [9343, 6739, 2094, 1603, 5737, 5950, 7794, 8416, 7522, 9256, 6126],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [8136, 5709, 7272, 447, 4855, 5532, 7337, 7717, 1190, 4650, 6214],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [2573, 2851, 4175, 3911, 3036, 3605, 8238, 4365, 4947, 6052, 6299],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [2864, 3317, 5130, 4681, 2770, 2629, 4759, 9907, 9885, 5042, 6382],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [348, 5778, 5148, 5580, 699, 7788, 1652, 5651, 7009, 3040, 6463],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [8063, 8197, 6268, 7850, 3804, 4961, 4564, 7179, 2037, 1326, 6542],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [7903, 3223, 43, 8609, 5872, 8191, 3455, 6229, 4802, 1059, 6619],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [1769, 3034, 793, 3993, 3246, 2659, 2188, 1695, 82, 3295, 6694],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [4762, 2146, 5053, 8479, 3852, 6408, 4529, 7007, 5210, 8994, 6767],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [2204, 9472, 4043, 1754, 5490, 1243, 9574, 6787, 8670, 9037, 6839],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [6961, 6349, 6184, 7531, 926, 1496, 2721, 1184, 3001, 4232, 6910],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [7198, 1969, 6208, 6733, 3366, 2222, 3998, 8887, 4690, 5320, 6979],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [1480, 8671, 8542, 3284, 8166, 5544, 9207, 4891, 3206, 2987, 7047],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [1738, 9956, 2316, 4778, 9244, 1230, 6120, 125, 898, 7866, 7113],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [5099, 1448, 3892, 2427, 8858, 2634, 9360, 8318, 5206, 543, 7179],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [3198, 1366, 117, 9117, 7141, 6185, 7099, 1740, 4344, 1564, 7243],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [4106, 2438, 3990, 833, 943, 7611, 4754, 2803, 7406, 1435, 7306],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [5162, 3834, 1444, 1596, 5667, 5964, 2115, 773, 9728, 629, 7368],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [1506, 7042, 9734, 1657, 6388, 7447, 2154, 6565, 4144, 9588, 7428],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [630, 654, 7036, 9408, 7943, 6891, 1978, 8507, 8721, 8723, 7488],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [9140, 5302, 6715, 6485, 8333, 241, 7376, 7574, 1428, 8423, 7547],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [4312, 4577, 3039, 6974, 947, 9347, 2370, 2783, 2152, 9049, 7605],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [9407, 3585, 9184, 3295, 5284, 8625, 659, 5531, 2393, 943, 7663],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [4991, 2985, 3088, 5707, 4235, 7095, 5526, 1641, 2936, 4426, 7719],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [367, 762, 90, 3517, 7640, 6121, 6564, 2586, 9734, 9800, 7774],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [3644, 9863, 4284, 8233, 2120, 4987, 1908, 7727, 8233, 7352, 7829],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [5765, 3172, 1284, 789, 4739, 1020, 8187, 5242, 6310, 7351, 7883],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [4666, 1957, 4130, 3615, 8196, 5852, 3737, 997, 5984, 52, 7937],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [3578, 8400, 1094, 2607, 113, 9303, 9868, 4012, 4045, 5697, 7989],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [9733, 9613, 7751, 8629, 9028, 7308, 9521, 8115, 1717, 4515, 8041],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [3062, 1495, 1095, 7598, 1204, 6902, 8298, 6455, 3456, 6723, 8092],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [3233, 4415, 6761, 384, 8409, 5426, 7145, 4719, 4978, 2528, 8143],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [339, 3391, 9973, 2857, 1286, 9507, 1937, 6458, 600, 2127, 8193],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [454, 1621, 2670, 7328, 8234, 5497, 6387, 7113, 9961, 5705, 8242],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [9965, 3281, 2754, 8726, 3593, 4000, 3716, 9697, 4184, 3443, 8291],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [9209, 1554, 3158, 4593, 665, 3985, 6442, 2606, 1540, 5509, 8339],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [1387, 1686, 7361, 3888, 9653, 3860, 3792, 7142, 2652, 2065, 8387],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [1657, 2401, 2943, 607, 7514, 5709, 4284, 7492, 5301, 3266, 8434],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [9798, 2629, 108, 3351, 3291, 7411, 9283, 8113, 8848, 9260, 8480],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [5924, 6048, 848, 8587, 5161, 2259, 6919, 1597, 8328, 189, 8527],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [8147, 6166, 3059, 102, 953, 7575, 7011, 3395, 8231, 6188, 8572],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [3798, 1037, 198, 774, 4266, 3717, 8870, 7534, 6012, 7387, 8617],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [1916, 2894, 7994, 5180, 23, 5932, 6594, 9027, 5340, 3910, 8662],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [1938, 3006, 6485, 2498, 1247, 7634, 8755, 3611, 9117, 5876, 8706],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [7968, 8740, 8850, 9899, 4109, 7687, 2677, 3274, 2283, 3401, 8750],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [7675, 1197, 8372, 768, 1585, 1842, 5516, 6358, 4431, 6593, 8793],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [8487, 3208, 5370, 8830, 6088, 8313, 623, 3612, 2240, 5559, 8836],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [3602, 6823, 7140, 5287, 9552, 9268, 842, 6007, 1742, 400, 8879],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [4254, 3705, 323, 8815, 420, 6752, 2015, 6347, 445, 1214, 8921],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [5000, 2333, 5894, 771, 4028, 9496, 4174, 4329, 9311, 8094, 8962],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [6264, 4632, 4228, 1816, 1413, 5572, 3412, 3701, 4609, 1133, 9004],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [5254, 6096, 9943, 6938, 4504, 1607, 8016, 274, 9651, 416, 9045],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [523, 2141, 251, 6363, 8781, 5605, 2944, 698, 6416, 6029, 9085],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [4353, 4508, 5635, 6008, 1812, 2787, 4551, 3933, 7077, 8052, 9125],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [6353, 6941, 558, 7083, 1370, 6092, 8662, 222, 5433, 6564, 9165],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [4446, 6538, 9389, 9780, 7602, 6790, 3690, 5888, 8251, 1640, 9205],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [4201, 4239, 5454, 2121, 4549, 557, 1027, 6482, 6537, 3354, 9244],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [6982, 3102, 9315, 8388, 2701, 2015, 7848, 5557, 6722, 1776, 9283],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [7205, 8564, 5908, 5671, 7282, 3298, 6006, 1576, 1786, 6975, 9321],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [2055, 8067, 5204, 1987, 1499, 9815, 330, 1157, 2314, 9016, 9359],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [2887, 4458, 6940, 507, 8215, 1795, 8653, 2973, 7495, 7963, 9397],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [8051, 7356, 379, 9657, 8687, 4105, 7146, 3066, 6063, 3879, 9435],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [6708, 5364, 8575, 161, 8892, 3253, 8929, 9095, 7185, 6823, 9472],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [2928, 402, 5930, 7769, 7748, 1632, 3900, 8150, 1305, 6854, 9509],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [4011, 5588, 9618, 937, 6880, 8517, 2742, 40, 936, 4027, 9546],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [9077, 617, 2742, 6799, 7294, 2001, 9415, 5567, 1412, 8397, 9582],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [4439, 306, 8560, 375, 3477, 3443, 3954, 7046, 1607, 17, 9619],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [8948, 6127, 6917, 3506, 7844, 9932, 5785, 6297, 4605, 8938, 9654],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [6595, 4548, 1715, 55, 1494, 1602, 3550, 3501, 8343, 5210, 9690],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [2474, 3702, 8666, 3057, 7156, 7894, 6813, 8559, 6218, 8882, 9725],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [3685, 3875, 5712, 4968, 2561, 1196, 1153, 5076, 7668, 0, 9761],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [3631, 4790, 9548, 5191, 5672, 9305, 9382, 5614, 8715, 8610, 9795],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [832, 9032, 7706, 3516, 8099, 8094, 97, 5585, 2491, 4757, 9830],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [9379, 941, 5617, 6183, 5292, 6644, 4059, 1880, 9732, 8482, 9864],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [5566, 2833, 299, 427, 2873, 7473, 3852, 1293, 9249, 9829, 9898],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [4175, 5685, 5045, 1392, 7930, 4360, 6651, 2686, 8379, 8838, 9932],
    },
    BigFloatInc {
        sign: 1,
        e: -36,
        n: 44,
        m: [9381, 7483, 8303, 6476, 4240, 4417, 6379, 5963, 3412, 5549, 9966],
    },
    BigFloatInc {
        sign: 1,
        e: -35,
        n: 44,
        m: [3491, 6551, 4657, 9194, 6350, 1007, 8924, 2778, 3361, 5888, 4641],
    },
    BigFloatInc {
        sign: 1,
        e: -35,
        n: 44,
        m: [9973, 7060, 4555, 2758, 4720, 1357, 1310, 5732, 7642, 354, 5848],
    },
    BigFloatInc {
        sign: 1,
        e: -35,
        n: 44,
        m: [1769, 3034, 793, 3993, 3246, 2659, 2188, 1695, 82, 3295, 6694],
    },
    BigFloatInc {
        sign: 1,
        e: -35,
        n: 44,
        m: [5162, 3834, 1444, 1596, 5667, 5964, 2115, 773, 9728, 629, 7368],
    },
    BigFloatInc {
        sign: 1,
        e: -35,
        n: 44,
        m: [4666, 1957, 4130, 3615, 8196, 5852, 3737, 997, 5984, 52, 7937],
    },
    BigFloatInc {
        sign: 1,
        e: -35,
        n: 44,
        m: [1657, 2401, 2943, 607, 7514, 5709, 4284, 7492, 5301, 3266, 8434],
    },
    BigFloatInc {
        sign: 1,
        e: -35,
        n: 44,
        m: [3602, 6823, 7140, 5287, 9552, 9268, 842, 6007, 1742, 400, 8879],
    },
    BigFloatInc {
        sign: 1,
        e: -35,
        n: 44,
        m: [6982, 3102, 9315, 8388, 2701, 2015, 7848, 5557, 6722, 1776, 9283],
    },
    BigFloatInc {
        sign: 1,
        e: -35,
        n: 44,
        m: [8948, 6127, 6917, 3506, 7844, 9932, 5785, 6297, 4605, 8938, 9654],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1000],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [7119, 1730, 161, 97, 5225, 1358, 1592, 6367, 1545, 2801, 1032],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [4351, 733, 6305, 1654, 2222, 4774, 660, 2611, 6918, 6585, 1062],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [9360, 9552, 9124, 5208, 912, 1913, 8451, 1105, 8306, 3928, 1091],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [9449, 692, 9022, 3277, 9662, 121, 7766, 1396, 4208, 6889, 1118],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [9069, 8915, 7700, 9396, 2211, 804, 8678, 3331, 4255, 7142, 1144],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [1994, 1412, 6911, 551, 4944, 271, 4262, 5146, 9528, 6070, 1169],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [5726, 6901, 622, 6018, 7218, 5552, 9430, 7336, 9192, 4831, 1193],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [5341, 3975, 6048, 5475, 8999, 7968, 369, 4680, 9911, 4403, 1216],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [9072, 1068, 7372, 909, 3583, 943, 8225, 170, 2963, 5623, 1238],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [2515, 570, 2835, 2782, 607, 6721, 1647, 4873, 4989, 9210, 1259],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [9526, 583, 9620, 6334, 533, 4641, 2552, 7494, 6498, 5791, 1280],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [8470, 6001, 9617, 7167, 1149, 1023, 9988, 1386, 4685, 5914, 1300],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [8794, 7576, 3872, 3, 9331, 9144, 3976, 5912, 2179, 61, 1320],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [8354, 6606, 6158, 2798, 8649, 6531, 437, 4339, 16, 8659, 1338],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [5539, 2402, 4460, 8397, 4734, 5904, 2857, 7453, 829, 2088, 1357],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [7322, 9372, 4664, 8247, 8938, 5182, 107, 4141, 6707, 688, 1375],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [4047, 2965, 3397, 2758, 2905, 2302, 6677, 3833, 5008, 4766, 1392],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [2296, 5734, 9708, 2656, 9633, 5108, 3841, 2978, 4641, 4597, 1409],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [1368, 1993, 9821, 2735, 3115, 3598, 7264, 2408, 4714, 431, 1426],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [8692, 8391, 958, 7801, 8310, 2163, 3823, 7408, 7030, 2495, 1442],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [2038, 2931, 3952, 7254, 2077, 7802, 6271, 6711, 3582, 997, 1458],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [9032, 8766, 2288, 4319, 9133, 1192, 6423, 6154, 9945, 6125, 1473],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [8, 9589, 6244, 5276, 681, 3315, 4495, 3827, 5295, 8055, 1488],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [2966, 389, 5802, 2899, 1351, 2746, 7741, 4974, 9620, 6945, 1503],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [7270, 7790, 3481, 2528, 4789, 1040, 2597, 7831, 8593, 2944, 1518],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [1881, 8717, 1836, 8659, 1056, 9725, 2131, 7106, 6478, 6188, 1532],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [7944, 2242, 5489, 1353, 4857, 2152, 4537, 2035, 7377, 6803, 1546],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [6498, 9731, 811, 2708, 8443, 2287, 7964, 7884, 5070, 4907, 1560],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [5691, 5282, 8541, 6409, 6675, 671, 5095, 1443, 1663, 609, 1574],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [4933, 391, 826, 2723, 5639, 5170, 4747, 8199, 5196, 4010, 1587],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [4681, 1823, 2169, 6236, 6291, 2274, 2738, 3155, 6388, 5206, 1600],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [4952, 2278, 4535, 4822, 2236, 5884, 7640, 4543, 4602, 4286, 1613],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [4898, 7932, 9120, 2945, 6494, 8900, 6954, 9168, 3167, 1333, 1626],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [2068, 6678, 5994, 2571, 4257, 5901, 6387, 1291, 4120, 6425, 1638],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [4423, 8423, 4247, 2045, 4976, 3730, 3419, 7313, 2444, 9636, 1650],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [5370, 4343, 8955, 3472, 6207, 3511, 7677, 765, 9884, 1034, 1663],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [6108, 4190, 8000, 6114, 7616, 1188, 809, 2234, 8360, 686, 1675],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [2331, 6480, 4588, 8121, 9502, 9141, 4856, 3498, 3060, 8653, 1686],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [7782, 3913, 2114, 2031, 5259, 8670, 6067, 1810, 5224, 4992, 1698],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [551, 9868, 6010, 5438, 8872, 5310, 9893, 6696, 4667, 9759, 1709],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [4522, 9171, 3876, 1812, 6646, 2539, 9147, 6315, 2072, 3006, 1721],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [8383, 8578, 1598, 7036, 4004, 9186, 5318, 1805, 1068, 4782, 1732],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [467, 6635, 9398, 3103, 701, 2270, 3063, 5128, 126, 5134, 1743],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [2992, 7118, 5366, 827, 2416, 407, 6393, 7719, 4292, 4106, 1754],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [3633, 2170, 4765, 4241, 6296, 9798, 5010, 3031, 6766, 1741, 1765],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [6720, 1364, 5428, 5057, 7910, 5853, 4168, 5201, 348, 8080, 1775],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [1015, 5136, 7569, 5858, 7472, 4690, 5699, 8056, 8770, 3159, 1786],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [8692, 2196, 6178, 4728, 8162, 7589, 6991, 3052, 7914, 7017, 1796],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [4854, 8797, 9527, 7837, 1888, 6303, 6127, 1189, 6932, 9688, 1806],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [2105, 2428, 6050, 3272, 1756, 9121, 6588, 2139, 9283, 1205, 1817],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [1555, 3648, 571, 6266, 5392, 6278, 5787, 3520, 3686, 1601, 1827],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [7532, 4440, 1606, 2372, 3659, 8011, 7206, 4227, 5001, 905, 1837],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [6309, 5034, 5541, 8627, 5814, 5020, 4145, 7833, 5044, 9147, 1846],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [5396, 620, 7863, 3677, 540, 6403, 5569, 5111, 3344, 6355, 1856],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [5627, 9350, 7053, 6782, 5303, 8257, 1214, 8624, 7840, 2555, 1866],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [2642, 3119, 8278, 200, 295, 7559, 4656, 6903, 5536, 7774, 1875],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [5105, 5902, 322, 8719, 4556, 5584, 578, 986, 3102, 2036, 1885],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [9342, 1072, 3715, 4032, 7778, 8650, 1785, 1819, 7437, 5364, 1894],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [3806, 4630, 3603, 9339, 2693, 8410, 2298, 3303, 6196, 7782, 1903],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [4390, 2862, 6028, 5487, 6839, 9911, 1011, 2389, 8277, 9311, 1912],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [8804, 748, 1975, 1426, 5279, 3820, 3554, 4671, 4277, 9973, 1921],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [5790, 5225, 3383, 8701, 5568, 1986, 5157, 1259, 6921, 9787, 1930],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [1074, 758, 2460, 2856, 4772, 7168, 804, 333, 1458, 8774, 1939],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [3715, 3960, 6852, 9004, 8121, 7872, 7566, 4657, 6037, 6951, 1948],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [8411, 2465, 3571, 2058, 8030, 1246, 7977, 4431, 2058, 4338, 1957],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [4166, 3806, 3541, 8703, 9619, 5618, 19, 3117, 4498, 951, 1966],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [5880, 3844, 5062, 8851, 9763, 6348, 8098, 2366, 2221, 6808, 1974],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [2484, 5345, 5726, 5006, 253, 8430, 7268, 774, 8268, 1924, 1983],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [7624, 3440, 9646, 6134, 6602, 606, 772, 9913, 128, 6317, 1991],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2000],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [2531, 9910, 9237, 9197, 7973, 4797, 5656, 6508, 5024, 2988, 2008],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [4902, 3366, 8946, 4914, 2864, 8907, 3977, 8104, 7521, 5296, 2016],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [4294, 8235, 6138, 2278, 9539, 8738, 738, 5457, 5200, 6938, 2024],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [6513, 7523, 221, 4306, 4079, 5348, 8575, 9706, 1362, 7927, 2032],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [6383, 2603, 2148, 6130, 806, 8289, 352, 8674, 5095, 8275, 2040],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [3500, 7292, 9737, 5943, 6494, 2165, 2351, 8266, 1451, 7996, 2048],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [8790, 4291, 925, 6534, 179, 5045, 3314, 5963, 1620, 7101, 2056],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [4238, 3461, 322, 194, 450, 2717, 3184, 2734, 3091, 5602, 2064],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [1564, 9540, 733, 4559, 6898, 3809, 9041, 9260, 9805, 3510, 2072],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [8053, 6337, 8538, 3578, 6824, 3005, 1145, 1904, 2305, 838, 2080],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [2858, 8071, 7496, 6598, 8400, 3352, 9505, 3448, 7866, 7594, 2087],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [7606, 1310, 8136, 1660, 5006, 9117, 5813, 3294, 634, 3791, 2095],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [3478, 8255, 3228, 7216, 244, 6560, 5198, 1420, 1746, 9437, 2102],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [9213, 1714, 1114, 9247, 2913, 6363, 8760, 149, 9449, 4542, 2110],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [8052, 3493, 5096, 1089, 6212, 4907, 5819, 7446, 9212, 9117, 2117],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [8702, 1466, 2610, 3309, 4444, 9548, 1320, 5222, 3836, 3171, 2125],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [2707, 6857, 9173, 6674, 9127, 6359, 8411, 5886, 3550, 6712, 2132],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [3754, 5960, 4837, 9870, 2002, 7040, 225, 159, 6113, 9749, 2139],
    },
    BigFloatInc {
        sign: 1,
        e: -34,
        n: 44,
        m: [2916, 3405, 6667, 2787, 1591, 6839, 1755, 8941, 6901, 2291, 2147],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1000],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [2515, 570, 2835, 2782, 607, 6721, 1647, 4873, 4989, 9210, 1259],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [8692, 8391, 958, 7801, 8310, 2163, 3823, 7408, 7030, 2495, 1442],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [4933, 391, 826, 2723, 5639, 5170, 4747, 8199, 5196, 4010, 1587],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [551, 9868, 6010, 5438, 8872, 5310, 9893, 6696, 4667, 9759, 1709],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [2105, 2428, 6050, 3272, 1756, 9121, 6588, 2139, 9283, 1205, 1817],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [4390, 2862, 6028, 5487, 6839, 9911, 1011, 2389, 8277, 9311, 1912],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2000],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [8053, 6337, 8538, 3578, 6824, 3005, 1145, 1904, 2305, 838, 2080],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [3449, 5259, 5049, 5193, 3566, 5929, 7217, 1883, 9003, 4346, 2154],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [6991, 6518, 5719, 7221, 3376, 6536, 5211, 9315, 9056, 9800, 2223],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [8138, 7831, 5401, 8793, 4423, 1608, 7356, 6663, 8510, 4284, 2289],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [8420, 6915, 1452, 9569, 6339, 1, 4895, 757, 8772, 3346, 2351],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [5813, 5354, 7289, 6032, 9667, 2836, 9861, 5229, 6417, 1422, 2410],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [4845, 2735, 8904, 1545, 1323, 9161, 1014, 470, 7433, 2120, 2466],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [5029, 1140, 5670, 5564, 1214, 3442, 3295, 9746, 9978, 8420, 2519],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [9016, 6427, 2611, 7397, 7208, 5318, 3554, 8235, 9065, 2815, 2571],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [4276, 239, 9627, 4419, 1280, 4166, 6071, 8896, 9420, 7413, 2620],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [8786, 5095, 3033, 9708, 7371, 3962, 8673, 1944, 4872, 4016, 2668],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [1078, 4805, 8920, 6794, 9469, 1808, 5715, 4906, 1659, 4176, 2714],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [7121, 2252, 2158, 3585, 1108, 6579, 6694, 1120, 7638, 9241, 2758],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [7982, 7585, 9401, 6658, 7385, 6567, 1206, 5387, 3065, 393, 2802],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [1652, 2764, 5185, 9586, 9400, 9543, 4776, 1565, 7985, 8669, 2843],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [7385, 6783, 1917, 5602, 6621, 4327, 7646, 4816, 4061, 4991, 2884],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [4986, 8530, 2277, 1379, 7360, 678, 655, 2866, 3821, 177, 2924],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [3574, 7566, 3853, 3418, 2189, 7306, 5086, 7370, 6840, 4960, 2962],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3000],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [4540, 5581, 6963, 5056, 9578, 2080, 5194, 5662, 7187, 5889, 3036],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [7832, 5502, 9748, 1055, 7982, 1263, 2933, 5847, 2568, 3168, 3072],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [9068, 2854, 8636, 5223, 2427, 7766, 8668, 3858, 595, 2325, 3107],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [8597, 6350, 4992, 4627, 5896, 9307, 44, 1393, 5239, 3806, 3141],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [9866, 782, 1652, 5446, 1278, 341, 9495, 6398, 393, 8021, 3174],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [8517, 1361, 2011, 7195, 5171, 5251, 4875, 5826, 2999, 5343, 3207],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [3790, 378, 2970, 2720, 9924, 7146, 3840, 7483, 127, 6118, 3239],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [9031, 4098, 3134, 3925, 6902, 2480, 7282, 8589, 1018, 663, 3271],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [8846, 6846, 8495, 4090, 9952, 7460, 6838, 4626, 4889, 9272, 3301],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [6167, 4409, 1900, 1851, 505, 9545, 2600, 5953, 5164, 2218, 3332],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [5790, 7406, 6344, 8105, 8566, 4055, 3148, 8963, 679, 9754, 3361],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [8361, 3262, 9673, 9945, 725, 5467, 7619, 4166, 4301, 2114, 3391],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [1102, 9736, 2021, 877, 7745, 621, 9787, 3393, 9335, 9518, 3419],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [9929, 7169, 8961, 2607, 3864, 9742, 3840, 2730, 4038, 2172, 3448],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [8385, 4004, 3743, 45, 5219, 3986, 7867, 6449, 4488, 266, 3476],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [7568, 7248, 2973, 1891, 3758, 1433, 1706, 6724, 6038, 3980, 3503],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [7266, 4340, 9530, 8482, 2592, 9597, 21, 6063, 3532, 3483, 3530],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [869, 4978, 1158, 2389, 4622, 615, 8060, 62, 449, 8933, 3556],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [8206, 2154, 6627, 5806, 3674, 8696, 4853, 5946, 7101, 478, 3583],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [5517, 4905, 9261, 9588, 7295, 5251, 6892, 8694, 8013, 8260, 3608],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [4209, 4856, 2100, 6545, 3512, 8242, 3177, 4279, 8566, 2411, 3634],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [1037, 3487, 826, 1194, 3310, 3807, 5172, 2971, 1002, 3057, 3659],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [2581, 1917, 722, 5798, 2833, 7982, 6057, 386, 9864, 314, 3684],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [8858, 555, 3742, 8887, 3519, 3881, 4726, 6189, 6926, 4297, 3708],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [1254, 8701, 4107, 3565, 607, 6515, 2429, 7248, 5681, 5111, 3732],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [6791, 9094, 1951, 593, 9632, 1210, 66, 1072, 5422, 2857, 3756],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [7544, 1710, 8505, 8346, 1821, 163, 4943, 4619, 4968, 7631, 3779],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [7156, 7288, 1519, 8487, 5473, 4673, 6185, 1391, 6076, 9524, 3802],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [8781, 5724, 2056, 975, 3679, 9823, 2023, 4778, 6554, 8623, 3825],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [4055, 7128, 2531, 5250, 259, 229, 687, 6805, 3127, 5011, 3848],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [3405, 991, 174, 3448, 4226, 1331, 7472, 7796, 4062, 8766, 3870],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [7896, 3992, 8924, 1497, 4757, 6148, 5464, 3260, 1587, 9964, 3892],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [6822, 4931, 7142, 4116, 6060, 2493, 5954, 8863, 4116, 8676, 3914],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [5559, 8638, 4785, 321, 1373, 2885, 1958, 2173, 8310, 4971, 3936],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [2496, 6173, 2610, 194, 8479, 3614, 4789, 405, 968, 8916, 3957],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [2720, 8484, 6557, 7487, 7987, 6452, 8596, 6391, 789, 572, 3979],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4000],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [9866, 9806, 8875, 4314, 4514, 8654, 9760, 9057, 5858, 7257, 4020],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [3098, 3372, 6211, 6342, 74, 199, 2708, 2190, 2062, 2400, 4041],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [585, 6419, 2596, 7992, 1585, 8206, 7890, 5679, 44, 5481, 4061],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [2766, 5207, 4296, 2260, 1613, 6578, 705, 7348, 191, 6551, 4081],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [1058, 7650, 7480, 1418, 4982, 4718, 5218, 2347, 2970, 5659, 4101],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [5227, 810, 1335, 3664, 9117, 7748, 8193, 8556, 9980, 2852, 4121],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [3508, 8159, 7183, 3255, 8809, 451, 2500, 2853, 4942, 8177, 4140],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [6107, 2675, 7077, 7157, 3648, 6011, 2290, 3808, 4610, 1676, 4160],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [9944, 8013, 6776, 9087, 6348, 5637, 8920, 1231, 9638, 3391, 4179],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [679, 95, 2015, 6652, 8592, 5329, 7221, 8407, 5380, 3364, 4198],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [5828, 6200, 6471, 303, 8757, 2854, 2142, 8746, 2650, 1633, 4217],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [6104, 6987, 192, 2179, 2424, 9815, 1638, 4893, 8425, 8235, 4235],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [4079, 2960, 1670, 1244, 8662, 7336, 7760, 5005, 6511, 3208, 4254],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [7089, 8916, 9085, 2424, 8529, 8772, 8249, 7916, 8169, 6586, 4272],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [1977, 755, 7094, 4542, 4233, 2831, 1116, 6207, 2702, 8404, 4290],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [6899, 518, 99, 387, 7133, 1858, 4435, 3767, 8006, 8693, 4308],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [6078, 5175, 2876, 3403, 4932, 6491, 1469, 2225, 1092, 7487, 4326],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [6042, 7193, 7592, 545, 546, 2235, 9017, 8611, 8576, 4814, 4344],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [4932, 692, 4781, 6759, 9476, 1397, 5647, 4837, 7145, 706, 4362],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [25, 9980, 7571, 3724, 3531, 1980, 2657, 7889, 3988, 5191, 4379],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [8838, 598, 4186, 5384, 792, 921, 2758, 8179, 7215, 8296, 4396],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [2765, 2305, 5132, 6533, 1438, 5164, 7724, 2103, 6244, 49, 4414],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [6489, 8924, 8745, 9886, 3155, 2945, 1592, 3634, 2169, 476, 4431],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [3982, 3037, 1439, 4443, 6753, 3072, 423, 8631, 8113, 9601, 4447],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [9792, 5067, 6949, 742, 8481, 3396, 6334, 4537, 9558, 7450, 4464],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [7500, 1166, 7947, 385, 2014, 4748, 7087, 7164, 4655, 4047, 4481],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [4506, 9683, 5732, 3073, 794, 9156, 7963, 5414, 4527, 9414, 4497],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [5552, 1457, 8714, 6645, 2702, 4506, 3794, 4001, 3547, 3574, 4514],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [792, 6062, 8706, 4405, 7700, 3927, 7770, 3492, 9608, 6548, 4530],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [6097, 6350, 8471, 3212, 1541, 192, 8938, 6343, 4377, 8359, 4546],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [2176, 7254, 2817, 3004, 5906, 6393, 7275, 6966, 3538, 9026, 4562],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [6277, 5663, 803, 7587, 8847, 3216, 4712, 3327, 7021, 8569, 4578],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [9755, 9120, 898, 4223, 6464, 9429, 8060, 7039, 9220, 7008, 4594],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [3756, 2498, 7493, 9406, 6097, 7469, 5696, 8446, 9205, 4362, 4610],
    },
    BigFloatInc {
        sign: 1,
        e: -33,
        n: 44,
        m: [1938, 4622, 8409, 7912, 2369, 9236, 7930, 2741, 918, 650, 4626],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [3449, 5259, 5049, 5193, 3566, 5929, 7217, 1883, 9003, 4346, 2154],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [1078, 4805, 8920, 6794, 9469, 1808, 5715, 4906, 1659, 4176, 2714],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [9068, 2854, 8636, 5223, 2427, 7766, 8668, 3858, 595, 2325, 3107],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [1102, 9736, 2021, 877, 7745, 621, 9787, 3393, 9335, 9518, 3419],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [2581, 1917, 722, 5798, 2833, 7982, 6057, 386, 9864, 314, 3684],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [6822, 4931, 7142, 4116, 6060, 2493, 5954, 8863, 4116, 8676, 3914],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [5227, 810, 1335, 3664, 9117, 7748, 8193, 8556, 9980, 2852, 4121],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [6899, 518, 99, 387, 7133, 1858, 4435, 3767, 8006, 8693, 4308],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [7500, 1166, 7947, 385, 2014, 4748, 7087, 7164, 4655, 4047, 4481],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [3491, 6551, 4657, 9194, 6350, 1007, 8924, 2778, 3361, 5888, 4641],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [9538, 308, 6371, 3399, 8647, 6000, 9707, 2783, 5706, 4198, 4791],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [9690, 5470, 7808, 3091, 2646, 8322, 2029, 940, 4866, 4241, 4932],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [9836, 3642, 4591, 1940, 17, 241, 2694, 886, 1910, 7970, 5065],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [8003, 5537, 4409, 6014, 5248, 9445, 261, 1104, 185, 4941, 5192],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [1756, 3667, 1525, 8273, 1110, 3871, 3302, 3055, 4591, 2928, 5313],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [2155, 9610, 7840, 3589, 8939, 3617, 1430, 9813, 3318, 8352, 5428],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [3952, 3724, 8255, 4951, 8145, 7416, 2107, 4464, 5675, 6582, 5539],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [5026, 7987, 7482, 877, 6362, 6531, 9464, 6170, 7328, 2161, 5646],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [637, 1999, 2981, 3393, 1923, 7383, 7621, 4830, 7894, 8970, 5748],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [9973, 7060, 4555, 2758, 4720, 1357, 1310, 5732, 7642, 354, 5848],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [6183, 2243, 1108, 8746, 7950, 6784, 8021, 3129, 5276, 9219, 5943],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [6477, 1463, 3113, 302, 4799, 1856, 8905, 7685, 3679, 8107, 6036],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [9343, 6739, 2094, 1603, 5737, 5950, 7794, 8416, 7522, 9256, 6126],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [8136, 5709, 7272, 447, 4855, 5532, 7337, 7717, 1190, 4650, 6214],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [2573, 2851, 4175, 3911, 3036, 3605, 8238, 4365, 4947, 6052, 6299],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [2864, 3317, 5130, 4681, 2770, 2629, 4759, 9907, 9885, 5042, 6382],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [348, 5778, 5148, 5580, 699, 7788, 1652, 5651, 7009, 3040, 6463],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [8063, 8197, 6268, 7850, 3804, 4961, 4564, 7179, 2037, 1326, 6542],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [7903, 3223, 43, 8609, 5872, 8191, 3455, 6229, 4802, 1059, 6619],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [1769, 3034, 793, 3993, 3246, 2659, 2188, 1695, 82, 3295, 6694],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [4762, 2146, 5053, 8479, 3852, 6408, 4529, 7007, 5210, 8994, 6767],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [2204, 9472, 4043, 1754, 5490, 1243, 9574, 6787, 8670, 9037, 6839],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [6961, 6349, 6184, 7531, 926, 1496, 2721, 1184, 3001, 4232, 6910],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [7198, 1969, 6208, 6733, 3366, 2222, 3998, 8887, 4690, 5320, 6979],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [1480, 8671, 8542, 3284, 8166, 5544, 9207, 4891, 3206, 2987, 7047],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [1738, 9956, 2316, 4778, 9244, 1230, 6120, 125, 898, 7866, 7113],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [5099, 1448, 3892, 2427, 8858, 2634, 9360, 8318, 5206, 543, 7179],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [3198, 1366, 117, 9117, 7141, 6185, 7099, 1740, 4344, 1564, 7243],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [4106, 2438, 3990, 833, 943, 7611, 4754, 2803, 7406, 1435, 7306],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [5162, 3834, 1444, 1596, 5667, 5964, 2115, 773, 9728, 629, 7368],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [1506, 7042, 9734, 1657, 6388, 7447, 2154, 6565, 4144, 9588, 7428],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [630, 654, 7036, 9408, 7943, 6891, 1978, 8507, 8721, 8723, 7488],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [9140, 5302, 6715, 6485, 8333, 241, 7376, 7574, 1428, 8423, 7547],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [4312, 4577, 3039, 6974, 947, 9347, 2370, 2783, 2152, 9049, 7605],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [9407, 3585, 9184, 3295, 5284, 8625, 659, 5531, 2393, 943, 7663],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [4991, 2985, 3088, 5707, 4235, 7095, 5526, 1641, 2936, 4426, 7719],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [367, 762, 90, 3517, 7640, 6121, 6564, 2586, 9734, 9800, 7774],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [3644, 9863, 4284, 8233, 2120, 4987, 1908, 7727, 8233, 7352, 7829],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [5765, 3172, 1284, 789, 4739, 1020, 8187, 5242, 6310, 7351, 7883],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [4666, 1957, 4130, 3615, 8196, 5852, 3737, 997, 5984, 52, 7937],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [3578, 8400, 1094, 2607, 113, 9303, 9868, 4012, 4045, 5697, 7989],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [9733, 9613, 7751, 8629, 9028, 7308, 9521, 8115, 1717, 4515, 8041],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [3062, 1495, 1095, 7598, 1204, 6902, 8298, 6455, 3456, 6723, 8092],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [3233, 4415, 6761, 384, 8409, 5426, 7145, 4719, 4978, 2528, 8143],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [339, 3391, 9973, 2857, 1286, 9507, 1937, 6458, 600, 2127, 8193],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [454, 1621, 2670, 7328, 8234, 5497, 6387, 7113, 9961, 5705, 8242],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [9965, 3281, 2754, 8726, 3593, 4000, 3716, 9697, 4184, 3443, 8291],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [9209, 1554, 3158, 4593, 665, 3985, 6442, 2606, 1540, 5509, 8339],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [1387, 1686, 7361, 3888, 9653, 3860, 3792, 7142, 2652, 2065, 8387],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [1657, 2401, 2943, 607, 7514, 5709, 4284, 7492, 5301, 3266, 8434],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [9798, 2629, 108, 3351, 3291, 7411, 9283, 8113, 8848, 9260, 8480],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [5924, 6048, 848, 8587, 5161, 2259, 6919, 1597, 8328, 189, 8527],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [8147, 6166, 3059, 102, 953, 7575, 7011, 3395, 8231, 6188, 8572],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [3798, 1037, 198, 774, 4266, 3717, 8870, 7534, 6012, 7387, 8617],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [1916, 2894, 7994, 5180, 23, 5932, 6594, 9027, 5340, 3910, 8662],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [1938, 3006, 6485, 2498, 1247, 7634, 8755, 3611, 9117, 5876, 8706],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [7968, 8740, 8850, 9899, 4109, 7687, 2677, 3274, 2283, 3401, 8750],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [7675, 1197, 8372, 768, 1585, 1842, 5516, 6358, 4431, 6593, 8793],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [8487, 3208, 5370, 8830, 6088, 8313, 623, 3612, 2240, 5559, 8836],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [3602, 6823, 7140, 5287, 9552, 9268, 842, 6007, 1742, 400, 8879],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [4254, 3705, 323, 8815, 420, 6752, 2015, 6347, 445, 1214, 8921],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [5000, 2333, 5894, 771, 4028, 9496, 4174, 4329, 9311, 8094, 8962],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [6264, 4632, 4228, 1816, 1413, 5572, 3412, 3701, 4609, 1133, 9004],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [5254, 6096, 9943, 6938, 4504, 1607, 8016, 274, 9651, 416, 9045],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [523, 2141, 251, 6363, 8781, 5605, 2944, 698, 6416, 6029, 9085],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [4353, 4508, 5635, 6008, 1812, 2787, 4551, 3933, 7077, 8052, 9125],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [6353, 6941, 558, 7083, 1370, 6092, 8662, 222, 5433, 6564, 9165],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [4446, 6538, 9389, 9780, 7602, 6790, 3690, 5888, 8251, 1640, 9205],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [4201, 4239, 5454, 2121, 4549, 557, 1027, 6482, 6537, 3354, 9244],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [6982, 3102, 9315, 8388, 2701, 2015, 7848, 5557, 6722, 1776, 9283],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [7205, 8564, 5908, 5671, 7282, 3298, 6006, 1576, 1786, 6975, 9321],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [2055, 8067, 5204, 1987, 1499, 9815, 330, 1157, 2314, 9016, 9359],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [2887, 4458, 6940, 507, 8215, 1795, 8653, 2973, 7495, 7963, 9397],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [8051, 7356, 379, 9657, 8687, 4105, 7146, 3066, 6063, 3879, 9435],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [6708, 5364, 8575, 161, 8892, 3253, 8929, 9095, 7185, 6823, 9472],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [2928, 402, 5930, 7769, 7748, 1632, 3900, 8150, 1305, 6854, 9509],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [4011, 5588, 9618, 937, 6880, 8517, 2742, 40, 936, 4027, 9546],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [9077, 617, 2742, 6799, 7294, 2001, 9415, 5567, 1412, 8397, 9582],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [4439, 306, 8560, 375, 3477, 3443, 3954, 7046, 1607, 17, 9619],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [8948, 6127, 6917, 3506, 7844, 9932, 5785, 6297, 4605, 8938, 9654],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [6595, 4548, 1715, 55, 1494, 1602, 3550, 3501, 8343, 5210, 9690],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [2474, 3702, 8666, 3057, 7156, 7894, 6813, 8559, 6218, 8882, 9725],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [3685, 3875, 5712, 4968, 2561, 1196, 1153, 5076, 7668, 0, 9761],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [3631, 4790, 9548, 5191, 5672, 9305, 9382, 5614, 8715, 8610, 9795],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [832, 9032, 7706, 3516, 8099, 8094, 97, 5585, 2491, 4757, 9830],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [9379, 941, 5617, 6183, 5292, 6644, 4059, 1880, 9732, 8482, 9864],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [5566, 2833, 299, 427, 2873, 7473, 3852, 1293, 9249, 9829, 9898],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [4175, 5685, 5045, 1392, 7930, 4360, 6651, 2686, 8379, 8838, 9932],
    },
    BigFloatInc {
        sign: 1,
        e: -32,
        n: 44,
        m: [9381, 7483, 8303, 6476, 4240, 4417, 6379, 5963, 3412, 5549, 9966],
    },
    BigFloatInc {
        sign: 1,
        e: -31,
        n: 44,
        m: [3491, 6551, 4657, 9194, 6350, 1007, 8924, 2778, 3361, 5888, 4641],
    },
    BigFloatInc {
        sign: 1,
        e: -31,
        n: 44,
        m: [9973, 7060, 4555, 2758, 4720, 1357, 1310, 5732, 7642, 354, 5848],
    },
    BigFloatInc {
        sign: 1,
        e: -31,
        n: 44,
        m: [1769, 3034, 793, 3993, 3246, 2659, 2188, 1695, 82, 3295, 6694],
    },
    BigFloatInc {
        sign: 1,
        e: -31,
        n: 44,
        m: [5162, 3834, 1444, 1596, 5667, 5964, 2115, 773, 9728, 629, 7368],
    },
    BigFloatInc {
        sign: 1,
        e: -31,
        n: 44,
        m: [4666, 1957, 4130, 3615, 8196, 5852, 3737, 997, 5984, 52, 7937],
    },
    BigFloatInc {
        sign: 1,
        e: -31,
        n: 44,
        m: [1657, 2401, 2943, 607, 7514, 5709, 4284, 7492, 5301, 3266, 8434],
    },
    BigFloatInc {
        sign: 1,
        e: -31,
        n: 44,
        m: [3602, 6823, 7140, 5287, 9552, 9268, 842, 6007, 1742, 400, 8879],
    },
    BigFloatInc {
        sign: 1,
        e: -31,
        n: 44,
        m: [6982, 3102, 9315, 8388, 2701, 2015, 7848, 5557, 6722, 1776, 9283],
    },
    BigFloatInc {
        sign: 1,
        e: -31,
        n: 44,
        m: [8948, 6127, 6917, 3506, 7844, 9932, 5785, 6297, 4605, 8938, 9654],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1000],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [7119, 1730, 161, 97, 5225, 1358, 1592, 6367, 1545, 2801, 1032],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [4351, 733, 6305, 1654, 2222, 4774, 660, 2611, 6918, 6585, 1062],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [9360, 9552, 9124, 5208, 912, 1913, 8451, 1105, 8306, 3928, 1091],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [9449, 692, 9022, 3277, 9662, 121, 7766, 1396, 4208, 6889, 1118],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [9069, 8915, 7700, 9396, 2211, 804, 8678, 3331, 4255, 7142, 1144],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [1994, 1412, 6911, 551, 4944, 271, 4262, 5146, 9528, 6070, 1169],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [5726, 6901, 622, 6018, 7218, 5552, 9430, 7336, 9192, 4831, 1193],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [5341, 3975, 6048, 5475, 8999, 7968, 369, 4680, 9911, 4403, 1216],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [9072, 1068, 7372, 909, 3583, 943, 8225, 170, 2963, 5623, 1238],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [2515, 570, 2835, 2782, 607, 6721, 1647, 4873, 4989, 9210, 1259],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [9526, 583, 9620, 6334, 533, 4641, 2552, 7494, 6498, 5791, 1280],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [8470, 6001, 9617, 7167, 1149, 1023, 9988, 1386, 4685, 5914, 1300],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [8794, 7576, 3872, 3, 9331, 9144, 3976, 5912, 2179, 61, 1320],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [8354, 6606, 6158, 2798, 8649, 6531, 437, 4339, 16, 8659, 1338],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [5539, 2402, 4460, 8397, 4734, 5904, 2857, 7453, 829, 2088, 1357],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [7322, 9372, 4664, 8247, 8938, 5182, 107, 4141, 6707, 688, 1375],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [4047, 2965, 3397, 2758, 2905, 2302, 6677, 3833, 5008, 4766, 1392],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [2296, 5734, 9708, 2656, 9633, 5108, 3841, 2978, 4641, 4597, 1409],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [1368, 1993, 9821, 2735, 3115, 3598, 7264, 2408, 4714, 431, 1426],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [8692, 8391, 958, 7801, 8310, 2163, 3823, 7408, 7030, 2495, 1442],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [2038, 2931, 3952, 7254, 2077, 7802, 6271, 6711, 3582, 997, 1458],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [9032, 8766, 2288, 4319, 9133, 1192, 6423, 6154, 9945, 6125, 1473],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [8, 9589, 6244, 5276, 681, 3315, 4495, 3827, 5295, 8055, 1488],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [2966, 389, 5802, 2899, 1351, 2746, 7741, 4974, 9620, 6945, 1503],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [7270, 7790, 3481, 2528, 4789, 1040, 2597, 7831, 8593, 2944, 1518],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [1881, 8717, 1836, 8659, 1056, 9725, 2131, 7106, 6478, 6188, 1532],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [7944, 2242, 5489, 1353, 4857, 2152, 4537, 2035, 7377, 6803, 1546],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [6498, 9731, 811, 2708, 8443, 2287, 7964, 7884, 5070, 4907, 1560],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [5691, 5282, 8541, 6409, 6675, 671, 5095, 1443, 1663, 609, 1574],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [4933, 391, 826, 2723, 5639, 5170, 4747, 8199, 5196, 4010, 1587],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [4681, 1823, 2169, 6236, 6291, 2274, 2738, 3155, 6388, 5206, 1600],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [4952, 2278, 4535, 4822, 2236, 5884, 7640, 4543, 4602, 4286, 1613],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [4898, 7932, 9120, 2945, 6494, 8900, 6954, 9168, 3167, 1333, 1626],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [2068, 6678, 5994, 2571, 4257, 5901, 6387, 1291, 4120, 6425, 1638],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [4423, 8423, 4247, 2045, 4976, 3730, 3419, 7313, 2444, 9636, 1650],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [5370, 4343, 8955, 3472, 6207, 3511, 7677, 765, 9884, 1034, 1663],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [6108, 4190, 8000, 6114, 7616, 1188, 809, 2234, 8360, 686, 1675],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [2331, 6480, 4588, 8121, 9502, 9141, 4856, 3498, 3060, 8653, 1686],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [7782, 3913, 2114, 2031, 5259, 8670, 6067, 1810, 5224, 4992, 1698],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [551, 9868, 6010, 5438, 8872, 5310, 9893, 6696, 4667, 9759, 1709],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [4522, 9171, 3876, 1812, 6646, 2539, 9147, 6315, 2072, 3006, 1721],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [8383, 8578, 1598, 7036, 4004, 9186, 5318, 1805, 1068, 4782, 1732],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [467, 6635, 9398, 3103, 701, 2270, 3063, 5128, 126, 5134, 1743],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [2992, 7118, 5366, 827, 2416, 407, 6393, 7719, 4292, 4106, 1754],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [3633, 2170, 4765, 4241, 6296, 9798, 5010, 3031, 6766, 1741, 1765],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [6720, 1364, 5428, 5057, 7910, 5853, 4168, 5201, 348, 8080, 1775],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [1015, 5136, 7569, 5858, 7472, 4690, 5699, 8056, 8770, 3159, 1786],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [8692, 2196, 6178, 4728, 8162, 7589, 6991, 3052, 7914, 7017, 1796],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [4854, 8797, 9527, 7837, 1888, 6303, 6127, 1189, 6932, 9688, 1806],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [2105, 2428, 6050, 3272, 1756, 9121, 6588, 2139, 9283, 1205, 1817],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [1555, 3648, 571, 6266, 5392, 6278, 5787, 3520, 3686, 1601, 1827],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [7532, 4440, 1606, 2372, 3659, 8011, 7206, 4227, 5001, 905, 1837],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [6309, 5034, 5541, 8627, 5814, 5020, 4145, 7833, 5044, 9147, 1846],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [5396, 620, 7863, 3677, 540, 6403, 5569, 5111, 3344, 6355, 1856],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [5627, 9350, 7053, 6782, 5303, 8257, 1214, 8624, 7840, 2555, 1866],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [2642, 3119, 8278, 200, 295, 7559, 4656, 6903, 5536, 7774, 1875],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [5105, 5902, 322, 8719, 4556, 5584, 578, 986, 3102, 2036, 1885],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [9342, 1072, 3715, 4032, 7778, 8650, 1785, 1819, 7437, 5364, 1894],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [3806, 4630, 3603, 9339, 2693, 8410, 2298, 3303, 6196, 7782, 1903],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [4390, 2862, 6028, 5487, 6839, 9911, 1011, 2389, 8277, 9311, 1912],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [8804, 748, 1975, 1426, 5279, 3820, 3554, 4671, 4277, 9973, 1921],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [5790, 5225, 3383, 8701, 5568, 1986, 5157, 1259, 6921, 9787, 1930],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [1074, 758, 2460, 2856, 4772, 7168, 804, 333, 1458, 8774, 1939],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [3715, 3960, 6852, 9004, 8121, 7872, 7566, 4657, 6037, 6951, 1948],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [8411, 2465, 3571, 2058, 8030, 1246, 7977, 4431, 2058, 4338, 1957],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [4166, 3806, 3541, 8703, 9619, 5618, 19, 3117, 4498, 951, 1966],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [5880, 3844, 5062, 8851, 9763, 6348, 8098, 2366, 2221, 6808, 1974],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [2484, 5345, 5726, 5006, 253, 8430, 7268, 774, 8268, 1924, 1983],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [7624, 3440, 9646, 6134, 6602, 606, 772, 9913, 128, 6317, 1991],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2000],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [2531, 9910, 9237, 9197, 7973, 4797, 5656, 6508, 5024, 2988, 2008],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [4902, 3366, 8946, 4914, 2864, 8907, 3977, 8104, 7521, 5296, 2016],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [4294, 8235, 6138, 2278, 9539, 8738, 738, 5457, 5200, 6938, 2024],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [6513, 7523, 221, 4306, 4079, 5348, 8575, 9706, 1362, 7927, 2032],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [6383, 2603, 2148, 6130, 806, 8289, 352, 8674, 5095, 8275, 2040],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [3500, 7292, 9737, 5943, 6494, 2165, 2351, 8266, 1451, 7996, 2048],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [8790, 4291, 925, 6534, 179, 5045, 3314, 5963, 1620, 7101, 2056],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [4238, 3461, 322, 194, 450, 2717, 3184, 2734, 3091, 5602, 2064],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [1564, 9540, 733, 4559, 6898, 3809, 9041, 9260, 9805, 3510, 2072],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [8053, 6337, 8538, 3578, 6824, 3005, 1145, 1904, 2305, 838, 2080],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [2858, 8071, 7496, 6598, 8400, 3352, 9505, 3448, 7866, 7594, 2087],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [7606, 1310, 8136, 1660, 5006, 9117, 5813, 3294, 634, 3791, 2095],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [3478, 8255, 3228, 7216, 244, 6560, 5198, 1420, 1746, 9437, 2102],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [9213, 1714, 1114, 9247, 2913, 6363, 8760, 149, 9449, 4542, 2110],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [8052, 3493, 5096, 1089, 6212, 4907, 5819, 7446, 9212, 9117, 2117],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [8702, 1466, 2610, 3309, 4444, 9548, 1320, 5222, 3836, 3171, 2125],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [2707, 6857, 9173, 6674, 9127, 6359, 8411, 5886, 3550, 6712, 2132],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [3754, 5960, 4837, 9870, 2002, 7040, 225, 159, 6113, 9749, 2139],
    },
    BigFloatInc {
        sign: 1,
        e: -30,
        n: 44,
        m: [2916, 3405, 6667, 2787, 1591, 6839, 1755, 8941, 6901, 2291, 2147],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1000],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [2515, 570, 2835, 2782, 607, 6721, 1647, 4873, 4989, 9210, 1259],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [8692, 8391, 958, 7801, 8310, 2163, 3823, 7408, 7030, 2495, 1442],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [4933, 391, 826, 2723, 5639, 5170, 4747, 8199, 5196, 4010, 1587],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [551, 9868, 6010, 5438, 8872, 5310, 9893, 6696, 4667, 9759, 1709],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [2105, 2428, 6050, 3272, 1756, 9121, 6588, 2139, 9283, 1205, 1817],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [4390, 2862, 6028, 5487, 6839, 9911, 1011, 2389, 8277, 9311, 1912],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2000],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [8053, 6337, 8538, 3578, 6824, 3005, 1145, 1904, 2305, 838, 2080],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [3449, 5259, 5049, 5193, 3566, 5929, 7217, 1883, 9003, 4346, 2154],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [6991, 6518, 5719, 7221, 3376, 6536, 5211, 9315, 9056, 9800, 2223],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [8138, 7831, 5401, 8793, 4423, 1608, 7356, 6663, 8510, 4284, 2289],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [8420, 6915, 1452, 9569, 6339, 1, 4895, 757, 8772, 3346, 2351],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [5813, 5354, 7289, 6032, 9667, 2836, 9861, 5229, 6417, 1422, 2410],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [4845, 2735, 8904, 1545, 1323, 9161, 1014, 470, 7433, 2120, 2466],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [5029, 1140, 5670, 5564, 1214, 3442, 3295, 9746, 9978, 8420, 2519],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [9016, 6427, 2611, 7397, 7208, 5318, 3554, 8235, 9065, 2815, 2571],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [4276, 239, 9627, 4419, 1280, 4166, 6071, 8896, 9420, 7413, 2620],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [8786, 5095, 3033, 9708, 7371, 3962, 8673, 1944, 4872, 4016, 2668],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [1078, 4805, 8920, 6794, 9469, 1808, 5715, 4906, 1659, 4176, 2714],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [7121, 2252, 2158, 3585, 1108, 6579, 6694, 1120, 7638, 9241, 2758],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [7982, 7585, 9401, 6658, 7385, 6567, 1206, 5387, 3065, 393, 2802],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [1652, 2764, 5185, 9586, 9400, 9543, 4776, 1565, 7985, 8669, 2843],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [7385, 6783, 1917, 5602, 6621, 4327, 7646, 4816, 4061, 4991, 2884],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [4986, 8530, 2277, 1379, 7360, 678, 655, 2866, 3821, 177, 2924],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [3574, 7566, 3853, 3418, 2189, 7306, 5086, 7370, 6840, 4960, 2962],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3000],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [4540, 5581, 6963, 5056, 9578, 2080, 5194, 5662, 7187, 5889, 3036],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [7832, 5502, 9748, 1055, 7982, 1263, 2933, 5847, 2568, 3168, 3072],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [9068, 2854, 8636, 5223, 2427, 7766, 8668, 3858, 595, 2325, 3107],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [8597, 6350, 4992, 4627, 5896, 9307, 44, 1393, 5239, 3806, 3141],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [9866, 782, 1652, 5446, 1278, 341, 9495, 6398, 393, 8021, 3174],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [8517, 1361, 2011, 7195, 5171, 5251, 4875, 5826, 2999, 5343, 3207],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [3790, 378, 2970, 2720, 9924, 7146, 3840, 7483, 127, 6118, 3239],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [9031, 4098, 3134, 3925, 6902, 2480, 7282, 8589, 1018, 663, 3271],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [8846, 6846, 8495, 4090, 9952, 7460, 6838, 4626, 4889, 9272, 3301],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [6167, 4409, 1900, 1851, 505, 9545, 2600, 5953, 5164, 2218, 3332],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [5790, 7406, 6344, 8105, 8566, 4055, 3148, 8963, 679, 9754, 3361],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [8361, 3262, 9673, 9945, 725, 5467, 7619, 4166, 4301, 2114, 3391],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [1102, 9736, 2021, 877, 7745, 621, 9787, 3393, 9335, 9518, 3419],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [9929, 7169, 8961, 2607, 3864, 9742, 3840, 2730, 4038, 2172, 3448],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [8385, 4004, 3743, 45, 5219, 3986, 7867, 6449, 4488, 266, 3476],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [7568, 7248, 2973, 1891, 3758, 1433, 1706, 6724, 6038, 3980, 3503],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [7266, 4340, 9530, 8482, 2592, 9597, 21, 6063, 3532, 3483, 3530],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [869, 4978, 1158, 2389, 4622, 615, 8060, 62, 449, 8933, 3556],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [8206, 2154, 6627, 5806, 3674, 8696, 4853, 5946, 7101, 478, 3583],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [5517, 4905, 9261, 9588, 7295, 5251, 6892, 8694, 8013, 8260, 3608],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [4209, 4856, 2100, 6545, 3512, 8242, 3177, 4279, 8566, 2411, 3634],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [1037, 3487, 826, 1194, 3310, 3807, 5172, 2971, 1002, 3057, 3659],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [2581, 1917, 722, 5798, 2833, 7982, 6057, 386, 9864, 314, 3684],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [8858, 555, 3742, 8887, 3519, 3881, 4726, 6189, 6926, 4297, 3708],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [1254, 8701, 4107, 3565, 607, 6515, 2429, 7248, 5681, 5111, 3732],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [6791, 9094, 1951, 593, 9632, 1210, 66, 1072, 5422, 2857, 3756],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [7544, 1710, 8505, 8346, 1821, 163, 4943, 4619, 4968, 7631, 3779],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [7156, 7288, 1519, 8487, 5473, 4673, 6185, 1391, 6076, 9524, 3802],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [8781, 5724, 2056, 975, 3679, 9823, 2023, 4778, 6554, 8623, 3825],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [4055, 7128, 2531, 5250, 259, 229, 687, 6805, 3127, 5011, 3848],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [3405, 991, 174, 3448, 4226, 1331, 7472, 7796, 4062, 8766, 3870],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [7896, 3992, 8924, 1497, 4757, 6148, 5464, 3260, 1587, 9964, 3892],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [6822, 4931, 7142, 4116, 6060, 2493, 5954, 8863, 4116, 8676, 3914],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [5559, 8638, 4785, 321, 1373, 2885, 1958, 2173, 8310, 4971, 3936],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [2496, 6173, 2610, 194, 8479, 3614, 4789, 405, 968, 8916, 3957],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [2720, 8484, 6557, 7487, 7987, 6452, 8596, 6391, 789, 572, 3979],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4000],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [9866, 9806, 8875, 4314, 4514, 8654, 9760, 9057, 5858, 7257, 4020],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [3098, 3372, 6211, 6342, 74, 199, 2708, 2190, 2062, 2400, 4041],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [585, 6419, 2596, 7992, 1585, 8206, 7890, 5679, 44, 5481, 4061],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [2766, 5207, 4296, 2260, 1613, 6578, 705, 7348, 191, 6551, 4081],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [1058, 7650, 7480, 1418, 4982, 4718, 5218, 2347, 2970, 5659, 4101],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [5227, 810, 1335, 3664, 9117, 7748, 8193, 8556, 9980, 2852, 4121],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [3508, 8159, 7183, 3255, 8809, 451, 2500, 2853, 4942, 8177, 4140],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [6107, 2675, 7077, 7157, 3648, 6011, 2290, 3808, 4610, 1676, 4160],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [9944, 8013, 6776, 9087, 6348, 5637, 8920, 1231, 9638, 3391, 4179],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [679, 95, 2015, 6652, 8592, 5329, 7221, 8407, 5380, 3364, 4198],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [5828, 6200, 6471, 303, 8757, 2854, 2142, 8746, 2650, 1633, 4217],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [6104, 6987, 192, 2179, 2424, 9815, 1638, 4893, 8425, 8235, 4235],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [4079, 2960, 1670, 1244, 8662, 7336, 7760, 5005, 6511, 3208, 4254],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [7089, 8916, 9085, 2424, 8529, 8772, 8249, 7916, 8169, 6586, 4272],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [1977, 755, 7094, 4542, 4233, 2831, 1116, 6207, 2702, 8404, 4290],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [6899, 518, 99, 387, 7133, 1858, 4435, 3767, 8006, 8693, 4308],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [6078, 5175, 2876, 3403, 4932, 6491, 1469, 2225, 1092, 7487, 4326],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [6042, 7193, 7592, 545, 546, 2235, 9017, 8611, 8576, 4814, 4344],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [4932, 692, 4781, 6759, 9476, 1397, 5647, 4837, 7145, 706, 4362],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [25, 9980, 7571, 3724, 3531, 1980, 2657, 7889, 3988, 5191, 4379],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [8838, 598, 4186, 5384, 792, 921, 2758, 8179, 7215, 8296, 4396],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [2765, 2305, 5132, 6533, 1438, 5164, 7724, 2103, 6244, 49, 4414],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [6489, 8924, 8745, 9886, 3155, 2945, 1592, 3634, 2169, 476, 4431],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [3982, 3037, 1439, 4443, 6753, 3072, 423, 8631, 8113, 9601, 4447],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [9792, 5067, 6949, 742, 8481, 3396, 6334, 4537, 9558, 7450, 4464],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [7500, 1166, 7947, 385, 2014, 4748, 7087, 7164, 4655, 4047, 4481],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [4506, 9683, 5732, 3073, 794, 9156, 7963, 5414, 4527, 9414, 4497],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [5552, 1457, 8714, 6645, 2702, 4506, 3794, 4001, 3547, 3574, 4514],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [792, 6062, 8706, 4405, 7700, 3927, 7770, 3492, 9608, 6548, 4530],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [6097, 6350, 8471, 3212, 1541, 192, 8938, 6343, 4377, 8359, 4546],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [2176, 7254, 2817, 3004, 5906, 6393, 7275, 6966, 3538, 9026, 4562],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [6277, 5663, 803, 7587, 8847, 3216, 4712, 3327, 7021, 8569, 4578],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [9755, 9120, 898, 4223, 6464, 9429, 8060, 7039, 9220, 7008, 4594],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [3756, 2498, 7493, 9406, 6097, 7469, 5696, 8446, 9205, 4362, 4610],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [1938, 4622, 8409, 7912, 2369, 9236, 7930, 2741, 918, 650, 4626],
    },
    BigFloatInc {
        sign: 1,
        e: -29,
        n: 44,
        m: [4217, 4514, 2339, 8450, 564, 2901, 6304, 3835, 780, 95, 4657],
    },
];
