/*
Copyright 2018 The CDI Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1beta1

import (
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/listers"
	"k8s.io/client-go/tools/cache"
	v1beta1 "kubevirt.io/containerized-data-importer-api/pkg/apis/core/v1beta1"
)

// VolumeUploadSourceLister helps list VolumeUploadSources.
// All objects returned here must be treated as read-only.
type VolumeUploadSourceLister interface {
	// List lists all VolumeUploadSources in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1beta1.VolumeUploadSource, err error)
	// VolumeUploadSources returns an object that can list and get VolumeUploadSources.
	VolumeUploadSources(namespace string) VolumeUploadSourceNamespaceLister
	VolumeUploadSourceListerExpansion
}

// volumeUploadSourceLister implements the VolumeUploadSourceLister interface.
type volumeUploadSourceLister struct {
	listers.ResourceIndexer[*v1beta1.VolumeUploadSource]
}

// NewVolumeUploadSourceLister returns a new VolumeUploadSourceLister.
func NewVolumeUploadSourceLister(indexer cache.Indexer) VolumeUploadSourceLister {
	return &volumeUploadSourceLister{listers.New[*v1beta1.VolumeUploadSource](indexer, v1beta1.Resource("volumeuploadsource"))}
}

// VolumeUploadSources returns an object that can list and get VolumeUploadSources.
func (s *volumeUploadSourceLister) VolumeUploadSources(namespace string) VolumeUploadSourceNamespaceLister {
	return volumeUploadSourceNamespaceLister{listers.NewNamespaced[*v1beta1.VolumeUploadSource](s.ResourceIndexer, namespace)}
}

// VolumeUploadSourceNamespaceLister helps list and get VolumeUploadSources.
// All objects returned here must be treated as read-only.
type VolumeUploadSourceNamespaceLister interface {
	// List lists all VolumeUploadSources in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1beta1.VolumeUploadSource, err error)
	// Get retrieves the VolumeUploadSource from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1beta1.VolumeUploadSource, error)
	VolumeUploadSourceNamespaceListerExpansion
}

// volumeUploadSourceNamespaceLister implements the VolumeUploadSourceNamespaceLister
// interface.
type volumeUploadSourceNamespaceLister struct {
	listers.ResourceIndexer[*v1beta1.VolumeUploadSource]
}
