/*
Copyright 2018 The CDI Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1beta1

import (
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/listers"
	"k8s.io/client-go/tools/cache"
	v1beta1 "kubevirt.io/containerized-data-importer-api/pkg/apis/core/v1beta1"
)

// VolumeCloneSourceLister helps list VolumeCloneSources.
// All objects returned here must be treated as read-only.
type VolumeCloneSourceLister interface {
	// List lists all VolumeCloneSources in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1beta1.VolumeCloneSource, err error)
	// VolumeCloneSources returns an object that can list and get VolumeCloneSources.
	VolumeCloneSources(namespace string) VolumeCloneSourceNamespaceLister
	VolumeCloneSourceListerExpansion
}

// volumeCloneSourceLister implements the VolumeCloneSourceLister interface.
type volumeCloneSourceLister struct {
	listers.ResourceIndexer[*v1beta1.VolumeCloneSource]
}

// NewVolumeCloneSourceLister returns a new VolumeCloneSourceLister.
func NewVolumeCloneSourceLister(indexer cache.Indexer) VolumeCloneSourceLister {
	return &volumeCloneSourceLister{listers.New[*v1beta1.VolumeCloneSource](indexer, v1beta1.Resource("volumeclonesource"))}
}

// VolumeCloneSources returns an object that can list and get VolumeCloneSources.
func (s *volumeCloneSourceLister) VolumeCloneSources(namespace string) VolumeCloneSourceNamespaceLister {
	return volumeCloneSourceNamespaceLister{listers.NewNamespaced[*v1beta1.VolumeCloneSource](s.ResourceIndexer, namespace)}
}

// VolumeCloneSourceNamespaceLister helps list and get VolumeCloneSources.
// All objects returned here must be treated as read-only.
type VolumeCloneSourceNamespaceLister interface {
	// List lists all VolumeCloneSources in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1beta1.VolumeCloneSource, err error)
	// Get retrieves the VolumeCloneSource from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1beta1.VolumeCloneSource, error)
	VolumeCloneSourceNamespaceListerExpansion
}

// volumeCloneSourceNamespaceLister implements the VolumeCloneSourceNamespaceLister
// interface.
type volumeCloneSourceNamespaceLister struct {
	listers.ResourceIndexer[*v1beta1.VolumeCloneSource]
}
