/*
Copyright 2018 The CDI Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1beta1

import (
	"context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
	v1beta1 "kubevirt.io/containerized-data-importer-api/pkg/apis/core/v1beta1"
	scheme "kubevirt.io/containerized-data-importer/pkg/client/clientset/versioned/scheme"
)

// ObjectTransfersGetter has a method to return a ObjectTransferInterface.
// A group's client should implement this interface.
type ObjectTransfersGetter interface {
	ObjectTransfers() ObjectTransferInterface
}

// ObjectTransferInterface has methods to work with ObjectTransfer resources.
type ObjectTransferInterface interface {
	Create(ctx context.Context, objectTransfer *v1beta1.ObjectTransfer, opts v1.CreateOptions) (*v1beta1.ObjectTransfer, error)
	Update(ctx context.Context, objectTransfer *v1beta1.ObjectTransfer, opts v1.UpdateOptions) (*v1beta1.ObjectTransfer, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, objectTransfer *v1beta1.ObjectTransfer, opts v1.UpdateOptions) (*v1beta1.ObjectTransfer, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1beta1.ObjectTransfer, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1beta1.ObjectTransferList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.ObjectTransfer, err error)
	ObjectTransferExpansion
}

// objectTransfers implements ObjectTransferInterface
type objectTransfers struct {
	*gentype.ClientWithList[*v1beta1.ObjectTransfer, *v1beta1.ObjectTransferList]
}

// newObjectTransfers returns a ObjectTransfers
func newObjectTransfers(c *CdiV1beta1Client) *objectTransfers {
	return &objectTransfers{
		gentype.NewClientWithList[*v1beta1.ObjectTransfer, *v1beta1.ObjectTransferList](
			"objecttransfers",
			c.RESTClient(),
			scheme.ParameterCodec,
			"",
			func() *v1beta1.ObjectTransfer { return &v1beta1.ObjectTransfer{} },
			func() *v1beta1.ObjectTransferList { return &v1beta1.ObjectTransferList{} }),
	}
}
