# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AccessControlRulesMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This property allows you to specify whether the access control rules are in Audit mode, in
    Enforce mode or Disabled. Possible values are: 'Audit', 'Enforce' or 'Disabled'.
    """

    AUDIT = "Audit"
    ENFORCE = "Enforce"
    DISABLED = "Disabled"


class AggregatedReplicationState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This is the aggregated replication status based on all the regional replication status flags."""

    UNKNOWN = "Unknown"
    IN_PROGRESS = "InProgress"
    COMPLETED = "Completed"
    FAILED = "Failed"


class Architecture(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The architecture of the image. Applicable to OS disks only."""

    X64 = "x64"
    ARM64 = "Arm64"


class ConfidentialVMEncryptionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """confidential VM encryption types."""

    ENCRYPTED_VM_GUEST_STATE_ONLY_WITH_PMK = "EncryptedVMGuestStateOnlyWithPmk"
    ENCRYPTED_WITH_PMK = "EncryptedWithPmk"
    ENCRYPTED_WITH_CMK = "EncryptedWithCmk"
    NON_PERSISTED_TPM = "NonPersistedTPM"


class EdgeZoneStorageAccountType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the storage account type to be used to store the image. This property is not
    updatable.
    """

    STANDARD_LRS = "Standard_LRS"
    STANDARD_ZRS = "Standard_ZRS"
    STANDARD_SSD_LRS = "StandardSSD_LRS"
    PREMIUM_LRS = "Premium_LRS"


class EndpointAccess(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This property allows you to specify if the requests will be allowed to access the host
    endpoints. Possible values are: 'Allow', 'Deny'.
    """

    ALLOW = "Allow"
    DENY = "Deny"


class EndpointTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This property allows you to specify the Endpoint type for which this profile is defining the
    access control for. Possible values are: 'WireServer' or 'IMDS'.
    """

    WIRE_SERVER = "WireServer"
    IMDS = "IMDS"


class ExtendedLocationTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of extendedLocation."""

    EDGE_ZONE = "EdgeZone"


class GalleryApplicationCustomActionParameterType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the type of the custom action parameter. Possible values are: String,
    ConfigurationDataBlob or LogOutputBlob.
    """

    STRING = "String"
    CONFIGURATION_DATA_BLOB = "ConfigurationDataBlob"
    LOG_OUTPUT_BLOB = "LogOutputBlob"


class GalleryApplicationScriptRebootBehavior(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Optional. The action to be taken with regards to install/update/remove of the gallery
    application in the event of a reboot.
    """

    NONE = "None"
    RERUN = "Rerun"


class GalleryExpandParams(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """GalleryExpandParams."""

    SHARING_PROFILE_GROUPS = "SharingProfile/Groups"


class GalleryExtendedLocationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """It is type of the extended location."""

    EDGE_ZONE = "EdgeZone"
    UNKNOWN = "Unknown"


class GalleryProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state, which only appears in the response."""

    CREATING = "Creating"
    UPDATING = "Updating"
    FAILED = "Failed"
    SUCCEEDED = "Succeeded"
    DELETING = "Deleting"
    MIGRATING = "Migrating"


class GallerySharingPermissionTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This property allows you to specify the permission of sharing gallery. Possible values are:
    **Private,** **Groups,** **Community.**.
    """

    PRIVATE = "Private"
    GROUPS = "Groups"
    COMMUNITY = "Community"


class HostCaching(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The host caching of the disk. Valid values are 'None', 'ReadOnly', and 'ReadWrite'."""

    NONE = "None"
    READ_ONLY = "ReadOnly"
    READ_WRITE = "ReadWrite"


class HyperVGeneration(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The hypervisor generation of the Virtual Machine. Applicable to OS disks only."""

    V1 = "V1"
    V2 = "V2"


class OperatingSystemStateTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This property allows the user to specify whether the virtual machines created under this image
    are 'Generalized' or 'Specialized'.
    """

    GENERALIZED = "Generalized"
    SPECIALIZED = "Specialized"


class OperatingSystemTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This property allows you to specify the supported type of the OS that application is built for.
    Possible values are: **Windows,** **Linux.**.
    """

    WINDOWS = "Windows"
    LINUX = "Linux"


class PolicyViolationCategory(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Describes the nature of the policy violation."""

    OTHER = "Other"
    IMAGE_FLAGGED_UNSAFE = "ImageFlaggedUnsafe"
    COPYRIGHT_VALIDATION = "CopyrightValidation"
    IP_THEFT = "IpTheft"


class ReplicationMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Optional parameter which specifies the mode to be used for replication. This property is not
    updatable.
    """

    FULL = "Full"
    SHALLOW = "Shallow"


class ReplicationState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This is the regional replication state."""

    UNKNOWN = "Unknown"
    REPLICATING = "Replicating"
    COMPLETED = "Completed"
    FAILED = "Failed"


class ReplicationStatusTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ReplicationStatusTypes."""

    REPLICATION_STATUS = "ReplicationStatus"
    UEFI_SETTINGS = "UefiSettings"


class ResourceIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity used for the gallery. The type 'SystemAssigned, UserAssigned' includes
    both an implicitly created identity and a set of user assigned identities. The type 'None' will
    remove all identities from the gallery.
    """

    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned, UserAssigned"
    NONE = "None"


class SelectPermissions(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """SelectPermissions."""

    PERMISSIONS = "Permissions"


class SharedGalleryHostCaching(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The host caching of the disk. Valid values are 'None', 'ReadOnly', and 'ReadWrite'."""

    NONE = "None"
    READ_ONLY = "ReadOnly"
    READ_WRITE = "ReadWrite"


class SharedToValues(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """SharedToValues."""

    TENANT = "tenant"


class SharingProfileGroupTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This property allows you to specify the type of sharing group. Possible values are:
    **Subscriptions,** **AADTenants.**.
    """

    SUBSCRIPTIONS = "Subscriptions"
    AAD_TENANTS = "AADTenants"


class SharingState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The sharing state of the gallery, which only appears in the response."""

    SUCCEEDED = "Succeeded"
    IN_PROGRESS = "InProgress"
    FAILED = "Failed"
    UNKNOWN = "Unknown"


class SharingUpdateOperationTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This property allows you to specify the operation type of gallery sharing update. Possible
    values are: **Add,** **Remove,** **Reset.**.
    """

    ADD = "Add"
    REMOVE = "Remove"
    RESET = "Reset"
    ENABLE_COMMUNITY = "EnableCommunity"


class SoftDeletedArtifactTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """artifact type of the soft-deleted resource."""

    IMAGES = "Images"


class StorageAccountType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the storage account type to be used to store the image. This property is not
    updatable.
    """

    STANDARD_LRS = "Standard_LRS"
    STANDARD_ZRS = "Standard_ZRS"
    PREMIUM_LRS = "Premium_LRS"
    PREMIUM_V2_LRS = "PremiumV2_LRS"


class UefiKeyType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of key signature."""

    SHA256 = "sha256"
    X509 = "x509"


class UefiSignatureTemplateName(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The name of the signature template that contains default UEFI keys."""

    NO_SIGNATURE_TEMPLATE = "NoSignatureTemplate"
    MICROSOFT_UEFI_CERTIFICATE_AUTHORITY_TEMPLATE = "MicrosoftUefiCertificateAuthorityTemplate"
    MICROSOFT_WINDOWS_TEMPLATE = "MicrosoftWindowsTemplate"


class ValidationStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """This property specifies the status of the validationProfile of the image version."""

    UNKNOWN = "Unknown"
    FAILED = "Failed"
    SUCCEEDED = "Succeeded"
