/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1beta1

import (
	v1beta1 "k8s.io/sample-apiserver/pkg/apis/wardle/v1beta1"
)

// FlunderSpecApplyConfiguration represents an declarative configuration of the FlunderSpec type for use
// with apply.
type FlunderSpecApplyConfiguration struct {
	FlunderReference *string                `json:"flunderReference,omitempty"`
	FischerReference *string                `json:"fischerReference,omitempty"`
	ReferenceType    *v1beta1.ReferenceType `json:"referenceType,omitempty"`
}

// FlunderSpecApplyConfiguration constructs an declarative configuration of the FlunderSpec type for use with
// apply.
func FlunderSpec() *FlunderSpecApplyConfiguration {
	return &FlunderSpecApplyConfiguration{}
}

// WithFlunderReference sets the FlunderReference field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the FlunderReference field is set to the value of the last call.
func (b *FlunderSpecApplyConfiguration) WithFlunderReference(value string) *FlunderSpecApplyConfiguration {
	b.FlunderReference = &value
	return b
}

// WithFischerReference sets the FischerReference field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the FischerReference field is set to the value of the last call.
func (b *FlunderSpecApplyConfiguration) WithFischerReference(value string) *FlunderSpecApplyConfiguration {
	b.FischerReference = &value
	return b
}

// WithReferenceType sets the ReferenceType field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ReferenceType field is set to the value of the last call.
func (b *FlunderSpecApplyConfiguration) WithReferenceType(value v1beta1.ReferenceType) *FlunderSpecApplyConfiguration {
	b.ReferenceType = &value
	return b
}
