/**********************************************************************
 * $timescale_info example -- C source code using ACC PLI routines
 *
 * C source to print the timescale information of a specific module
 * instance.
 *
 * For the book, "The Verilog PLI Handbook" by Stuart Sutherland
 *  Book copyright 1999, Kluwer Academic Publishers, Norwell, MA, USA
 *   Contact: www.wkap.il
 *  Example copyright 1998, Sutherland HDL Inc, Portland, Oregon, USA
 *   Contact: www.sutherland.com or (503) 692-0898
 *
 * Usage: $timescale_info(<module_instance>);
 *
 * Routine definitions for a veriusertfs array:
 *  /* routine prototypes -/
 *   extern int PLIbook_TimeInfo_checktf(),
 *              PLIbook_TimeInfo_calltf();
 *  /* table entries -/
 *   {usertask,                       /* type of PLI routine -/
 *     0,                             /* user_data value -/
 *     PLIbook_TimeInfo_checktf,      /* checktf routine -/
 *     0,                             /* sizetf routine -/
 *     PLIbook_TimeInfo_calltf,       /* calltf routine -/
 *     0,                             /* misctf routine -/
 *     "$timescale_info",             /* system task/function name -/
 *     1                              /* forward reference = true -/
 *   },
 *********************************************************************/

#include "veriuser.h"         /* IEEE 1364 PLI TF  routine library */
#include "acc_user.h"         /* IEEE 1364 PLI ACC routine library */
/**********************************************************************
 * checktf routine
 *********************************************************************/
int PLIbook_TimeInfo_checktf()
{
  acc_initialize();
  if (tf_nump() != 1)
    tf_error("$timescale_info must have 1 argument.");
  else if (tf_typep(1) == TF_NULLPARAM)
    tf_error("$time_info arg cannot be null.");
  else if (acc_fetch_type(acc_handle_tfarg(1)) != accModule)
    tf_error("$timescale_info arg must be a module instance.");
  acc_close();
  return(0);
}

/**********************************************************************
 * calltf routine
 *********************************************************************/
int PLIbook_TimeInfo_calltf()
{
  handle module_h, tfinst_h;
  s_timescale_info ts_info;

  acc_initialize();
  
  module_h = acc_handle_tfarg(1);
  tfinst_h = acc_handle_tfinst();

  acc_fetch_timescale_info(module_h, &ts_info);
  io_printf("\nModule %s: time_units = %d  time_precision = %d\n",
            acc_fetch_fullname(module_h),
            ts_info.unit, ts_info.precision);

  acc_fetch_timescale_info(tfinst_h, &ts_info);
  io_printf("\nSystem task: time_units = %d  time_precision = %d\n",
            ts_info.unit, ts_info.precision);

  acc_fetch_timescale_info(null, &ts_info);
  io_printf("\n$timeformat time_units = %d  time_precision = %d\n\n",
            ts_info.unit, ts_info.precision);

  acc_close();
  return(0);
}
/*********************************************************************/

