# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, Optional, TYPE_CHECKING

from azure.core.pipeline.transport import AsyncHttpResponse, HttpRequest
from azure.mgmt.core import AsyncARMPipelineClient
from msrest import Deserializer, Serializer

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials_async import AsyncTokenCredential

from ._configuration import PeeringManagementClientConfiguration
from .operations import PeeringManagementClientOperationsMixin
from .operations import LegacyPeeringsOperations
from .operations import Operations
from .operations import PeerAsnsOperations
from .operations import PeeringLocationsOperations
from .operations import PeeringsOperations
from .operations import PeeringServiceLocationsOperations
from .operations import PeeringServicePrefixesOperations
from .operations import PrefixesOperations
from .operations import PeeringServiceProvidersOperations
from .operations import PeeringServicesOperations
from .. import models


class PeeringManagementClient(PeeringManagementClientOperationsMixin):
    """Peering Client.

    :ivar legacy_peerings: LegacyPeeringsOperations operations
    :vartype legacy_peerings: azure.mgmt.peering.aio.operations.LegacyPeeringsOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.peering.aio.operations.Operations
    :ivar peer_asns: PeerAsnsOperations operations
    :vartype peer_asns: azure.mgmt.peering.aio.operations.PeerAsnsOperations
    :ivar peering_locations: PeeringLocationsOperations operations
    :vartype peering_locations: azure.mgmt.peering.aio.operations.PeeringLocationsOperations
    :ivar peerings: PeeringsOperations operations
    :vartype peerings: azure.mgmt.peering.aio.operations.PeeringsOperations
    :ivar peering_service_locations: PeeringServiceLocationsOperations operations
    :vartype peering_service_locations: azure.mgmt.peering.aio.operations.PeeringServiceLocationsOperations
    :ivar peering_service_prefixes: PeeringServicePrefixesOperations operations
    :vartype peering_service_prefixes: azure.mgmt.peering.aio.operations.PeeringServicePrefixesOperations
    :ivar prefixes: PrefixesOperations operations
    :vartype prefixes: azure.mgmt.peering.aio.operations.PrefixesOperations
    :ivar peering_service_providers: PeeringServiceProvidersOperations operations
    :vartype peering_service_providers: azure.mgmt.peering.aio.operations.PeeringServiceProvidersOperations
    :ivar peering_services: PeeringServicesOperations operations
    :vartype peering_services: azure.mgmt.peering.aio.operations.PeeringServicesOperations
    :param credential: Credential needed for the client to connect to Azure.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :param subscription_id: The Azure subscription ID.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
        self,
        credential: "AsyncTokenCredential",
        subscription_id: str,
        base_url: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        if not base_url:
            base_url = 'https://management.azure.com'
        self._config = PeeringManagementClientConfiguration(credential, subscription_id, **kwargs)
        self._client = AsyncARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._serialize.client_side_validation = False
        self._deserialize = Deserializer(client_models)

        self.legacy_peerings = LegacyPeeringsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.operations = Operations(
            self._client, self._config, self._serialize, self._deserialize)
        self.peer_asns = PeerAsnsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.peering_locations = PeeringLocationsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.peerings = PeeringsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.peering_service_locations = PeeringServiceLocationsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.peering_service_prefixes = PeeringServicePrefixesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.prefixes = PrefixesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.peering_service_providers = PeeringServiceProvidersOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.peering_services = PeeringServicesOperations(
            self._client, self._config, self._serialize, self._deserialize)

    async def _send_request(self, http_request: HttpRequest, **kwargs: Any) -> AsyncHttpResponse:
        """Runs the network request through the client's chained policies.

        :param http_request: The network request you want to make. Required.
        :type http_request: ~azure.core.pipeline.transport.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to True.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.pipeline.transport.AsyncHttpResponse
        """
        path_format_arguments = {
            'subscriptionId': self._serialize.url("self._config.subscription_id", self._config.subscription_id, 'str'),
        }
        http_request.url = self._client.format_url(http_request.url, **path_format_arguments)
        stream = kwargs.pop("stream", True)
        pipeline_response = await self._client._pipeline.run(http_request, stream=stream, **kwargs)
        return pipeline_response.http_response

    async def close(self) -> None:
        await self._client.close()

    async def __aenter__(self) -> "PeeringManagementClient":
        await self._client.__aenter__()
        return self

    async def __aexit__(self, *exc_details) -> None:
        await self._client.__aexit__(*exc_details)
