# Copyright 2018, OpenCensus Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import unittest

from opencensus.stats import execution_context


class TestExecutionContext(unittest.TestCase):

    def tearDown(self):
        execution_context.clear()

    def test_get_and_set(self):
        execution_context.clear()
        execution_context.get_measure_to_view_map()
        self.assertEqual({}, execution_context.get_measure_to_view_map())

        measure_to_view_map = {'key1', 'val1'}
        execution_context.set_measure_to_view_map(measure_to_view_map)

        execution_context.get_measure_to_view_map()
        self.assertEqual(measure_to_view_map,
                         execution_context.get_measure_to_view_map())
