/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.telnet;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import org.apache.commons.net.telnet.TelnetClient;
import org.apache.commons.net.telnet.TelnetOption;

final class TelnetInputStream
extends BufferedInputStream
implements Runnable {
    static final int _STATE_DATA = 0;
    static final int _STATE_IAC = 1;
    static final int _STATE_WILL = 2;
    static final int _STATE_WONT = 3;
    static final int _STATE_DO = 4;
    static final int _STATE_DONT = 5;
    static final int _STATE_SB = 6;
    static final int _STATE_SE = 7;
    static final int _STATE_CR = 8;
    private boolean __hasReachedEOF;
    private boolean __isClosed;
    private boolean __readIsWaiting;
    private int __receiveState;
    private int __queueHead;
    private int __queueTail;
    private int __bytesAvailable;
    private int[] __queue;
    private TelnetClient __client;
    private Thread __thread;
    private IOException __ioException;

    TelnetInputStream(InputStream input, TelnetClient client) {
        super(input);
        this.__client = client;
        this.__receiveState = 0;
        this.__isClosed = true;
        this.__hasReachedEOF = false;
        this.__queue = new int[2049];
        this.__queueHead = 0;
        this.__queueTail = 0;
        this.__bytesAvailable = 0;
        this.__ioException = null;
        this.__readIsWaiting = false;
        this.__thread = new Thread(this);
    }

    void _start() {
        this.__isClosed = false;
        int priority = Thread.currentThread().getPriority() + 1;
        if (priority > 10) {
            priority = 10;
        }
        this.__thread.setPriority(priority);
        this.__thread.setDaemon(true);
        this.__thread.start();
    }

    private int __read() throws IOException {
        int ch;
        block31: while (true) {
            if ((ch = super.read()) < 0) {
                return -1;
            }
            ch &= 0xFF;
            switch (this.__receiveState) {
                case 8: {
                    if (ch == 0) continue block31;
                }
                case 0: {
                    TelnetClient telnetClient;
                    if (ch == 255) {
                        this.__receiveState = 1;
                        continue block31;
                    }
                    if (ch == 13) {
                        telnetClient = this.__client;
                        synchronized (telnetClient) {
                            this.__receiveState = this.__client._requestedDont(TelnetOption.BINARY) ? 8 : 0;
                            break block31;
                        }
                    }
                    this.__receiveState = 0;
                    break block31;
                }
                case 1: {
                    switch (ch) {
                        case 251: {
                            this.__receiveState = 2;
                            continue block31;
                        }
                        case 252: {
                            this.__receiveState = 3;
                            continue block31;
                        }
                        case 253: {
                            this.__receiveState = 4;
                            continue block31;
                        }
                        case 254: {
                            this.__receiveState = 5;
                            continue block31;
                        }
                        case 255: {
                            this.__receiveState = 0;
                            break;
                        }
                    }
                    this.__receiveState = 0;
                    continue block31;
                }
                case 2: {
                    TelnetClient telnetClient = this.__client;
                    synchronized (telnetClient) {
                        this.__client._processWill(ch);
                        this.__client._flushOutputStream();
                    }
                    this.__receiveState = 0;
                    continue block31;
                }
                case 3: {
                    TelnetClient telnetClient = this.__client;
                    synchronized (telnetClient) {
                        this.__client._processWont(ch);
                        this.__client._flushOutputStream();
                    }
                    this.__receiveState = 0;
                    continue block31;
                }
                case 4: {
                    TelnetClient telnetClient = this.__client;
                    synchronized (telnetClient) {
                        this.__client._processDo(ch);
                        this.__client._flushOutputStream();
                    }
                    this.__receiveState = 0;
                    continue block31;
                }
                case 5: {
                    TelnetClient telnetClient = this.__client;
                    synchronized (telnetClient) {
                        this.__client._processDont(ch);
                        this.__client._flushOutputStream();
                    }
                    this.__receiveState = 0;
                    continue block31;
                }
            }
            break;
        }
        return ch;
    }

    public int read() throws IOException {
        int[] nArray = this.__queue;
        synchronized (nArray) {
            while (true) {
                if (this.__ioException != null) {
                    IOException e = this.__ioException;
                    this.__ioException = null;
                    throw e;
                }
                if (this.__bytesAvailable != 0) break;
                if (this.__hasReachedEOF) {
                    int e = -1;
                    return e;
                }
                this.__queue.notify();
                try {
                    this.__readIsWaiting = true;
                    this.__queue.wait();
                    this.__readIsWaiting = false;
                }
                catch (InterruptedException e) {
                    throw new IOException("Fatal thread interruption during read.");
                }
            }
            int ch = this.__queue[this.__queueHead];
            if (++this.__queueHead >= this.__queue.length) {
                this.__queueHead = 0;
            }
            --this.__bytesAvailable;
            int n = ch;
            return n;
        }
    }

    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (length < 1) {
            return 0;
        }
        int[] nArray = this.__queue;
        synchronized (nArray) {
            if (length > this.__bytesAvailable) {
                length = this.__bytesAvailable;
            }
        }
        int ch = this.read();
        if (ch == -1) {
            return -1;
        }
        int off = offset;
        do {
            buffer[offset++] = (byte)ch;
        } while (--length > 0 && (ch = this.read()) != -1);
        return offset - off;
    }

    public boolean markSupported() {
        return false;
    }

    public int available() throws IOException {
        int[] nArray = this.__queue;
        synchronized (nArray) {
            int n = this.__bytesAvailable;
            return n;
        }
    }

    public void close() throws IOException {
        super.close();
        int[] nArray = this.__queue;
        synchronized (nArray) {
            this.__hasReachedEOF = true;
            this.__isClosed = true;
            if (this.__thread.isAlive()) {
                this.__thread.interrupt();
            }
            this.__queue.notifyAll();
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block22: {
            try {
                block16: while (!this.__isClosed) {
                    block21: {
                        try {
                            ch = this.__read();
                            if (ch >= 0) break block21;
                            break;
                        }
                        catch (InterruptedIOException e) {
                            var3_5 = this.__queue;
                            synchronized (var3_5) {
                                block23: {
                                    this.__ioException = e;
                                    this.__queue.notifyAll();
                                    try {
                                        this.__queue.wait(100L);
                                    }
                                    catch (InterruptedException interrupted) {
                                        if (!this.__isClosed) break block23;
                                        break;
                                    }
                                }
                                continue;
                            }
                        }
                    }
                    e = this.__queue;
                    synchronized (e) {
                        while (true) {
                            if (this.__bytesAvailable < this.__queue.length - 1) {
                                if (this.__readIsWaiting) {
                                    this.__queue.notify();
                                }
                                this.__queue[this.__queueTail] = ch;
                                ++this.__bytesAvailable;
                                if (++this.__queueTail >= this.__queue.length) {
                                    this.__queueTail = 0;
                                }
                                continue block16;
                            }
                            this.__queue.notify();
                            try {
                                this.__queue.wait();
                                continue;
                            }
                            catch (InterruptedException e) {
                                if (this.__isClosed) ** break;
                                continue;
                                break block22;
                            }
                            break;
                        }
                    }
                }
            }
            catch (IOException e) {
                var3_7 = this.__queue;
                synchronized (var3_7) {
                    this.__ioException = e;
                }
            }
        }
        var2_2 = this.__queue;
        synchronized (var2_2) {
            this.__isClosed = true;
            this.__hasReachedEOF = true;
            this.__queue.notify();
            return;
        }
    }
}

