/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.Button;
import com.meterware.httpunit.CheckboxFormControl;
import com.meterware.httpunit.FileSubmitFormControl;
import com.meterware.httpunit.FormParameter;
import com.meterware.httpunit.HTMLElementBase;
import com.meterware.httpunit.HTMLElementScriptable;
import com.meterware.httpunit.HiddenFieldFormControl;
import com.meterware.httpunit.MissingParameterValueException;
import com.meterware.httpunit.NodeUtils;
import com.meterware.httpunit.ParameterProcessor;
import com.meterware.httpunit.RadioButtonFormControl;
import com.meterware.httpunit.ResetButton;
import com.meterware.httpunit.SelectionFormControl;
import com.meterware.httpunit.SubmitButton;
import com.meterware.httpunit.TextAreaFormControl;
import com.meterware.httpunit.TextFieldFormControl;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.scripting.Input;
import com.meterware.httpunit.scripting.ScriptableDelegate;
import java.io.IOException;
import java.util.List;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

abstract class FormControl
extends HTMLElementBase {
    static final String[] NO_VALUE = new String[0];
    private String _valueAttribute;
    private final boolean _readOnly;
    private final boolean _disabled;
    private final String _onChangeEvent;
    private final String _onClickEvent;
    private final WebForm _form;

    static ScriptableDelegate newSelectionOption() {
        return new SelectionFormControl.Option();
    }

    FormControl(WebForm form) {
        super(FormControl.newEmptyNode(form));
        this._form = form;
        this._valueAttribute = "";
        this._readOnly = false;
        this._disabled = false;
        this._onChangeEvent = "";
        this._onClickEvent = "";
    }

    private static Node newEmptyNode(WebForm form) {
        return form.getNode().getOwnerDocument().createElement("httpunit-supplied");
    }

    FormControl(WebForm form, Node node) {
        super(node);
        this._form = form;
        this._valueAttribute = NodeUtils.getNodeAttribute(node, "value");
        this._readOnly = NodeUtils.isNodeAttributePresent(node, "readonly");
        this._disabled = NodeUtils.isNodeAttributePresent(node, "disabled");
        this._onChangeEvent = NodeUtils.getNodeAttribute(node, "onchange");
        this._onClickEvent = NodeUtils.getNodeAttribute(node, "onclick");
    }

    abstract String[] getValues();

    Object getDelegate() {
        return this.getScriptableDelegate();
    }

    protected final WebForm getForm() {
        return this._form;
    }

    protected ScriptableDelegate getParentDelegate() {
        return this.getForm().getScriptableDelegate();
    }

    public String[] getOptionValues() {
        return NO_VALUE;
    }

    String[] getDisplayedOptions() {
        return NO_VALUE;
    }

    boolean isReadOnly() {
        return this._readOnly || this._disabled;
    }

    boolean isHidden() {
        return false;
    }

    boolean isDisabled() {
        return this._disabled;
    }

    boolean isTextControl() {
        return false;
    }

    boolean isExclusive() {
        return false;
    }

    boolean isMultiValued() {
        return false;
    }

    boolean isFileParameter() {
        return false;
    }

    abstract void addValues(ParameterProcessor var1, String var2) throws IOException;

    void claimRequiredValues(List values) {
    }

    void claimValue(List values) {
    }

    void claimUniqueValue(List values) {
    }

    void claimUploadSpecification(List files) {
    }

    void reset() {
    }

    public void toggle() {
        throw new FormParameter.IllegalCheckboxParameterException(this.getName(), "toggleCheckbox");
    }

    public void setState(boolean state) {
        throw new FormParameter.IllegalCheckboxParameterException(this.getName(), "setCheckbox");
    }

    protected void sendOnChangeEvent() {
        if (this._onChangeEvent.length() > 0) {
            this.getScriptableDelegate().doEvent(this._onChangeEvent);
        }
    }

    protected void sendOnClickEvent() {
        if (this._onClickEvent.length() > 0) {
            this.getScriptableDelegate().doEvent(this._onClickEvent);
        }
    }

    protected ScriptableDelegate newScriptable() {
        return new Scriptable();
    }

    protected String getValueAttribute() {
        return this._valueAttribute;
    }

    protected final void claimValueIsRequired(List values, String value) {
        if (!values.contains(value)) {
            throw new MissingParameterValueException(this.getName(), value, values.toArray(new String[values.size()]));
        }
        values.remove(value);
    }

    static String[] getControlElementTags() {
        return new String[]{"textarea", "select", "button", "input"};
    }

    static FormControl newFormParameter(WebForm form, Node node) {
        if (node.getNodeType() != 1) {
            return null;
        }
        if (node.getNodeName().equalsIgnoreCase("textarea")) {
            return new TextAreaFormControl(form, node);
        }
        if (node.getNodeName().equalsIgnoreCase("select")) {
            return new SelectionFormControl(form, node);
        }
        if (node.getNodeName().equalsIgnoreCase("button")) {
            String type = NodeUtils.getNodeAttribute(node, "type", "submit");
            if (type.equalsIgnoreCase("submit")) {
                return new SubmitButton(form, node);
            }
            if (type.equalsIgnoreCase("reset")) {
                return new ResetButton(form, node);
            }
            return new Button(form, node);
        }
        if (!node.getNodeName().equalsIgnoreCase("input")) {
            return null;
        }
        String type = NodeUtils.getNodeAttribute(node, "type", "text");
        if (type.equalsIgnoreCase("text") || type.equalsIgnoreCase("password")) {
            return new TextFieldFormControl(form, node);
        }
        if (type.equalsIgnoreCase("hidden")) {
            return new HiddenFieldFormControl(form, node);
        }
        if (type.equalsIgnoreCase("radio")) {
            return new RadioButtonFormControl(form, node);
        }
        if (type.equalsIgnoreCase("checkbox")) {
            return new CheckboxFormControl(form, node);
        }
        if (type.equalsIgnoreCase("submit") || type.equalsIgnoreCase("image")) {
            return new SubmitButton(form, node);
        }
        if (type.equalsIgnoreCase("button")) {
            return new Button(form, node);
        }
        if (type.equalsIgnoreCase("reset")) {
            return new ResetButton(form, node);
        }
        if (type.equalsIgnoreCase("file")) {
            return new FileSubmitFormControl(form, node);
        }
        return new TextFieldFormControl(form, node);
    }

    class Scriptable
    extends HTMLElementScriptable
    implements Input {
        public String getName() {
            return FormControl.this.getName();
        }

        public String getID() {
            return FormControl.this.getID();
        }

        public Scriptable() {
            super(FormControl.this);
        }

        public Object get(String propertyName) {
            if (propertyName.equalsIgnoreCase("name")) {
                return FormControl.this.getName();
            }
            return super.get(propertyName);
        }

        public void set(String propertyName, Object value) {
            if (propertyName.equalsIgnoreCase("value")) {
                FormControl.this._valueAttribute = value.toString();
            } else {
                super.set(propertyName, value);
            }
        }

        public void click() throws IOException, SAXException {
        }
    }
}

