/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.filters;

import com.sun.jimi.core.filters.ImageFilterPlus;
import com.sun.jimi.core.filters.RGBBlockFilter;
import java.awt.image.ImageProducer;

public class Gamma
extends RGBBlockFilter {
    private double rValue;
    private double gValue;
    private double bValue;
    private int[] rTable;
    private int[] gTable;
    private int[] bTable;
    private boolean initialized = false;

    public Gamma(ImageProducer imageProducer, double d) {
        this(imageProducer, d, d, d);
    }

    public Gamma(ImageProducer imageProducer, double d, double d2, double d3) {
        super(imageProducer);
        this.rValue = d;
        this.gValue = d2;
        this.bValue = d3;
    }

    private int[] buildTable(double d) {
        int[] nArray = new int[256];
        double d2 = 1.0 / d;
        int n = 0;
        while (n < 256) {
            int n2 = (int)(255.0 * Math.pow((double)n / 255.0, d2) + 0.5);
            if (n2 > 255) {
                n2 = 255;
            }
            nArray[n] = n2;
            ++n;
        }
        return nArray;
    }

    public int[][] filterRGBBlock(int n, int n2, int n3, int n4, int[][] nArray) {
        this.initialize();
        int n5 = 0;
        while (n5 < n4) {
            int n6 = 0;
            while (n6 < n3) {
                int n7 = nArray[n5][n6];
                int n8 = n7 >> 24 & 0xFF;
                int n9 = n7 >> 16 & 0xFF;
                int n10 = n7 >> 8 & 0xFF;
                int n11 = n7 & 0xFF;
                n9 = this.rTable[n9];
                n10 = this.gTable[n10];
                n11 = this.bTable[n11];
                nArray[n5][n6] = n8 << 24 | n9 << 16 | n10 << 8 | n11;
                ++n6;
            }
            ++n5;
        }
        return nArray;
    }

    private void initialize() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.rTable = this.buildTable(this.rValue);
        this.gTable = this.gValue == this.rValue ? this.rTable : this.buildTable(this.gValue);
        this.bTable = this.bValue == this.rValue ? this.rTable : (this.bValue == this.gValue ? this.gTable : this.buildTable(this.bValue));
    }

    public static void main(String[] stringArray) {
        Gamma gamma = null;
        if (stringArray.length == 1) {
            gamma = new Gamma(null, Double.valueOf(stringArray[0]));
        } else if (stringArray.length == 3) {
            gamma = new Gamma(null, Double.valueOf(stringArray[0]), Double.valueOf(stringArray[1]), Double.valueOf(stringArray[2]));
        } else {
            Gamma.usage();
        }
        System.exit(ImageFilterPlus.filterStream(System.in, System.out, gamma));
    }

    private static void usage() {
        System.err.println("usage: Gamma <value>");
        System.err.println("or:    Gamma <rValue> <gValue> <bValue>");
        System.exit(1);
    }
}

