/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.Modality;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.SealedClassInheritorsProvider;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.DescriptorKindFilter;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.ResolutionScope;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;

public final class CliSealedClassInheritorsProvider
extends SealedClassInheritorsProvider {
    @NotNull
    public static final CliSealedClassInheritorsProvider INSTANCE = new CliSealedClassInheritorsProvider();

    private CliSealedClassInheritorsProvider() {
    }

    @NotNull
    public Collection<ClassDescriptor> computeSealedSubclasses(@NotNull ClassDescriptor sealedClass, boolean allowSealedInheritorsInDifferentFilesOfSamePackage) {
        DeclarationDescriptor container;
        DeclarationDescriptor declarationDescriptor;
        Intrinsics.checkNotNullParameter(sealedClass, "sealedClass");
        if (sealedClass.getModality() != Modality.SEALED) {
            return CollectionsKt.emptyList();
        }
        boolean bl = false;
        LinkedHashSet<ClassDescriptor> result2 = new LinkedHashSet<ClassDescriptor>();
        if (!allowSealedInheritorsInDifferentFilesOfSamePackage) {
            declarationDescriptor = sealedClass.getContainingDeclaration();
        } else {
            DeclarationDescriptor declarationDescriptor2;
            block5: {
                Sequence<DeclarationDescriptor> $this$firstOrNull$iv = DescriptorUtilsKt.getParents(sealedClass);
                boolean $i$f$firstOrNull = false;
                Iterator<DeclarationDescriptor> iterator2 = $this$firstOrNull$iv.iterator();
                while (iterator2.hasNext()) {
                    DeclarationDescriptor element$iv;
                    DeclarationDescriptor it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    if (!(it instanceof PackageFragmentDescriptor)) continue;
                    declarationDescriptor2 = element$iv;
                    break block5;
                }
                declarationDescriptor2 = null;
            }
            declarationDescriptor = container = (DeclarationDescriptor)declarationDescriptor2;
        }
        if (container instanceof PackageFragmentDescriptor) {
            CliSealedClassInheritorsProvider.computeSealedSubclasses$collectSubclasses(sealedClass, result2, ((PackageFragmentDescriptor)container).getMemberScope(), allowSealedInheritorsInDifferentFilesOfSamePackage);
        }
        MemberScope memberScope2 = sealedClass.getUnsubstitutedInnerClassesScope();
        Intrinsics.checkNotNullExpressionValue(memberScope2, "sealedClass.unsubstitutedInnerClassesScope");
        CliSealedClassInheritorsProvider.computeSealedSubclasses$collectSubclasses(sealedClass, result2, memberScope2, true);
        return result2;
    }

    private static final void computeSealedSubclasses$collectSubclasses(ClassDescriptor $sealedClass, LinkedHashSet<ClassDescriptor> $result, MemberScope scope2, boolean collectNested) {
        for (DeclarationDescriptor descriptor2 : ResolutionScope.DefaultImpls.getContributedDescriptors$default(scope2, DescriptorKindFilter.CLASSIFIERS, null, 2, null)) {
            if (!(descriptor2 instanceof ClassDescriptor)) continue;
            if (DescriptorUtils.isDirectSubclass((ClassDescriptor)descriptor2, $sealedClass)) {
                $result.add((ClassDescriptor)descriptor2);
            }
            if (!collectNested) continue;
            MemberScope memberScope2 = ((ClassDescriptor)descriptor2).getUnsubstitutedInnerClassesScope();
            Intrinsics.checkNotNullExpressionValue(memberScope2, "descriptor.unsubstitutedInnerClassesScope");
            CliSealedClassInheritorsProvider.computeSealedSubclasses$collectSubclasses($sealedClass, $result, memberScope2, collectNested);
        }
    }
}

