/*
 * Copyright 2010-2016 Amazon.com, Inc. or its affiliates. All Rights
 * Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *  http://aws.amazon.com/apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

package com.amazonaws.services.waf.model;

import java.io.Serializable;
import com.amazonaws.AmazonWebServiceRequest;

/**
 * <p>
 * A request to create an <a>XssMatchSet</a>.
 * </p>
 */
public class CreateXssMatchSetRequest extends AmazonWebServiceRequest implements
        Serializable, Cloneable {

    /**
     * <p>
     * A friendly name or description for the <a>XssMatchSet</a> that you're
     * creating. You can't change <code>Name</code> after you create the
     * <code>XssMatchSet</code>.
     * </p>
     */
    private String name;
    /**
     * <p>
     * The value returned by the most recent call to <a>GetChangeToken</a>.
     * </p>
     */
    private String changeToken;

    /**
     * <p>
     * A friendly name or description for the <a>XssMatchSet</a> that you're
     * creating. You can't change <code>Name</code> after you create the
     * <code>XssMatchSet</code>.
     * </p>
     * 
     * @param name
     *        A friendly name or description for the <a>XssMatchSet</a> that
     *        you're creating. You can't change <code>Name</code> after you
     *        create the <code>XssMatchSet</code>.
     */

    public void setName(String name) {
        this.name = name;
    }

    /**
     * <p>
     * A friendly name or description for the <a>XssMatchSet</a> that you're
     * creating. You can't change <code>Name</code> after you create the
     * <code>XssMatchSet</code>.
     * </p>
     * 
     * @return A friendly name or description for the <a>XssMatchSet</a> that
     *         you're creating. You can't change <code>Name</code> after you
     *         create the <code>XssMatchSet</code>.
     */

    public String getName() {
        return this.name;
    }

    /**
     * <p>
     * A friendly name or description for the <a>XssMatchSet</a> that you're
     * creating. You can't change <code>Name</code> after you create the
     * <code>XssMatchSet</code>.
     * </p>
     * 
     * @param name
     *        A friendly name or description for the <a>XssMatchSet</a> that
     *        you're creating. You can't change <code>Name</code> after you
     *        create the <code>XssMatchSet</code>.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */

    public CreateXssMatchSetRequest withName(String name) {
        setName(name);
        return this;
    }

    /**
     * <p>
     * The value returned by the most recent call to <a>GetChangeToken</a>.
     * </p>
     * 
     * @param changeToken
     *        The value returned by the most recent call to
     *        <a>GetChangeToken</a>.
     */

    public void setChangeToken(String changeToken) {
        this.changeToken = changeToken;
    }

    /**
     * <p>
     * The value returned by the most recent call to <a>GetChangeToken</a>.
     * </p>
     * 
     * @return The value returned by the most recent call to
     *         <a>GetChangeToken</a>.
     */

    public String getChangeToken() {
        return this.changeToken;
    }

    /**
     * <p>
     * The value returned by the most recent call to <a>GetChangeToken</a>.
     * </p>
     * 
     * @param changeToken
     *        The value returned by the most recent call to
     *        <a>GetChangeToken</a>.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */

    public CreateXssMatchSetRequest withChangeToken(String changeToken) {
        setChangeToken(changeToken);
        return this;
    }

    /**
     * Returns a string representation of this object; useful for testing and
     * debugging.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getName() != null)
            sb.append("Name: " + getName() + ",");
        if (getChangeToken() != null)
            sb.append("ChangeToken: " + getChangeToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CreateXssMatchSetRequest == false)
            return false;
        CreateXssMatchSetRequest other = (CreateXssMatchSetRequest) obj;
        if (other.getName() == null ^ this.getName() == null)
            return false;
        if (other.getName() != null
                && other.getName().equals(this.getName()) == false)
            return false;
        if (other.getChangeToken() == null ^ this.getChangeToken() == null)
            return false;
        if (other.getChangeToken() != null
                && other.getChangeToken().equals(this.getChangeToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode
                + ((getName() == null) ? 0 : getName().hashCode());
        hashCode = prime
                * hashCode
                + ((getChangeToken() == null) ? 0 : getChangeToken().hashCode());
        return hashCode;
    }

    @Override
    public CreateXssMatchSetRequest clone() {
        return (CreateXssMatchSetRequest) super.clone();
    }
}