/* parser.c generated by valac, the Vala compiler
 * generated from parser.vala, do not modify */

/* parser.vala
 *
 * Copyright (C) 2008-2009 Florian Brosch, Didier Villevalois
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Didier 'Ptitjes Villevalois <ptitjes@free.fr>
 */

#include <glib.h>
#include <glib-object.h>
#include "valadoc.h"
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <gobject/gvaluecollector.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ValadocParamSpecParser ValadocParamSpecParser;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValadocParserPrivate {
	ValadocSettings* _settings;
	ValadocScanner* _scanner;
	ValadocErrorReporter* _reporter;
	ValadocRule* _root_rule;
	gchar* _filename;
	gint _first_line;
	gint _first_column;
	ValadocToken* _current_token;
	ValaArrayList* rule_stack;
	ValaArrayList* rule_state_stack;
};

struct _ValadocParamSpecParser {
	GParamSpec parent_instance;
};


static gpointer valadoc_parser_parent_class = NULL;
static ValadocParserCallbackIface * valadoc_parser_valadoc_parser_callback_parent_iface = NULL;

#define VALADOC_PARSER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALADOC_TYPE_PARSER, ValadocParserPrivate))
G_GNUC_INTERNAL void valadoc_token_type_init_token_types (void);
static ValadocRule* valadoc_parser_peek_rule (ValadocParser* self, gint offset);
static ValadocRule* valadoc_parser_pop_rule (ValadocParser* self);
static void valadoc_parser_real_push_rule (ValadocParserCallback* base, ValadocRule* rule);
static GObject* valadoc_parser_peek_state (ValadocParser* self, gint offset);
static GObject* valadoc_parser_real_get_rule_state (ValadocParserCallback* base);
static void valadoc_parser_real_set_rule_state (ValadocParserCallback* base, GObject* state);
static void valadoc_parser_real_reduce (ValadocParserCallback* base);
static gboolean valadoc_parser_real_would_parent_accept_token (ValadocParserCallback* base, ValadocToken* token);
static gboolean valadoc_parser_real_would_parent_reduce_to_rule (ValadocParserCallback* base, ValadocToken* token, ValadocRule* rule);
static void valadoc_parser_real_warning (ValadocParserCallback* base, ValadocToken* token, const gchar* message);
static gint valadoc_parser_get_line (ValadocParser* self, ValadocToken* token);
static gint valadoc_parser_get_start_column (ValadocParser* self, ValadocToken* token);
static gint valadoc_parser_get_end_column (ValadocParser* self, ValadocToken* token);
static void valadoc_parser_real_error (ValadocParserCallback* base, ValadocToken* token, const gchar* message, GError** error);
static void valadoc_parser_finalize (ValadocParser * obj);


GQuark valadoc_parser_error_quark (void) {
	return g_quark_from_static_string ("valadoc_parser_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


ValadocParser* valadoc_parser_construct (GType object_type, ValadocSettings* settings, ValadocScanner* scanner, ValadocErrorReporter* reporter) {
	ValadocParser* self = NULL;
	ValadocSettings* _tmp0_;
	ValadocSettings* _tmp1_;
	ValadocScanner* _tmp2_;
	ValadocScanner* _tmp3_;
	ValadocErrorReporter* _tmp4_;
	ValadocErrorReporter* _tmp5_;
	g_return_val_if_fail (settings != NULL, NULL);
	g_return_val_if_fail (scanner != NULL, NULL);
	g_return_val_if_fail (reporter != NULL, NULL);
	self = (ValadocParser*) g_type_create_instance (object_type);
	_tmp0_ = settings;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_settings);
	self->priv->_settings = _tmp1_;
	_tmp2_ = scanner;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->_scanner);
	self->priv->_scanner = _tmp3_;
	_tmp4_ = reporter;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->priv->_reporter);
	self->priv->_reporter = _tmp5_;
	valadoc_token_type_init_token_types ();
	return self;
}


ValadocParser* valadoc_parser_new (ValadocSettings* settings, ValadocScanner* scanner, ValadocErrorReporter* reporter) {
	return valadoc_parser_construct (VALADOC_TYPE_PARSER, settings, scanner, reporter);
}


void valadoc_parser_set_root_rule (ValadocParser* self, ValadocRule* root_rule) {
	ValadocRule* _tmp0_;
	ValadocRule* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (root_rule != NULL);
	_tmp0_ = root_rule;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_root_rule);
	self->priv->_root_rule = _tmp1_;
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


void valadoc_parser_parse (ValadocParser* self, const gchar* content, const gchar* filename, gint first_line, gint first_column, GError** error) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	ValaArrayList* _tmp4_;
	ValaArrayList* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content != NULL);
	g_return_if_fail (filename != NULL);
	_tmp0_ = filename;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_filename);
	self->priv->_filename = _tmp1_;
	_tmp2_ = first_line;
	self->priv->_first_line = _tmp2_;
	_tmp3_ = first_column;
	self->priv->_first_column = _tmp3_;
	_tmp4_ = self->priv->rule_stack;
	vala_collection_clear ((ValaCollection*) _tmp4_);
	_tmp5_ = self->priv->rule_state_stack;
	vala_collection_clear ((ValaCollection*) _tmp5_);
	{
		ValadocRule* _tmp6_;
		ValadocScanner* _tmp7_;
		ValadocScanner* _tmp8_;
		const gchar* _tmp9_;
		ValadocScanner* _tmp10_;
		ValaArrayList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		_tmp6_ = self->priv->_root_rule;
		valadoc_parser_callback_push_rule ((ValadocParserCallback*) self, _tmp6_);
		_tmp7_ = self->priv->_scanner;
		valadoc_scanner_reset (_tmp7_);
		_tmp8_ = self->priv->_scanner;
		_tmp9_ = content;
		valadoc_scanner_scan (_tmp8_, _tmp9_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
				goto __catch21_valadoc_parser_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp10_ = self->priv->_scanner;
		valadoc_scanner_end (_tmp10_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
				goto __catch21_valadoc_parser_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp11_ = self->priv->rule_stack;
		_tmp12_ = vala_collection_get_size ((ValaCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		if (_tmp13_ != 0) {
			valadoc_parser_callback_error ((ValadocParserCallback*) self, NULL, "Rule stack is not empty!", &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
					goto __catch21_valadoc_parser_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	goto __finally21;
	__catch21_valadoc_parser_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		GError* _tmp15_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _g_error_copy0 (_tmp14_);
		_inner_error_ = _tmp15_;
		_g_error_free0 (e);
		goto __finally21;
	}
	__finally21:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


void valadoc_parser_accept_token (ValadocParser* self, ValadocToken* token, GError** error) {
	ValadocToken* _tmp0_;
	ValadocToken* _tmp1_;
	gint rule_depth = 0;
	ValaArrayList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	ValadocRuleForward forward = 0;
	ValadocRule* rule = NULL;
	ValadocRule* _tmp5_;
	ValadocRule* _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (token != NULL);
	_tmp0_ = token;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_current_token);
	self->priv->_current_token = _tmp1_;
	_tmp2_ = self->priv->rule_stack;
	_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
	_tmp4_ = _tmp3_;
	rule_depth = _tmp4_;
	forward = VALADOC_RULE_FORWARD_NONE;
	_tmp5_ = valadoc_parser_peek_rule (self, -1);
	rule = _tmp5_;
	_tmp6_ = rule;
	if (_tmp6_ == NULL) {
		GError* _tmp7_;
		_tmp7_ = g_error_new_literal (VALADOC_PARSER_ERROR, VALADOC_PARSER_ERROR_INTERNAL_ERROR, "Rule stack is empty!");
		_inner_error_ = _tmp7_;
		if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (rule);
			return;
		} else {
			_g_object_unref0 (rule);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	while (TRUE) {
		ValadocRule* _tmp8_;
		gboolean _tmp9_ = FALSE;
		ValadocRule* _tmp10_;
		ValadocToken* _tmp11_;
		ValadocRuleForward _tmp12_;
		gboolean _tmp13_;
		gboolean _tmp14_ = FALSE;
		gint _tmp15_;
		ValaArrayList* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		ValadocRule* _tmp22_;
		ValadocRuleForward _tmp23_ = 0;
		gint _tmp24_;
		ValaArrayList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		ValaArrayList* _tmp28_;
		gint _tmp29_;
		gint _tmp30_;
		_tmp8_ = rule;
		if (!(_tmp8_ != NULL)) {
			break;
		}
		_tmp10_ = rule;
		_tmp11_ = token;
		_tmp12_ = forward;
		_tmp13_ = valadoc_rule_accept_token (_tmp10_, _tmp11_, (ValadocParserCallback*) self, _tmp12_, &_inner_error_);
		_tmp9_ = _tmp13_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (rule);
				return;
			} else {
				_g_object_unref0 (rule);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (_tmp9_) {
			break;
		}
		_tmp15_ = rule_depth;
		_tmp16_ = self->priv->rule_stack;
		_tmp17_ = vala_collection_get_size ((ValaCollection*) _tmp16_);
		_tmp18_ = _tmp17_;
		if (_tmp15_ != _tmp18_) {
			ValadocRule* _tmp19_;
			ValadocRule* _tmp20_;
			ValadocRule* _tmp21_;
			_tmp19_ = valadoc_parser_peek_rule (self, -1);
			_tmp20_ = _tmp19_;
			_tmp21_ = rule;
			_tmp14_ = _tmp20_ == _tmp21_;
			_g_object_unref0 (_tmp20_);
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			valadoc_parser_callback_error ((ValadocParserCallback*) self, NULL, "Parser state error", &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (rule);
					return;
				} else {
					_g_object_unref0 (rule);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			break;
		}
		_tmp22_ = valadoc_parser_peek_rule (self, -1);
		_g_object_unref0 (rule);
		rule = _tmp22_;
		_tmp24_ = rule_depth;
		_tmp25_ = self->priv->rule_stack;
		_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		if (_tmp24_ > _tmp27_) {
			_tmp23_ = VALADOC_RULE_FORWARD_CHILD;
		} else {
			_tmp23_ = VALADOC_RULE_FORWARD_PARENT;
		}
		forward = _tmp23_;
		_tmp28_ = self->priv->rule_stack;
		_tmp29_ = vala_collection_get_size ((ValaCollection*) _tmp28_);
		_tmp30_ = _tmp29_;
		rule_depth = _tmp30_;
	}
	_g_object_unref0 (rule);
}


static ValadocRule* valadoc_parser_peek_rule (ValadocParser* self, gint offset) {
	ValadocRule* result = NULL;
	gint _tmp0_;
	ValaArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	ValaArrayList* _tmp5_;
	ValaArrayList* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gpointer _tmp10_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = offset;
	_vala_assert (_tmp0_ < 0, "offset < 0");
	_tmp1_ = self->priv->rule_stack;
	_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = offset;
	if ((_tmp3_ + _tmp4_) < 0) {
		result = NULL;
		return result;
	}
	_tmp5_ = self->priv->rule_stack;
	_tmp6_ = self->priv->rule_stack;
	_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = offset;
	_tmp10_ = vala_list_get ((ValaList*) _tmp5_, _tmp8_ + _tmp9_);
	result = (ValadocRule*) _tmp10_;
	return result;
}


static ValadocRule* valadoc_parser_pop_rule (ValadocParser* self) {
	ValadocRule* result = NULL;
	gint last_index = 0;
	ValaArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	ValadocRule* rule = NULL;
	ValaArrayList* _tmp3_;
	gpointer _tmp4_;
	ValaArrayList* _tmp5_;
	gpointer _tmp6_;
	ValadocRule* _tmp7_;
	ValaArrayList* _tmp8_;
	gpointer _tmp9_;
	GObject* _tmp10_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->rule_stack;
	_tmp1_ = vala_collection_get_size ((ValaCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	last_index = _tmp2_ - 1;
	_tmp3_ = self->priv->rule_stack;
	_tmp4_ = vala_list_get ((ValaList*) _tmp3_, last_index);
	rule = (ValadocRule*) _tmp4_;
	_tmp5_ = self->priv->rule_stack;
	_tmp6_ = vala_list_remove_at ((ValaList*) _tmp5_, last_index);
	_tmp7_ = (ValadocRule*) _tmp6_;
	_g_object_unref0 (_tmp7_);
	_tmp8_ = self->priv->rule_state_stack;
	_tmp9_ = vala_list_remove_at ((ValaList*) _tmp8_, last_index);
	_tmp10_ = (GObject*) _tmp9_;
	_g_object_unref0 (_tmp10_);
	result = rule;
	return result;
}


static void valadoc_parser_real_push_rule (ValadocParserCallback* base, ValadocRule* rule) {
	ValadocParser * self;
	ValaArrayList* _tmp0_;
	ValadocRule* _tmp1_;
	ValaArrayList* _tmp2_;
	self = (ValadocParser*) base;
	g_return_if_fail (rule != NULL);
	_tmp0_ = self->priv->rule_stack;
	_tmp1_ = rule;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp2_ = self->priv->rule_state_stack;
	vala_collection_add ((ValaCollection*) _tmp2_, NULL);
}


static GObject* valadoc_parser_peek_state (ValadocParser* self, gint offset) {
	GObject* result = NULL;
	gint _tmp0_;
	ValaArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	ValaArrayList* _tmp5_;
	ValaArrayList* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gpointer _tmp10_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = offset;
	_vala_assert (_tmp0_ < 0, "offset < 0");
	_tmp1_ = self->priv->rule_state_stack;
	_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = offset;
	if ((_tmp3_ + _tmp4_) < 0) {
		result = NULL;
		return result;
	}
	_tmp5_ = self->priv->rule_state_stack;
	_tmp6_ = self->priv->rule_state_stack;
	_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = offset;
	_tmp10_ = vala_list_get ((ValaList*) _tmp5_, _tmp8_ + _tmp9_);
	result = (GObject*) _tmp10_;
	return result;
}


static GObject* valadoc_parser_real_get_rule_state (ValadocParserCallback* base) {
	ValadocParser * self;
	GObject* result = NULL;
	GObject* _tmp0_;
	self = (ValadocParser*) base;
	_tmp0_ = valadoc_parser_peek_state (self, -1);
	result = _tmp0_;
	return result;
}


static void valadoc_parser_real_set_rule_state (ValadocParserCallback* base, GObject* state) {
	ValadocParser * self;
	gint last_index = 0;
	ValaArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	ValaArrayList* _tmp3_;
	GObject* _tmp4_;
	self = (ValadocParser*) base;
	g_return_if_fail (state != NULL);
	_tmp0_ = self->priv->rule_stack;
	_tmp1_ = vala_collection_get_size ((ValaCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	last_index = _tmp2_ - 1;
	_tmp3_ = self->priv->rule_state_stack;
	_tmp4_ = state;
	vala_list_set ((ValaList*) _tmp3_, last_index, _tmp4_);
}


static void valadoc_parser_real_reduce (ValadocParserCallback* base) {
	ValadocParser * self;
	ValadocRule* _tmp0_;
	ValadocRule* _tmp1_;
	self = (ValadocParser*) base;
	_tmp0_ = valadoc_parser_pop_rule (self);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (_tmp1_);
}


static gboolean valadoc_parser_real_would_parent_accept_token (ValadocParserCallback* base, ValadocToken* token) {
	ValadocParser * self;
	gboolean result = FALSE;
	gint offset = 0;
	ValadocRule* parent_rule = NULL;
	gint _tmp0_;
	ValadocRule* _tmp1_;
	GObject* state = NULL;
	gint _tmp2_;
	GObject* _tmp3_;
	self = (ValadocParser*) base;
	g_return_val_if_fail (token != NULL, FALSE);
	offset = -2;
	_tmp0_ = offset;
	_tmp1_ = valadoc_parser_peek_rule (self, _tmp0_);
	parent_rule = _tmp1_;
	_tmp2_ = offset;
	_tmp3_ = valadoc_parser_peek_state (self, _tmp2_);
	state = _tmp3_;
	while (TRUE) {
		ValadocRule* _tmp4_;
		ValadocRule* _tmp5_;
		ValadocToken* _tmp6_;
		GObject* _tmp7_;
		gboolean _tmp8_;
		ValadocRule* _tmp9_;
		ValadocToken* _tmp10_;
		GObject* _tmp11_;
		gboolean _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		ValadocRule* _tmp15_;
		gint _tmp16_;
		GObject* _tmp17_;
		_tmp4_ = parent_rule;
		if (!(_tmp4_ != NULL)) {
			break;
		}
		_tmp5_ = parent_rule;
		_tmp6_ = token;
		_tmp7_ = state;
		_tmp8_ = valadoc_rule_would_accept_token (_tmp5_, _tmp6_, _tmp7_);
		if (_tmp8_) {
			result = TRUE;
			_g_object_unref0 (state);
			_g_object_unref0 (parent_rule);
			return result;
		}
		_tmp9_ = parent_rule;
		_tmp10_ = token;
		_tmp11_ = state;
		_tmp12_ = valadoc_rule_would_reduce (_tmp9_, _tmp10_, _tmp11_);
		if (!_tmp12_) {
			result = FALSE;
			_g_object_unref0 (state);
			_g_object_unref0 (parent_rule);
			return result;
		}
		_tmp13_ = offset;
		offset = _tmp13_ - 1;
		_tmp14_ = offset;
		_tmp15_ = valadoc_parser_peek_rule (self, _tmp14_);
		_g_object_unref0 (parent_rule);
		parent_rule = _tmp15_;
		_tmp16_ = offset;
		_tmp17_ = valadoc_parser_peek_state (self, _tmp16_);
		_g_object_unref0 (state);
		state = _tmp17_;
	}
	result = FALSE;
	_g_object_unref0 (state);
	_g_object_unref0 (parent_rule);
	return result;
}


static gboolean valadoc_parser_real_would_parent_reduce_to_rule (ValadocParserCallback* base, ValadocToken* token, ValadocRule* rule) {
	ValadocParser * self;
	gboolean result = FALSE;
	gint offset = 0;
	ValadocRule* parent_rule = NULL;
	gint _tmp0_;
	ValadocRule* _tmp1_;
	GObject* state = NULL;
	gint _tmp2_;
	GObject* _tmp3_;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	ValadocRule* _tmp16_;
	self = (ValadocParser*) base;
	g_return_val_if_fail (token != NULL, FALSE);
	g_return_val_if_fail (rule != NULL, FALSE);
	offset = -2;
	_tmp0_ = offset;
	_tmp1_ = valadoc_parser_peek_rule (self, _tmp0_);
	parent_rule = _tmp1_;
	_tmp2_ = offset;
	_tmp3_ = valadoc_parser_peek_state (self, _tmp2_);
	state = _tmp3_;
	while (TRUE) {
		ValadocRule* _tmp4_;
		ValadocRule* _tmp5_;
		ValadocToken* _tmp6_;
		GObject* _tmp7_;
		gboolean _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		ValadocRule* _tmp11_;
		gint _tmp12_;
		GObject* _tmp13_;
		_tmp4_ = parent_rule;
		if (!(_tmp4_ != NULL)) {
			break;
		}
		_tmp5_ = parent_rule;
		_tmp6_ = token;
		_tmp7_ = state;
		_tmp8_ = valadoc_rule_would_reduce (_tmp5_, _tmp6_, _tmp7_);
		if (!_tmp8_) {
			break;
		}
		_tmp9_ = offset;
		offset = _tmp9_ - 1;
		_tmp10_ = offset;
		_tmp11_ = valadoc_parser_peek_rule (self, _tmp10_);
		_g_object_unref0 (parent_rule);
		parent_rule = _tmp11_;
		_tmp12_ = offset;
		_tmp13_ = valadoc_parser_peek_state (self, _tmp12_);
		_g_object_unref0 (state);
		state = _tmp13_;
	}
	_tmp16_ = parent_rule;
	if (_tmp16_ != NULL) {
		ValadocRule* _tmp17_;
		ValadocToken* _tmp18_;
		GObject* _tmp19_;
		gboolean _tmp20_;
		_tmp17_ = parent_rule;
		_tmp18_ = token;
		_tmp19_ = state;
		_tmp20_ = valadoc_rule_would_accept_token (_tmp17_, _tmp18_, _tmp19_);
		_tmp15_ = _tmp20_;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		_tmp14_ = TRUE;
	} else {
		gboolean _tmp21_ = FALSE;
		ValadocRule* _tmp22_;
		_tmp22_ = parent_rule;
		if (_tmp22_ == NULL) {
			ValadocTokenType* _tmp23_;
			ValadocToken* _tmp24_;
			gboolean _tmp25_;
			_tmp23_ = valadoc_token_type_EOF;
			_tmp24_ = token;
			_tmp25_ = valadoc_token_type_matches (_tmp23_, _tmp24_);
			_tmp21_ = _tmp25_;
		} else {
			_tmp21_ = FALSE;
		}
		_tmp14_ = _tmp21_;
	}
	if (_tmp14_) {
		result = TRUE;
		_g_object_unref0 (state);
		_g_object_unref0 (parent_rule);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (state);
	_g_object_unref0 (parent_rule);
	return result;
}


static void valadoc_parser_real_warning (ValadocParserCallback* base, ValadocToken* token, const gchar* message) {
	ValadocParser * self;
	gchar* error_message = NULL;
	ValadocToken* _tmp0_;
	ValadocErrorReporter* _tmp10_;
	const gchar* _tmp11_;
	ValadocToken* _tmp12_;
	gint _tmp13_;
	ValadocToken* _tmp14_;
	gint _tmp15_;
	ValadocToken* _tmp16_;
	gint _tmp17_;
	ValadocScanner* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	self = (ValadocParser*) base;
	g_return_if_fail (message != NULL);
	_tmp0_ = token;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		ValadocToken* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp1_ = message;
		_tmp2_ = g_strconcat (_tmp1_, ": ", NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = token;
		_tmp5_ = valadoc_token_to_pretty_string (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strconcat (_tmp3_, _tmp6_, NULL);
		_g_free0 (error_message);
		error_message = _tmp7_;
		_g_free0 (_tmp6_);
		_g_free0 (_tmp3_);
	} else {
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = message;
		_tmp9_ = g_strdup (_tmp8_);
		_g_free0 (error_message);
		error_message = _tmp9_;
	}
	_tmp10_ = self->priv->_reporter;
	_tmp11_ = self->priv->_filename;
	_tmp12_ = token;
	_tmp13_ = valadoc_parser_get_line (self, _tmp12_);
	_tmp14_ = token;
	_tmp15_ = valadoc_parser_get_start_column (self, _tmp14_);
	_tmp16_ = token;
	_tmp17_ = valadoc_parser_get_end_column (self, _tmp16_);
	_tmp18_ = self->priv->_scanner;
	_tmp19_ = valadoc_scanner_get_line_content (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = error_message;
	valadoc_error_reporter_warning (_tmp10_, _tmp11_, (glong) _tmp13_, (glong) _tmp15_, (glong) _tmp17_, _tmp20_, "%s", _tmp21_);
	_g_free0 (_tmp20_);
	_g_free0 (error_message);
}


static void valadoc_parser_real_error (ValadocParserCallback* base, ValadocToken* token, const gchar* message, GError** error) {
	ValadocParser * self;
	gchar* error_message = NULL;
	ValadocToken* _tmp0_;
	ValadocErrorReporter* _tmp10_;
	const gchar* _tmp11_;
	ValadocToken* _tmp12_;
	gint _tmp13_;
	ValadocToken* _tmp14_;
	gint _tmp15_;
	ValadocToken* _tmp16_;
	gint _tmp17_;
	ValadocScanner* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	GError* _tmp23_;
	GError * _inner_error_ = NULL;
	self = (ValadocParser*) base;
	g_return_if_fail (message != NULL);
	_tmp0_ = token;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		ValadocToken* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp1_ = message;
		_tmp2_ = g_strconcat (_tmp1_, ": ", NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = token;
		_tmp5_ = valadoc_token_to_pretty_string (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strconcat (_tmp3_, _tmp6_, NULL);
		_g_free0 (error_message);
		error_message = _tmp7_;
		_g_free0 (_tmp6_);
		_g_free0 (_tmp3_);
	} else {
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = message;
		_tmp9_ = g_strdup (_tmp8_);
		_g_free0 (error_message);
		error_message = _tmp9_;
	}
	_tmp10_ = self->priv->_reporter;
	_tmp11_ = self->priv->_filename;
	_tmp12_ = token;
	_tmp13_ = valadoc_parser_get_line (self, _tmp12_);
	_tmp14_ = token;
	_tmp15_ = valadoc_parser_get_start_column (self, _tmp14_);
	_tmp16_ = token;
	_tmp17_ = valadoc_parser_get_end_column (self, _tmp16_);
	_tmp18_ = self->priv->_scanner;
	_tmp19_ = valadoc_scanner_get_line_content (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = error_message;
	valadoc_error_reporter_error (_tmp10_, _tmp11_, (glong) _tmp13_, (glong) _tmp15_, (glong) _tmp17_, _tmp20_, "%s", _tmp21_);
	_g_free0 (_tmp20_);
	_tmp22_ = error_message;
	_tmp23_ = g_error_new_literal (VALADOC_PARSER_ERROR, VALADOC_PARSER_ERROR_UNEXPECTED_TOKEN, _tmp22_);
	_inner_error_ = _tmp23_;
	if (_inner_error_->domain == VALADOC_PARSER_ERROR) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (error_message);
		return;
	} else {
		_g_free0 (error_message);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (error_message);
}


static gint valadoc_parser_get_line (ValadocParser* self, ValadocToken* token) {
	gint result = 0;
	ValadocToken* _tmp0_;
	ValadocToken* _tmp2_;
	ValadocSourceLocation _tmp3_ = {0};
	ValadocSourceLocation _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = token;
	if (_tmp0_ == NULL) {
		ValadocToken* _tmp1_;
		_tmp1_ = self->priv->_current_token;
		token = _tmp1_;
	}
	_tmp2_ = token;
	valadoc_token_get_begin (_tmp2_, &_tmp3_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_.line;
	_tmp6_ = self->priv->_first_line;
	result = _tmp5_ + _tmp6_;
	return result;
}


static gint valadoc_parser_get_start_column (ValadocParser* self, ValadocToken* token) {
	gint result = 0;
	ValadocToken* _tmp0_;
	ValadocToken* _tmp2_;
	ValadocSourceLocation _tmp3_ = {0};
	ValadocSourceLocation _tmp4_;
	gint _tmp5_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = token;
	if (_tmp0_ == NULL) {
		ValadocToken* _tmp1_;
		_tmp1_ = self->priv->_current_token;
		token = _tmp1_;
	}
	_tmp2_ = token;
	valadoc_token_get_begin (_tmp2_, &_tmp3_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_.line;
	if (_tmp5_ == 0) {
		ValadocToken* _tmp6_;
		ValadocSourceLocation _tmp7_ = {0};
		ValadocSourceLocation _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		_tmp6_ = token;
		valadoc_token_get_begin (_tmp6_, &_tmp7_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_.column;
		_tmp10_ = self->priv->_first_column;
		result = (_tmp9_ + _tmp10_) + 1;
		return result;
	} else {
		ValadocToken* _tmp11_;
		ValadocSourceLocation _tmp12_ = {0};
		ValadocSourceLocation _tmp13_;
		gint _tmp14_;
		_tmp11_ = token;
		valadoc_token_get_begin (_tmp11_, &_tmp12_);
		_tmp13_ = _tmp12_;
		_tmp14_ = _tmp13_.column;
		result = _tmp14_ + 1;
		return result;
	}
}


static gint valadoc_parser_get_end_column (ValadocParser* self, ValadocToken* token) {
	gint result = 0;
	ValadocToken* _tmp0_;
	ValadocToken* _tmp2_;
	ValadocSourceLocation _tmp3_ = {0};
	ValadocSourceLocation _tmp4_;
	gint _tmp5_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = token;
	if (_tmp0_ == NULL) {
		ValadocToken* _tmp1_;
		_tmp1_ = self->priv->_current_token;
		token = _tmp1_;
	}
	_tmp2_ = token;
	valadoc_token_get_end (_tmp2_, &_tmp3_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_.line;
	if (_tmp5_ == 0) {
		ValadocToken* _tmp6_;
		ValadocSourceLocation _tmp7_ = {0};
		ValadocSourceLocation _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		_tmp6_ = token;
		valadoc_token_get_end (_tmp6_, &_tmp7_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_.column;
		_tmp10_ = self->priv->_first_column;
		result = (_tmp9_ + _tmp10_) + 1;
		return result;
	} else {
		ValadocToken* _tmp11_;
		ValadocSourceLocation _tmp12_ = {0};
		ValadocSourceLocation _tmp13_;
		gint _tmp14_;
		_tmp11_ = token;
		valadoc_token_get_end (_tmp11_, &_tmp12_);
		_tmp13_ = _tmp12_;
		_tmp14_ = _tmp13_.column;
		result = _tmp14_ + 1;
		return result;
	}
}


static void valadoc_value_parser_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void valadoc_value_parser_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		valadoc_parser_unref (value->data[0].v_pointer);
	}
}


static void valadoc_value_parser_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = valadoc_parser_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer valadoc_value_parser_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* valadoc_value_parser_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValadocParser * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = valadoc_parser_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* valadoc_value_parser_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValadocParser ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = valadoc_parser_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* valadoc_param_spec_parser (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValadocParamSpecParser* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALADOC_TYPE_PARSER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer valadoc_value_get_parser (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALADOC_TYPE_PARSER), NULL);
	return value->data[0].v_pointer;
}


void valadoc_value_set_parser (GValue* value, gpointer v_object) {
	ValadocParser * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALADOC_TYPE_PARSER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALADOC_TYPE_PARSER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		valadoc_parser_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		valadoc_parser_unref (old);
	}
}


void valadoc_value_take_parser (GValue* value, gpointer v_object) {
	ValadocParser * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALADOC_TYPE_PARSER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALADOC_TYPE_PARSER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		valadoc_parser_unref (old);
	}
}


static void valadoc_parser_class_init (ValadocParserClass * klass) {
	valadoc_parser_parent_class = g_type_class_peek_parent (klass);
	((ValadocParserClass *) klass)->finalize = valadoc_parser_finalize;
	g_type_class_add_private (klass, sizeof (ValadocParserPrivate));
}


static void valadoc_parser_valadoc_parser_callback_interface_init (ValadocParserCallbackIface * iface) {
	valadoc_parser_valadoc_parser_callback_parent_iface = g_type_interface_peek_parent (iface);
	iface->push_rule = (void (*) (ValadocParserCallback *, ValadocRule*)) valadoc_parser_real_push_rule;
	iface->get_rule_state = (GObject* (*) (ValadocParserCallback *)) valadoc_parser_real_get_rule_state;
	iface->set_rule_state = (void (*) (ValadocParserCallback *, GObject*)) valadoc_parser_real_set_rule_state;
	iface->reduce = (void (*) (ValadocParserCallback *)) valadoc_parser_real_reduce;
	iface->would_parent_accept_token = (gboolean (*) (ValadocParserCallback *, ValadocToken*)) valadoc_parser_real_would_parent_accept_token;
	iface->would_parent_reduce_to_rule = (gboolean (*) (ValadocParserCallback *, ValadocToken*, ValadocRule*)) valadoc_parser_real_would_parent_reduce_to_rule;
	iface->warning = (void (*) (ValadocParserCallback *, ValadocToken*, const gchar*)) valadoc_parser_real_warning;
	iface->error = (void (*) (ValadocParserCallback *, ValadocToken*, const gchar*, GError**)) valadoc_parser_real_error;
}


static void valadoc_parser_instance_init (ValadocParser * self) {
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	self->priv = VALADOC_PARSER_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALADOC_TYPE_RULE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp0_);
	self->priv->rule_stack = _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (G_TYPE_OBJECT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp2_);
	self->priv->rule_state_stack = _tmp3_;
	self->ref_count = 1;
}


static void valadoc_parser_finalize (ValadocParser * obj) {
	ValadocParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_TYPE_PARSER, ValadocParser);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->_settings);
	_g_object_unref0 (self->priv->_scanner);
	_g_object_unref0 (self->priv->_reporter);
	_g_object_unref0 (self->priv->_root_rule);
	_g_free0 (self->priv->_filename);
	_g_object_unref0 (self->priv->_current_token);
	_vala_iterable_unref0 (self->priv->rule_stack);
	_vala_iterable_unref0 (self->priv->rule_state_stack);
}


GType valadoc_parser_get_type (void) {
	static volatile gsize valadoc_parser_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_parser_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { valadoc_value_parser_init, valadoc_value_parser_free_value, valadoc_value_parser_copy_value, valadoc_value_parser_peek_pointer, "p", valadoc_value_parser_collect_value, "p", valadoc_value_parser_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValadocParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocParser), 0, (GInstanceInitFunc) valadoc_parser_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		static const GInterfaceInfo valadoc_parser_callback_info = { (GInterfaceInitFunc) valadoc_parser_valadoc_parser_callback_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType valadoc_parser_type_id;
		valadoc_parser_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValadocParser", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_type_add_interface_static (valadoc_parser_type_id, VALADOC_TYPE_PARSER_CALLBACK, &valadoc_parser_callback_info);
		g_once_init_leave (&valadoc_parser_type_id__volatile, valadoc_parser_type_id);
	}
	return valadoc_parser_type_id__volatile;
}


gpointer valadoc_parser_ref (gpointer instance) {
	ValadocParser * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void valadoc_parser_unref (gpointer instance) {
	ValadocParser * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALADOC_PARSER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



