/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bib2gls;

import com.dickimawbooks.bib2gls.Bib2Gls;
import com.dickimawbooks.bib2gls.Bib2GlsAt;
import com.dickimawbooks.bib2gls.Bib2GlsDualIndexEntry;
import com.dickimawbooks.bib2gls.Bib2GlsEntry;
import com.dickimawbooks.bib2gls.Bib2GlsMultiEntry;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.bib.BibParser;
import com.dickimawbooks.texparserlib.bib.BibUserString;
import com.dickimawbooks.texparserlib.bib.BibValueList;
import com.dickimawbooks.texparserlib.latex.CsvList;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;

public class Bib2GlsSpawnDualIndexEntry
extends Bib2GlsDualIndexEntry
implements Bib2GlsMultiEntry {
    private Vector<Bib2GlsEntry> progeny = new Vector();

    public Bib2GlsSpawnDualIndexEntry(Bib2Gls bib2Gls) {
        this(bib2Gls, "spawndualindexentry");
    }

    public Bib2GlsSpawnDualIndexEntry(Bib2Gls bib2Gls, String string) {
        super(bib2Gls, string);
    }

    @Override
    public void checkRequiredFields() {
        if (this.getField("progeny") == null || this.progeny.size() == 0) {
            this.missingFieldWarning("adoptparents");
        }
        super.checkRequiredFields();
    }

    protected String getProgenyEntryType() {
        return "index";
    }

    @Override
    protected Vector<String> processSpecialFields(TeXParser teXParser, boolean bl, String[] stringArray, String string, Vector<String> vector) throws IOException {
        vector = super.processSpecialFields(teXParser, bl, stringArray, string, vector);
        for (String string2 : Bib2Gls.SPAWN_SPECIAL_FIELDS) {
            vector = this.processField(teXParser, string2, bl, stringArray, string, vector);
        }
        return vector;
    }

    @Override
    public void populate(BibParser bibParser) throws IOException {
        Object object;
        BibValueList bibValueList = this.getField("adoptparents");
        if (bibValueList == null && this.resource.hasFieldAliases() && (object = this.resource.getOriginalField("adoptparents")) != null) {
            bibValueList = this.getField((String)object);
        }
        if (bibValueList == null) {
            return;
        }
        object = bibParser.getParser();
        TeXObjectList teXObjectList = bibValueList.expand((TeXParser)object);
        String string = teXObjectList.toString((TeXParser)object);
        if (this.resource.isInterpretLabelFieldsEnabled() && string.matches("(?s).*[\\\\\\{\\}].*")) {
            string = this.bib2gls.interpret(string, bibValueList, true);
            teXObjectList = ((TeXParser)object).getListener().createString(string);
        }
        CsvList csvList = CsvList.getList((TeXParser)object, teXObjectList);
        teXObjectList = new TeXObjectList();
        String string2 = this.getOriginalId();
        String string3 = this.processLabel(string2);
        String string4 = this.resource.getAdoptedParentField();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < csvList.size(); ++i) {
            String string5 = csvList.getValue(i).toString((TeXParser)object).trim();
            String string6 = this.getProgenyEntryType();
            String string7 = string5 + "." + this.getOriginalId();
            this.bib2gls.debugMessage("message.spawning", string7, this.getOriginalId());
            Bib2GlsEntry bib2GlsEntry = Bib2GlsAt.createBib2GlsEntry(this.bib2gls, "spawned" + string6);
            if (bib2GlsEntry == null) {
                throw new NullPointerException();
            }
            this.progeny.add(bib2GlsEntry);
            bib2GlsEntry.setId(this.getPrefix(), string7);
            bib2GlsEntry.setBase(this.getBase());
            bib2GlsEntry.setOriginalEntryType(this.getOriginalEntryType());
            for (String string8 : this.getKeySet()) {
                if (string8.equals("alias") || string8.equals("parent") || (bibValueList = this.getField(string8)) == null) continue;
                bib2GlsEntry.putField(string8, (BibValueList)bibValueList.clone());
            }
            bib2GlsEntry.putField("progenitor", string3);
            bibValueList = new BibValueList();
            bibValueList.add(new BibUserString(bibParser.createString(string3)));
            bib2GlsEntry.putField("progenitor", bibValueList);
            bibValueList = new BibValueList();
            bibValueList.add(new BibUserString(bibParser.createString(string5)));
            bib2GlsEntry.putField(string4, bibValueList);
            this.addDependency(bib2GlsEntry.getId());
            if (teXObjectList.size() > 0) {
                teXObjectList.add(bibParser.getOther(44));
                stringBuilder.append(',');
            }
            String string8 = bib2GlsEntry.getId();
            teXObjectList.addAll(bibParser.createString(string8));
            stringBuilder.append(string8);
            bibParser.addBibData(bib2GlsEntry);
            if (this.bib2gls.getDebugLevel() <= 0) continue;
            for (String string9 : bib2GlsEntry.getKeySet()) {
                bibValueList = bib2GlsEntry.getField(string9);
                this.bib2gls.debug(String.format("%s={%s}", string9, bibValueList == null ? "" : bibValueList.expand((TeXParser)object).toString((TeXParser)object)));
            }
        }
        bibValueList = new BibValueList();
        bibValueList.add(new BibUserString(teXObjectList));
        this.putField("progeny", bibValueList);
        this.putField("progeny", stringBuilder.toString());
    }

    @Override
    public void writeExtraFields(PrintWriter printWriter) throws IOException {
        String string = this.getFieldValue("progeny");
        if (string == null) {
            this.bib2gls.debugMessage("message.entry.lost.field", this.getId(), "progeny");
        } else {
            printWriter.println(String.format("\\GlsXtrSetField{%s}{progeny}{%s}", this.getId(), this.getFieldValue("progeny")));
        }
    }

    @Override
    public Bib2GlsEntry createDual() {
        Bib2GlsEntry bib2GlsEntry = super.createDual();
        if (this.resource.hasDualPrimaryDepencendies()) {
            for (Bib2GlsEntry bib2GlsEntry2 : this.progeny) {
                bib2GlsEntry.addDependency(bib2GlsEntry2.getId());
            }
        }
        return bib2GlsEntry;
    }
}

