; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --function foo --extra_scrub --default-march nvptx64 --filter-out ".*//.*" --filter-out "[\{\}\(\)]" --version 5

; RUN: llc < %s -march=nvptx64 -mcpu=sm_50 | FileCheck %s
; RUN: %if ptxas %{ llc < %s -march=nvptx64 -mcpu=sm_50 | %ptxas-verify %}

target triple = "nvptx-nvidia-cuda"

define void @foo(ptr noalias readonly %ptr, ptr noalias %retval) {
; CHECK-LABEL: foo(
; CHECK:    .reg .b16 %rs<2>;
; CHECK:    .reg .b32 %r<4>;
; CHECK:    .reg .b64 %rd<5>;
; CHECK-EMPTY:
; CHECK:    ld.param.u64 %rd1, [foo_param_0];
; CHECK:    ld.param.u64 %rd2, [foo_param_1];
; CHECK:    cvta.to.global.u64 %rd3, %rd2;
; CHECK:    cvta.to.global.u64 %rd4, %rd1;
; CHECK:    ld.global.nc.u8 %rs1, [%rd4];
; CHECK:    cvt.u32.u8 %r1, %rs1;
; CHECK:    add.s32 %r2, %r1, 1;
; CHECK:    and.b32 %r3, %r2, 1;
; CHECK:    st.global.u32 [%rd3], %r3;
; CHECK:    ret;
  %ld = load i1, ptr %ptr, align 1
  %zext = zext i1 %ld to i32
  %add = add i32 %zext, 1
  %and = and i32 %add, 1
  store i32 %and, ptr %retval
  ret void
}

!nvvm.annotations = !{!0}

!0 = !{ptr @foo, !"kernel", i32 1}
