use crate::inc::inc::BigFloatInc;

// hyperbolic tangent polynomial coefficients
pub(crate) const TANH_VALUES: [BigFloatInc; 10] = [
    BigFloatInc {
        sign: -1,
        e: -44,
        n: 44,
        m: [3333, 3333, 3333, 3333, 3333, 3333, 3333, 3333, 3333, 3333, 3333],
    },
    BigFloatInc {
        sign: 1,
        e: -44,
        n: 44,
        m: [3333, 3333, 3333, 3333, 3333, 3333, 3333, 3333, 3333, 3333, 1333],
    },
    BigFloatInc {
        sign: -1,
        e: -45,
        n: 44,
        m: [8254, 5396, 9682, 8253, 5396, 9682, 8253, 5396, 9682, 8253, 5396],
    },
    BigFloatInc {
        sign: 1,
        e: -45,
        n: 44,
        m: [9488, 2186, 2028, 6155, 8853, 8694, 2821, 5520, 5361, 9488, 2186],
    },
    BigFloatInc {
        sign: -1,
        e: -46,
        n: 44,
        m: [2355, 8863, 9656, 9021, 5529, 6323, 5688, 2196, 2990, 2355, 8863],
    },
    BigFloatInc {
        sign: 1,
        e: -46,
        n: 44,
        m: [7947, 258, 1435, 9058, 1369, 2546, 169, 2481, 3657, 1280, 3592],
    },
    BigFloatInc {
        sign: -1,
        e: -46,
        n: 44,
        m: [1360, 9043, 1191, 7021, 5180, 4948, 2682, 1318, 8705, 8343, 1455],
    },
    BigFloatInc {
        sign: 1,
        e: -47,
        n: 44,
        m: [5984, 7543, 1088, 2, 9937, 8075, 8137, 5859, 945, 2744, 5900],
    },
    BigFloatInc {
        sign: -1,
        e: -47,
        n: 44,
        m: [6910, 3205, 2809, 8511, 4588, 5731, 8148, 5524, 4243, 2911, 2391],
    },
    BigFloatInc {
        sign: 1,
        e: -48,
        n: 44,
        m: [7555, 7858, 937, 3888, 5000, 9587, 3255, 9450, 5692, 5379, 9691],
    },
];
