/*
This file is part of the KubeVirt project

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Copyright The KubeVirt Authors.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
	v1 "kubevirt.io/api/core/v1"
)

// FakeKubeVirts implements KubeVirtInterface
type FakeKubeVirts struct {
	Fake *FakeKubevirtV1
	ns   string
}

var kubevirtsResource = v1.SchemeGroupVersion.WithResource("kubevirts")

var kubevirtsKind = v1.SchemeGroupVersion.WithKind("KubeVirt")

// Get takes name of the kubeVirt, and returns the corresponding kubeVirt object, and an error if there is any.
func (c *FakeKubeVirts) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.KubeVirt, err error) {
	emptyResult := &v1.KubeVirt{}
	obj, err := c.Fake.
		Invokes(testing.NewGetActionWithOptions(kubevirtsResource, c.ns, name, options), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1.KubeVirt), err
}

// List takes label and field selectors, and returns the list of KubeVirts that match those selectors.
func (c *FakeKubeVirts) List(ctx context.Context, opts metav1.ListOptions) (result *v1.KubeVirtList, err error) {
	emptyResult := &v1.KubeVirtList{}
	obj, err := c.Fake.
		Invokes(testing.NewListActionWithOptions(kubevirtsResource, kubevirtsKind, c.ns, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1.KubeVirtList{ListMeta: obj.(*v1.KubeVirtList).ListMeta}
	for _, item := range obj.(*v1.KubeVirtList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested kubeVirts.
func (c *FakeKubeVirts) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchActionWithOptions(kubevirtsResource, c.ns, opts))

}

// Create takes the representation of a kubeVirt and creates it.  Returns the server's representation of the kubeVirt, and an error, if there is any.
func (c *FakeKubeVirts) Create(ctx context.Context, kubeVirt *v1.KubeVirt, opts metav1.CreateOptions) (result *v1.KubeVirt, err error) {
	emptyResult := &v1.KubeVirt{}
	obj, err := c.Fake.
		Invokes(testing.NewCreateActionWithOptions(kubevirtsResource, c.ns, kubeVirt, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1.KubeVirt), err
}

// Update takes the representation of a kubeVirt and updates it. Returns the server's representation of the kubeVirt, and an error, if there is any.
func (c *FakeKubeVirts) Update(ctx context.Context, kubeVirt *v1.KubeVirt, opts metav1.UpdateOptions) (result *v1.KubeVirt, err error) {
	emptyResult := &v1.KubeVirt{}
	obj, err := c.Fake.
		Invokes(testing.NewUpdateActionWithOptions(kubevirtsResource, c.ns, kubeVirt, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1.KubeVirt), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeKubeVirts) UpdateStatus(ctx context.Context, kubeVirt *v1.KubeVirt, opts metav1.UpdateOptions) (result *v1.KubeVirt, err error) {
	emptyResult := &v1.KubeVirt{}
	obj, err := c.Fake.
		Invokes(testing.NewUpdateSubresourceActionWithOptions(kubevirtsResource, "status", c.ns, kubeVirt, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1.KubeVirt), err
}

// Delete takes name of the kubeVirt and deletes it. Returns an error if one occurs.
func (c *FakeKubeVirts) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteActionWithOptions(kubevirtsResource, c.ns, name, opts), &v1.KubeVirt{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeKubeVirts) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	action := testing.NewDeleteCollectionActionWithOptions(kubevirtsResource, c.ns, opts, listOpts)

	_, err := c.Fake.Invokes(action, &v1.KubeVirtList{})
	return err
}

// Patch applies the patch and returns the patched kubeVirt.
func (c *FakeKubeVirts) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.KubeVirt, err error) {
	emptyResult := &v1.KubeVirt{}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceActionWithOptions(kubevirtsResource, c.ns, name, pt, data, opts, subresources...), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1.KubeVirt), err
}
