// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// When writing a match expression against `KeySpec`, it is important to ensure
/// your code is forward-compatible. That is, if a match arm handles a case for a
/// feature that is supported by the service but has not been represented as an enum
/// variant in a current version of SDK, your code should continue to work when you
/// upgrade SDK to a future version in which the enum does include a variant for that
/// feature.
///
/// Here is an example of how you can make a match expression forward-compatible:
///
/// ```text
/// # let keyspec = unimplemented!();
/// match keyspec {
///     KeySpec::EccNistP256 => { /* ... */ },
///     KeySpec::EccNistP384 => { /* ... */ },
///     KeySpec::EccNistP521 => { /* ... */ },
///     KeySpec::EccSecgP256K1 => { /* ... */ },
///     KeySpec::Hmac224 => { /* ... */ },
///     KeySpec::Hmac256 => { /* ... */ },
///     KeySpec::Hmac384 => { /* ... */ },
///     KeySpec::Hmac512 => { /* ... */ },
///     KeySpec::Rsa2048 => { /* ... */ },
///     KeySpec::Rsa3072 => { /* ... */ },
///     KeySpec::Rsa4096 => { /* ... */ },
///     KeySpec::Sm2 => { /* ... */ },
///     KeySpec::SymmetricDefault => { /* ... */ },
///     other @ _ if other.as_str() == "NewFeature" => { /* handles a case for `NewFeature` */ },
///     _ => { /* ... */ },
/// }
/// ```
/// The above code demonstrates that when `keyspec` represents
/// `NewFeature`, the execution path will lead to the second last match arm,
/// even though the enum does not contain a variant `KeySpec::NewFeature`
/// in the current version of SDK. The reason is that the variable `other`,
/// created by the `@` operator, is bound to
/// `KeySpec::Unknown(UnknownVariantValue("NewFeature".to_owned()))`
/// and calling `as_str` on it yields `"NewFeature"`.
/// This match expression is forward-compatible when executed with a newer
/// version of SDK where the variant `KeySpec::NewFeature` is defined.
/// Specifically, when `keyspec` represents `NewFeature`,
/// the execution path will hit the second last match arm as before by virtue of
/// calling `as_str` on `KeySpec::NewFeature` also yielding `"NewFeature"`.
///
/// Explicitly matching on the `Unknown` variant should
/// be avoided for two reasons:
/// - The inner data `UnknownVariantValue` is opaque, and no further information can be extracted.
/// - It might inadvertently shadow other intended match arms.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    ::std::clone::Clone, ::std::cmp::Eq, ::std::cmp::Ord, ::std::cmp::PartialEq, ::std::cmp::PartialOrd, ::std::fmt::Debug, ::std::hash::Hash,
)]
pub enum KeySpec {
    #[allow(missing_docs)] // documentation missing in model
    EccNistP256,
    #[allow(missing_docs)] // documentation missing in model
    EccNistP384,
    #[allow(missing_docs)] // documentation missing in model
    EccNistP521,
    #[allow(missing_docs)] // documentation missing in model
    EccSecgP256K1,
    #[allow(missing_docs)] // documentation missing in model
    Hmac224,
    #[allow(missing_docs)] // documentation missing in model
    Hmac256,
    #[allow(missing_docs)] // documentation missing in model
    Hmac384,
    #[allow(missing_docs)] // documentation missing in model
    Hmac512,
    #[allow(missing_docs)] // documentation missing in model
    Rsa2048,
    #[allow(missing_docs)] // documentation missing in model
    Rsa3072,
    #[allow(missing_docs)] // documentation missing in model
    Rsa4096,
    #[allow(missing_docs)] // documentation missing in model
    Sm2,
    #[allow(missing_docs)] // documentation missing in model
    SymmetricDefault,
    /// `Unknown` contains new variants that have been added since this code was generated.
    #[deprecated(note = "Don't directly match on `Unknown`. See the docs on this enum for the correct way to handle unknown variants.")]
    Unknown(crate::primitives::sealed_enum_unknown::UnknownVariantValue),
}
impl ::std::convert::From<&str> for KeySpec {
    fn from(s: &str) -> Self {
        match s {
            "ECC_NIST_P256" => KeySpec::EccNistP256,
            "ECC_NIST_P384" => KeySpec::EccNistP384,
            "ECC_NIST_P521" => KeySpec::EccNistP521,
            "ECC_SECG_P256K1" => KeySpec::EccSecgP256K1,
            "HMAC_224" => KeySpec::Hmac224,
            "HMAC_256" => KeySpec::Hmac256,
            "HMAC_384" => KeySpec::Hmac384,
            "HMAC_512" => KeySpec::Hmac512,
            "RSA_2048" => KeySpec::Rsa2048,
            "RSA_3072" => KeySpec::Rsa3072,
            "RSA_4096" => KeySpec::Rsa4096,
            "SM2" => KeySpec::Sm2,
            "SYMMETRIC_DEFAULT" => KeySpec::SymmetricDefault,
            other => KeySpec::Unknown(crate::primitives::sealed_enum_unknown::UnknownVariantValue(other.to_owned())),
        }
    }
}
impl ::std::str::FromStr for KeySpec {
    type Err = ::std::convert::Infallible;

    fn from_str(s: &str) -> ::std::result::Result<Self, <Self as ::std::str::FromStr>::Err> {
        ::std::result::Result::Ok(KeySpec::from(s))
    }
}
impl KeySpec {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            KeySpec::EccNistP256 => "ECC_NIST_P256",
            KeySpec::EccNistP384 => "ECC_NIST_P384",
            KeySpec::EccNistP521 => "ECC_NIST_P521",
            KeySpec::EccSecgP256K1 => "ECC_SECG_P256K1",
            KeySpec::Hmac224 => "HMAC_224",
            KeySpec::Hmac256 => "HMAC_256",
            KeySpec::Hmac384 => "HMAC_384",
            KeySpec::Hmac512 => "HMAC_512",
            KeySpec::Rsa2048 => "RSA_2048",
            KeySpec::Rsa3072 => "RSA_3072",
            KeySpec::Rsa4096 => "RSA_4096",
            KeySpec::Sm2 => "SM2",
            KeySpec::SymmetricDefault => "SYMMETRIC_DEFAULT",
            KeySpec::Unknown(value) => value.as_str(),
        }
    }
    /// Returns all the `&str` representations of the enum members.
    pub const fn values() -> &'static [&'static str] {
        &[
            "ECC_NIST_P256",
            "ECC_NIST_P384",
            "ECC_NIST_P521",
            "ECC_SECG_P256K1",
            "HMAC_224",
            "HMAC_256",
            "HMAC_384",
            "HMAC_512",
            "RSA_2048",
            "RSA_3072",
            "RSA_4096",
            "SM2",
            "SYMMETRIC_DEFAULT",
        ]
    }
}
impl ::std::convert::AsRef<str> for KeySpec {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
impl KeySpec {
    /// Parses the enum value while disallowing unknown variants.
    ///
    /// Unknown variants will result in an error.
    pub fn try_parse(value: &str) -> ::std::result::Result<Self, crate::error::UnknownVariantError> {
        match Self::from(value) {
            #[allow(deprecated)]
            Self::Unknown(_) => ::std::result::Result::Err(crate::error::UnknownVariantError::new(value)),
            known => Ok(known),
        }
    }
}
impl ::std::fmt::Display for KeySpec {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        match self {
            KeySpec::EccNistP256 => write!(f, "ECC_NIST_P256"),
            KeySpec::EccNistP384 => write!(f, "ECC_NIST_P384"),
            KeySpec::EccNistP521 => write!(f, "ECC_NIST_P521"),
            KeySpec::EccSecgP256K1 => write!(f, "ECC_SECG_P256K1"),
            KeySpec::Hmac224 => write!(f, "HMAC_224"),
            KeySpec::Hmac256 => write!(f, "HMAC_256"),
            KeySpec::Hmac384 => write!(f, "HMAC_384"),
            KeySpec::Hmac512 => write!(f, "HMAC_512"),
            KeySpec::Rsa2048 => write!(f, "RSA_2048"),
            KeySpec::Rsa3072 => write!(f, "RSA_3072"),
            KeySpec::Rsa4096 => write!(f, "RSA_4096"),
            KeySpec::Sm2 => write!(f, "SM2"),
            KeySpec::SymmetricDefault => write!(f, "SYMMETRIC_DEFAULT"),
            KeySpec::Unknown(value) => write!(f, "{}", value),
        }
    }
}
