// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct SignOutput {
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the asymmetric KMS key that was used to sign the message.</p>
    pub key_id: ::std::option::Option<::std::string::String>,
    /// <p>The cryptographic signature that was generated for the message.</p>
    /// <ul>
    /// <li>
    /// <p>When used with the supported RSA signing algorithms, the encoding of this value is defined by <a href="https://tools.ietf.org/html/rfc8017">PKCS #1 in RFC 8017</a>.</p></li>
    /// <li>
    /// <p>When used with the <code>ECDSA_SHA_256</code>, <code>ECDSA_SHA_384</code>, or <code>ECDSA_SHA_512</code> signing algorithms, this value is a DER-encoded object as defined by ANSI X9.62–2005 and <a href="https://tools.ietf.org/html/rfc3279#section-2.2.3">RFC 3279 Section 2.2.3</a>. This is the most commonly used signature format and is appropriate for most uses.</p></li>
    /// </ul>
    /// <p>When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
    pub signature: ::std::option::Option<::aws_smithy_types::Blob>,
    /// <p>The signing algorithm that was used to sign the message.</p>
    pub signing_algorithm: ::std::option::Option<crate::types::SigningAlgorithmSpec>,
    _request_id: Option<String>,
}
impl SignOutput {
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the asymmetric KMS key that was used to sign the message.</p>
    pub fn key_id(&self) -> ::std::option::Option<&str> {
        self.key_id.as_deref()
    }
    /// <p>The cryptographic signature that was generated for the message.</p>
    /// <ul>
    /// <li>
    /// <p>When used with the supported RSA signing algorithms, the encoding of this value is defined by <a href="https://tools.ietf.org/html/rfc8017">PKCS #1 in RFC 8017</a>.</p></li>
    /// <li>
    /// <p>When used with the <code>ECDSA_SHA_256</code>, <code>ECDSA_SHA_384</code>, or <code>ECDSA_SHA_512</code> signing algorithms, this value is a DER-encoded object as defined by ANSI X9.62–2005 and <a href="https://tools.ietf.org/html/rfc3279#section-2.2.3">RFC 3279 Section 2.2.3</a>. This is the most commonly used signature format and is appropriate for most uses.</p></li>
    /// </ul>
    /// <p>When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
    pub fn signature(&self) -> ::std::option::Option<&::aws_smithy_types::Blob> {
        self.signature.as_ref()
    }
    /// <p>The signing algorithm that was used to sign the message.</p>
    pub fn signing_algorithm(&self) -> ::std::option::Option<&crate::types::SigningAlgorithmSpec> {
        self.signing_algorithm.as_ref()
    }
}
impl ::aws_types::request_id::RequestId for SignOutput {
    fn request_id(&self) -> Option<&str> {
        self._request_id.as_deref()
    }
}
impl SignOutput {
    /// Creates a new builder-style object to manufacture [`SignOutput`](crate::operation::sign::SignOutput).
    pub fn builder() -> crate::operation::sign::builders::SignOutputBuilder {
        crate::operation::sign::builders::SignOutputBuilder::default()
    }
}

/// A builder for [`SignOutput`](crate::operation::sign::SignOutput).
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
pub struct SignOutputBuilder {
    pub(crate) key_id: ::std::option::Option<::std::string::String>,
    pub(crate) signature: ::std::option::Option<::aws_smithy_types::Blob>,
    pub(crate) signing_algorithm: ::std::option::Option<crate::types::SigningAlgorithmSpec>,
    _request_id: Option<String>,
}
impl SignOutputBuilder {
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the asymmetric KMS key that was used to sign the message.</p>
    pub fn key_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.key_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the asymmetric KMS key that was used to sign the message.</p>
    pub fn set_key_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.key_id = input;
        self
    }
    /// <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the asymmetric KMS key that was used to sign the message.</p>
    pub fn get_key_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.key_id
    }
    /// <p>The cryptographic signature that was generated for the message.</p>
    /// <ul>
    /// <li>
    /// <p>When used with the supported RSA signing algorithms, the encoding of this value is defined by <a href="https://tools.ietf.org/html/rfc8017">PKCS #1 in RFC 8017</a>.</p></li>
    /// <li>
    /// <p>When used with the <code>ECDSA_SHA_256</code>, <code>ECDSA_SHA_384</code>, or <code>ECDSA_SHA_512</code> signing algorithms, this value is a DER-encoded object as defined by ANSI X9.62–2005 and <a href="https://tools.ietf.org/html/rfc3279#section-2.2.3">RFC 3279 Section 2.2.3</a>. This is the most commonly used signature format and is appropriate for most uses.</p></li>
    /// </ul>
    /// <p>When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
    pub fn signature(mut self, input: ::aws_smithy_types::Blob) -> Self {
        self.signature = ::std::option::Option::Some(input);
        self
    }
    /// <p>The cryptographic signature that was generated for the message.</p>
    /// <ul>
    /// <li>
    /// <p>When used with the supported RSA signing algorithms, the encoding of this value is defined by <a href="https://tools.ietf.org/html/rfc8017">PKCS #1 in RFC 8017</a>.</p></li>
    /// <li>
    /// <p>When used with the <code>ECDSA_SHA_256</code>, <code>ECDSA_SHA_384</code>, or <code>ECDSA_SHA_512</code> signing algorithms, this value is a DER-encoded object as defined by ANSI X9.62–2005 and <a href="https://tools.ietf.org/html/rfc3279#section-2.2.3">RFC 3279 Section 2.2.3</a>. This is the most commonly used signature format and is appropriate for most uses.</p></li>
    /// </ul>
    /// <p>When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
    pub fn set_signature(mut self, input: ::std::option::Option<::aws_smithy_types::Blob>) -> Self {
        self.signature = input;
        self
    }
    /// <p>The cryptographic signature that was generated for the message.</p>
    /// <ul>
    /// <li>
    /// <p>When used with the supported RSA signing algorithms, the encoding of this value is defined by <a href="https://tools.ietf.org/html/rfc8017">PKCS #1 in RFC 8017</a>.</p></li>
    /// <li>
    /// <p>When used with the <code>ECDSA_SHA_256</code>, <code>ECDSA_SHA_384</code>, or <code>ECDSA_SHA_512</code> signing algorithms, this value is a DER-encoded object as defined by ANSI X9.62–2005 and <a href="https://tools.ietf.org/html/rfc3279#section-2.2.3">RFC 3279 Section 2.2.3</a>. This is the most commonly used signature format and is appropriate for most uses.</p></li>
    /// </ul>
    /// <p>When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
    pub fn get_signature(&self) -> &::std::option::Option<::aws_smithy_types::Blob> {
        &self.signature
    }
    /// <p>The signing algorithm that was used to sign the message.</p>
    pub fn signing_algorithm(mut self, input: crate::types::SigningAlgorithmSpec) -> Self {
        self.signing_algorithm = ::std::option::Option::Some(input);
        self
    }
    /// <p>The signing algorithm that was used to sign the message.</p>
    pub fn set_signing_algorithm(mut self, input: ::std::option::Option<crate::types::SigningAlgorithmSpec>) -> Self {
        self.signing_algorithm = input;
        self
    }
    /// <p>The signing algorithm that was used to sign the message.</p>
    pub fn get_signing_algorithm(&self) -> &::std::option::Option<crate::types::SigningAlgorithmSpec> {
        &self.signing_algorithm
    }
    pub(crate) fn _request_id(mut self, request_id: impl Into<String>) -> Self {
        self._request_id = Some(request_id.into());
        self
    }

    pub(crate) fn _set_request_id(&mut self, request_id: Option<String>) -> &mut Self {
        self._request_id = request_id;
        self
    }
    /// Consumes the builder and constructs a [`SignOutput`](crate::operation::sign::SignOutput).
    pub fn build(self) -> crate::operation::sign::SignOutput {
        crate::operation::sign::SignOutput {
            key_id: self.key_id,
            signature: self.signature,
            signing_algorithm: self.signing_algorithm,
            _request_id: self._request_id,
        }
    }
}
