// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`RetireGrant`](crate::operation::retire_grant::builders::RetireGrantFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`grant_token(impl Into<String>)`](crate::operation::retire_grant::builders::RetireGrantFluentBuilder::grant_token) / [`set_grant_token(Option<String>)`](crate::operation::retire_grant::builders::RetireGrantFluentBuilder::set_grant_token):<br>required: **false**<br><p>Identifies the grant to be retired. You can use a grant token to identify a new grant even before it has achieved eventual consistency.</p> <p>Only the <code>CreateGrant</code> operation returns a grant token. For details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token">Grant token</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#terms-eventual-consistency">Eventual consistency</a> in the <i>Key Management Service Developer Guide</i>.</p><br>
    ///   - [`key_id(impl Into<String>)`](crate::operation::retire_grant::builders::RetireGrantFluentBuilder::key_id) / [`set_key_id(Option<String>)`](crate::operation::retire_grant::builders::RetireGrantFluentBuilder::set_key_id):<br>required: **false**<br><p>The key ARN KMS key associated with the grant. To find the key ARN, use the <code>ListKeys</code> operation.</p> <p>For example: <code>arn:aws:kms:us-east-2:444455556666:key/1234abcd-12ab-34cd-56ef-1234567890ab</code></p><br>
    ///   - [`grant_id(impl Into<String>)`](crate::operation::retire_grant::builders::RetireGrantFluentBuilder::grant_id) / [`set_grant_id(Option<String>)`](crate::operation::retire_grant::builders::RetireGrantFluentBuilder::set_grant_id):<br>required: **false**<br><p>Identifies the grant to retire. To get the grant ID, use <code>CreateGrant</code>, <code>ListGrants</code>, or <code>ListRetirableGrants</code>.</p> <ul>  <li>   <p>Grant ID Example - 0123456789012345678901234567890123456789012345678901234567890123</p></li> </ul><br>
    ///   - [`dry_run(bool)`](crate::operation::retire_grant::builders::RetireGrantFluentBuilder::dry_run) / [`set_dry_run(Option<bool>)`](crate::operation::retire_grant::builders::RetireGrantFluentBuilder::set_dry_run):<br>required: **false**<br><p>Checks if your request will succeed. <code>DryRun</code> is an optional parameter.</p> <p>To learn more about how to use this parameter, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/programming-dryrun.html">Testing your KMS API calls</a> in the <i>Key Management Service Developer Guide</i>.</p><br>
    /// - On success, responds with [`RetireGrantOutput`](crate::operation::retire_grant::RetireGrantOutput)
    /// - On failure, responds with [`SdkError<RetireGrantError>`](crate::operation::retire_grant::RetireGrantError)
    pub fn retire_grant(&self) -> crate::operation::retire_grant::builders::RetireGrantFluentBuilder {
        crate::operation::retire_grant::builders::RetireGrantFluentBuilder::new(self.handle.clone())
    }
}
