/* { dg-do run { target aarch64_sve_hw } } */
/* { dg-options "-O" } */

#include "uzp2_1.c"

#define TEST_UZP2(TYPE, EXPECTED_RESULT, VALUES1, VALUES2)		\
{									\
  TYPE expected_result = EXPECTED_RESULT;				\
  TYPE values1 = VALUES1;						\
  TYPE values2 = VALUES2;						\
  TYPE dest;								\
  dest = uzp2_##TYPE (values1, values2);				\
  if (__builtin_memcmp (&dest, &expected_result, sizeof (TYPE)) != 0)	\
    __builtin_abort ();							\
}

int main (void)
{
  TEST_UZP2 (vnx2di,
	     ((vnx2di) { 5, 7, 24, 48 }),
	     ((vnx2di) { 4, 5, 6, 7 }),
	     ((vnx2di) { 12, 24, 36, 48 }));
  TEST_UZP2 (vnx4si,
	     ((vnx4si) { 4, 6, 8, 10, 34, 36, 38, 40 }),
	     ((vnx4si) { 3, 4, 5, 6, 7, 8, 9, 10 }),
	     ((vnx4si) { 33, 34, 35, 36, 37, 38, 39, 40 }));
  TEST_UZP2 (vnx8hi,
	     ((vnx8hi) { 4, 6, 8, 10, 12, 14, 16, 18,
			 34, 36, 38, 40, 42, 44, 46, 48 }),
	     ((vnx8hi) { 3, 4, 5, 6, 7, 8, 9, 10,
			 11, 12, 13, 14, 15, 16, 17, 18 }),
	     ((vnx8hi) { 33, 34, 35, 36, 37, 38, 39, 40,
			 41, 42, 43, 44, 45, 46, 47, 48 }));
  TEST_UZP2 (vnx16qi,
	     ((vnx16qi) { 5, 7, 5, 7, 5, 7, 5, 7,
			  5, 7, 5, 7, 5, 7, 5, 7,
			  24, 48, 24, 48, 24, 48, 24, 48,
			  24, 48, 24, 48, 24, 48, 24, 48 }),
	     ((vnx16qi) { 4, 5, 6, 7, 4, 5, 6, 7,
			  4, 5, 6, 7, 4, 5, 6, 7,
			  4, 5, 6, 7, 4, 5, 6, 7,
			  4, 5, 6, 7, 4, 5, 6, 7 }),
	     ((vnx16qi) { 12, 24, 36, 48, 12, 24, 36, 48,
			  12, 24, 36, 48, 12, 24, 36, 48,
			  12, 24, 36, 48, 12, 24, 36, 48,
			  12, 24, 36, 48, 12, 24, 36, 48 }));
  TEST_UZP2 (vnx2df,
	     ((vnx2df) { 5.0, 7.0, 24.0, 48.0 }),
	     ((vnx2df) { 4.0, 5.0, 6.0, 7.0 }),
	     ((vnx2df) { 12.0, 24.0, 36.0, 48.0 }));
  TEST_UZP2 (vnx4sf,
	     ((vnx4sf) { 4.0, 6.0, 8.0, 10.0, 34.0, 36.0, 38.0, 40.0 }),
	     ((vnx4sf) { 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0 }),
	     ((vnx4sf) { 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0 }));
  TEST_UZP2 (vnx8hf,
	     ((vnx8hf) { 4.0, 6.0, 8.0, 10.0, 12.0, 14.0, 16.0, 18.0,
			 34.0, 36.0, 38.0, 40.0, 42.0, 44.0, 46.0, 48.0 }),
	     ((vnx8hf) { 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0,
			 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0 }),
	     ((vnx8hf) { 33.0, 34.0, 35.0, 36.0, 37.0, 38.0, 39.0, 40.0,
			 41.0, 42.0, 43.0, 44.0, 45.0, 46.0, 47.0, 48.0 }));
  return 0;
}
