# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

from aliyunsdkcore.request import RpcRequest
from aliyunsdkopenanalytics_open.endpoint import endpoint_data

class ResetMainPasswordRequest(RpcRequest):

	def __init__(self):
		RpcRequest.__init__(self, 'openanalytics-open', '2018-06-19', 'ResetMainPassword','openanalytics')
		self.set_method('POST')
		if hasattr(self, "endpoint_map"):
			setattr(self, "endpoint_map", endpoint_data.getEndpointMap())
		if hasattr(self, "endpoint_regional"):
			setattr(self, "endpoint_regional", endpoint_data.getEndpointRegional())


	def get_ExternalUid(self):
		return self.get_body_params().get('ExternalUid')

	def set_ExternalUid(self,ExternalUid):
		self.add_body_params('ExternalUid', ExternalUid)

	def get_InitPassword(self):
		return self.get_body_params().get('InitPassword')

	def set_InitPassword(self,InitPassword):
		self.add_body_params('InitPassword', InitPassword)

	def get_ExternalAliyunUid(self):
		return self.get_body_params().get('ExternalAliyunUid')

	def set_ExternalAliyunUid(self,ExternalAliyunUid):
		self.add_body_params('ExternalAliyunUid', ExternalAliyunUid)

	def get_UseRandomPassword(self):
		return self.get_body_params().get('UseRandomPassword')

	def set_UseRandomPassword(self,UseRandomPassword):
		self.add_body_params('UseRandomPassword', UseRandomPassword)

	def get_EnableKMS(self):
		return self.get_body_params().get('EnableKMS')

	def set_EnableKMS(self,EnableKMS):
		self.add_body_params('EnableKMS', EnableKMS)

	def get_ExternalBizAliyunUid(self):
		return self.get_body_params().get('ExternalBizAliyunUid')

	def set_ExternalBizAliyunUid(self,ExternalBizAliyunUid):
		self.add_body_params('ExternalBizAliyunUid', ExternalBizAliyunUid)