# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import datetime
from io import IOBase
from typing import Any, AsyncIterable, Callable, Dict, IO, Optional, TypeVar, Union, overload
import urllib.parse

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._chat_operations import (
    build_create_chat_thread_request,
    build_delete_chat_thread_request,
    build_list_chat_threads_request,
)

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class ChatOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.communication.chat.aio.AzureCommunicationChatService`'s
        :attr:`chat` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @overload
    async def create_chat_thread(
        self,
        create_chat_thread_request: _models.CreateChatThreadRequest,
        repeatability_request_id: Optional[str] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CreateChatThreadResult:
        """Creates a chat thread.

        Creates a chat thread.

        :param create_chat_thread_request: Request payload for creating a chat thread. Required.
        :type create_chat_thread_request: ~azure.communication.chat.models.CreateChatThreadRequest
        :param repeatability_request_id: If specified, the client directs that the request is
         repeatable; that is, that the client can make the request multiple times with the same
         Repeatability-Request-Id and get back an appropriate response without the server executing the
         request multiple times. The value of the Repeatability-Request-Id is an opaque string
         representing a client-generated, globally unique for all time, identifier for the request. It
         is recommended to use version 4 (random) UUIDs. Default value is None.
        :type repeatability_request_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CreateChatThreadResult or the result of cls(response)
        :rtype: ~azure.communication.chat.models.CreateChatThreadResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_chat_thread(
        self,
        create_chat_thread_request: IO,
        repeatability_request_id: Optional[str] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.CreateChatThreadResult:
        """Creates a chat thread.

        Creates a chat thread.

        :param create_chat_thread_request: Request payload for creating a chat thread. Required.
        :type create_chat_thread_request: IO
        :param repeatability_request_id: If specified, the client directs that the request is
         repeatable; that is, that the client can make the request multiple times with the same
         Repeatability-Request-Id and get back an appropriate response without the server executing the
         request multiple times. The value of the Repeatability-Request-Id is an opaque string
         representing a client-generated, globally unique for all time, identifier for the request. It
         is recommended to use version 4 (random) UUIDs. Default value is None.
        :type repeatability_request_id: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CreateChatThreadResult or the result of cls(response)
        :rtype: ~azure.communication.chat.models.CreateChatThreadResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_chat_thread(
        self,
        create_chat_thread_request: Union[_models.CreateChatThreadRequest, IO],
        repeatability_request_id: Optional[str] = None,
        **kwargs: Any
    ) -> _models.CreateChatThreadResult:
        """Creates a chat thread.

        Creates a chat thread.

        :param create_chat_thread_request: Request payload for creating a chat thread. Is either a
         CreateChatThreadRequest type or a IO type. Required.
        :type create_chat_thread_request: ~azure.communication.chat.models.CreateChatThreadRequest or
         IO
        :param repeatability_request_id: If specified, the client directs that the request is
         repeatable; that is, that the client can make the request multiple times with the same
         Repeatability-Request-Id and get back an appropriate response without the server executing the
         request multiple times. The value of the Repeatability-Request-Id is an opaque string
         representing a client-generated, globally unique for all time, identifier for the request. It
         is recommended to use version 4 (random) UUIDs. Default value is None.
        :type repeatability_request_id: str
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CreateChatThreadResult or the result of cls(response)
        :rtype: ~azure.communication.chat.models.CreateChatThreadResult
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.CommunicationErrorResponse, response)
            ),
            403: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.CommunicationErrorResponse, response)
            ),
            429: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.CommunicationErrorResponse, response)
            ),
            503: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.CommunicationErrorResponse, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.CreateChatThreadResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(create_chat_thread_request, (IOBase, bytes)):
            _content = create_chat_thread_request
        else:
            _json = self._serialize.body(create_chat_thread_request, "CreateChatThreadRequest")

        _request = build_create_chat_thread_request(
            repeatability_request_id=repeatability_request_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = self._deserialize("CreateChatThreadResult", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def list_chat_threads(
        self, max_page_size: Optional[int] = None, start_time: Optional[datetime.datetime] = None, **kwargs: Any
    ) -> AsyncIterable["_models.ChatThreadItem"]:
        """Gets the list of chat threads of a user.

        Gets the list of chat threads of a user.

        :param max_page_size: The maximum number of chat threads returned per page. Default value is
         None.
        :type max_page_size: int
        :param start_time: The earliest point in time to get chat threads up to. The timestamp should
         be in RFC3339 format: ``yyyy-MM-ddTHH:mm:ssZ``. Default value is None.
        :type start_time: ~datetime.datetime
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either ChatThreadItem or the result of cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.communication.chat.models.ChatThreadItem]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.ChatThreadsItemCollection] = kwargs.pop("cls", None)

        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.CommunicationErrorResponse, response)
            ),
            403: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.CommunicationErrorResponse, response)
            ),
            429: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.CommunicationErrorResponse, response)
            ),
            503: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.CommunicationErrorResponse, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_chat_threads_request(
                    max_page_size=max_page_size,
                    start_time=start_time,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request = _convert_request(_request)
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request = _convert_request(_request)
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                _request.url = self._client.format_url(_request.url, **path_format_arguments)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("ChatThreadsItemCollection", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def delete_chat_thread(  # pylint: disable=inconsistent-return-statements
        self, chat_thread_id: str, **kwargs: Any
    ) -> None:
        """Deletes a thread.

        Deletes a thread.

        :param chat_thread_id: Id of the thread to be deleted. Required.
        :type chat_thread_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
            401: lambda response: ClientAuthenticationError(
                response=response, model=self._deserialize(_models.CommunicationErrorResponse, response)
            ),
            403: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.CommunicationErrorResponse, response)
            ),
            429: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.CommunicationErrorResponse, response)
            ),
            503: lambda response: HttpResponseError(
                response=response, model=self._deserialize(_models.CommunicationErrorResponse, response)
            ),
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_delete_chat_thread_request(
            chat_thread_id=chat_thread_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request = _convert_request(_request)
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore
