/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.drivers;

import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.spi.KeyGenerator;
import org.exolab.castor.persist.spi.PersistenceFactory;
import org.exolab.castor.util.Messages;

public final class IdentityKeyGenerator
implements KeyGenerator {
    private final int _sqlType;
    private final String _fName;

    public IdentityKeyGenerator(PersistenceFactory factory, int sqlType) throws MappingException {
        String fName = factory.getFactoryName();
        if (!(fName.equals("sybase") || fName.equals("sql-server") || fName.equals("hsql") || fName.equals("mysql") || fName.equals("informix") || fName.equals("db2"))) {
            throw new MappingException(Messages.format("mapping.keyGenNotCompatible", this.getClass().getName(), fName));
        }
        this._fName = fName;
        this._sqlType = sqlType;
        if (sqlType != 4 && sqlType != 2 && sqlType != 3 && sqlType != -5) {
            throw new MappingException(Messages.format("mapping.keyGenSQLType", this.getClass().getName(), new Integer(sqlType)));
        }
        if (sqlType != 4 && this._fName.equals("hsql")) {
            throw new MappingException(Messages.format("mapping.keyGenSQLType", this.getClass().getName(), new Integer(sqlType)));
        }
    }

    public Object generateKey(Connection conn, String tableName, String primKeyName, Properties props) throws PersistenceException {
        Statement stmt;
        block20: {
            BigDecimal bigDecimal;
            block25: {
                int value;
                block23: {
                    Long l;
                    block24: {
                        block21: {
                            Integer n;
                            block22: {
                                ResultSet rs;
                                stmt = null;
                                if (this._fName.equals("hsql")) {
                                    CallableStatement cstmt = conn.prepareCall("{call IDENTITY()}");
                                    stmt = cstmt;
                                    cstmt.execute();
                                    rs = cstmt.getResultSet();
                                } else if (this._fName.equals("mysql")) {
                                    stmt = conn.prepareStatement("SELECT LAST_INSERT_ID()");
                                    rs = stmt.executeQuery();
                                } else if (this._fName.equals("informix")) {
                                    stmt = conn.prepareStatement("select dbinfo('sqlca.sqlerrd1') from systables where tabid = 1");
                                    rs = stmt.executeQuery();
                                } else if (this._fName.equals("db2")) {
                                    stmt = conn.prepareStatement("SELECT IDENTITY_VAL_LOCAL() FROM " + tableName + " FETCH FIRST ROW ONLY");
                                    rs = stmt.executeQuery();
                                } else {
                                    stmt = conn.prepareStatement("SELECT @@identity");
                                    rs = stmt.executeQuery();
                                }
                                if (!rs.next()) break block20;
                                value = rs.getInt(1);
                                if (this._sqlType != 4) break block21;
                                n = new Integer(value);
                                Object var10_13 = null;
                                if (stmt == null) break block22;
                                try {
                                    stmt.close();
                                }
                                catch (SQLException ex) {
                                    // empty catch block
                                }
                            }
                            return n;
                        }
                        if (this._sqlType != -5) break block23;
                        l = new Long(value);
                        Object var10_14 = null;
                        if (stmt == null) break block24;
                        try {
                            stmt.close();
                        }
                        catch (SQLException ex) {
                            // empty catch block
                        }
                    }
                    return l;
                }
                bigDecimal = new BigDecimal((double)value);
                Object var10_15 = null;
                if (stmt == null) break block25;
                try {
                    stmt.close();
                }
                catch (SQLException ex) {
                    // empty catch block
                }
            }
            return bigDecimal;
        }
        try {
            try {
                throw new PersistenceException(Messages.message("persist.keyGenFailed"));
            }
            catch (SQLException ex) {
                throw new PersistenceException(Messages.format("persist.keyGenSQL", ex.toString()));
            }
        }
        catch (Throwable throwable) {
            block26: {
                Object var10_16 = null;
                if (stmt == null) break block26;
                try {
                    stmt.close();
                }
                catch (SQLException ex) {}
            }
            throw throwable;
        }
    }

    public final byte getStyle() {
        return 1;
    }

    public final String patchSQL(String insert, String primKeyName) throws MappingException {
        return insert;
    }

    public boolean isInSameConnection() {
        return true;
    }
}

