/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ftp.ftp2.parser;

import java.util.Calendar;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.ftp2.FTPFileEntryParser;
import org.apache.commons.net.ftp.ftp2.parser.MatchApparatus;

public class VMSFTPEntryParser
extends MatchApparatus
implements FTPFileEntryParser {
    private String prefix = "[" + this.getClass().getName() + "] ";
    private boolean versioning;
    private static final String MONTHS = "(JAN|FEB|MAR|APR|MAY|JUN|JUL|AUG|SEP|OCT|NOV|DEC)";
    private static final String REGEX = "(.*;[0-9]+)\\s*(\\d+)/\\d+\\s*(\\d{1,2})-(JAN|FEB|MAR|APR|MAY|JUN|JUL|AUG|SEP|OCT|NOV|DEC)-([0-9]{4})\\s*((?:[01]\\d)|(?:2[0-3])):([012345]\\d):([012345]\\d)\\s*\\[([0-9$A-Za-z_]+),([0-9$a-zA-Z_]+)\\]\\s*(\\([a-zA-Z]*,[a-zA-Z]*,[a-zA-Z]*,[a-zA-Z]*\\))";

    public VMSFTPEntryParser() {
        this(false);
    }

    public VMSFTPEntryParser(boolean versioning) {
        super(REGEX);
        this.versioning = versioning;
    }

    public FTPFile parseFTPEntry(String entry) {
        Integer oneBlock = new Integer(512);
        int intBlock = oneBlock;
        long longBlock = 512L;
        if (this.matches(entry)) {
            FTPFile f = new FTPFile();
            f.setRawListing(entry);
            String name = this.group(1);
            String size = this.group(2);
            String day = this.group(3);
            String mo = this.group(4);
            String yr = this.group(5);
            String hr = this.group(6);
            String min = this.group(7);
            String sec = this.group(8);
            String grp = this.group(9);
            String owner = this.group(10);
            if (name.lastIndexOf(".DIR") != -1) {
                f.setType(1);
            } else {
                f.setType(0);
            }
            if (this.versioning) {
                f.setName(name);
            } else {
                name = name.substring(0, name.lastIndexOf(";"));
                f.setName(name);
            }
            Long theSize = new Long(size);
            long sizeInBytes = theSize * longBlock;
            f.setSize(sizeInBytes);
            Calendar cal = Calendar.getInstance();
            cal.clear();
            cal.set(5, new Integer(day));
            cal.set(2, MONTHS.indexOf(mo) / 4);
            cal.set(1, new Integer(yr));
            cal.set(11, new Integer(hr));
            cal.set(12, new Integer(min));
            cal.set(13, new Integer(sec));
            f.setTimestamp(cal);
            f.setGroup(grp);
            f.setUser(owner);
            return f;
        }
        return null;
    }
}

