/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.raster;

import com.sun.jimi.core.JimiImage;
import com.sun.jimi.core.raster.ByteRasterImage;
import com.sun.jimi.core.raster.JimiRasterImage;
import com.sun.jimi.core.raster.LongRasterImage;
import com.sun.jimi.core.util.JimiUtil;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;

public class JimiRasterImageCategorizer {
    public static boolean isBytePaletteImage(JimiImage jimiImage) {
        return JimiRasterImageCategorizer.isPaletteImage(jimiImage = JimiUtil.asJimiRasterImage(jimiImage)) && jimiImage instanceof ByteRasterImage;
    }

    public static boolean isGrayscaleImage(JimiImage jimiImage) {
        JimiRasterImage jimiRasterImage = JimiUtil.asJimiRasterImage(jimiImage);
        if (jimiRasterImage.getColorModel() instanceof DirectColorModel) {
            DirectColorModel directColorModel = (DirectColorModel)jimiRasterImage.getColorModel();
            return directColorModel.getRedMask() == directColorModel.getGreenMask() && directColorModel.getRedMask() == directColorModel.getBlueMask();
        }
        return false;
    }

    public static boolean isLongRasterImage(JimiImage jimiImage) {
        jimiImage = JimiUtil.asJimiRasterImage(jimiImage);
        return jimiImage instanceof LongRasterImage;
    }

    public static boolean isMonoColorImage(JimiImage jimiImage) {
        return JimiRasterImageCategorizer.isBytePaletteImage(jimiImage) && ((IndexColorModel)((JimiRasterImage)jimiImage).getColorModel()).getMapSize() == 2;
    }

    public static boolean isPaletteImage(JimiImage jimiImage) {
        jimiImage = JimiUtil.asJimiRasterImage(jimiImage);
        return ((JimiRasterImage)jimiImage).getColorModel() instanceof IndexColorModel;
    }
}

