/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.servletunit;

import com.meterware.servletunit.DispatchedRequestWrapper;
import com.meterware.servletunit.RequestDispatcherImpl;
import java.util.Hashtable;
import javax.servlet.RequestDispatcher;
import javax.servlet.http.HttpServletRequest;

class IncludeRequestWrapper
extends DispatchedRequestWrapper {
    static final String REQUEST_URI = "javax.servlet.include.request_uri";
    static final String CONTEXT_PATH = "javax.servlet.include.context_path";
    static final String SERVLET_PATH = "javax.servlet.include.servlet_path";
    static final String PATH_INFO = "javax.servlet.include.path_info";
    static final String QUERY_STRING = "javax.servlet.include.query_string";
    private Hashtable _attributes = new Hashtable();

    IncludeRequestWrapper(HttpServletRequest request, RequestDispatcher dispatcher) {
        super(request, dispatcher);
        this._attributes.put(REQUEST_URI, ((RequestDispatcherImpl)dispatcher).getRequestURI());
        this._attributes.put(CONTEXT_PATH, request.getContextPath());
        this._attributes.put(SERVLET_PATH, ((RequestDispatcherImpl)dispatcher).getServletMetaData().getServletPath());
        String pathInfo = ((RequestDispatcherImpl)dispatcher).getServletMetaData().getPathInfo();
        if (pathInfo != null) {
            this._attributes.put(PATH_INFO, pathInfo);
        }
    }

    public Object getAttribute(String s) {
        Object result = this._attributes.get(s);
        return result != null ? result : super.getAttribute(s);
    }

    static {
        REQUEST_URI = REQUEST_URI;
        CONTEXT_PATH = CONTEXT_PATH;
        SERVLET_PATH = SERVLET_PATH;
        PATH_INFO = PATH_INFO;
        QUERY_STRING = QUERY_STRING;
    }
}

