/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jsse;

import com.ibm.jsse.JSSEContext;
import com.ibm.jsse.JSSEInputStream;
import com.ibm.jsse.JSSEOutputStream;
import com.ibm.jsse.JSSESession;
import com.ibm.sslite.b;
import com.ibm.sslite.c;
import com.ibm.sslite.s;
import com.ibm.sslite.t;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Vector;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;

final class JSSESocket
extends SSLSocket {
    JSSESession session;
    boolean autoClose = true;
    boolean enableSessionCreation = true;
    boolean clientRole = true;
    private Vector handshakeListeners;
    private JSSEOutputStream output;
    private JSSEInputStream input;
    private JSSEContext context;
    Socket sock;
    b ssliteSocket;
    static final String[] alertCodes = new String[]{null, null, null, null, null, null, null, null, null, "unexpected message", null, null, null, null, null, null, null, null, null, "bad record MAC", "decryption failed", "record overflow", null, null, null, null, null, null, null, "decompression failure", null, null, null, null, null, null, null, null, null, "handshake failure", "no certificate", "bad certificate", "unsupported certificate", "certificate revoked", "certificate expired", "unknown certificate", "illegal parameter", "unknown CA", "access denied", "decode error", "decrypt error", null, null, null, null, null, null, null, null, "export restriction", null, null, null, null, null, null, null, null, null, "protocol version", "insufficient security", null, null, null, null, null, null, null, null, "internal error", null, null, null, null, null, null, null, null, null, "user canceled"};

    public synchronized void startHandshake() throws IOException {
        if (this.ssliteSocket == null) {
            this.install();
            return;
        }
        this.ssliteSocket.a(this.context);
    }

    public synchronized void setUseClientMode(boolean bl) {
        if (this.ssliteSocket == null) {
            this.clientRole = bl;
        }
    }

    public void setTcpNoDelay(boolean bl) throws SocketException {
        this.sock.setTcpNoDelay(bl);
    }

    public synchronized void setSoTimeout(int n2) throws SocketException {
        if (this.ssliteSocket != null) {
            this.ssliteSocket.setSoTimeout(n2);
        } else {
            this.sock.setSoTimeout(n2);
        }
    }

    public void setSoLinger(boolean bl, int n2) throws SocketException {
        this.sock.setSoLinger(bl, n2);
    }

    public synchronized void setNeedClientAuth(boolean bl) {
        this.context.q = bl;
    }

    public void setEnabledCipherSuites(String[] stringArray) {
        this.context.setEnabledCipherSuites(stringArray);
    }

    public synchronized void setEnableSessionCreation(boolean bl) {
        this.enableSessionCreation = bl;
    }

    public void removeHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        if (this.handshakeListeners == null) {
            throw new IllegalArgumentException("no listeners");
        }
        if (!this.handshakeListeners.removeElement(handshakeCompletedListener)) {
            throw new IllegalArgumentException("listener not registered");
        }
        if (this.handshakeListeners.isEmpty()) {
            this.handshakeListeners = null;
        }
    }

    synchronized void install() throws IOException {
        if (this.ssliteSocket == null) {
            try {
                this.ssliteSocket = new b(this.sock, this.autoClose ^ true, (t)this.context, !this.clientRole, (Object)this);
            }
            catch (s s2) {
                if (s2.a == 1 || s2.a == 2) {
                    throw new SSLHandshakeException(s2.e < 1 || s2.e > alertCodes.length ? "<unknown>" : alertCodes[s2.e - 1]);
                }
                if (s2.a == 4) {
                    throw new SSLProtocolException("end of file");
                }
                throw new SSLProtocolException("timeout");
            }
        }
    }

    boolean handshakeCompleted(c c2) {
        int n2;
        if (this.session == null || this.session.ssliteSession != c2) {
            this.session = (this.clientRole ? this.context.clientCache : this.context.serverCache).create(c2);
        }
        if (this.handshakeListeners != null && (n2 = this.handshakeListeners.size()) > 0) {
            HandshakeCompletedEvent handshakeCompletedEvent = new HandshakeCompletedEvent(this, this.session);
            int n3 = 0;
            do {
                ((HandshakeCompletedListener)this.handshakeListeners.elementAt(n3)).handshakeCompleted(handshakeCompletedEvent);
            } while (++n3 < n2);
        }
        return true;
    }

    public synchronized boolean getUseClientMode() {
        return this.clientRole;
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this.sock.getTcpNoDelay();
    }

    public String[] getSupportedCipherSuites() {
        return this.context.getSupportedCipherSuites();
    }

    public synchronized int getSoTimeout() throws SocketException {
        return this.ssliteSocket != null ? this.ssliteSocket.getSoTimeout() : this.sock.getSoTimeout();
    }

    public int getSoLinger() throws SocketException {
        return this.sock.getSoLinger();
    }

    public synchronized SSLSession getSession() {
        try {
            this.install();
        }
        catch (IOException iOException) {}
        return this.session;
    }

    public int getPort() {
        return this.sock.getPort();
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        return this.output == null ? (this.output = new JSSEOutputStream(this)) : this.output;
    }

    public synchronized boolean getNeedClientAuth() {
        return this.context.q;
    }

    public int getLocalPort() {
        return this.sock.getLocalPort();
    }

    public InetAddress getLocalAddress() {
        return this.sock.getLocalAddress();
    }

    public synchronized InputStream getInputStream() throws IOException {
        return this.input == null ? (this.input = new JSSEInputStream(this)) : this.input;
    }

    public InetAddress getInetAddress() {
        return this.sock.getInetAddress();
    }

    public String[] getEnabledCipherSuites() {
        return this.context.a();
    }

    public synchronized boolean getEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    public synchronized void close() throws IOException {
        if (this.ssliteSocket != null) {
            this.ssliteSocket.close();
        } else if (this.autoClose) {
            this.sock.close();
        }
    }

    public void addHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        if (this.handshakeListeners == null) {
            this.handshakeListeners = new Vector(1, 2);
        }
        this.handshakeListeners.addElement(handshakeCompletedListener);
    }

    JSSESocket(Socket socket, String string, int n2, JSSEContext jSSEContext, boolean bl) throws IOException {
        this.sock = socket;
        this.context = jSSEContext;
        this.autoClose = bl;
    }

    JSSESocket(Socket socket, JSSEContext jSSEContext, boolean bl, boolean bl2) throws IOException {
        this.sock = socket;
        this.context = jSSEContext;
        this.clientRole = bl;
        this.enableSessionCreation = bl2;
    }

    JSSESocket(InetAddress inetAddress, int n2, InetAddress inetAddress2, int n3, JSSEContext jSSEContext) throws UnknownHostException, IOException {
        this.sock = new Socket(inetAddress, n2, inetAddress2, n3);
        this.context = jSSEContext;
    }

    JSSESocket(InetAddress inetAddress, int n2, JSSEContext jSSEContext) throws UnknownHostException, IOException {
        this.sock = new Socket(inetAddress, n2);
        this.context = jSSEContext;
    }

    JSSESocket(String string, int n2, InetAddress inetAddress, int n3, JSSEContext jSSEContext) throws UnknownHostException, IOException {
        this.sock = new Socket(string, n2, inetAddress, n3);
        this.context = jSSEContext;
    }

    JSSESocket(String string, int n2, JSSEContext jSSEContext) throws UnknownHostException, IOException {
        this.sock = new Socket(string, n2);
        this.context = jSSEContext;
    }
}

