/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.joran.spi;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.joran.spi.Interpreter;
import org.apache.log4j.spi.ErrorItem;
import org.xml.sax.Locator;

public class ExecutionContext {
    Stack objectStack;
    Map objectMap;
    Vector errorList;
    Properties substitutionProperties;
    Interpreter joranInterpreter;

    public ExecutionContext(Interpreter joranInterpreter) {
        this.joranInterpreter = joranInterpreter;
        this.objectStack = new Stack();
        this.objectMap = new HashMap(5);
        this.errorList = new Vector();
        this.substitutionProperties = new Properties();
    }

    public void addError(ErrorItem errorItem) {
        Locator locator = this.joranInterpreter.getLocator();
        if (locator != null) {
            errorItem.setLineNumber(locator.getLineNumber());
            errorItem.setColNumber(locator.getColumnNumber());
        }
        this.errorList.add(errorItem);
    }

    public List getErrorList() {
        return this.errorList;
    }

    public Locator getLocator() {
        return this.joranInterpreter.getLocator();
    }

    public Interpreter getJoranInterpreter() {
        return this.joranInterpreter;
    }

    public Stack getObjectStack() {
        return this.objectStack;
    }

    public Object peekObject() {
        return this.objectStack.peek();
    }

    public void pushObject(Object o) {
        this.objectStack.push(o);
    }

    public Object popObject() {
        return this.objectStack.pop();
    }

    public Object getObject(int i) {
        return this.objectStack.get(i);
    }

    public Map getObjectMap() {
        return this.objectMap;
    }

    public void addProperty(String key, String value) {
        if (key == null || value == null) {
            return;
        }
        value = value.trim();
        this.substitutionProperties.put(key, value);
    }

    public void addProperties(Properties props) {
        if (props == null) {
            return;
        }
        Iterator<Object> i = props.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            this.addProperty(key, props.getProperty(key));
        }
    }

    public String getSubstitutionProperty(String key) {
        return this.substitutionProperties.getProperty(key);
    }

    public String subst(String value) {
        if (value == null) {
            return null;
        }
        return OptionConverter.substVars(value, this.substitutionProperties);
    }
}

