<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0">

<!-- Aug 2010 one-off conversion from old documentation format to new -->

<xsl:output method="xml" indent="yes" cdata-section-elements="example" 
    saxon:suppress-indentation="p"
    saxon:double-space="page subpage p"
    xmlns:saxon="http://saxon.sf.net/"/>
<xsl:strip-space elements="*"/>
<xsl:preserve-space elements="p"/>

<xsl:template match="cat:section" xmlns:cat="http://www.saxonica.com/ns/doc/catalog">
    <xsl:result-document href="src/{@ref}.xml">
        <xsl:apply-templates select="doc(concat(@ref, '.xml'))"/>
    </xsl:result-document>
</xsl:template>

<xsl:template match="cat:section[@ref='functions']" xmlns:cat="http://www.saxonica.com/ns/doc/catalog"/>

<xsl:template match="*">
  <xsl:copy copy-namespaces="no">
    <xsl:copy-of select="@*"/>
    <xsl:apply-templates/>
  </xsl:copy>
</xsl:template>

<xsl:template match="html">
  <section xml:id="{@section}">
    <title><xsl:value-of select="head/title"/></title>
    <xsl:apply-templates/>
  </section>
</xsl:template>

<xsl:template match="head | h1"/>

<xsl:template match="h3">
    <subtitle><xsl:value-of select="."/></subtitle>
</xsl:template>

<xsl:template match="body">
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="page">
  <page xml:id="{h2/@id}">
    <xsl:copy-of select="@* except @id"/>
    <title><xsl:copy-of select="h2/node()"/></title>
    <xsl:apply-templates select="node() except h2"/>
  </page>
</xsl:template>

<xsl:template match="subpage">
  <subpage xml:id="{@id}">
    <xsl:copy-of select="@* except (@id, @title)"/>
    <title><xsl:value-of select="@title"/></title>
    <xsl:apply-templates/>
  </subpage>
</xsl:template>

<xsl:template match="li[p[count(../*)=1]]">
  <li content="para">  
    <xsl:apply-templates select="p/node()"/>
  </li>
</xsl:template>

<xsl:template match="td[p[every $td
                          in ancestor::table//td
                                [count(preceding-sibling::td) = count(current()/../preceding-sibling::td)]
                          satisfies count($td/*)=1]]">
  <td content="para">                        
    <xsl:apply-templates select="p/node()"/>
  </td>
</xsl:template>

</xsl:stylesheet>