; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mattr=+shstk | FileCheck %s

define void @test_incsspd(i32 %a) local_unnamed_addr {
; CHECK-LABEL: test_incsspd:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    incsspd %edi
; CHECK-NEXT:    retq
entry:
  tail call void @llvm.x86.incsspd(i32 %a)
  ret void
}

declare void @llvm.x86.incsspd(i32)

define void @test_incsspq(i32 %a) local_unnamed_addr {
; CHECK-LABEL: test_incsspq:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    movslq %edi, %rax
; CHECK-NEXT:    incsspq %rax
; CHECK-NEXT:    retq
entry:
  %conv.i = sext i32 %a to i64
  tail call void @llvm.x86.incsspq(i64 %conv.i)
  ret void
}

declare void @llvm.x86.incsspq(i64)

define i32 @test_rdsspd(i32 %a) {
; CHECK-LABEL: test_rdsspd:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    rdsspd %edi
; CHECK-NEXT:    movl %edi, %eax
; CHECK-NEXT:    retq
entry:
  %0 = call i32 @llvm.x86.rdsspd(i32 %a)
  ret i32 %0
}

declare i32 @llvm.x86.rdsspd(i32)

define i64 @test_rdsspq(i64 %a) {
; CHECK-LABEL: test_rdsspq:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    rdsspq %rdi
; CHECK-NEXT:    movq %rdi, %rax
; CHECK-NEXT:    retq
entry:
  %0 = call i64 @llvm.x86.rdsspq(i64 %a)
  ret i64 %0
}

declare i64 @llvm.x86.rdsspq(i64)

define void @test_saveprevssp() {
; CHECK-LABEL: test_saveprevssp:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    saveprevssp
; CHECK-NEXT:    retq
entry:
  tail call void @llvm.x86.saveprevssp()
  ret void
}

declare void @llvm.x86.saveprevssp()

define void @test_rstorssp(i8* %__p) {
; CHECK-LABEL: test_rstorssp:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    rstorssp (%rdi)
; CHECK-NEXT:    retq
entry:
  tail call void @llvm.x86.rstorssp(i8* %__p)
  ret void
}

declare void @llvm.x86.rstorssp(i8*)

define void @test_wrssd(i32 %a, i8* %__p) {
; CHECK-LABEL: test_wrssd:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    wrssd %edi, (%rsi)
; CHECK-NEXT:    retq
entry:
  tail call void @llvm.x86.wrssd(i32 %a, i8* %__p)
  ret void
}

declare void @llvm.x86.wrssd(i32, i8*)

define void @test_wrssq(i64 %a, i8* %__p) {
; CHECK-LABEL: test_wrssq:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    wrssq %rdi, (%rsi)
; CHECK-NEXT:    retq
entry:
  tail call void @llvm.x86.wrssq(i64 %a, i8* %__p)
  ret void
}

declare void @llvm.x86.wrssq(i64, i8*)

define void @test_wrussd(i32 %a, i8* %__p) {
; CHECK-LABEL: test_wrussd:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    wrussd %edi, (%rsi)
; CHECK-NEXT:    retq
entry:
  tail call void @llvm.x86.wrussd(i32 %a, i8* %__p)
  ret void
}

declare void @llvm.x86.wrussd(i32, i8*)

define void @test_wrussq(i64 %a, i8* %__p) {
; CHECK-LABEL: test_wrussq:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    wrussq %rdi, (%rsi)
; CHECK-NEXT:    retq
entry:
  tail call void @llvm.x86.wrussq(i64 %a, i8* %__p)
  ret void
}

declare void @llvm.x86.wrussq(i64, i8*)

define void @test_setssbsy() {
; CHECK-LABEL: test_setssbsy:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    setssbsy
; CHECK-NEXT:    retq
entry:
  tail call void @llvm.x86.setssbsy()
  ret void
}

declare void @llvm.x86.setssbsy()

define void @test_clrssbsy(i8* %__p) {
; CHECK-LABEL: test_clrssbsy:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    clrssbsy (%rdi)
; CHECK-NEXT:    retq
entry:
  tail call void @llvm.x86.clrssbsy(i8* %__p)
  ret void
}

declare void @llvm.x86.clrssbsy(i8* %__p)
