// Copyright 2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License"). You may not
// use this file except in compliance with the License. A copy of the
// License is located at
//
// http://aws.amazon.com/apache2.0/
//
// or in the "license" file accompanying this file. This file is distributed
// on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
// either express or implied. See the License for the specific language governing
// permissions and limitations under the License.

// Code generated by mockery v1.0.0
package mocks

import (
	time "time"

	context "github.com/aws/amazon-ssm-agent/agent/context"
	log "github.com/aws/amazon-ssm-agent/agent/log"
	v4 "github.com/aws/aws-sdk-go/aws/signer/v4"
	mock "github.com/stretchr/testify/mock"
)

// IWebSocketChannel is an autogenerated mock type for the IWebSocketChannel type
type IWebSocketChannel struct {
	mock.Mock
}

// Close provides a mock function with given fields: _a0
func (_m *IWebSocketChannel) Close(_a0 log.T) error {
	ret := _m.Called(_a0)

	var r0 error
	if rf, ok := ret.Get(0).(func(log.T) error); ok {
		r0 = rf(_a0)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// GetChannelToken provides a mock function with given fields:
func (_m *IWebSocketChannel) GetChannelToken() string {
	ret := _m.Called()

	var r0 string
	if rf, ok := ret.Get(0).(func() string); ok {
		r0 = rf()
	} else {
		r0 = ret.Get(0).(string)
	}

	return r0
}

// Initialize provides a mock function with given fields: _a0, channelId, channelType, channelRole, channelToken, region, signer, onMessageHandler, onErrorHandler
func (_m *IWebSocketChannel) Initialize(_a0 context.T, channelId string, channelType string, channelRole string, channelToken string, region string, signer *v4.Signer, onMessageHandler func([]byte), onErrorHandler func(error)) error {
	ret := _m.Called(_a0, channelId, channelType, channelRole, channelToken, region, signer, onMessageHandler, onErrorHandler)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.T, string, string, string, string, string, *v4.Signer, func([]byte), func(error)) error); ok {
		r0 = rf(_a0, channelId, channelType, channelRole, channelToken, region, signer, onMessageHandler, onErrorHandler)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// Open provides a mock function with given fields: _a0
func (_m *IWebSocketChannel) Open(_a0 log.T) error {
	ret := _m.Called(_a0)

	var r0 error
	if rf, ok := ret.Get(0).(func(log.T) error); ok {
		r0 = rf(_a0)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// SendMessage provides a mock function with given fields: _a0, input, inputType
func (_m *IWebSocketChannel) SendMessage(_a0 log.T, input []byte, inputType int) error {
	ret := _m.Called(_a0, input, inputType)

	var r0 error
	if rf, ok := ret.Get(0).(func(log.T, []byte, int) error); ok {
		r0 = rf(_a0, input, inputType)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// SetChannelToken provides a mock function with given fields: token
func (_m *IWebSocketChannel) SetChannelToken(token string) {
	_m.Called(token)
}

// SetSubProtocol provides a mock function with given fields: subProtocol
func (_m *IWebSocketChannel) SetSubProtocol(subProtocol string) {
	_m.Called(subProtocol)
}

// SetUrl provides a mock function with given fields: url
func (_m *IWebSocketChannel) SetUrl(url string) {
	_m.Called(url)
}

// StartPings provides a mock function with given fields: _a0, pingInterval
func (_m *IWebSocketChannel) StartPings(_a0 log.T, pingInterval time.Duration) {
	_m.Called(_a0, pingInterval)
}
