// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`CreateTokenWithIAM`](crate::operation::create_token_with_iam::builders::CreateTokenWithIAMFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_id(impl Into<String>)`](crate::operation::create_token_with_iam::builders::CreateTokenWithIAMFluentBuilder::client_id) / [`set_client_id(Option<String>)`](crate::operation::create_token_with_iam::builders::CreateTokenWithIAMFluentBuilder::set_client_id):<br>required: **true**<br><p>The unique identifier string for the client or application. This value is an application ARN that has OAuth grants configured.</p><br>
    ///   - [`grant_type(impl Into<String>)`](crate::operation::create_token_with_iam::builders::CreateTokenWithIAMFluentBuilder::grant_type) / [`set_grant_type(Option<String>)`](crate::operation::create_token_with_iam::builders::CreateTokenWithIAMFluentBuilder::set_grant_type):<br>required: **true**<br><p>Supports the following OAuth grant types: Authorization Code, Refresh Token, JWT Bearer, and Token Exchange. Specify one of the following values, depending on the grant type that you want:</p> <p>* Authorization Code - <code>authorization_code</code></p> <p>* Refresh Token - <code>refresh_token</code></p> <p>* JWT Bearer - <code>urn:ietf:params:oauth:grant-type:jwt-bearer</code></p> <p>* Token Exchange - <code>urn:ietf:params:oauth:grant-type:token-exchange</code></p><br>
    ///   - [`code(impl Into<String>)`](crate::operation::create_token_with_iam::builders::CreateTokenWithIAMFluentBuilder::code) / [`set_code(Option<String>)`](crate::operation::create_token_with_iam::builders::CreateTokenWithIAMFluentBuilder::set_code):<br>required: **false**<br><p>Used only when calling this API for the Authorization Code grant type. This short-term code is used to identify this authorization request. The code is obtained through a redirect from IAM Identity Center to a redirect URI persisted in the Authorization Code GrantOptions for the application.</p><br>
    ///   - [`refresh_token(impl Into<String>)`](crate::operation::create_token_with_iam::builders::CreateTokenWithIAMFluentBuilder::refresh_token) / [`set_refresh_token(Option<String>)`](crate::operation::create_token_with_iam::builders::CreateTokenWithIAMFluentBuilder::set_refresh_token):<br>required: **false**<br><p>Used only when calling this API for the Refresh Token grant type. This token is used to refresh short-term tokens, such as the access token, that might expire.</p> <p>For more information about the features and limitations of the current IAM Identity Center OIDC implementation, see <i>Considerations for Using this Guide</i> in the <a href="https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/Welcome.html">IAM Identity Center OIDC API Reference</a>.</p><br>
    ///   - [`assertion(impl Into<String>)`](crate::operation::create_token_with_iam::builders::CreateTokenWithIAMFluentBuilder::assertion) / [`set_assertion(Option<String>)`](crate::operation::create_token_with_iam::builders::CreateTokenWithIAMFluentBuilder::set_assertion):<br>required: **false**<br><p>Used only when calling this API for the JWT Bearer grant type. This value specifies the JSON Web Token (JWT) issued by a trusted token issuer. To authorize a trusted token issuer, configure the JWT Bearer GrantOptions for the application.</p><br>
    ///   - [`scope(impl Into<String>)`](crate::operation::create_token_with_iam::builders::CreateTokenWithIAMFluentBuilder::scope) / [`set_scope(Option<Vec::<String>>)`](crate::operation::create_token_with_iam::builders::CreateTokenWithIAMFluentBuilder::set_scope):<br>required: **false**<br><p>The list of scopes for which authorization is requested. The access token that is issued is limited to the scopes that are granted. If the value is not specified, IAM Identity Center authorizes all scopes configured for the application, including the following default scopes: <code>openid</code>, <code>aws</code>, <code>sts:identity_context</code>.</p><br>
    ///   - [`redirect_uri(impl Into<String>)`](crate::operation::create_token_with_iam::builders::CreateTokenWithIAMFluentBuilder::redirect_uri) / [`set_redirect_uri(Option<String>)`](crate::operation::create_token_with_iam::builders::CreateTokenWithIAMFluentBuilder::set_redirect_uri):<br>required: **false**<br><p>Used only when calling this API for the Authorization Code grant type. This value specifies the location of the client or application that has registered to receive the authorization code.</p><br>
    ///   - [`subject_token(impl Into<String>)`](crate::operation::create_token_with_iam::builders::CreateTokenWithIAMFluentBuilder::subject_token) / [`set_subject_token(Option<String>)`](crate::operation::create_token_with_iam::builders::CreateTokenWithIAMFluentBuilder::set_subject_token):<br>required: **false**<br><p>Used only when calling this API for the Token Exchange grant type. This value specifies the subject of the exchange. The value of the subject token must be an access token issued by IAM Identity Center to a different client or application. The access token must have authorized scopes that indicate the requested application as a target audience.</p><br>
    ///   - [`subject_token_type(impl Into<String>)`](crate::operation::create_token_with_iam::builders::CreateTokenWithIAMFluentBuilder::subject_token_type) / [`set_subject_token_type(Option<String>)`](crate::operation::create_token_with_iam::builders::CreateTokenWithIAMFluentBuilder::set_subject_token_type):<br>required: **false**<br><p>Used only when calling this API for the Token Exchange grant type. This value specifies the type of token that is passed as the subject of the exchange. The following value is supported:</p> <p>* Access Token - <code>urn:ietf:params:oauth:token-type:access_token</code></p><br>
    ///   - [`requested_token_type(impl Into<String>)`](crate::operation::create_token_with_iam::builders::CreateTokenWithIAMFluentBuilder::requested_token_type) / [`set_requested_token_type(Option<String>)`](crate::operation::create_token_with_iam::builders::CreateTokenWithIAMFluentBuilder::set_requested_token_type):<br>required: **false**<br><p>Used only when calling this API for the Token Exchange grant type. This value specifies the type of token that the requester can receive. The following values are supported:</p> <p>* Access Token - <code>urn:ietf:params:oauth:token-type:access_token</code></p> <p>* Refresh Token - <code>urn:ietf:params:oauth:token-type:refresh_token</code></p><br>
    /// - On success, responds with [`CreateTokenWithIamOutput`](crate::operation::create_token_with_iam::CreateTokenWithIamOutput) with field(s):
    ///   - [`access_token(Option<String>)`](crate::operation::create_token_with_iam::CreateTokenWithIamOutput::access_token): <p>A bearer token to access AWS accounts and applications assigned to a user.</p>
    ///   - [`token_type(Option<String>)`](crate::operation::create_token_with_iam::CreateTokenWithIamOutput::token_type): <p>Used to notify the requester that the returned token is an access token. The supported token type is <code>Bearer</code>.</p>
    ///   - [`expires_in(i32)`](crate::operation::create_token_with_iam::CreateTokenWithIamOutput::expires_in): <p>Indicates the time in seconds when an access token will expire.</p>
    ///   - [`refresh_token(Option<String>)`](crate::operation::create_token_with_iam::CreateTokenWithIamOutput::refresh_token): <p>A token that, if present, can be used to refresh a previously issued access token that might have expired.</p> <p>For more information about the features and limitations of the current IAM Identity Center OIDC implementation, see <i>Considerations for Using this Guide</i> in the <a href="https://docs.aws.amazon.com/singlesignon/latest/OIDCAPIReference/Welcome.html">IAM Identity Center OIDC API Reference</a>.</p>
    ///   - [`id_token(Option<String>)`](crate::operation::create_token_with_iam::CreateTokenWithIamOutput::id_token): <p>A JSON Web Token (JWT) that identifies the user associated with the issued access token.</p>
    ///   - [`issued_token_type(Option<String>)`](crate::operation::create_token_with_iam::CreateTokenWithIamOutput::issued_token_type): <p>Indicates the type of tokens that are issued by IAM Identity Center. The following values are supported:</p> <p>* Access Token - <code>urn:ietf:params:oauth:token-type:access_token</code></p> <p>* Refresh Token - <code>urn:ietf:params:oauth:token-type:refresh_token</code></p>
    ///   - [`scope(Option<Vec::<String>>)`](crate::operation::create_token_with_iam::CreateTokenWithIamOutput::scope): <p>The list of scopes for which authorization is granted. The access token that is issued is limited to the scopes that are granted.</p>
    /// - On failure, responds with [`SdkError<CreateTokenWithIAMError>`](crate::operation::create_token_with_iam::CreateTokenWithIAMError)
    pub fn create_token_with_iam(&self) -> crate::operation::create_token_with_iam::builders::CreateTokenWithIAMFluentBuilder {
        crate::operation::create_token_with_iam::builders::CreateTokenWithIAMFluentBuilder::new(self.handle.clone())
    }
}
