# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from six import with_metaclass
from azure.core import CaseInsensitiveEnumMeta


class AuthenticationType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Specifies the authentication type being used for connecting to the endpoint. Defaults to
    'KeyBased'. If 'KeyBased' is selected, a connection string must be specified (at least the
    primary connection string). If 'IdentityBased' is select, the endpointUri and entityPath
    properties must be specified.
    """

    KEY_BASED = "KeyBased"
    IDENTITY_BASED = "IdentityBased"

class ConnectionPropertiesProvisioningState(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The provisioning state.
    """

    PENDING = "Pending"
    APPROVED = "Approved"
    REJECTED = "Rejected"
    DISCONNECTED = "Disconnected"

class ConnectionType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The type of time series connection resource.
    """

    AZURE_DATA_EXPLORER = "AzureDataExplorer"

class CreatedByType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The type of identity that created the resource.
    """

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"

class DigitalTwinsIdentityType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The type of Managed Identity used by the DigitalTwinsInstance. Only SystemAssigned is
    supported.
    """

    NONE = "None"
    SYSTEM_ASSIGNED = "SystemAssigned"

class EndpointProvisioningState(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The provisioning state.
    """

    PROVISIONING = "Provisioning"
    DELETING = "Deleting"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    DELETED = "Deleted"
    WARNING = "Warning"
    SUSPENDING = "Suspending"
    RESTORING = "Restoring"
    MOVING = "Moving"
    DISABLED = "Disabled"

class EndpointType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The type of Digital Twins endpoint
    """

    EVENT_HUB = "EventHub"
    EVENT_GRID = "EventGrid"
    SERVICE_BUS = "ServiceBus"

class PrivateLinkServiceConnectionStatus(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The status of a private endpoint connection.
    """

    PENDING = "Pending"
    APPROVED = "Approved"
    REJECTED = "Rejected"
    DISCONNECTED = "Disconnected"

class ProvisioningState(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The provisioning state.
    """

    PROVISIONING = "Provisioning"
    DELETING = "Deleting"
    UPDATING = "Updating"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    DELETED = "Deleted"
    WARNING = "Warning"
    SUSPENDING = "Suspending"
    RESTORING = "Restoring"
    MOVING = "Moving"

class PublicNetworkAccess(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Public network access for the DigitalTwinsInstance.
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class Reason(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Message providing the reason why the given name is invalid.
    """

    INVALID = "Invalid"
    ALREADY_EXISTS = "AlreadyExists"

class TimeSeriesDatabaseConnectionState(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The provisioning state.
    """

    PROVISIONING = "Provisioning"
    DELETING = "Deleting"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    DELETED = "Deleted"
    WARNING = "Warning"
    SUSPENDING = "Suspending"
    RESTORING = "Restoring"
    MOVING = "Moving"
    DISABLED = "Disabled"
