/*
 * Copyright 2010-2016 Amazon.com, Inc. or its affiliates. All Rights
 * Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *  http://aws.amazon.com/apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

package com.amazonaws.services.simpleworkflow.model;

import java.io.Serializable;
import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 */
public class RespondActivityTaskCompletedRequest extends
        AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The <code>taskToken</code> of the <a>ActivityTask</a>.
     * </p>
     * <important> <code>taskToken</code> is generated by the service and should
     * be treated as an opaque value. If the task is passed to another process,
     * its <code>taskToken</code> must also be passed. This enables it to
     * provide its progress and respond with results.</important>
     */
    private String taskToken;
    /**
     * <p>
     * The result of the activity task. It is a free form string that is
     * implementation specific.
     * </p>
     */
    private String result;

    /**
     * <p>
     * The <code>taskToken</code> of the <a>ActivityTask</a>.
     * </p>
     * <important> <code>taskToken</code> is generated by the service and should
     * be treated as an opaque value. If the task is passed to another process,
     * its <code>taskToken</code> must also be passed. This enables it to
     * provide its progress and respond with results.</important>
     * 
     * @param taskToken
     *        The <code>taskToken</code> of the <a>ActivityTask</a>.</p>
     *        <important> <code>taskToken</code> is generated by the service and
     *        should be treated as an opaque value. If the task is passed to
     *        another process, its <code>taskToken</code> must also be passed.
     *        This enables it to provide its progress and respond with results.
     */

    public void setTaskToken(String taskToken) {
        this.taskToken = taskToken;
    }

    /**
     * <p>
     * The <code>taskToken</code> of the <a>ActivityTask</a>.
     * </p>
     * <important> <code>taskToken</code> is generated by the service and should
     * be treated as an opaque value. If the task is passed to another process,
     * its <code>taskToken</code> must also be passed. This enables it to
     * provide its progress and respond with results.</important>
     * 
     * @return The <code>taskToken</code> of the <a>ActivityTask</a>.</p>
     *         <important> <code>taskToken</code> is generated by the service
     *         and should be treated as an opaque value. If the task is passed
     *         to another process, its <code>taskToken</code> must also be
     *         passed. This enables it to provide its progress and respond with
     *         results.
     */

    public String getTaskToken() {
        return this.taskToken;
    }

    /**
     * <p>
     * The <code>taskToken</code> of the <a>ActivityTask</a>.
     * </p>
     * <important> <code>taskToken</code> is generated by the service and should
     * be treated as an opaque value. If the task is passed to another process,
     * its <code>taskToken</code> must also be passed. This enables it to
     * provide its progress and respond with results.</important>
     * 
     * @param taskToken
     *        The <code>taskToken</code> of the <a>ActivityTask</a>.</p>
     *        <important> <code>taskToken</code> is generated by the service and
     *        should be treated as an opaque value. If the task is passed to
     *        another process, its <code>taskToken</code> must also be passed.
     *        This enables it to provide its progress and respond with results.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */

    public RespondActivityTaskCompletedRequest withTaskToken(String taskToken) {
        setTaskToken(taskToken);
        return this;
    }

    /**
     * <p>
     * The result of the activity task. It is a free form string that is
     * implementation specific.
     * </p>
     * 
     * @param result
     *        The result of the activity task. It is a free form string that is
     *        implementation specific.
     */

    public void setResult(String result) {
        this.result = result;
    }

    /**
     * <p>
     * The result of the activity task. It is a free form string that is
     * implementation specific.
     * </p>
     * 
     * @return The result of the activity task. It is a free form string that is
     *         implementation specific.
     */

    public String getResult() {
        return this.result;
    }

    /**
     * <p>
     * The result of the activity task. It is a free form string that is
     * implementation specific.
     * </p>
     * 
     * @param result
     *        The result of the activity task. It is a free form string that is
     *        implementation specific.
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */

    public RespondActivityTaskCompletedRequest withResult(String result) {
        setResult(result);
        return this;
    }

    /**
     * Returns a string representation of this object; useful for testing and
     * debugging.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getTaskToken() != null)
            sb.append("TaskToken: " + getTaskToken() + ",");
        if (getResult() != null)
            sb.append("Result: " + getResult());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof RespondActivityTaskCompletedRequest == false)
            return false;
        RespondActivityTaskCompletedRequest other = (RespondActivityTaskCompletedRequest) obj;
        if (other.getTaskToken() == null ^ this.getTaskToken() == null)
            return false;
        if (other.getTaskToken() != null
                && other.getTaskToken().equals(this.getTaskToken()) == false)
            return false;
        if (other.getResult() == null ^ this.getResult() == null)
            return false;
        if (other.getResult() != null
                && other.getResult().equals(this.getResult()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode
                + ((getTaskToken() == null) ? 0 : getTaskToken().hashCode());
        hashCode = prime * hashCode
                + ((getResult() == null) ? 0 : getResult().hashCode());
        return hashCode;
    }

    @Override
    public RespondActivityTaskCompletedRequest clone() {
        return (RespondActivityTaskCompletedRequest) super.clone();
    }
}