# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .catalog_item import CatalogItem


class USqlExternalDataSource(CatalogItem):
    """A Data Lake Analytics catalog U-SQL external datasource item.

    :param compute_account_name: the name of the Data Lake Analytics account.
    :type compute_account_name: str
    :param version: the version of the catalog item.
    :type version: str
    :param database_name: the name of the database.
    :type database_name: str
    :param name: the name of the external data source.
    :type name: str
    :param provider: the name of the provider for the external data source.
    :type provider: str
    :param provider_string: the name of the provider string for the external
     data source.
    :type provider_string: str
    :param pushdown_types: the list of types to push down from the external
     data source.
    :type pushdown_types: list[str]
    """

    _attribute_map = {
        'compute_account_name': {'key': 'computeAccountName', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'database_name': {'key': 'databaseName', 'type': 'str'},
        'name': {'key': 'externalDataSourceName', 'type': 'str'},
        'provider': {'key': 'provider', 'type': 'str'},
        'provider_string': {'key': 'providerString', 'type': 'str'},
        'pushdown_types': {'key': 'pushdownTypes', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(USqlExternalDataSource, self).__init__(**kwargs)
        self.database_name = kwargs.get('database_name', None)
        self.name = kwargs.get('name', None)
        self.provider = kwargs.get('provider', None)
        self.provider_string = kwargs.get('provider_string', None)
        self.pushdown_types = kwargs.get('pushdown_types', None)
