// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`ReEncrypt`](crate::operation::re_encrypt::builders::ReEncryptFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`ciphertext_blob(Blob)`](crate::operation::re_encrypt::builders::ReEncryptFluentBuilder::ciphertext_blob) / [`set_ciphertext_blob(Option<Blob>)`](crate::operation::re_encrypt::builders::ReEncryptFluentBuilder::set_ciphertext_blob):<br>required: **true**<br><p>Ciphertext of the data to reencrypt.</p><br>
    ///   - [`source_encryption_context(impl Into<String>, impl Into<String>)`](crate::operation::re_encrypt::builders::ReEncryptFluentBuilder::source_encryption_context) / [`set_source_encryption_context(Option<HashMap::<String, String>>)`](crate::operation::re_encrypt::builders::ReEncryptFluentBuilder::set_source_encryption_context):<br>required: **false**<br><p>Specifies the encryption context to use to decrypt the ciphertext. Enter the same encryption context that was used to encrypt the ciphertext.</p> <p>An <i>encryption context</i> is a collection of non-secret key-value pairs that represent additional authenticated data. When you use an encryption context to encrypt data, you must specify the same (an exact case-sensitive match) encryption context to decrypt the data. An encryption context is supported only on operations with symmetric encryption KMS keys. On operations with symmetric encryption KMS keys, an encryption context is optional, but it is strongly recommended.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">Encryption context</a> in the <i>Key Management Service Developer Guide</i>.</p><br>
    ///   - [`source_key_id(impl Into<String>)`](crate::operation::re_encrypt::builders::ReEncryptFluentBuilder::source_key_id) / [`set_source_key_id(Option<String>)`](crate::operation::re_encrypt::builders::ReEncryptFluentBuilder::set_source_key_id):<br>required: **false**<br><p>Specifies the KMS key that KMS will use to decrypt the ciphertext before it is re-encrypted.</p> <p>Enter a key ID of the KMS key that was used to encrypt the ciphertext. If you identify a different KMS key, the <code>ReEncrypt</code> operation throws an <code>IncorrectKeyException</code>.</p> <p>This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key. If you used a symmetric encryption KMS key, KMS can get the KMS key from metadata that it adds to the symmetric ciphertext blob. However, it is always recommended as a best practice. This practice ensures that you use the KMS key that you intend.</p> <p>To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.</p> <p>For example:</p> <ul>  <li>   <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code></p></li>  <li>   <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code></p></li>  <li>   <p>Alias name: <code>alias/ExampleAlias</code></p></li>  <li>   <p>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code></p></li> </ul> <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>. To get the alias name and alias ARN, use <code>ListAliases</code>.</p><br>
    ///   - [`destination_key_id(impl Into<String>)`](crate::operation::re_encrypt::builders::ReEncryptFluentBuilder::destination_key_id) / [`set_destination_key_id(Option<String>)`](crate::operation::re_encrypt::builders::ReEncryptFluentBuilder::set_destination_key_id):<br>required: **true**<br><p>A unique identifier for the KMS key that is used to reencrypt the data. Specify a symmetric encryption KMS key or an asymmetric KMS key with a <code>KeyUsage</code> value of <code>ENCRYPT_DECRYPT</code>. To find the <code>KeyUsage</code> value of a KMS key, use the <code>DescribeKey</code> operation.</p> <p>To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.</p> <p>For example:</p> <ul>  <li>   <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code></p></li>  <li>   <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code></p></li>  <li>   <p>Alias name: <code>alias/ExampleAlias</code></p></li>  <li>   <p>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code></p></li> </ul> <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>. To get the alias name and alias ARN, use <code>ListAliases</code>.</p><br>
    ///   - [`destination_encryption_context(impl Into<String>, impl Into<String>)`](crate::operation::re_encrypt::builders::ReEncryptFluentBuilder::destination_encryption_context) / [`set_destination_encryption_context(Option<HashMap::<String, String>>)`](crate::operation::re_encrypt::builders::ReEncryptFluentBuilder::set_destination_encryption_context):<br>required: **false**<br><p>Specifies that encryption context to use when the reencrypting the data.</p><important>  <p>Do not include confidential or sensitive information in this field. This field may be displayed in plaintext in CloudTrail logs and other output.</p> </important> <p>A destination encryption context is valid only when the destination KMS key is a symmetric encryption KMS key. The standard ciphertext format for asymmetric KMS keys does not include fields for metadata.</p> <p>An <i>encryption context</i> is a collection of non-secret key-value pairs that represent additional authenticated data. When you use an encryption context to encrypt data, you must specify the same (an exact case-sensitive match) encryption context to decrypt the data. An encryption context is supported only on operations with symmetric encryption KMS keys. On operations with symmetric encryption KMS keys, an encryption context is optional, but it is strongly recommended.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">Encryption context</a> in the <i>Key Management Service Developer Guide</i>.</p><br>
    ///   - [`source_encryption_algorithm(EncryptionAlgorithmSpec)`](crate::operation::re_encrypt::builders::ReEncryptFluentBuilder::source_encryption_algorithm) / [`set_source_encryption_algorithm(Option<EncryptionAlgorithmSpec>)`](crate::operation::re_encrypt::builders::ReEncryptFluentBuilder::set_source_encryption_algorithm):<br>required: **false**<br><p>Specifies the encryption algorithm that KMS will use to decrypt the ciphertext before it is reencrypted. The default value, <code>SYMMETRIC_DEFAULT</code>, represents the algorithm used for symmetric encryption KMS keys.</p> <p>Specify the same algorithm that was used to encrypt the ciphertext. If you specify a different algorithm, the decrypt attempt fails.</p> <p>This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key.</p><br>
    ///   - [`destination_encryption_algorithm(EncryptionAlgorithmSpec)`](crate::operation::re_encrypt::builders::ReEncryptFluentBuilder::destination_encryption_algorithm) / [`set_destination_encryption_algorithm(Option<EncryptionAlgorithmSpec>)`](crate::operation::re_encrypt::builders::ReEncryptFluentBuilder::set_destination_encryption_algorithm):<br>required: **false**<br><p>Specifies the encryption algorithm that KMS will use to reecrypt the data after it has decrypted it. The default value, <code>SYMMETRIC_DEFAULT</code>, represents the encryption algorithm used for symmetric encryption KMS keys.</p> <p>This parameter is required only when the destination KMS key is an asymmetric KMS key.</p><br>
    ///   - [`grant_tokens(impl Into<String>)`](crate::operation::re_encrypt::builders::ReEncryptFluentBuilder::grant_tokens) / [`set_grant_tokens(Option<Vec::<String>>)`](crate::operation::re_encrypt::builders::ReEncryptFluentBuilder::set_grant_tokens):<br>required: **false**<br><p>A list of grant tokens.</p> <p>Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved <i>eventual consistency</i>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token">Grant token</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token">Using a grant token</a> in the <i>Key Management Service Developer Guide</i>.</p><br>
    ///   - [`dry_run(bool)`](crate::operation::re_encrypt::builders::ReEncryptFluentBuilder::dry_run) / [`set_dry_run(Option<bool>)`](crate::operation::re_encrypt::builders::ReEncryptFluentBuilder::set_dry_run):<br>required: **false**<br><p>Checks if your request will succeed. <code>DryRun</code> is an optional parameter.</p> <p>To learn more about how to use this parameter, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/programming-dryrun.html">Testing your KMS API calls</a> in the <i>Key Management Service Developer Guide</i>.</p><br>
    /// - On success, responds with [`ReEncryptOutput`](crate::operation::re_encrypt::ReEncryptOutput) with field(s):
    ///   - [`ciphertext_blob(Option<Blob>)`](crate::operation::re_encrypt::ReEncryptOutput::ciphertext_blob): <p>The reencrypted data. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p>
    ///   - [`source_key_id(Option<String>)`](crate::operation::re_encrypt::ReEncryptOutput::source_key_id): <p>Unique identifier of the KMS key used to originally encrypt the data.</p>
    ///   - [`key_id(Option<String>)`](crate::operation::re_encrypt::ReEncryptOutput::key_id): <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key that was used to reencrypt the data.</p>
    ///   - [`source_encryption_algorithm(Option<EncryptionAlgorithmSpec>)`](crate::operation::re_encrypt::ReEncryptOutput::source_encryption_algorithm): <p>The encryption algorithm that was used to decrypt the ciphertext before it was reencrypted.</p>
    ///   - [`destination_encryption_algorithm(Option<EncryptionAlgorithmSpec>)`](crate::operation::re_encrypt::ReEncryptOutput::destination_encryption_algorithm): <p>The encryption algorithm that was used to reencrypt the data.</p>
    /// - On failure, responds with [`SdkError<ReEncryptError>`](crate::operation::re_encrypt::ReEncryptError)
    pub fn re_encrypt(&self) -> crate::operation::re_encrypt::builders::ReEncryptFluentBuilder {
        crate::operation::re_encrypt::builders::ReEncryptFluentBuilder::new(self.handle.clone())
    }
}
