<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:cat="http://www.saxonica.com/ns/doc/catalog"
  xmlns:fn="http://www.saxonica.com/ns/doc/functions" xmlns:xs="http://www.w3.org/2001/XMLSchema"
  xmlns:saxon="http://saxon.sf.net/" exclude-result-prefixes="cat fn xs saxon">

  <xsl:import href="preprocess-functions.xsl"/>

  <xsl:output method="xml" encoding="iso-8859-1" indent="yes" saxon:suppress-indentation="p"/>

  <xsl:param name="destination" select="'online'" as="xs:string"/>
  <!-- set this to "online" for the web site, "offline" for the document supplied in the download"-->

  <xsl:variable name="img" select="'img'"/>

  <xsl:import-schema schema-location="../src/saxon-doc-schema.xsd"/>
  <xsl:import-schema namespace="http://www.saxonica.com/ns/doc/catalog"
    schema-location="../src/catalog-schema.xsd"/>
 <!-- <xsl:import-schema namespace="http://www.saxonica.com/ns/doc/functions"
    schema-location="../src/functions-schema.xsd"/>-->

  <xsl:variable name="sections" select="/cat:catalog/cat:section/@ref"/>

  <xsl:template match="/">
    <!-- process the catalog file -->
    <xsl:if test="not(* instance of schema-element(cat:catalog))">
      <xsl:message terminate="yes"> Input file must be a validated instance of cat:catalog
      </xsl:message>
    </xsl:if>
    <xsl:apply-templates/>
    <xsl:call-template name="generate-contents"/>
    <xsl:call-template name="generate-contents-html-links"/>
    <xsl:call-template name="generate-xml-contents"/>
  </xsl:template>
  
  <xsl:variable name="docs" as="document-node()*">
    <xsl:for-each select="$sections">
      <xsl:variable name="doc" select="document(concat(., '.xml'),/)"/>
      <xsl:if
        test="not($doc/section instance of schema-element(section))">
        <xsl:message terminate="yes">Input  <xsl:value-of select="."/> has not been validated against
          the schema</xsl:message>
      </xsl:if>
      <xsl:sequence select="$doc"/>
    </xsl:for-each>      
  </xsl:variable>

  <xsl:template match="cat:catalog">
    <xsl:for-each select="$docs">
      <xsl:apply-templates select="section">
        <xsl:with-param name="this-doc" select="section/@xml:id" tunnel="yes"/>
      </xsl:apply-templates>
    </xsl:for-each>
  </xsl:template>

  <!-- entry point for processing a single document -->

  <xsl:template match="/" mode="single-doc">
    <xsl:apply-templates select="./section">
      <xsl:with-param name="this-doc" select="@xml:id" tunnel="yes"/>
    </xsl:apply-templates>
  </xsl:template>
 
  <xsl:template match="index" priority="5">
   <xsl:apply-templates/>
  
 </xsl:template>

  <xsl:template
    match="element(*, inline) | element(*, list-type) | tr | td | li | table | br | thead | tbody">
    <xsl:copy copy-namespaces="no">
      <xsl:copy-of select="@*"/>
      <xsl:apply-templates/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="*">
    <xsl:message> *** Unrecognized element <xsl:value-of select="name(.)"/> of type <xsl:value-of
        select="saxon:type-annotation(.)"/> *** </xsl:message>
  </xsl:template>

  <xsl:template
    match="a[starts-with(string(@href), 'http://') or starts-with(string(@href), '../javadoc')
                            or starts-with(string(@href), '../dotnetdoc')]">
                            <!-- redundant, same as the generic rule -->
    <xsl:copy copy-namespaces="no">
      <xsl:copy-of select="@*"/>
      <!--<xsl:attribute name="target" select="'_blank'"/>-->
      <xsl:attribute name="class" select="'bodylink'"/>
      <xsl:apply-templates/>
    </xsl:copy>
  </xsl:template>
  
  <xsl:template match="a">
     <xsl:copy copy-namespaces="no">
      <xsl:copy-of select="@*"/>
      <!--<xsl:attribute name="target" select="'_blank'"/>-->
      <xsl:attribute name="class" select="'bodylink'"/>
      <xsl:apply-templates/>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="a[starts-with(string(@href), '#')]">
    <xsl:param name="this-doc" required="yes" tunnel="yes" as="xs:string"/>
    <xsl:message terminate="yes">** obsolete hyperlink in <xsl:value-of select="document-uri(/)"/>: <xsl:copy-of
        select="."/></xsl:message>
  </xsl:template>

  <xsl:template match="a[matches(string(@href), '^[A-Za-z\-]+.html#.+$')]">
    <xsl:param name="this-doc" required="yes" tunnel="yes" as="xs:string"/>
    <xsl:message>** obsolete hyperlink in <xsl:value-of select="document-uri(/)"/>: <xsl:copy-of
        select="."/></xsl:message>
  </xsl:template>

  <xsl:template match="a[matches(string(@href), '^[A-Za-z\-]+\.html$')]">
    <xsl:param name="this-doc" required="yes" tunnel="yes" as="xs:string"/>
    <xsl:message>** obsolete hyperlink in <xsl:value-of select="document-uri(/)"/>: <xsl:copy-of
        select="."/></xsl:message>
  </xsl:template>

  <xsl:template match="section">
    <!--<xsl:call-template name="make-menu"/>-->
    <xsl:apply-templates select="page"/>
  </xsl:template>

  <xsl:template match="page">
    <xsl:param name="this-doc" required="yes" tunnel="yes" as="xs:string"/>
    <xsl:variable name="pgid" select="@xml:id"/>
    <xsl:if test="count(p) gt 10">
      <xsl:message>** Warning: long page <xsl:value-of select="$this-doc, @xml:id"/></xsl:message>
    </xsl:if>
    <xsl:result-document href="{$this-doc}/{$pgid}.xml" method="xml" indent="yes">
      <xsl:call-template name="make-page">
        <xsl:with-param name="title" select="if (title = 'Introduction') then ../title else title"/>
        <xsl:with-param name="pgid" select="$pgid"/>
      </xsl:call-template>
    </xsl:result-document>
  </xsl:template>

  <xsl:template name="make-page">
    <xsl:param name="title" as="xs:string" required="yes"/>
    <xsl:param name="this-doc" as="xs:string" required="yes" tunnel="yes"/>
    <xsl:param name="pgid" as="xs:string" required="yes"/>
    <xsl:param name="subpageid" as="xs:string" required="no" select="''"/>
    <xsl:variable name="path-prefix" as="xs:string"
      select="if (self::page) then '../'
				        else if (self::subpage) then '../../'
						else ''"/>
    <xsl:variable name="paras" select=".//p except .//subpage//p"/>
    <xsl:variable name="est-length"
      select="max((ceiling(sum($paras/string-length()) idiv 4) + 
                                               count($paras) * 20 +
											   (if (subpageindex) then count(subpage)*40 else 0), 1000))"/>
    <xsl:variable name="est-length" select="if (@size) then $est-length * @size else $est-length"/>
    <!--<xsl:comment>Est sizes <xsl:value-of select="sum($paras/string-length()) idiv 4, count($paras) * 20, 
(if (subpageindex) then count(subpage)*40 else 0)"/></xsl:comment>-->
    <xsl:processing-instruction name="xml-stylesheet">href="<xsl:value-of select="$path-prefix"/>make-menu.xsl" type="text/xsl"</xsl:processing-instruction> 
    <html>
      <head>
        <this-is section="{$this-doc}" page="{$pgid}" subpage="{$subpageid}"/>
        <xsl:comment>
          <!--<xsl:value-of select="$this-doc, $pgid" separator="/"/>--> Generated at <xsl:value-of
            select="current-dateTime()"/>
        </xsl:comment>
        <title>Saxonica: XSLT and XQuery Processing: <xsl:value-of select="$title"/></title>
        <meta name="coverage" content="Worldwide"/>
        <meta name="copyright" content="Copyright Saxonica Ltd"/>
        <meta name="title" content="Saxonica: XSLT and XQuery Processing: {$title}"/>
        <meta name="robots" content="noindex,nofollow"/>
        <link rel="stylesheet" href="{$path-prefix}saxondocs.css" type="text/css"/>

      </head>
      <body class="main">
        <!--
        <div id="rhDkBlueArea"
          style="position:absolute; width:123px; height:{$est-length}px; z-index:2; right: 0px; top: 0px; border: 1px none #000000; background-color: #C1CEDE; layer-background-color: #C1CEDE; visibility: visible;"/>
        <div id="rhMdBlueArea"
          style="position:absolute; width:217px; height:{$est-length}px; z-index:2; right: 340px; top: 0px; border: 1px none #000000; background-color: #E4EEF0; layer-background-color: #E4EEF0; visibility: visible;"/>
        <div id="lhLightArea"
          style="position:absolute; width:34px; height:{$est-length}px; z-index:2; left: 66px; top: 0px; border: 1px none #000000; background-color: #f6fffb; layer-background-color: #E4EEF0; visibility: visible;"/>
        <div id="lhDkBlueArea"
          style="position:absolute; width:66px; height:{$est-length}px; z-index:2; left: 0px; top: 0px; border: 1px none #000000; background-color: #C1CEDE; layer-background-color: #C1CEDE; visibility: visible;"/>
        <div id="LogoArea"
          style="position:absolute; width:340px; height:72px; z-index:3; right: 0px; top: 0px; border: 1px none #000000; visibility: visible;">
          <a href="http://www.saxonica.com/">
            <img src="{$path-prefix}{$img}/saxonica_logo.gif" width="340" height="72" border="0"
              alt="saxonica.com"/>
          </a>
        </div>

        <div id="MenuArea"
          style="position:absolute; width:157px; z-index:4; right: 33px; top: 114px; visibility: visible; background-color: #f6fffb; layer-background-color: #f6fffb; border: 1px solid #3D5B96; padding-top:9px; padding-left:15px;padding-right:11px; padding-bottom:9px;">
         -->
          <!--Menu is inserted here by the client-side XSLT stylesheet-->
        <!--</div>
        <div id="MainTextArea"
          style="position:absolute; height:100%; z-index:5; left: 130px; right: 260px; top: 110px; border: 1px none #000000; visibility: visible;">-->
          <h1>
            <xsl:value-of select="$title"/>
          </h1>
          <xsl:apply-templates select="node() except h1 "/>
          <table width="100%">
            <tr>
              <td>
                <p align="right">
                  <xsl:choose>
                    <xsl:when test="following-sibling::subpage">
                      <a class="nav" href="{following-sibling::subpage[1]/@xml:id}.xml">Next</a>
                    </xsl:when>
                    <xsl:when test="../following-sibling::page">
                      <a class="nav" href="../{../following-sibling::page[1]/@xml:id}.xml">Next</a>
                    </xsl:when>
                    <xsl:when test="child::subpage">
                      <a class="nav" href="{@xml:id}/{child::subpage[1]/@xml:id}.xml">Next</a>
                    </xsl:when>
                    <xsl:when test="following-sibling::page">
                      <a class="nav" href="{following-sibling::page[1]/@xml:id}.xml">Next</a>
                    </xsl:when>
                  </xsl:choose>
                </p>
              </td>
            </tr>
          </table>
        <!--</div>-->
      </body>
    </html>
  </xsl:template>

  <xsl:template match="subpage">
    <xsl:param name="this-doc" required="yes" tunnel="yes" as="xs:string"/>
    <xsl:variable name="pgid" select="../@xml:id"/>
    <xsl:if test="count(p) gt 10">
      <xsl:message>** Warning: long sub-page <xsl:value-of select="$this-doc, $pgid, @xml:id"
        /></xsl:message>
    </xsl:if>
    <xsl:result-document href="{$this-doc}/{$pgid}/{@xml:id}.xml" method="xml" indent="yes">
      <xsl:call-template name="make-page">
        <xsl:with-param name="title" select="title"/>
        <xsl:with-param name="pgid" select="$pgid"/>
        <xsl:with-param name="subpageid" select="@xml:id"/>
      </xsl:call-template>
    </xsl:result-document>
  </xsl:template>

  <xsl:template match="subpageindex">
    <ul>
      <xsl:for-each select="../subpage">
        <li>
          <p>
            <a class="bodylink" href="{ancestor::page/@xml:id}/{@xml:id}.xml">
              <xsl:value-of select="title"/>
            </a>
            <xsl:if test="@summary">
              <xsl:value-of select="':', @summary" separator=" "/>
            </xsl:if>
          </p>
        </li>
      </xsl:for-each>
    </ul>
  </xsl:template>

  <xsl:template match="pageindex">
    <ul>
      <xsl:for-each select="../../page except parent::page">
        <li>
          <p>
            <a class="bodylink" href="{@xml:id}.xml">
              <xsl:value-of select="title"/>
            </a>
          </p>
        </li>
      </xsl:for-each>
    </ul>
  </xsl:template>

  <xsl:function name="fn:path-prefix" as="xs:string">
    <xsl:param name="node" as="element()"/>
    <xsl:sequence
      select="if ($node/(/table)) then '../' (: generated feature keys :)
              else if ($node/ancestor::subpage) then '../../'
              else if ($node/ancestor::page) then '../'
						  else ''"
    />
  </xsl:function>

  <xsl:template match="xref[@subpage]">
    <xsl:variable name="section" select="(@section, /section/@xml:id)[1]"/>
    <xsl:variable name="page" select="(@page, ancestor::page/@xml:id)[1]"/>
    <xsl:if test="empty($docs/section[@xml:id=$section]/page[@xml:id=$page]/subpage[@xml:id=current()/@subpage])">
      <xsl:message>*** Broken subpage link!!! *** <xsl:copy-of select="."/>(<xsl:value-of
        select="'section', document-uri(/), 'page', ancestor::page/@xml:id"/>)</xsl:message>
    </xsl:if>
    <a class="bodylink" href="{fn:path-prefix(.)}{$section}/{$page}/{@subpage}.xml">
      <xsl:value-of select="."/>
      <xsl:if test=".=''">
        <xsl:value-of select="$docs/section[@xml:id=$section]/page[@xml:id=$page]/subpage[@xml:id=current()]/title"/>
      </xsl:if>
    </a>
  </xsl:template>

  <xsl:template match="xref[@page and not(@subpage)]">
    <xsl:variable name="section" select="(@section, /section/@xml:id)[1]"/>
    <xsl:variable name="page" select="(@page, ancestor::page/@xml:id)[1]"/>
    <xsl:if test="empty($docs/section[@xml:id=$section]/page[@xml:id=$page])">
      <xsl:message>*** Broken page link!!! *** <xsl:copy-of select="."/>(<xsl:value-of
        select="'section', document-uri(/), 'page', ancestor::page/@xml:id"/>)</xsl:message>
    </xsl:if>
    <a class="bodylink" href="{fn:path-prefix(.)}{$section}/{$page}.xml">
      <xsl:value-of select="."/>
      <xsl:if test=".=''">
        <xsl:if test=".=''">
          <xsl:value-of select="$docs/section[@xml:id=$section]/page[@xml:id=$page]/title"/>
        </xsl:if>
      </xsl:if>
    </a>
  </xsl:template>

  <xsl:template match="xref[@section and not(@page)]">
    <xsl:if test="empty($docs/section[@xml:id=current()/@section])">
      <xsl:message>*** Broken section link!!! *** <xsl:copy-of select="."/>(<xsl:value-of
        select="'section', document-uri(/), 'page', ancestor::page/@xml:id"/>)</xsl:message>
    </xsl:if>
    <a class="bodylink" href="{fn:path-prefix(.)}{@section}/intro.xml">
      <xsl:value-of select="."/>
      <xsl:if test=".=''">
        <xsl:if test=".=''">
          <xsl:value-of select="$docs/section[@xml:id=current()/@section]/title"/>
        </xsl:if>
      </xsl:if>
    </a>
  </xsl:template>

  <xsl:template match="code[@java]">
    <xsl:variable name="link" select="translate(@java, '.', '/')"/>
    <xsl:variable name="file" select="if (contains($link, '#')) 
                                      then concat(substring-before($link, '#'), '.html#', substring-after($link, '#'))
                                      else concat($link, '.html')"/>
    
    <a class="bodylink" href="{fn:path-prefix(.)}javadoc/{$file}"><code><xsl:apply-templates/></code></a>
  </xsl:template>

  <xsl:template match="title"/>

  <xsl:template match="subtitle">
    <p class="subhead">
      <xsl:apply-templates/>
    </p>
  </xsl:template>

  <xsl:template match="code[pre]">
    <div class="codeblock">
      <pre><code>
  <xsl:apply-templates select="pre/*"/>
  </code></pre>
    </div>
  </xsl:template>

  <xsl:template match="pre">
    <div style="border: solid thin; background-color: #B1CCC7; padding: 2px" class="codeblock">
      <xsl:next-match/>
    </div>
  </xsl:template>

  <xsl:template match="example" priority="2">
    <div class="codeblock" style="border: solid thin; background-color: #B1CCC7; padding: 2px">
      <pre><code>
  <xsl:apply-templates/>
  </code></pre>
    </div>
  </xsl:template>

  <xsl:template match="box" priority="2">
    <div class="boxed" style="border: solid thin; background-color: #B1CCC7; padding: 2px">
      <xsl:apply-templates/>
    </div>
  </xsl:template>

  <xsl:template match="command" priority="2">
    <p class="command">
      <xsl:apply-templates/>
    </p>
  </xsl:template>

  <xsl:template match="defect" priority="1.5">
    <p><a
        href="http://sourceforge.net/tracker/index.php?func=detail&amp;aid={@id}&amp;group_id=29872&amp;atid=397617"
        target="_new" class="bodylink">
        <xsl:value-of select="@id"/>
      </a>&#xa0; <xsl:apply-templates/>
    </p>
  </xsl:template>

  <!-- add <p> elements inside a <td> or <li> if not there already -->

  <xsl:template match="td[not(p) and not(@align='center')]">
    <!-- the test on "align" is to avoid changing the knight's tour diagram -->
    <xsl:copy copy-namespaces="no">
      <xsl:copy-of select="@*"/>
      <p>
        <xsl:apply-templates/>
      </p>
    </xsl:copy>
  </xsl:template>

  <xsl:template match="li[not(p)]">
    <xsl:copy copy-namespaces="no">
      <xsl:copy-of select="@*"/>
      <p>
        <xsl:apply-templates/>
      </p>
    </xsl:copy>
  </xsl:template>

  <!--<xsl:template match="fn:conformance">
    <xsl:variable name="temp">
      <xsl:document validation="strict">
        <xsl:apply-templates select="fn:functions" mode="f"/>
      </xsl:document>
    </xsl:variable>
    <xsl:apply-templates select="$temp//body"/>
  </xsl:template>-->

  <xsl:template name="generate-contents">
    <xsl:result-document href="contents.html">
      <html>
        <head>
          <xsl:comment> Generated at <xsl:value-of
              select="format-dateTime(current-dateTime(), '[D] [MNn] [Y0001] at [H01]:[m01]')"/>
          </xsl:comment>
          <title>Saxonica: XSLT and XQuery Processing: <xsl:value-of select="title"/></title>
          <meta name="coverage" content="Worldwide"/>
          <meta name="copyright" content="Copyright Saxonica Ltd"/>
          <meta name="title" content="Saxonica: XSLT and XQuery Processing: {title}"/>
          <meta name="robots" content="noindex,nofollow"/>
          <link rel="stylesheet" href="saxondocs.css" type="text/css"/>

        </head>
        <body class="main">
          <h1>Saxon Documentation</h1>
          <xsl:for-each select="$sections">
            <xsl:variable name="sname" select="string(.)"/>
            <xsl:variable name="sect" select="document(concat(., '.xml'),/)"/>
            <p class="subhead">
              <xsl:value-of select="$sect/section/title"/>
            </p>
            <xsl:choose>
              <xsl:when test="$sname = 'functions'">
                <xsl:for-each select="$sect">
                  <xsl:call-template name="make-function-contents-page"/>
                </xsl:for-each>
              </xsl:when>
              <xsl:otherwise>
                <ul>
                  <xsl:for-each select="$sect/section/page">
                    <xsl:variable name="h" select="."/>
                    <li>
                      <a class="toc2" href="{concat($sname, '/', @xml:id, '.xml')}">
                        <xsl:value-of select="$h/title"/>
                      </a>
                      <xsl:if test="subpage">
                        <ul>
                          <xsl:for-each select="subpage">
                            <li>
                              <a href="{concat($sname, '/', $h/@xml:id, '/', @xml:id, '.xml')}">
                                <xsl:value-of select="title"/>
                              </a>
                            </li>
                          </xsl:for-each>
                        </ul>
                      </xsl:if>
                    </li>
                  </xsl:for-each>
                </ul>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:for-each>
        </body>
      </html>
    </xsl:result-document>
  </xsl:template>
  
  <xsl:template name="generate-contents-html-links">
    <xsl:result-document href="contents-html-links.html">
      <html>
        <head>
          <xsl:comment> Generated at <xsl:value-of
              select="format-dateTime(current-dateTime(), '[D] [MNn] [Y0001] at [H01]:[m01]')"/>
          </xsl:comment>
          <title>Saxonica: XSLT and XQuery Processing: <xsl:value-of select="title"/></title>
          <meta name="coverage" content="Worldwide"/>
          <meta name="copyright" content="Copyright Saxonica Ltd"/>
          <meta name="title" content="Saxonica: XSLT and XQuery Processing: {title}"/>
          <meta name="robots" content="noindex,nofollow"/>
          <link rel="stylesheet" href="saxondocs.css" type="text/css"/>

        </head>
        <body class="main">
          <h1>Saxon Documentation</h1>
          <xsl:for-each select="$sections">
            <xsl:variable name="sname" select="string(.)"/>
            <xsl:variable name="sect" select="document(concat(., '.xml'),/)"/>
            <p class="subhead">
              <xsl:value-of select="$sect/section/title"/>
            </p>
            <xsl:choose>
              <xsl:when test="$sname = 'functions'">
                <xsl:for-each select="$sect">
                  <xsl:call-template name="make-function-contents-page"/>
                </xsl:for-each>
              </xsl:when>
              <xsl:otherwise>
                <ul>
                  <xsl:for-each select="$sect/section/page">
                    <xsl:variable name="h" select="."/>
                    <li>
                      <a class="toc2" href="{concat($sname, '/', @xml:id, '.html')}">
                        <xsl:value-of select="$h/title"/>
                      </a>
                      <xsl:if test="subpage">
                        <ul>
                          <xsl:for-each select="subpage">
                            <li>
                              <a href="{concat($sname, '/', $h/@xml:id, '/', @xml:id, '.html')}">
                                <xsl:value-of select="title"/>
                              </a>
                            </li>
                          </xsl:for-each>
                        </ul>
                      </xsl:if>
                    </li>
                  </xsl:for-each>
                </ul>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:for-each>
        </body>
      </html>
    </xsl:result-document>
  </xsl:template>
  
  <xsl:template name="generate-xml-contents">
    <xsl:result-document href="contents.xml" method="xml" indent="yes">
      <xsl:comment> Generated at <xsl:value-of
          select="format-dateTime(current-dateTime(), '[D] [MNn] [Y0001] at [H01]:[m01]')"/>
      </xsl:comment>
      <contents>
          <xsl:for-each select="$sections">
            <xsl:variable name="sname" select="string(.)"/>
            <xsl:variable name="sect" select="document(concat(., '.xml'),/)"/>
            
            <xsl:choose>
              <xsl:when test="$sname = 'functions'">
                <section name="functions" title="Standard functions">
                    <xsl:for-each select="$sect">
                      <xsl:call-template name="make-function-contents-xml-page"/>
                    </xsl:for-each>
                </section>
              </xsl:when>
              <xsl:otherwise>
                <section name="{$sname}" title="{$sect/section/title}">
                  <xsl:for-each select="$sect/section/page">
                    <xsl:variable name="h" select="."/>
                    <page name="{$h/@xml:id}" title="{$h/title}">
                        <xsl:for-each select="subpage">
                            <subpage name="{@xml:id}" title="{title}"/>
                        </xsl:for-each>
                    </page>
                  </xsl:for-each>
                 </section>
              </xsl:otherwise>
            </xsl:choose>
           </xsl:for-each>
        </contents>
    </xsl:result-document>
  </xsl:template>
  
  <!-- Generate list of functions in main table of contents -->
  <xsl:template name="make-function-contents-page">
    <xsl:variable name="fns" select="conformance/functions/function[starts-with(name, 'fn:') or starts-with(name, 'xslt:')]"/>
    <xsl:variable name="sfns" as="element()*">
      <xsl:perform-sort select="$fns[. is key('fk', name)[1]]">
        <xsl:sort select="substring-after(name, ':')"/>
      </xsl:perform-sort>
    </xsl:variable>
    <ul>
      <xsl:for-each select="$sfns">
        <li>
          <p><a href="functions/intro/{translate(name, ':', '_')}.html">
            <xsl:value-of select="name"/>
          </a></p>
        </li>
      </xsl:for-each>
    </ul>
  </xsl:template>
  
  <!-- Generate list of functions in XML table of contents -->
  <xsl:template name="make-function-contents-xml-page">
    <xsl:variable name="fns" select="conformance/functions/function[starts-with(name, 'fn:') or starts-with(name, 'xslt:')]"/>
    <xsl:variable name="sfns" as="element()*">
      <xsl:perform-sort select="$fns[. is key('fk', name)[1]]">
        <xsl:sort select="lower-case(substring-after(name, ':'))"/>
      </xsl:perform-sort>
    </xsl:variable>
    <page name="intro" title="Index of functions">
      <xsl:for-each select="$sfns">
        <subpage name="{translate(name, ':', '_')}" title="{name}"/>
      </xsl:for-each>
    </page>
  </xsl:template>	
  

  <xsl:template match="html-example">
    <xsl:copy-of select="*"/>
  </xsl:template>

  <xsl:template match="processing-instruction(featurekeys)">
    <xsl:apply-templates select="doc('../src/FeatureKeysDoc.xml')/*"/>
  </xsl:template>


</xsl:stylesheet>
