/*
 * Decompiled with CFR 0.152.
 */
package org.javacc.jjtree;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Vector;
import org.javacc.jjtree.JJTreeIOException;
import org.javacc.parser.JavaCCGlobals;
import org.javacc.parser.Options;

final class IO {
    private String ifn = "<uninitialized input>";
    private String ofn = "<uninitialized output>";
    private Reader in;
    private PrintWriter out;
    private PrintStream msg = System.out;
    private PrintStream err = System.err;
    private Vector toolList;

    IO() {
    }

    String getInputFileName() {
        return this.ifn;
    }

    Reader getIn() {
        return this.in;
    }

    String getOutputFileName() {
        return this.ofn;
    }

    PrintWriter getOut() {
        return this.out;
    }

    PrintStream getMsg() {
        return this.msg;
    }

    PrintStream getErr() {
        return this.err;
    }

    void print(String s) {
        this.out.print(s);
    }

    void println(String s) {
        this.out.println(s);
    }

    void println() {
        this.out.println();
    }

    void closeAll() {
        if (this.out != null) {
            this.out.close();
        }
        if (this.msg != null) {
            this.msg.flush();
        }
        if (this.err != null) {
            this.err.flush();
        }
    }

    private String create_output_file_name(String i, char sep) {
        String o = Options.S("OUTPUT_FILE");
        String d = Options.S("OUTPUT_DIRECTORY");
        if (o.equals("")) {
            String suffix;
            int di;
            int s = i.lastIndexOf(sep);
            if (s >= 0) {
                i = i.substring(s + 1);
            }
            o = (di = i.lastIndexOf(46)) == -1 ? i + ".jj" : ((suffix = i.substring(di)).equals(".jj") ? i + ".jj" : i.substring(0, di) + ".jj");
        }
        if (d.equals("")) {
            return o;
        }
        return d + sep + o;
    }

    void setInput(String fn) throws JJTreeIOException {
        try {
            File fp = new File(fn);
            if (!fp.exists()) {
                throw new JJTreeIOException("File " + fn + " not found.");
            }
            if (fp.isDirectory()) {
                throw new JJTreeIOException(fn + " is a directory. Please use a valid file name.");
            }
            if (JavaCCGlobals.isGeneratedBy("JJTree", fn)) {
                throw new JJTreeIOException(fn + " was generated by jjtree.  Cannot run jjtree again.");
            }
            this.toolList = JavaCCGlobals.getToolNames(fn);
            this.ifn = fp.getPath();
            this.ofn = this.create_output_file_name(this.ifn, File.separatorChar);
            this.in = new FileReader(this.ifn);
        }
        catch (NullPointerException ne) {
            throw new JJTreeIOException(ne.toString());
        }
        catch (SecurityException se) {
            throw new JJTreeIOException("Security violation while trying to open " + fn);
        }
        catch (FileNotFoundException e) {
            throw new JJTreeIOException("File " + fn + " not found.");
        }
        catch (IOException ioe) {
            throw new JJTreeIOException(ioe.toString());
        }
        try {
            this.out = new PrintWriter(new FileWriter(this.ofn));
        }
        catch (IOException fnf) {
            throw new JJTreeIOException("Can't create output file " + this.ofn);
        }
    }
}

