/* valaclass.c generated by valac, the Vala compiler
 * generated from valaclass.vala, do not modify */

/* valaclass.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>
#include <string.h>
#include <stdlib.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _ValaClassPrivate {
	ValaClass* _base_class;
	gboolean _is_abstract;
	gboolean _is_partial;
	gboolean _is_sealed;
	gboolean _has_private_fields;
	gboolean _has_class_private_fields;
	gboolean* _is_compact;
	gboolean* _is_opaque;
	gboolean* _is_immutable;
	gboolean* _is_singleton;
	ValaList* base_types;
	ValaHashMap* implicit_implementations;
	ValaCreationMethod* _default_construction_method;
	ValaConstructor* _constructor;
	ValaConstructor* _class_constructor;
	ValaConstructor* _static_constructor;
	ValaDestructor* _destructor;
	ValaDestructor* _class_destructor;
	ValaDestructor* _static_destructor;
};

static gint ValaClass_private_offset;
static gpointer vala_class_parent_class = NULL;

static gboolean* _bool_dup (gboolean* self);
static void vala_class_set_has_class_private_fields (ValaClass* self,
                                              gboolean value);
static guint _vala_symbol_hash_func_ghash_func (gconstpointer key);
static gboolean _vala_symbol_equal_func_gequal_func (gconstpointer a,
                                              gconstpointer b);
static void vala_class_set_default_construction_method (ValaClass* self,
                                                 ValaCreationMethod* value);
static void vala_class_set_constructor (ValaClass* self,
                                 ValaConstructor* value);
static void vala_class_set_class_constructor (ValaClass* self,
                                       ValaConstructor* value);
static void vala_class_set_static_constructor (ValaClass* self,
                                        ValaConstructor* value);
static void vala_class_set_destructor (ValaClass* self,
                                ValaDestructor* value);
static void vala_class_set_static_destructor (ValaClass* self,
                                       ValaDestructor* value);
static void vala_class_set_class_destructor (ValaClass* self,
                                      ValaDestructor* value);
static void vala_class_real_add_field (ValaSymbol* base,
                                ValaField* f);
static void vala_class_real_add_method (ValaSymbol* base,
                                 ValaMethod* m);
static void vala_class_real_add_property (ValaSymbol* base,
                                   ValaProperty* prop);
static void vala_class_real_add_constructor (ValaSymbol* base,
                                      ValaConstructor* c);
static void vala_class_real_add_destructor (ValaSymbol* base,
                                     ValaDestructor* d);
static void vala_class_real_accept (ValaCodeNode* base,
                             ValaCodeVisitor* visitor);
static void vala_class_real_accept_children (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static gboolean vala_class_real_is_reference_type (ValaTypeSymbol* base);
static gboolean vala_class_real_is_subtype_of (ValaTypeSymbol* base,
                                        ValaTypeSymbol* t);
static void vala_class_real_replace_type (ValaCodeNode* base,
                                   ValaDataType* old_type,
                                   ValaDataType* new_type);
static void vala_class_get_all_prerequisites (ValaClass* self,
                                       ValaInterface* iface,
                                       ValaList* list);
static gboolean vala_class_real_check (ValaCodeNode* base,
                                ValaCodeContext* context);
static void vala_class_finalize (ValaCodeNode * obj);
static GType vala_class_get_type_once (void);

static inline gpointer
vala_class_get_instance_private (ValaClass* self)
{
	return G_STRUCT_MEMBER_P (self, ValaClass_private_offset);
}

ValaClass*
vala_class_get_base_class (ValaClass* self)
{
	ValaClass* result;
	ValaClass* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_class;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_class_set_base_class (ValaClass* self,
                           ValaClass* value)
{
	ValaClass* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_base_class);
	self->priv->_base_class = _tmp0_;
}

gboolean
vala_class_get_is_abstract (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_abstract;
	return result;
}

void
vala_class_set_is_abstract (ValaClass* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_abstract = value;
}

gboolean
vala_class_get_is_partial (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_partial;
	return result;
}

void
vala_class_set_is_partial (ValaClass* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_partial = value;
}

gboolean
vala_class_get_is_sealed (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_sealed;
	return result;
}

void
vala_class_set_is_sealed (ValaClass* self,
                          gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_sealed = value;
}

static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}

static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}

gboolean
vala_class_get_is_compact (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp10_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_compact;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_ = FALSE;
		ValaClass* _tmp2_;
		_tmp2_ = self->priv->_base_class;
		if (_tmp2_ != NULL) {
			ValaClass* _tmp3_;
			_tmp3_ = self->priv->_base_class;
			_tmp1_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp3_, (ValaTypeSymbol*) self);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			ValaClass* _tmp4_;
			gboolean _tmp5_;
			gboolean _tmp6_;
			gboolean* _tmp7_;
			_tmp4_ = self->priv->_base_class;
			_tmp5_ = vala_class_get_is_compact (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = __bool_dup0 (&_tmp6_);
			_g_free0 (self->priv->_is_compact);
			self->priv->_is_compact = _tmp7_;
		} else {
			gboolean _tmp8_;
			gboolean* _tmp9_;
			_tmp8_ = vala_code_node_has_attribute ((ValaCodeNode*) self, "Compact");
			_tmp9_ = __bool_dup0 (&_tmp8_);
			_g_free0 (self->priv->_is_compact);
			self->priv->_is_compact = _tmp9_;
		}
	}
	_tmp10_ = self->priv->_is_compact;
	result = *_tmp10_;
	return result;
}

gboolean
vala_class_get_is_opaque (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_opaque;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_;
		gboolean* _tmp2_;
		_tmp1_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "Compact", "opaque", FALSE);
		_tmp2_ = __bool_dup0 (&_tmp1_);
		_g_free0 (self->priv->_is_opaque);
		self->priv->_is_opaque = _tmp2_;
	}
	_tmp3_ = self->priv->_is_opaque;
	result = *_tmp3_;
	return result;
}

gboolean
vala_class_get_is_immutable (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp10_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_immutable;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_ = FALSE;
		ValaClass* _tmp2_;
		_tmp2_ = self->priv->_base_class;
		if (_tmp2_ != NULL) {
			ValaClass* _tmp3_;
			_tmp3_ = self->priv->_base_class;
			_tmp1_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp3_, (ValaTypeSymbol*) self);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			ValaClass* _tmp4_;
			gboolean _tmp5_;
			gboolean _tmp6_;
			gboolean* _tmp7_;
			_tmp4_ = self->priv->_base_class;
			_tmp5_ = vala_class_get_is_immutable (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = __bool_dup0 (&_tmp6_);
			_g_free0 (self->priv->_is_immutable);
			self->priv->_is_immutable = _tmp7_;
		} else {
			gboolean _tmp8_;
			gboolean* _tmp9_;
			_tmp8_ = vala_code_node_has_attribute ((ValaCodeNode*) self, "Immutable");
			_tmp9_ = __bool_dup0 (&_tmp8_);
			_g_free0 (self->priv->_is_immutable);
			self->priv->_is_immutable = _tmp9_;
		}
	}
	_tmp10_ = self->priv->_is_immutable;
	result = *_tmp10_;
	return result;
}

gboolean
vala_class_get_is_singleton (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_singleton;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_;
		gboolean* _tmp2_;
		_tmp1_ = vala_code_node_has_attribute ((ValaCodeNode*) self, "SingleInstance");
		_tmp2_ = __bool_dup0 (&_tmp1_);
		_g_free0 (self->priv->_is_singleton);
		self->priv->_is_singleton = _tmp2_;
	}
	_tmp3_ = self->priv->_is_singleton;
	result = *_tmp3_;
	return result;
}

gboolean
vala_class_get_has_private_fields (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_private_fields;
	return result;
}

void
vala_class_set_has_private_fields (ValaClass* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_has_private_fields = value;
}

gboolean
vala_class_get_has_class_private_fields (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_class_private_fields;
	return result;
}

static void
vala_class_set_has_class_private_fields (ValaClass* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_has_class_private_fields = value;
}

static guint
_vala_symbol_hash_func_ghash_func (gconstpointer key)
{
	guint result;
	result = vala_symbol_hash_func ((ValaSymbol*) key);
	return result;
}

static gboolean
_vala_symbol_equal_func_gequal_func (gconstpointer a,
                                     gconstpointer b)
{
	gboolean result;
	result = vala_symbol_equal_func ((ValaSymbol*) a, (ValaSymbol*) b);
	return result;
}

ValaCreationMethod*
vala_class_get_default_construction_method (ValaClass* self)
{
	ValaCreationMethod* result;
	ValaCreationMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_construction_method;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_default_construction_method (ValaClass* self,
                                            ValaCreationMethod* value)
{
	ValaCreationMethod* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	self->priv->_default_construction_method = _tmp0_;
}

ValaConstructor*
vala_class_get_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_constructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_constructor (ValaClass* self,
                            ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_constructor);
	self->priv->_constructor = _tmp0_;
	_tmp1_ = self->priv->_constructor;
	if (_tmp1_ != NULL) {
		ValaConstructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_constructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaConstructor*
vala_class_get_class_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_constructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_class_constructor (ValaClass* self,
                                  ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_class_constructor);
	self->priv->_class_constructor = _tmp0_;
	_tmp1_ = self->priv->_class_constructor;
	if (_tmp1_ != NULL) {
		ValaConstructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_class_constructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaConstructor*
vala_class_get_static_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_static_constructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_static_constructor (ValaClass* self,
                                   ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_static_constructor);
	self->priv->_static_constructor = _tmp0_;
	_tmp1_ = self->priv->_static_constructor;
	if (_tmp1_ != NULL) {
		ValaConstructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_static_constructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaDestructor*
vala_class_get_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_destructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_destructor (ValaClass* self,
                           ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_destructor);
	self->priv->_destructor = _tmp0_;
	_tmp1_ = self->priv->_destructor;
	if (_tmp1_ != NULL) {
		ValaDestructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_destructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaDestructor*
vala_class_get_static_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_static_destructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_static_destructor (ValaClass* self,
                                  ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_static_destructor);
	self->priv->_static_destructor = _tmp0_;
	_tmp1_ = self->priv->_static_destructor;
	if (_tmp1_ != NULL) {
		ValaDestructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_static_destructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

ValaDestructor*
vala_class_get_class_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_destructor;
	result = _tmp0_;
	return result;
}

static void
vala_class_set_class_destructor (ValaClass* self,
                                 ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_class_destructor);
	self->priv->_class_destructor = _tmp0_;
	_tmp1_ = self->priv->_class_destructor;
	if (_tmp1_ != NULL) {
		ValaDestructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_class_destructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}

gboolean
vala_class_get_is_error_base (ValaClass* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = vala_code_node_has_attribute ((ValaCodeNode*) self, "ErrorBase");
	return result;
}

/**
 * Creates a new class.
 *
 * @param name             type name
 * @param source_reference reference to source code
 * @param comment          class documentation
 * @return                 newly created class
 */
ValaClass*
vala_class_construct (GType object_type,
                      const gchar* name,
                      ValaSourceReference* source_reference,
                      ValaComment* comment)
{
	ValaClass* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaClass*) vala_object_type_symbol_construct (object_type, name, source_reference, comment);
	return self;
}

ValaClass*
vala_class_new (const gchar* name,
                ValaSourceReference* source_reference,
                ValaComment* comment)
{
	return vala_class_construct (VALA_TYPE_CLASS, name, source_reference, comment);
}

/**
 * Adds the specified class or interface to the list of base types of
 * this class.
 *
 * @param type a class or interface reference
 */
void
vala_class_add_base_type (ValaClass* self,
                          ValaDataType* type)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = self->priv->base_types;
	vala_collection_add ((ValaCollection*) _tmp0_, type);
	vala_code_node_set_parent_node ((ValaCodeNode*) type, (ValaCodeNode*) self);
}

/**
 * Returns the base type list.
 *
 * @return list of base types
 */
ValaList*
vala_class_get_base_types (ValaClass* self)
{
	ValaList* _tmp0_;
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->base_types;
	result = _tmp0_;
	return result;
}

/**
 * Adds the specified field as a member to this class.
 *
 * @param f a field
 */
static void
vala_class_real_add_field (ValaSymbol* base,
                           ValaField* f)
{
	ValaClass * self;
	gboolean _tmp0_ = FALSE;
	ValaSymbolAccessibility _tmp1_;
	ValaSymbolAccessibility _tmp2_;
	self = (ValaClass*) base;
	g_return_if_fail (f != NULL);
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_field ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), f);
	_tmp1_ = vala_symbol_get_access ((ValaSymbol*) f);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaMemberBinding _tmp3_;
		ValaMemberBinding _tmp4_;
		_tmp3_ = vala_field_get_binding (f);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		vala_class_set_has_private_fields (self, TRUE);
	} else {
		gboolean _tmp5_ = FALSE;
		ValaSymbolAccessibility _tmp6_;
		ValaSymbolAccessibility _tmp7_;
		_tmp6_ = vala_symbol_get_access ((ValaSymbol*) f);
		_tmp7_ = _tmp6_;
		if (_tmp7_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaMemberBinding _tmp8_;
			ValaMemberBinding _tmp9_;
			_tmp8_ = vala_field_get_binding (f);
			_tmp9_ = _tmp8_;
			_tmp5_ = _tmp9_ == VALA_MEMBER_BINDING_CLASS;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			vala_class_set_has_class_private_fields (self, TRUE);
		}
	}
}

/**
 * Adds the specified method as a member to this class.
 *
 * @param m a method
 */
static void
vala_class_real_add_method (ValaSymbol* base,
                            ValaMethod* m)
{
	ValaClass * self;
	gboolean _tmp0_ = FALSE;
	ValaMemberBinding _tmp1_;
	ValaMemberBinding _tmp2_;
	gboolean _tmp25_ = FALSE;
	ValaDataType* _tmp26_;
	ValaDataType* _tmp27_;
	self = (ValaClass*) base;
	g_return_if_fail (m != NULL);
	_tmp1_ = vala_method_get_binding (m);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != VALA_MEMBER_BINDING_STATIC) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = VALA_IS_CREATION_METHOD (m);
	}
	if (_tmp0_) {
		ValaParameter* _tmp3_;
		ValaParameter* _tmp4_;
		ValaDataType* _tmp11_;
		ValaDataType* _tmp12_;
		ValaSourceReference* _tmp13_;
		ValaSourceReference* _tmp14_;
		ValaParameter* _tmp15_;
		ValaParameter* _tmp16_;
		ValaScope* _tmp17_;
		ValaScope* _tmp18_;
		ValaParameter* _tmp19_;
		ValaParameter* _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		ValaParameter* _tmp23_;
		ValaParameter* _tmp24_;
		_tmp3_ = vala_method_get_this_parameter (m);
		_tmp4_ = _tmp3_;
		if (_tmp4_ != NULL) {
			ValaScope* _tmp5_;
			ValaScope* _tmp6_;
			ValaParameter* _tmp7_;
			ValaParameter* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			_tmp5_ = vala_symbol_get_scope ((ValaSymbol*) m);
			_tmp6_ = _tmp5_;
			_tmp7_ = vala_method_get_this_parameter (m);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_symbol_get_name ((ValaSymbol*) _tmp8_);
			_tmp10_ = _tmp9_;
			vala_scope_remove (_tmp6_, _tmp10_);
		}
		_tmp11_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) m, (ValaTypeSymbol*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_parameter_new ("this", _tmp12_, _tmp14_);
		_tmp16_ = _tmp15_;
		vala_method_set_this_parameter (m, _tmp16_);
		_vala_code_node_unref0 (_tmp16_);
		_vala_code_node_unref0 (_tmp12_);
		_tmp17_ = vala_symbol_get_scope ((ValaSymbol*) m);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_method_get_this_parameter (m);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_symbol_get_name ((ValaSymbol*) _tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = vala_method_get_this_parameter (m);
		_tmp24_ = _tmp23_;
		vala_scope_add (_tmp18_, _tmp22_, (ValaSymbol*) _tmp24_);
	}
	_tmp26_ = vala_callable_get_return_type ((ValaCallable*) m);
	_tmp27_ = _tmp26_;
	if (!VALA_IS_VOID_TYPE (_tmp27_)) {
		ValaList* _tmp28_;
		gint _tmp29_;
		gint _tmp30_;
		_tmp28_ = vala_method_get_postconditions (m);
		_tmp29_ = vala_collection_get_size ((ValaCollection*) _tmp28_);
		_tmp30_ = _tmp29_;
		_tmp25_ = _tmp30_ > 0;
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		ValaLocalVariable* _tmp31_;
		ValaLocalVariable* _tmp32_;
		ValaDataType* _tmp39_;
		ValaDataType* _tmp40_;
		ValaDataType* _tmp41_;
		ValaDataType* _tmp42_;
		ValaSourceReference* _tmp43_;
		ValaSourceReference* _tmp44_;
		ValaLocalVariable* _tmp45_;
		ValaLocalVariable* _tmp46_;
		ValaLocalVariable* _tmp47_;
		ValaLocalVariable* _tmp48_;
		_tmp31_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp32_ = _tmp31_;
		if (_tmp32_ != NULL) {
			ValaScope* _tmp33_;
			ValaScope* _tmp34_;
			ValaLocalVariable* _tmp35_;
			ValaLocalVariable* _tmp36_;
			const gchar* _tmp37_;
			const gchar* _tmp38_;
			_tmp33_ = vala_symbol_get_scope ((ValaSymbol*) m);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
			_tmp36_ = _tmp35_;
			_tmp37_ = vala_symbol_get_name ((ValaSymbol*) _tmp36_);
			_tmp38_ = _tmp37_;
			vala_scope_remove (_tmp34_, _tmp38_);
		}
		_tmp39_ = vala_callable_get_return_type ((ValaCallable*) m);
		_tmp40_ = _tmp39_;
		_tmp41_ = vala_data_type_copy (_tmp40_);
		_tmp42_ = _tmp41_;
		_tmp43_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
		_tmp44_ = _tmp43_;
		_tmp45_ = vala_local_variable_new (_tmp42_, "result", NULL, _tmp44_);
		_tmp46_ = _tmp45_;
		vala_subroutine_set_result_var ((ValaSubroutine*) m, _tmp46_);
		_vala_code_node_unref0 (_tmp46_);
		_vala_code_node_unref0 (_tmp42_);
		_tmp47_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp48_ = _tmp47_;
		vala_local_variable_set_is_result (_tmp48_, TRUE);
	}
	if (VALA_IS_CREATION_METHOD (m)) {
		const gchar* _tmp49_;
		const gchar* _tmp50_;
		ValaCreationMethod* cm = NULL;
		gboolean _tmp51_ = FALSE;
		ValaCreationMethod* _tmp52_;
		const gchar* _tmp53_;
		const gchar* _tmp54_;
		gboolean _tmp67_ = FALSE;
		gboolean _tmp68_;
		_tmp49_ = vala_symbol_get_name ((ValaSymbol*) m);
		_tmp50_ = _tmp49_;
		if (_tmp50_ == NULL) {
			vala_class_set_default_construction_method (self, G_TYPE_CHECK_INSTANCE_CAST (m, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
			vala_symbol_set_name ((ValaSymbol*) m, ".new");
		}
		cm = G_TYPE_CHECK_INSTANCE_CAST (m, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
		_tmp52_ = cm;
		_tmp53_ = vala_creation_method_get_class_name (_tmp52_);
		_tmp54_ = _tmp53_;
		if (_tmp54_ != NULL) {
			ValaCreationMethod* _tmp55_;
			const gchar* _tmp56_;
			const gchar* _tmp57_;
			const gchar* _tmp58_;
			const gchar* _tmp59_;
			_tmp55_ = cm;
			_tmp56_ = vala_creation_method_get_class_name (_tmp55_);
			_tmp57_ = _tmp56_;
			_tmp58_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp59_ = _tmp58_;
			_tmp51_ = g_strcmp0 (_tmp57_, _tmp59_) != 0;
		} else {
			_tmp51_ = FALSE;
		}
		if (_tmp51_) {
			ValaSourceReference* _tmp60_;
			ValaSourceReference* _tmp61_;
			gchar* _tmp62_;
			gchar* _tmp63_;
			ValaCreationMethod* _tmp64_;
			const gchar* _tmp65_;
			const gchar* _tmp66_;
			_tmp60_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
			_tmp61_ = _tmp60_;
			_tmp62_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp63_ = _tmp62_;
			_tmp64_ = cm;
			_tmp65_ = vala_creation_method_get_class_name (_tmp64_);
			_tmp66_ = _tmp65_;
			vala_report_error (_tmp61_, "missing return type in method `%s.%s´", _tmp63_, _tmp66_);
			_g_free0 (_tmp63_);
			vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
			return;
		}
		_tmp68_ = self->priv->_is_abstract;
		if (_tmp68_) {
			ValaCreationMethod* _tmp69_;
			ValaSymbolAccessibility _tmp70_;
			ValaSymbolAccessibility _tmp71_;
			_tmp69_ = cm;
			_tmp70_ = vala_symbol_get_access ((ValaSymbol*) _tmp69_);
			_tmp71_ = _tmp70_;
			_tmp67_ = _tmp71_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
		} else {
			_tmp67_ = FALSE;
		}
		if (_tmp67_) {
			gboolean _tmp72_;
			gboolean _tmp73_;
			_tmp72_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp73_ = _tmp72_;
			if (_tmp73_) {
				ValaSourceReference* _tmp74_;
				ValaSourceReference* _tmp75_;
				_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
				_tmp75_ = _tmp74_;
				vala_report_warning (_tmp75_, "Creation method of abstract class cannot be public.");
			} else {
				ValaSourceReference* _tmp76_;
				ValaSourceReference* _tmp77_;
				_tmp76_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
				_tmp77_ = _tmp76_;
				vala_report_error (_tmp77_, "Creation method of abstract class cannot be public.");
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				return;
			}
		}
	}
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_method ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), m);
}

static gpointer
_vala_map_ref0 (gpointer self)
{
	return self ? vala_map_ref (self) : NULL;
}

ValaHashMap*
vala_class_get_implicit_implementations (ValaClass* self)
{
	ValaHashMap* _tmp0_;
	ValaHashMap* _tmp1_;
	ValaHashMap* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->implicit_implementations;
	_tmp1_ = _vala_map_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
 * Adds the specified property as a member to this class.
 *
 * @param prop a property
 */
static void
vala_class_real_add_property (ValaSymbol* base,
                              ValaProperty* prop)
{
	ValaClass * self;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaField* _tmp16_;
	ValaField* _tmp17_;
	self = (ValaClass*) base;
	g_return_if_fail (prop != NULL);
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_property ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), prop);
	_tmp0_ = vala_property_get_binding (prop);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != VALA_MEMBER_BINDING_STATIC) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaParameter* _tmp6_;
		ValaParameter* _tmp7_;
		ValaScope* _tmp8_;
		ValaScope* _tmp9_;
		ValaParameter* _tmp10_;
		ValaParameter* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		ValaParameter* _tmp14_;
		ValaParameter* _tmp15_;
		_tmp2_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) prop, (ValaTypeSymbol*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) prop);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_parameter_new ("this", _tmp3_, _tmp5_);
		_tmp7_ = _tmp6_;
		vala_property_set_this_parameter (prop, _tmp7_);
		_vala_code_node_unref0 (_tmp7_);
		_vala_code_node_unref0 (_tmp3_);
		_tmp8_ = vala_symbol_get_scope ((ValaSymbol*) prop);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_property_get_this_parameter (prop);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_symbol_get_name ((ValaSymbol*) _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_property_get_this_parameter (prop);
		_tmp15_ = _tmp14_;
		vala_scope_add (_tmp9_, _tmp13_, (ValaSymbol*) _tmp15_);
	}
	_tmp16_ = vala_property_get_field (prop);
	_tmp17_ = _tmp16_;
	if (_tmp17_ != NULL) {
		ValaField* _tmp18_;
		ValaField* _tmp19_;
		_tmp18_ = vala_property_get_field (prop);
		_tmp19_ = _tmp18_;
		vala_symbol_add_field ((ValaSymbol*) self, _tmp19_);
	}
}

static void
vala_class_real_add_constructor (ValaSymbol* base,
                                 ValaConstructor* c)
{
	ValaClass * self;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaMemberBinding _tmp14_;
	ValaMemberBinding _tmp15_;
	self = (ValaClass*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = vala_constructor_get_binding (c);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case VALA_MEMBER_BINDING_INSTANCE:
		{
			ValaConstructor* _tmp2_;
			ValaConstructor* _tmp3_;
			_tmp2_ = vala_class_get_constructor (self);
			_tmp3_ = _tmp2_;
			if (_tmp3_ != NULL) {
				ValaSourceReference* _tmp4_;
				ValaSourceReference* _tmp5_;
				_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp5_ = _tmp4_;
				vala_report_error (_tmp5_, "class already contains a constructor");
			}
			vala_class_set_constructor (self, c);
			break;
		}
		case VALA_MEMBER_BINDING_CLASS:
		{
			ValaConstructor* _tmp6_;
			ValaConstructor* _tmp7_;
			_tmp6_ = vala_class_get_class_constructor (self);
			_tmp7_ = _tmp6_;
			if (_tmp7_ != NULL) {
				ValaSourceReference* _tmp8_;
				ValaSourceReference* _tmp9_;
				_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp9_ = _tmp8_;
				vala_report_error (_tmp9_, "class already contains a class constructor");
			}
			vala_class_set_class_constructor (self, c);
			break;
		}
		case VALA_MEMBER_BINDING_STATIC:
		{
			ValaConstructor* _tmp10_;
			ValaConstructor* _tmp11_;
			_tmp10_ = vala_class_get_static_constructor (self);
			_tmp11_ = _tmp10_;
			if (_tmp11_ != NULL) {
				ValaSourceReference* _tmp12_;
				ValaSourceReference* _tmp13_;
				_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp13_ = _tmp12_;
				vala_report_error (_tmp13_, "class already contains a static constructor");
			}
			vala_class_set_static_constructor (self, c);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp14_ = vala_constructor_get_binding (c);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != VALA_MEMBER_BINDING_STATIC) {
		ValaParameter* _tmp16_;
		ValaParameter* _tmp17_;
		ValaDataType* _tmp24_;
		ValaDataType* _tmp25_;
		ValaSourceReference* _tmp26_;
		ValaSourceReference* _tmp27_;
		ValaParameter* _tmp28_;
		ValaParameter* _tmp29_;
		ValaScope* _tmp30_;
		ValaScope* _tmp31_;
		ValaParameter* _tmp32_;
		ValaParameter* _tmp33_;
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		ValaParameter* _tmp36_;
		ValaParameter* _tmp37_;
		_tmp16_ = vala_constructor_get_this_parameter (c);
		_tmp17_ = _tmp16_;
		if (_tmp17_ != NULL) {
			ValaScope* _tmp18_;
			ValaScope* _tmp19_;
			ValaParameter* _tmp20_;
			ValaParameter* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			_tmp18_ = vala_symbol_get_scope ((ValaSymbol*) c);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_constructor_get_this_parameter (c);
			_tmp21_ = _tmp20_;
			_tmp22_ = vala_symbol_get_name ((ValaSymbol*) _tmp21_);
			_tmp23_ = _tmp22_;
			vala_scope_remove (_tmp19_, _tmp23_);
		}
		_tmp24_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) c, (ValaTypeSymbol*) self);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
		_tmp27_ = _tmp26_;
		_tmp28_ = vala_parameter_new ("this", _tmp25_, _tmp27_);
		_tmp29_ = _tmp28_;
		vala_constructor_set_this_parameter (c, _tmp29_);
		_vala_code_node_unref0 (_tmp29_);
		_vala_code_node_unref0 (_tmp25_);
		_tmp30_ = vala_symbol_get_scope ((ValaSymbol*) c);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_constructor_get_this_parameter (c);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_symbol_get_name ((ValaSymbol*) _tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_constructor_get_this_parameter (c);
		_tmp37_ = _tmp36_;
		vala_scope_add (_tmp31_, _tmp35_, (ValaSymbol*) _tmp37_);
	}
}

static void
vala_class_real_add_destructor (ValaSymbol* base,
                                ValaDestructor* d)
{
	ValaClass * self;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaMemberBinding _tmp14_;
	ValaMemberBinding _tmp15_;
	self = (ValaClass*) base;
	g_return_if_fail (d != NULL);
	_tmp0_ = vala_destructor_get_binding (d);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case VALA_MEMBER_BINDING_INSTANCE:
		{
			ValaDestructor* _tmp2_;
			ValaDestructor* _tmp3_;
			_tmp2_ = vala_class_get_destructor (self);
			_tmp3_ = _tmp2_;
			if (_tmp3_ != NULL) {
				ValaSourceReference* _tmp4_;
				ValaSourceReference* _tmp5_;
				_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
				_tmp5_ = _tmp4_;
				vala_report_error (_tmp5_, "class already contains a destructor");
			}
			vala_class_set_destructor (self, d);
			break;
		}
		case VALA_MEMBER_BINDING_CLASS:
		{
			ValaDestructor* _tmp6_;
			ValaDestructor* _tmp7_;
			_tmp6_ = vala_class_get_class_destructor (self);
			_tmp7_ = _tmp6_;
			if (_tmp7_ != NULL) {
				ValaSourceReference* _tmp8_;
				ValaSourceReference* _tmp9_;
				_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
				_tmp9_ = _tmp8_;
				vala_report_error (_tmp9_, "class already contains a class destructor");
			}
			vala_class_set_class_destructor (self, d);
			break;
		}
		case VALA_MEMBER_BINDING_STATIC:
		{
			ValaDestructor* _tmp10_;
			ValaDestructor* _tmp11_;
			_tmp10_ = vala_class_get_static_destructor (self);
			_tmp11_ = _tmp10_;
			if (_tmp11_ != NULL) {
				ValaSourceReference* _tmp12_;
				ValaSourceReference* _tmp13_;
				_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
				_tmp13_ = _tmp12_;
				vala_report_error (_tmp13_, "class already contains a static destructor");
			}
			vala_class_set_static_destructor (self, d);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp14_ = vala_destructor_get_binding (d);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != VALA_MEMBER_BINDING_STATIC) {
		ValaParameter* _tmp16_;
		ValaParameter* _tmp17_;
		ValaDataType* _tmp24_;
		ValaDataType* _tmp25_;
		ValaSourceReference* _tmp26_;
		ValaSourceReference* _tmp27_;
		ValaParameter* _tmp28_;
		ValaParameter* _tmp29_;
		ValaScope* _tmp30_;
		ValaScope* _tmp31_;
		ValaParameter* _tmp32_;
		ValaParameter* _tmp33_;
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		ValaParameter* _tmp36_;
		ValaParameter* _tmp37_;
		_tmp16_ = vala_destructor_get_this_parameter (d);
		_tmp17_ = _tmp16_;
		if (_tmp17_ != NULL) {
			ValaScope* _tmp18_;
			ValaScope* _tmp19_;
			ValaParameter* _tmp20_;
			ValaParameter* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			_tmp18_ = vala_symbol_get_scope ((ValaSymbol*) d);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_destructor_get_this_parameter (d);
			_tmp21_ = _tmp20_;
			_tmp22_ = vala_symbol_get_name ((ValaSymbol*) _tmp21_);
			_tmp23_ = _tmp22_;
			vala_scope_remove (_tmp19_, _tmp23_);
		}
		_tmp24_ = vala_semantic_analyzer_get_this_type ((ValaSymbol*) d, (ValaTypeSymbol*) self);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
		_tmp27_ = _tmp26_;
		_tmp28_ = vala_parameter_new ("this", _tmp25_, _tmp27_);
		_tmp29_ = _tmp28_;
		vala_destructor_set_this_parameter (d, _tmp29_);
		_vala_code_node_unref0 (_tmp29_);
		_vala_code_node_unref0 (_tmp25_);
		_tmp30_ = vala_symbol_get_scope ((ValaSymbol*) d);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_destructor_get_this_parameter (d);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_symbol_get_name ((ValaSymbol*) _tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_destructor_get_this_parameter (d);
		_tmp37_ = _tmp36_;
		vala_scope_add (_tmp31_, _tmp35_, (ValaSymbol*) _tmp37_);
	}
}

static void
vala_class_real_accept (ValaCodeNode* base,
                        ValaCodeVisitor* visitor)
{
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_class (visitor, self);
}

static void
vala_class_real_accept_children (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaClass * self;
	ValaConstructor* _tmp9_;
	ValaConstructor* _tmp10_;
	ValaConstructor* _tmp13_;
	ValaConstructor* _tmp14_;
	ValaConstructor* _tmp17_;
	ValaConstructor* _tmp18_;
	ValaDestructor* _tmp21_;
	ValaDestructor* _tmp22_;
	ValaDestructor* _tmp25_;
	ValaDestructor* _tmp26_;
	ValaDestructor* _tmp29_;
	ValaDestructor* _tmp30_;
	self = (ValaClass*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp0_;
		gint _type_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _type_index = 0;
		_tmp0_ = self->priv->base_types;
		_type_list = _tmp0_;
		_tmp1_ = _type_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_type_size = _tmp3_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaDataType* type = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaDataType* _tmp8_;
			_type_index = _type_index + 1;
			_tmp4_ = _type_index;
			_tmp5_ = _type_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _type_list;
			_tmp7_ = vala_list_get (_tmp6_, _type_index);
			type = (ValaDataType*) _tmp7_;
			_tmp8_ = type;
			vala_code_node_accept ((ValaCodeNode*) _tmp8_, visitor);
			_vala_code_node_unref0 (type);
		}
	}
	VALA_CODE_NODE_CLASS (vala_class_parent_class)->accept_children ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), visitor);
	_tmp9_ = vala_class_get_constructor (self);
	_tmp10_ = _tmp9_;
	if (_tmp10_ != NULL) {
		ValaConstructor* _tmp11_;
		ValaConstructor* _tmp12_;
		_tmp11_ = vala_class_get_constructor (self);
		_tmp12_ = _tmp11_;
		vala_code_node_accept ((ValaCodeNode*) _tmp12_, visitor);
	}
	_tmp13_ = vala_class_get_class_constructor (self);
	_tmp14_ = _tmp13_;
	if (_tmp14_ != NULL) {
		ValaConstructor* _tmp15_;
		ValaConstructor* _tmp16_;
		_tmp15_ = vala_class_get_class_constructor (self);
		_tmp16_ = _tmp15_;
		vala_code_node_accept ((ValaCodeNode*) _tmp16_, visitor);
	}
	_tmp17_ = vala_class_get_static_constructor (self);
	_tmp18_ = _tmp17_;
	if (_tmp18_ != NULL) {
		ValaConstructor* _tmp19_;
		ValaConstructor* _tmp20_;
		_tmp19_ = vala_class_get_static_constructor (self);
		_tmp20_ = _tmp19_;
		vala_code_node_accept ((ValaCodeNode*) _tmp20_, visitor);
	}
	_tmp21_ = vala_class_get_destructor (self);
	_tmp22_ = _tmp21_;
	if (_tmp22_ != NULL) {
		ValaDestructor* _tmp23_;
		ValaDestructor* _tmp24_;
		_tmp23_ = vala_class_get_destructor (self);
		_tmp24_ = _tmp23_;
		vala_code_node_accept ((ValaCodeNode*) _tmp24_, visitor);
	}
	_tmp25_ = vala_class_get_static_destructor (self);
	_tmp26_ = _tmp25_;
	if (_tmp26_ != NULL) {
		ValaDestructor* _tmp27_;
		ValaDestructor* _tmp28_;
		_tmp27_ = vala_class_get_static_destructor (self);
		_tmp28_ = _tmp27_;
		vala_code_node_accept ((ValaCodeNode*) _tmp28_, visitor);
	}
	_tmp29_ = vala_class_get_class_destructor (self);
	_tmp30_ = _tmp29_;
	if (_tmp30_ != NULL) {
		ValaDestructor* _tmp31_;
		ValaDestructor* _tmp32_;
		_tmp31_ = vala_class_get_class_destructor (self);
		_tmp32_ = _tmp31_;
		vala_code_node_accept ((ValaCodeNode*) _tmp32_, visitor);
	}
}

static gboolean
vala_class_real_is_reference_type (ValaTypeSymbol* base)
{
	ValaClass * self;
	gboolean result;
	self = (ValaClass*) base;
	result = TRUE;
	return result;
}

gboolean
vala_class_is_fundamental (ValaClass* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = vala_class_get_is_compact (self);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		ValaClass* _tmp3_;
		_tmp3_ = self->priv->_base_class;
		_tmp0_ = _tmp3_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
vala_class_real_is_subtype_of (ValaTypeSymbol* base,
                               ValaTypeSymbol* t)
{
	ValaClass * self;
	gboolean result;
	self = (ValaClass*) base;
	g_return_val_if_fail (t != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp0_;
		gint _base_type_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _base_type_index = 0;
		_tmp0_ = self->priv->base_types;
		_base_type_list = _tmp0_;
		_tmp1_ = _base_type_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_base_type_size = _tmp3_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			gboolean _tmp8_ = FALSE;
			gboolean _tmp9_ = FALSE;
			ValaDataType* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			ValaTypeSymbol* _tmp12_;
			_base_type_index = _base_type_index + 1;
			_tmp4_ = _base_type_index;
			_tmp5_ = _base_type_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _base_type_list;
			_tmp7_ = vala_list_get (_tmp6_, _base_type_index);
			base_type = (ValaDataType*) _tmp7_;
			_tmp10_ = base_type;
			_tmp11_ = vala_data_type_get_type_symbol (_tmp10_);
			_tmp12_ = _tmp11_;
			if (_tmp12_ != NULL) {
				ValaDataType* _tmp13_;
				ValaTypeSymbol* _tmp14_;
				ValaTypeSymbol* _tmp15_;
				_tmp13_ = base_type;
				_tmp14_ = vala_data_type_get_type_symbol (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp9_ = _tmp15_ != G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				ValaDataType* _tmp16_;
				ValaTypeSymbol* _tmp17_;
				ValaTypeSymbol* _tmp18_;
				_tmp16_ = base_type;
				_tmp17_ = vala_data_type_get_type_symbol (_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp8_ = vala_typesymbol_is_subtype_of (_tmp18_, t);
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				result = TRUE;
				_vala_code_node_unref0 (base_type);
				return result;
			}
			_vala_code_node_unref0 (base_type);
		}
	}
	result = FALSE;
	return result;
}

static void
vala_class_real_replace_type (ValaCodeNode* base,
                              ValaDataType* old_type,
                              ValaDataType* new_type)
{
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->base_types;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->base_types;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->base_types;
					vala_list_set (_tmp9_, i, new_type);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_type, (ValaCodeNode*) self);
					return;
				}
			}
		}
	}
}

static void
vala_class_get_all_prerequisites (ValaClass* self,
                                  ValaInterface* iface,
                                  ValaList* list)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface != NULL);
	g_return_if_fail (list != NULL);
	{
		ValaList* _prereq_list = NULL;
		ValaList* _tmp0_;
		gint _prereq_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _prereq_index = 0;
		_tmp0_ = vala_interface_get_prerequisites (iface);
		_prereq_list = _tmp0_;
		_tmp1_ = _prereq_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_prereq_size = _tmp3_;
		_prereq_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaDataType* prereq = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaTypeSymbol* type = NULL;
			ValaDataType* _tmp8_;
			ValaTypeSymbol* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			ValaTypeSymbol* _tmp12_;
			ValaTypeSymbol* _tmp13_;
			ValaTypeSymbol* _tmp14_;
			_prereq_index = _prereq_index + 1;
			_tmp4_ = _prereq_index;
			_tmp5_ = _prereq_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _prereq_list;
			_tmp7_ = vala_list_get (_tmp6_, _prereq_index);
			prereq = (ValaDataType*) _tmp7_;
			_tmp8_ = prereq;
			_tmp9_ = vala_data_type_get_type_symbol (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = _vala_code_node_ref0 (_tmp10_);
			type = _tmp11_;
			_tmp12_ = type;
			if (_tmp12_ == NULL) {
				_vala_code_node_unref0 (type);
				_vala_code_node_unref0 (prereq);
				continue;
			}
			_tmp13_ = type;
			vala_collection_add ((ValaCollection*) list, _tmp13_);
			_tmp14_ = type;
			if (VALA_IS_INTERFACE (_tmp14_)) {
				ValaTypeSymbol* _tmp15_;
				_tmp15_ = type;
				vala_class_get_all_prerequisites (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, VALA_TYPE_INTERFACE, ValaInterface), list);
			}
			_vala_code_node_unref0 (type);
			_vala_code_node_unref0 (prereq);
		}
	}
}

gboolean
vala_class_is_a (ValaClass* self,
                 ValaObjectTypeSymbol* t)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (t != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp0_;
		gint _base_type_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _base_type_index = 0;
		_tmp0_ = vala_class_get_base_types (self);
		_base_type_list = _tmp0_;
		_tmp1_ = _base_type_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_base_type_size = _tmp3_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaDataType* _tmp8_;
			ValaTypeSymbol* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			_base_type_index = _base_type_index + 1;
			_tmp4_ = _base_type_index;
			_tmp5_ = _base_type_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _base_type_list;
			_tmp7_ = vala_list_get (_tmp6_, _base_type_index);
			base_type = (ValaDataType*) _tmp7_;
			_tmp8_ = base_type;
			_tmp9_ = vala_data_type_get_type_symbol (_tmp8_);
			_tmp10_ = _tmp9_;
			if (VALA_IS_CLASS (_tmp10_)) {
				ValaDataType* _tmp11_;
				ValaTypeSymbol* _tmp12_;
				ValaTypeSymbol* _tmp13_;
				_tmp11_ = base_type;
				_tmp12_ = vala_data_type_get_type_symbol (_tmp11_);
				_tmp13_ = _tmp12_;
				if (vala_class_is_a (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_CLASS, ValaClass), t)) {
					result = TRUE;
					_vala_code_node_unref0 (base_type);
					return result;
				}
			} else {
				ValaDataType* _tmp14_;
				ValaTypeSymbol* _tmp15_;
				ValaTypeSymbol* _tmp16_;
				_tmp14_ = base_type;
				_tmp15_ = vala_data_type_get_type_symbol (_tmp14_);
				_tmp16_ = _tmp15_;
				if (_tmp16_ == G_TYPE_CHECK_INSTANCE_CAST (t, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol)) {
					result = TRUE;
					_vala_code_node_unref0 (base_type);
					return result;
				}
			}
			_vala_code_node_unref0 (base_type);
		}
	}
	result = FALSE;
	return result;
}

gboolean
vala_class_implements (ValaClass* self,
                       ValaInterface* i)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (i != NULL, FALSE);
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp0_;
		gint _base_type_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _base_type_index = 0;
		_tmp0_ = vala_class_get_base_types (self);
		_base_type_list = _tmp0_;
		_tmp1_ = _base_type_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_base_type_size = _tmp3_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaDataType* _tmp8_;
			ValaTypeSymbol* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			_base_type_index = _base_type_index + 1;
			_tmp4_ = _base_type_index;
			_tmp5_ = _base_type_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _base_type_list;
			_tmp7_ = vala_list_get (_tmp6_, _base_type_index);
			base_type = (ValaDataType*) _tmp7_;
			_tmp8_ = base_type;
			_tmp9_ = vala_data_type_get_type_symbol (_tmp8_);
			_tmp10_ = _tmp9_;
			if (_tmp10_ == G_TYPE_CHECK_INSTANCE_CAST (i, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol)) {
				result = TRUE;
				_vala_code_node_unref0 (base_type);
				return result;
			}
			_vala_code_node_unref0 (base_type);
		}
	}
	result = FALSE;
	return result;
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gboolean
vala_class_real_check (ValaCodeNode* base,
                       ValaCodeContext* context)
{
	ValaClass * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	gboolean _tmp71_ = FALSE;
	ValaClass* _tmp72_;
	gboolean _tmp83_ = FALSE;
	gboolean _tmp84_;
	gboolean _tmp85_;
	gboolean _tmp93_ = FALSE;
	gboolean _tmp94_;
	gboolean _tmp95_;
	gboolean _tmp107_ = FALSE;
	gboolean _tmp108_ = FALSE;
	gboolean _tmp109_;
	gboolean _tmp110_;
	gboolean _tmp121_;
	ValaConstructor* _tmp235_;
	ValaConstructor* _tmp236_;
	ValaConstructor* _tmp239_;
	ValaConstructor* _tmp240_;
	ValaConstructor* _tmp243_;
	ValaConstructor* _tmp244_;
	ValaDestructor* _tmp247_;
	ValaDestructor* _tmp248_;
	ValaDestructor* _tmp251_;
	ValaDestructor* _tmp252_;
	ValaDestructor* _tmp255_;
	ValaDestructor* _tmp256_;
	gboolean _tmp295_;
	gboolean _tmp296_;
	ValaList* prerequisites = NULL;
	GEqualFunc _tmp337_;
	ValaArrayList* _tmp338_;
	ValaList* missing_prereqs = NULL;
	GEqualFunc _tmp354_;
	ValaArrayList* _tmp355_;
	ValaList* _tmp369_;
	gint _tmp370_;
	gint _tmp371_;
	ValaSourceFileType _tmp395_;
	ValaSourceFileType _tmp396_;
	ValaSemanticAnalyzer* _tmp613_;
	ValaSemanticAnalyzer* _tmp614_;
	ValaSourceFile* _tmp615_;
	ValaSemanticAnalyzer* _tmp616_;
	ValaSemanticAnalyzer* _tmp617_;
	ValaSymbol* _tmp618_;
	gboolean _tmp619_;
	gboolean _tmp620_;
	gboolean result;
	self = (ValaClass*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	if (!VALA_CODE_NODE_CLASS (vala_class_parent_class)->check ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), context)) {
		result = FALSE;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_context_get_analyzer (context);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_semantic_analyzer_get_current_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	old_symbol = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceFile* _tmp20_;
		ValaSourceFile* _tmp21_;
		_tmp16_ = vala_code_context_get_analyzer (context);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_source_reference_get_file (_tmp19_);
		_tmp21_ = _tmp20_;
		vala_semantic_analyzer_set_current_source_file (_tmp17_, _tmp21_);
	}
	_tmp22_ = vala_code_context_get_analyzer (context);
	_tmp23_ = _tmp22_;
	vala_semantic_analyzer_set_current_symbol (_tmp23_, (ValaSymbol*) self);
	{
		ValaList* _base_type_reference_list = NULL;
		ValaList* _tmp24_;
		gint _base_type_reference_size = 0;
		ValaList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _base_type_reference_index = 0;
		_tmp24_ = vala_class_get_base_types (self);
		_base_type_reference_list = _tmp24_;
		_tmp25_ = _base_type_reference_list;
		_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_base_type_reference_size = _tmp27_;
		_base_type_reference_index = -1;
		while (TRUE) {
			gint _tmp28_;
			gint _tmp29_;
			ValaDataType* base_type_reference = NULL;
			ValaList* _tmp30_;
			gpointer _tmp31_;
			ValaDataType* _tmp32_;
			ValaDataType* _tmp33_;
			ValaDataType* _tmp41_;
			ValaDataType* _tmp49_;
			_base_type_reference_index = _base_type_reference_index + 1;
			_tmp28_ = _base_type_reference_index;
			_tmp29_ = _base_type_reference_size;
			if (!(_tmp28_ < _tmp29_)) {
				break;
			}
			_tmp30_ = _base_type_reference_list;
			_tmp31_ = vala_list_get (_tmp30_, _base_type_reference_index);
			base_type_reference = (ValaDataType*) _tmp31_;
			_tmp32_ = base_type_reference;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp32_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp33_ = base_type_reference;
			if (!VALA_IS_OBJECT_TYPE (_tmp33_)) {
				ValaSourceReference* _tmp34_;
				ValaSourceReference* _tmp35_;
				ValaDataType* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp34_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp35_ = _tmp34_;
				_tmp36_ = base_type_reference;
				_tmp37_ = vala_code_node_to_string ((ValaCodeNode*) _tmp36_);
				_tmp38_ = _tmp37_;
				_tmp39_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp40_ = _tmp39_;
				vala_report_error (_tmp35_, "base type `%s' of class `%s' is not an object type", _tmp38_, _tmp40_);
				_g_free0 (_tmp40_);
				_g_free0 (_tmp38_);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp41_ = base_type_reference;
			if (!vala_data_type_is_accessible (_tmp41_, (ValaSymbol*) self)) {
				ValaSourceReference* _tmp42_;
				ValaSourceReference* _tmp43_;
				ValaDataType* _tmp44_;
				gchar* _tmp45_;
				gchar* _tmp46_;
				gchar* _tmp47_;
				gchar* _tmp48_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp42_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp43_ = _tmp42_;
				_tmp44_ = base_type_reference;
				_tmp45_ = vala_code_node_to_string ((ValaCodeNode*) _tmp44_);
				_tmp46_ = _tmp45_;
				_tmp47_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp48_ = _tmp47_;
				vala_report_error (_tmp43_, "base type `%s' is less accessible than class `%s'", _tmp46_, _tmp48_);
				_g_free0 (_tmp48_);
				_g_free0 (_tmp46_);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp49_ = base_type_reference;
			if (!vala_data_type_check_type_arguments (_tmp49_, context, FALSE)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (base_type_reference);
		}
	}
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp50_;
		gint _type_size = 0;
		ValaList* _tmp51_;
		gint _tmp52_;
		gint _tmp53_;
		gint _type_index = 0;
		_tmp50_ = self->priv->base_types;
		_type_list = _tmp50_;
		_tmp51_ = _type_list;
		_tmp52_ = vala_collection_get_size ((ValaCollection*) _tmp51_);
		_tmp53_ = _tmp52_;
		_type_size = _tmp53_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp54_;
			gint _tmp55_;
			ValaDataType* type = NULL;
			ValaList* _tmp56_;
			gpointer _tmp57_;
			ValaDataType* _tmp58_;
			ValaSemanticAnalyzer* _tmp59_;
			ValaSemanticAnalyzer* _tmp60_;
			ValaDataType* _tmp61_;
			_type_index = _type_index + 1;
			_tmp54_ = _type_index;
			_tmp55_ = _type_size;
			if (!(_tmp54_ < _tmp55_)) {
				break;
			}
			_tmp56_ = _type_list;
			_tmp57_ = vala_list_get (_tmp56_, _type_index);
			type = (ValaDataType*) _tmp57_;
			_tmp58_ = type;
			vala_code_node_check ((ValaCodeNode*) _tmp58_, context);
			_tmp59_ = vala_code_context_get_analyzer (context);
			_tmp60_ = _tmp59_;
			_tmp61_ = type;
			vala_semantic_analyzer_check_type (_tmp60_, _tmp61_);
			_vala_code_node_unref0 (type);
		}
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp62_;
		gint _p_size = 0;
		ValaList* _tmp63_;
		gint _tmp64_;
		gint _tmp65_;
		gint _p_index = 0;
		_tmp62_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_p_list = _tmp62_;
		_tmp63_ = _p_list;
		_tmp64_ = vala_collection_get_size ((ValaCollection*) _tmp63_);
		_tmp65_ = _tmp64_;
		_p_size = _tmp65_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp66_;
			gint _tmp67_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp68_;
			gpointer _tmp69_;
			ValaTypeParameter* _tmp70_;
			_p_index = _p_index + 1;
			_tmp66_ = _p_index;
			_tmp67_ = _p_size;
			if (!(_tmp66_ < _tmp67_)) {
				break;
			}
			_tmp68_ = _p_list;
			_tmp69_ = vala_list_get (_tmp68_, _p_index);
			p = (ValaTypeParameter*) _tmp69_;
			_tmp70_ = p;
			vala_code_node_check ((ValaCodeNode*) _tmp70_, context);
			_vala_code_node_unref0 (p);
		}
	}
	_tmp72_ = self->priv->_base_class;
	if (_tmp72_ != NULL) {
		ValaClass* _tmp73_;
		gboolean _tmp74_;
		gboolean _tmp75_;
		_tmp73_ = self->priv->_base_class;
		_tmp74_ = vala_class_get_is_singleton (_tmp73_);
		_tmp75_ = _tmp74_;
		_tmp71_ = _tmp75_;
	} else {
		_tmp71_ = FALSE;
	}
	if (_tmp71_) {
		ValaSourceReference* _tmp76_;
		ValaSourceReference* _tmp77_;
		gchar* _tmp78_;
		gchar* _tmp79_;
		ValaClass* _tmp80_;
		gchar* _tmp81_;
		gchar* _tmp82_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp76_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp77_ = _tmp76_;
		_tmp78_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp79_ = _tmp78_;
		_tmp80_ = self->priv->_base_class;
		_tmp81_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp80_);
		_tmp82_ = _tmp81_;
		vala_report_error (_tmp77_, "`%s' cannot inherit from SingleInstance class `%s'", _tmp79_, _tmp82_);
		_g_free0 (_tmp82_);
		_g_free0 (_tmp79_);
	}
	_tmp84_ = vala_class_get_is_singleton (self);
	_tmp85_ = _tmp84_;
	if (_tmp85_) {
		ValaSemanticAnalyzer* _tmp86_;
		ValaSemanticAnalyzer* _tmp87_;
		ValaClass* _tmp88_;
		_tmp86_ = vala_code_context_get_analyzer (context);
		_tmp87_ = _tmp86_;
		_tmp88_ = _tmp87_->object_type;
		_tmp83_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) self, (ValaTypeSymbol*) _tmp88_);
	} else {
		_tmp83_ = FALSE;
	}
	if (_tmp83_) {
		ValaSourceReference* _tmp89_;
		ValaSourceReference* _tmp90_;
		gchar* _tmp91_;
		gchar* _tmp92_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp89_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp90_ = _tmp89_;
		_tmp91_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp92_ = _tmp91_;
		vala_report_error (_tmp90_, "SingleInstance class `%s' requires inheritance from `GLib.Object'", _tmp92_);
		_g_free0 (_tmp92_);
	}
	_tmp94_ = vala_class_get_is_singleton (self);
	_tmp95_ = _tmp94_;
	if (_tmp95_) {
		ValaConstructor* _tmp96_;
		ValaConstructor* _tmp97_;
		_tmp96_ = vala_class_get_constructor (self);
		_tmp97_ = _tmp96_;
		_tmp93_ = _tmp97_ == NULL;
	} else {
		_tmp93_ = FALSE;
	}
	if (_tmp93_) {
		ValaConstructor* c = NULL;
		ValaSourceReference* _tmp98_;
		ValaSourceReference* _tmp99_;
		ValaConstructor* _tmp100_;
		ValaConstructor* _tmp101_;
		ValaSourceReference* _tmp102_;
		ValaSourceReference* _tmp103_;
		ValaBlock* _tmp104_;
		ValaBlock* _tmp105_;
		ValaConstructor* _tmp106_;
		_tmp98_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp99_ = _tmp98_;
		_tmp100_ = vala_constructor_new (_tmp99_);
		c = _tmp100_;
		_tmp101_ = c;
		_tmp102_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp103_ = _tmp102_;
		_tmp104_ = vala_block_new (_tmp103_);
		_tmp105_ = _tmp104_;
		vala_subroutine_set_body ((ValaSubroutine*) _tmp101_, _tmp105_);
		_vala_code_node_unref0 (_tmp105_);
		_tmp106_ = c;
		vala_symbol_add_constructor ((ValaSymbol*) self, _tmp106_);
		_vala_code_node_unref0 (c);
	}
	_tmp109_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp110_ = _tmp109_;
	if (!_tmp110_) {
		ValaClass* _tmp111_;
		_tmp111_ = self->priv->_base_class;
		_tmp108_ = _tmp111_ != NULL;
	} else {
		_tmp108_ = FALSE;
	}
	if (_tmp108_) {
		ValaClass* _tmp112_;
		gboolean _tmp113_;
		_tmp112_ = self->priv->_base_class;
		_tmp113_ = _tmp112_->priv->_is_sealed;
		_tmp107_ = _tmp113_;
	} else {
		_tmp107_ = FALSE;
	}
	if (_tmp107_) {
		ValaSourceReference* _tmp114_;
		ValaSourceReference* _tmp115_;
		gchar* _tmp116_;
		gchar* _tmp117_;
		ValaClass* _tmp118_;
		gchar* _tmp119_;
		gchar* _tmp120_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp114_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp115_ = _tmp114_;
		_tmp116_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp117_ = _tmp116_;
		_tmp118_ = self->priv->_base_class;
		_tmp119_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp118_);
		_tmp120_ = _tmp119_;
		vala_report_error (_tmp115_, "`%s' cannot inherit from sealed class `%s'", _tmp117_, _tmp120_);
		_g_free0 (_tmp120_);
		_g_free0 (_tmp117_);
	}
	_tmp121_ = self->priv->_is_sealed;
	if (_tmp121_) {
		gboolean _tmp122_;
		gboolean _tmp123_;
		gboolean _tmp128_;
		_tmp122_ = vala_class_get_is_compact (self);
		_tmp123_ = _tmp122_;
		if (_tmp123_) {
			ValaSourceReference* _tmp124_;
			ValaSourceReference* _tmp125_;
			gchar* _tmp126_;
			gchar* _tmp127_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp124_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp125_ = _tmp124_;
			_tmp126_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp127_ = _tmp126_;
			vala_report_error (_tmp125_, "Sealed class `%s' cannot be compact", _tmp127_);
			_g_free0 (_tmp127_);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp128_ = self->priv->_is_abstract;
		if (_tmp128_) {
			ValaSourceReference* _tmp129_;
			ValaSourceReference* _tmp130_;
			gchar* _tmp131_;
			gchar* _tmp132_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp129_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp130_ = _tmp129_;
			_tmp131_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp132_ = _tmp131_;
			vala_report_error (_tmp130_, "Sealed class `%s' cannot be abstract", _tmp132_);
			_g_free0 (_tmp132_);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp133_;
		gint _en_size = 0;
		ValaList* _tmp134_;
		gint _tmp135_;
		gint _tmp136_;
		gint _en_index = 0;
		_tmp133_ = vala_object_type_symbol_get_enums ((ValaObjectTypeSymbol*) self);
		_en_list = _tmp133_;
		_tmp134_ = _en_list;
		_tmp135_ = vala_collection_get_size ((ValaCollection*) _tmp134_);
		_tmp136_ = _tmp135_;
		_en_size = _tmp136_;
		_en_index = -1;
		while (TRUE) {
			gint _tmp137_;
			gint _tmp138_;
			ValaEnum* en = NULL;
			ValaList* _tmp139_;
			gpointer _tmp140_;
			ValaEnum* _tmp141_;
			_en_index = _en_index + 1;
			_tmp137_ = _en_index;
			_tmp138_ = _en_size;
			if (!(_tmp137_ < _tmp138_)) {
				break;
			}
			_tmp139_ = _en_list;
			_tmp140_ = vala_list_get (_tmp139_, _en_index);
			en = (ValaEnum*) _tmp140_;
			_tmp141_ = en;
			vala_code_node_check ((ValaCodeNode*) _tmp141_, context);
			_vala_code_node_unref0 (en);
		}
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp142_;
		gint _f_size = 0;
		ValaList* _tmp143_;
		gint _tmp144_;
		gint _tmp145_;
		gint _f_index = 0;
		_tmp142_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
		_f_list = _tmp142_;
		_tmp143_ = _f_list;
		_tmp144_ = vala_collection_get_size ((ValaCollection*) _tmp143_);
		_tmp145_ = _tmp144_;
		_f_size = _tmp145_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp146_;
			gint _tmp147_;
			ValaField* f = NULL;
			ValaList* _tmp148_;
			gpointer _tmp149_;
			gboolean _tmp150_ = FALSE;
			gboolean _tmp151_;
			gboolean _tmp152_;
			ValaField* _tmp190_;
			_f_index = _f_index + 1;
			_tmp146_ = _f_index;
			_tmp147_ = _f_size;
			if (!(_tmp146_ < _tmp147_)) {
				break;
			}
			_tmp148_ = _f_list;
			_tmp149_ = vala_list_get (_tmp148_, _f_index);
			f = (ValaField*) _tmp149_;
			_tmp151_ = vala_class_get_is_compact (self);
			_tmp152_ = _tmp151_;
			if (_tmp152_) {
				ValaField* _tmp153_;
				ValaMemberBinding _tmp154_;
				ValaMemberBinding _tmp155_;
				_tmp153_ = f;
				_tmp154_ = vala_field_get_binding (_tmp153_);
				_tmp155_ = _tmp154_;
				_tmp150_ = _tmp155_ != VALA_MEMBER_BINDING_STATIC;
			} else {
				_tmp150_ = FALSE;
			}
			if (_tmp150_) {
				gboolean _tmp156_ = FALSE;
				gboolean _tmp157_ = FALSE;
				gboolean _tmp158_;
				gboolean _tmp159_;
				gboolean _tmp168_ = FALSE;
				gboolean _tmp169_ = FALSE;
				gboolean _tmp170_;
				gboolean _tmp171_;
				ValaField* _tmp184_;
				ValaMemberBinding _tmp185_;
				ValaMemberBinding _tmp186_;
				_tmp158_ = vala_symbol_get_external_package ((ValaSymbol*) self);
				_tmp159_ = _tmp158_;
				if (!_tmp159_) {
					gboolean _tmp160_;
					gboolean _tmp161_;
					_tmp160_ = vala_class_get_is_opaque (self);
					_tmp161_ = _tmp160_;
					_tmp157_ = !_tmp161_;
				} else {
					_tmp157_ = FALSE;
				}
				if (_tmp157_) {
					ValaField* _tmp162_;
					ValaSymbolAccessibility _tmp163_;
					ValaSymbolAccessibility _tmp164_;
					_tmp162_ = f;
					_tmp163_ = vala_symbol_get_access ((ValaSymbol*) _tmp162_);
					_tmp164_ = _tmp163_;
					_tmp156_ = _tmp164_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
				} else {
					_tmp156_ = FALSE;
				}
				if (_tmp156_) {
					ValaField* _tmp165_;
					ValaSourceReference* _tmp166_;
					ValaSourceReference* _tmp167_;
					_tmp165_ = f;
					_tmp166_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp165_);
					_tmp167_ = _tmp166_;
					vala_report_error (_tmp167_, "private fields are only supported in opaque compact classes, use [Comp" \
"act (opaque = true)]");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
				_tmp170_ = vala_symbol_get_external_package ((ValaSymbol*) self);
				_tmp171_ = _tmp170_;
				if (!_tmp171_) {
					gboolean _tmp172_;
					gboolean _tmp173_;
					_tmp172_ = vala_class_get_is_opaque (self);
					_tmp173_ = _tmp172_;
					_tmp169_ = _tmp173_;
				} else {
					_tmp169_ = FALSE;
				}
				if (_tmp169_) {
					gboolean _tmp174_ = FALSE;
					ValaField* _tmp175_;
					ValaSymbolAccessibility _tmp176_;
					ValaSymbolAccessibility _tmp177_;
					_tmp175_ = f;
					_tmp176_ = vala_symbol_get_access ((ValaSymbol*) _tmp175_);
					_tmp177_ = _tmp176_;
					if (_tmp177_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
						_tmp174_ = TRUE;
					} else {
						ValaField* _tmp178_;
						ValaSymbolAccessibility _tmp179_;
						ValaSymbolAccessibility _tmp180_;
						_tmp178_ = f;
						_tmp179_ = vala_symbol_get_access ((ValaSymbol*) _tmp178_);
						_tmp180_ = _tmp179_;
						_tmp174_ = _tmp180_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED;
					}
					_tmp168_ = _tmp174_;
				} else {
					_tmp168_ = FALSE;
				}
				if (_tmp168_) {
					ValaField* _tmp181_;
					ValaSourceReference* _tmp182_;
					ValaSourceReference* _tmp183_;
					_tmp181_ = f;
					_tmp182_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp181_);
					_tmp183_ = _tmp182_;
					vala_report_error (_tmp183_, "fields in opaque compact classes must be private or internal");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
				_tmp184_ = f;
				_tmp185_ = vala_field_get_binding (_tmp184_);
				_tmp186_ = _tmp185_;
				if (_tmp186_ == VALA_MEMBER_BINDING_CLASS) {
					ValaField* _tmp187_;
					ValaSourceReference* _tmp188_;
					ValaSourceReference* _tmp189_;
					_tmp187_ = f;
					_tmp188_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp187_);
					_tmp189_ = _tmp188_;
					vala_report_error (_tmp189_, "class fields are not supported in compact classes");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
			}
			_tmp190_ = f;
			vala_code_node_check ((ValaCodeNode*) _tmp190_, context);
			_vala_code_node_unref0 (f);
		}
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp191_;
		gint _c_size = 0;
		ValaList* _tmp192_;
		gint _tmp193_;
		gint _tmp194_;
		gint _c_index = 0;
		_tmp191_ = vala_object_type_symbol_get_constants ((ValaObjectTypeSymbol*) self);
		_c_list = _tmp191_;
		_tmp192_ = _c_list;
		_tmp193_ = vala_collection_get_size ((ValaCollection*) _tmp192_);
		_tmp194_ = _tmp193_;
		_c_size = _tmp194_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp195_;
			gint _tmp196_;
			ValaConstant* c = NULL;
			ValaList* _tmp197_;
			gpointer _tmp198_;
			ValaConstant* _tmp199_;
			_c_index = _c_index + 1;
			_tmp195_ = _c_index;
			_tmp196_ = _c_size;
			if (!(_tmp195_ < _tmp196_)) {
				break;
			}
			_tmp197_ = _c_list;
			_tmp198_ = vala_list_get (_tmp197_, _c_index);
			c = (ValaConstant*) _tmp198_;
			_tmp199_ = c;
			vala_code_node_check ((ValaCodeNode*) _tmp199_, context);
			_vala_code_node_unref0 (c);
		}
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp200_;
		gint _m_size = 0;
		ValaList* _tmp201_;
		gint _tmp202_;
		gint _tmp203_;
		gint _m_index = 0;
		_tmp200_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) self);
		_m_list = _tmp200_;
		_tmp201_ = _m_list;
		_tmp202_ = vala_collection_get_size ((ValaCollection*) _tmp201_);
		_tmp203_ = _tmp202_;
		_m_size = _tmp203_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp204_;
			gint _tmp205_;
			ValaMethod* m = NULL;
			ValaList* _tmp206_;
			gpointer _tmp207_;
			ValaMethod* _tmp208_;
			_m_index = _m_index + 1;
			_tmp204_ = _m_index;
			_tmp205_ = _m_size;
			if (!(_tmp204_ < _tmp205_)) {
				break;
			}
			_tmp206_ = _m_list;
			_tmp207_ = vala_list_get (_tmp206_, _m_index);
			m = (ValaMethod*) _tmp207_;
			_tmp208_ = m;
			vala_code_node_check ((ValaCodeNode*) _tmp208_, context);
			_vala_code_node_unref0 (m);
		}
	}
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp209_;
		gint _prop_size = 0;
		ValaList* _tmp210_;
		gint _tmp211_;
		gint _tmp212_;
		gint _prop_index = 0;
		_tmp209_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) self);
		_prop_list = _tmp209_;
		_tmp210_ = _prop_list;
		_tmp211_ = vala_collection_get_size ((ValaCollection*) _tmp210_);
		_tmp212_ = _tmp211_;
		_prop_size = _tmp212_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp213_;
			gint _tmp214_;
			ValaProperty* prop = NULL;
			ValaList* _tmp215_;
			gpointer _tmp216_;
			gboolean _tmp217_ = FALSE;
			ValaProperty* _tmp218_;
			ValaProperty* _tmp225_;
			_prop_index = _prop_index + 1;
			_tmp213_ = _prop_index;
			_tmp214_ = _prop_size;
			if (!(_tmp213_ < _tmp214_)) {
				break;
			}
			_tmp215_ = _prop_list;
			_tmp216_ = vala_list_get (_tmp215_, _prop_index);
			prop = (ValaProperty*) _tmp216_;
			_tmp218_ = prop;
			if (vala_code_node_has_attribute ((ValaCodeNode*) _tmp218_, "NoAccessorMethod")) {
				ValaSemanticAnalyzer* _tmp219_;
				ValaSemanticAnalyzer* _tmp220_;
				ValaClass* _tmp221_;
				_tmp219_ = vala_code_context_get_analyzer (context);
				_tmp220_ = _tmp219_;
				_tmp221_ = _tmp220_->object_type;
				_tmp217_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) self, (ValaTypeSymbol*) _tmp221_);
			} else {
				_tmp217_ = FALSE;
			}
			if (_tmp217_) {
				ValaProperty* _tmp222_;
				ValaSourceReference* _tmp223_;
				ValaSourceReference* _tmp224_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp222_ = prop;
				_tmp223_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp222_);
				_tmp224_ = _tmp223_;
				vala_report_error (_tmp224_, "NoAccessorMethod is only allowed for properties in classes derived fro" \
"m GLib.Object");
				result = FALSE;
				_vala_code_node_unref0 (prop);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp225_ = prop;
			vala_code_node_check ((ValaCodeNode*) _tmp225_, context);
			_vala_code_node_unref0 (prop);
		}
	}
	{
		ValaList* _sig_list = NULL;
		ValaList* _tmp226_;
		gint _sig_size = 0;
		ValaList* _tmp227_;
		gint _tmp228_;
		gint _tmp229_;
		gint _sig_index = 0;
		_tmp226_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) self);
		_sig_list = _tmp226_;
		_tmp227_ = _sig_list;
		_tmp228_ = vala_collection_get_size ((ValaCollection*) _tmp227_);
		_tmp229_ = _tmp228_;
		_sig_size = _tmp229_;
		_sig_index = -1;
		while (TRUE) {
			gint _tmp230_;
			gint _tmp231_;
			ValaSignal* sig = NULL;
			ValaList* _tmp232_;
			gpointer _tmp233_;
			ValaSignal* _tmp234_;
			_sig_index = _sig_index + 1;
			_tmp230_ = _sig_index;
			_tmp231_ = _sig_size;
			if (!(_tmp230_ < _tmp231_)) {
				break;
			}
			_tmp232_ = _sig_list;
			_tmp233_ = vala_list_get (_tmp232_, _sig_index);
			sig = (ValaSignal*) _tmp233_;
			_tmp234_ = sig;
			vala_code_node_check ((ValaCodeNode*) _tmp234_, context);
			_vala_code_node_unref0 (sig);
		}
	}
	_tmp235_ = vala_class_get_constructor (self);
	_tmp236_ = _tmp235_;
	if (_tmp236_ != NULL) {
		ValaConstructor* _tmp237_;
		ValaConstructor* _tmp238_;
		_tmp237_ = vala_class_get_constructor (self);
		_tmp238_ = _tmp237_;
		vala_code_node_check ((ValaCodeNode*) _tmp238_, context);
	}
	_tmp239_ = vala_class_get_class_constructor (self);
	_tmp240_ = _tmp239_;
	if (_tmp240_ != NULL) {
		ValaConstructor* _tmp241_;
		ValaConstructor* _tmp242_;
		_tmp241_ = vala_class_get_class_constructor (self);
		_tmp242_ = _tmp241_;
		vala_code_node_check ((ValaCodeNode*) _tmp242_, context);
	}
	_tmp243_ = vala_class_get_static_constructor (self);
	_tmp244_ = _tmp243_;
	if (_tmp244_ != NULL) {
		ValaConstructor* _tmp245_;
		ValaConstructor* _tmp246_;
		_tmp245_ = vala_class_get_static_constructor (self);
		_tmp246_ = _tmp245_;
		vala_code_node_check ((ValaCodeNode*) _tmp246_, context);
	}
	_tmp247_ = vala_class_get_destructor (self);
	_tmp248_ = _tmp247_;
	if (_tmp248_ != NULL) {
		ValaDestructor* _tmp249_;
		ValaDestructor* _tmp250_;
		_tmp249_ = vala_class_get_destructor (self);
		_tmp250_ = _tmp249_;
		vala_code_node_check ((ValaCodeNode*) _tmp250_, context);
	}
	_tmp251_ = vala_class_get_static_destructor (self);
	_tmp252_ = _tmp251_;
	if (_tmp252_ != NULL) {
		ValaDestructor* _tmp253_;
		ValaDestructor* _tmp254_;
		_tmp253_ = vala_class_get_static_destructor (self);
		_tmp254_ = _tmp253_;
		vala_code_node_check ((ValaCodeNode*) _tmp254_, context);
	}
	_tmp255_ = vala_class_get_class_destructor (self);
	_tmp256_ = _tmp255_;
	if (_tmp256_ != NULL) {
		ValaDestructor* _tmp257_;
		ValaDestructor* _tmp258_;
		_tmp257_ = vala_class_get_class_destructor (self);
		_tmp258_ = _tmp257_;
		vala_code_node_check ((ValaCodeNode*) _tmp258_, context);
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp259_;
		gint _cl_size = 0;
		ValaList* _tmp260_;
		gint _tmp261_;
		gint _tmp262_;
		gint _cl_index = 0;
		_tmp259_ = vala_object_type_symbol_get_classes ((ValaObjectTypeSymbol*) self);
		_cl_list = _tmp259_;
		_tmp260_ = _cl_list;
		_tmp261_ = vala_collection_get_size ((ValaCollection*) _tmp260_);
		_tmp262_ = _tmp261_;
		_cl_size = _tmp262_;
		_cl_index = -1;
		while (TRUE) {
			gint _tmp263_;
			gint _tmp264_;
			ValaClass* cl = NULL;
			ValaList* _tmp265_;
			gpointer _tmp266_;
			ValaClass* _tmp267_;
			_cl_index = _cl_index + 1;
			_tmp263_ = _cl_index;
			_tmp264_ = _cl_size;
			if (!(_tmp263_ < _tmp264_)) {
				break;
			}
			_tmp265_ = _cl_list;
			_tmp266_ = vala_list_get (_tmp265_, _cl_index);
			cl = (ValaClass*) _tmp266_;
			_tmp267_ = cl;
			vala_code_node_check ((ValaCodeNode*) _tmp267_, context);
			_vala_code_node_unref0 (cl);
		}
	}
	{
		ValaList* _iface_list = NULL;
		ValaList* _tmp268_;
		gint _iface_size = 0;
		ValaList* _tmp269_;
		gint _tmp270_;
		gint _tmp271_;
		gint _iface_index = 0;
		_tmp268_ = vala_object_type_symbol_get_interfaces ((ValaObjectTypeSymbol*) self);
		_iface_list = _tmp268_;
		_tmp269_ = _iface_list;
		_tmp270_ = vala_collection_get_size ((ValaCollection*) _tmp269_);
		_tmp271_ = _tmp270_;
		_iface_size = _tmp271_;
		_iface_index = -1;
		while (TRUE) {
			gint _tmp272_;
			gint _tmp273_;
			ValaInterface* iface = NULL;
			ValaList* _tmp274_;
			gpointer _tmp275_;
			ValaInterface* _tmp276_;
			_iface_index = _iface_index + 1;
			_tmp272_ = _iface_index;
			_tmp273_ = _iface_size;
			if (!(_tmp272_ < _tmp273_)) {
				break;
			}
			_tmp274_ = _iface_list;
			_tmp275_ = vala_list_get (_tmp274_, _iface_index);
			iface = (ValaInterface*) _tmp275_;
			_tmp276_ = iface;
			vala_code_node_check ((ValaCodeNode*) _tmp276_, context);
			_vala_code_node_unref0 (iface);
		}
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp277_;
		gint _st_size = 0;
		ValaList* _tmp278_;
		gint _tmp279_;
		gint _tmp280_;
		gint _st_index = 0;
		_tmp277_ = vala_object_type_symbol_get_structs ((ValaObjectTypeSymbol*) self);
		_st_list = _tmp277_;
		_tmp278_ = _st_list;
		_tmp279_ = vala_collection_get_size ((ValaCollection*) _tmp278_);
		_tmp280_ = _tmp279_;
		_st_size = _tmp280_;
		_st_index = -1;
		while (TRUE) {
			gint _tmp281_;
			gint _tmp282_;
			ValaStruct* st = NULL;
			ValaList* _tmp283_;
			gpointer _tmp284_;
			ValaStruct* _tmp285_;
			_st_index = _st_index + 1;
			_tmp281_ = _st_index;
			_tmp282_ = _st_size;
			if (!(_tmp281_ < _tmp282_)) {
				break;
			}
			_tmp283_ = _st_list;
			_tmp284_ = vala_list_get (_tmp283_, _st_index);
			st = (ValaStruct*) _tmp284_;
			_tmp285_ = st;
			vala_code_node_check ((ValaCodeNode*) _tmp285_, context);
			_vala_code_node_unref0 (st);
		}
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp286_;
		gint _d_size = 0;
		ValaList* _tmp287_;
		gint _tmp288_;
		gint _tmp289_;
		gint _d_index = 0;
		_tmp286_ = vala_object_type_symbol_get_delegates ((ValaObjectTypeSymbol*) self);
		_d_list = _tmp286_;
		_tmp287_ = _d_list;
		_tmp288_ = vala_collection_get_size ((ValaCollection*) _tmp287_);
		_tmp289_ = _tmp288_;
		_d_size = _tmp289_;
		_d_index = -1;
		while (TRUE) {
			gint _tmp290_;
			gint _tmp291_;
			ValaDelegate* d = NULL;
			ValaList* _tmp292_;
			gpointer _tmp293_;
			ValaDelegate* _tmp294_;
			_d_index = _d_index + 1;
			_tmp290_ = _d_index;
			_tmp291_ = _d_size;
			if (!(_tmp290_ < _tmp291_)) {
				break;
			}
			_tmp292_ = _d_list;
			_tmp293_ = vala_list_get (_tmp292_, _d_index);
			d = (ValaDelegate*) _tmp293_;
			_tmp294_ = d;
			vala_code_node_check ((ValaCodeNode*) _tmp294_, context);
			_vala_code_node_unref0 (d);
		}
	}
	_tmp295_ = vala_class_get_is_compact (self);
	_tmp296_ = _tmp295_;
	if (_tmp296_) {
		gboolean _tmp312_ = FALSE;
		gboolean _tmp313_ = FALSE;
		gboolean _tmp314_ = FALSE;
		gboolean _tmp315_;
		gboolean _tmp316_;
		{
			ValaList* _base_type_list = NULL;
			ValaList* _tmp297_;
			gint _base_type_size = 0;
			ValaList* _tmp298_;
			gint _tmp299_;
			gint _tmp300_;
			gint _base_type_index = 0;
			_tmp297_ = vala_class_get_base_types (self);
			_base_type_list = _tmp297_;
			_tmp298_ = _base_type_list;
			_tmp299_ = vala_collection_get_size ((ValaCollection*) _tmp298_);
			_tmp300_ = _tmp299_;
			_base_type_size = _tmp300_;
			_base_type_index = -1;
			while (TRUE) {
				gint _tmp301_;
				gint _tmp302_;
				ValaDataType* base_type = NULL;
				ValaList* _tmp303_;
				gpointer _tmp304_;
				ValaDataType* _tmp305_;
				ValaTypeSymbol* _tmp306_;
				ValaTypeSymbol* _tmp307_;
				_base_type_index = _base_type_index + 1;
				_tmp301_ = _base_type_index;
				_tmp302_ = _base_type_size;
				if (!(_tmp301_ < _tmp302_)) {
					break;
				}
				_tmp303_ = _base_type_list;
				_tmp304_ = vala_list_get (_tmp303_, _base_type_index);
				base_type = (ValaDataType*) _tmp304_;
				_tmp305_ = base_type;
				_tmp306_ = vala_data_type_get_type_symbol (_tmp305_);
				_tmp307_ = _tmp306_;
				if (VALA_IS_INTERFACE (_tmp307_)) {
					ValaSourceReference* _tmp308_;
					ValaSourceReference* _tmp309_;
					gchar* _tmp310_;
					gchar* _tmp311_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp308_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp309_ = _tmp308_;
					_tmp310_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp311_ = _tmp310_;
					vala_report_error (_tmp309_, "compact classes `%s' may not implement interfaces", _tmp311_);
					_g_free0 (_tmp311_);
				}
				_vala_code_node_unref0 (base_type);
			}
		}
		_tmp315_ = vala_symbol_get_external ((ValaSymbol*) self);
		_tmp316_ = _tmp315_;
		if (!_tmp316_) {
			gboolean _tmp317_;
			gboolean _tmp318_;
			_tmp317_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp318_ = _tmp317_;
			_tmp314_ = !_tmp318_;
		} else {
			_tmp314_ = FALSE;
		}
		if (_tmp314_) {
			ValaClass* _tmp319_;
			_tmp319_ = self->priv->_base_class;
			_tmp313_ = _tmp319_ != NULL;
		} else {
			_tmp313_ = FALSE;
		}
		if (_tmp313_) {
			ValaClass* _tmp320_;
			ValaSemanticAnalyzer* _tmp321_;
			ValaSemanticAnalyzer* _tmp322_;
			ValaClass* _tmp323_;
			_tmp320_ = self->priv->_base_class;
			_tmp321_ = vala_code_context_get_analyzer (context);
			_tmp322_ = _tmp321_;
			_tmp323_ = _tmp322_->gsource_type;
			_tmp312_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp320_, (ValaTypeSymbol*) _tmp323_);
		} else {
			_tmp312_ = FALSE;
		}
		if (_tmp312_) {
			{
				ValaList* _f_list = NULL;
				ValaList* _tmp324_;
				gint _f_size = 0;
				ValaList* _tmp325_;
				gint _tmp326_;
				gint _tmp327_;
				gint _f_index = 0;
				_tmp324_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
				_f_list = _tmp324_;
				_tmp325_ = _f_list;
				_tmp326_ = vala_collection_get_size ((ValaCollection*) _tmp325_);
				_tmp327_ = _tmp326_;
				_f_size = _tmp327_;
				_f_index = -1;
				while (TRUE) {
					gint _tmp328_;
					gint _tmp329_;
					ValaField* f = NULL;
					ValaList* _tmp330_;
					gpointer _tmp331_;
					ValaField* _tmp332_;
					ValaMemberBinding _tmp333_;
					ValaMemberBinding _tmp334_;
					_f_index = _f_index + 1;
					_tmp328_ = _f_index;
					_tmp329_ = _f_size;
					if (!(_tmp328_ < _tmp329_)) {
						break;
					}
					_tmp330_ = _f_list;
					_tmp331_ = vala_list_get (_tmp330_, _f_index);
					f = (ValaField*) _tmp331_;
					_tmp332_ = f;
					_tmp333_ = vala_field_get_binding (_tmp332_);
					_tmp334_ = _tmp333_;
					if (_tmp334_ == VALA_MEMBER_BINDING_INSTANCE) {
						ValaSourceReference* _tmp335_;
						ValaSourceReference* _tmp336_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp335_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp336_ = _tmp335_;
						vala_report_error (_tmp336_, "derived compact classes may not have instance fields");
						_vala_code_node_unref0 (f);
						break;
					}
					_vala_code_node_unref0 (f);
				}
			}
		}
	}
	_tmp337_ = g_direct_equal;
	_tmp338_ = vala_array_list_new (VALA_TYPE_TYPESYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp337_);
	prerequisites = (ValaList*) _tmp338_;
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp339_;
		gint _base_type_size = 0;
		ValaList* _tmp340_;
		gint _tmp341_;
		gint _tmp342_;
		gint _base_type_index = 0;
		_tmp339_ = vala_class_get_base_types (self);
		_base_type_list = _tmp339_;
		_tmp340_ = _base_type_list;
		_tmp341_ = vala_collection_get_size ((ValaCollection*) _tmp340_);
		_tmp342_ = _tmp341_;
		_base_type_size = _tmp342_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp343_;
			gint _tmp344_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp345_;
			gpointer _tmp346_;
			ValaDataType* _tmp347_;
			ValaTypeSymbol* _tmp348_;
			ValaTypeSymbol* _tmp349_;
			_base_type_index = _base_type_index + 1;
			_tmp343_ = _base_type_index;
			_tmp344_ = _base_type_size;
			if (!(_tmp343_ < _tmp344_)) {
				break;
			}
			_tmp345_ = _base_type_list;
			_tmp346_ = vala_list_get (_tmp345_, _base_type_index);
			base_type = (ValaDataType*) _tmp346_;
			_tmp347_ = base_type;
			_tmp348_ = vala_data_type_get_type_symbol (_tmp347_);
			_tmp349_ = _tmp348_;
			if (VALA_IS_INTERFACE (_tmp349_)) {
				ValaDataType* _tmp350_;
				ValaTypeSymbol* _tmp351_;
				ValaTypeSymbol* _tmp352_;
				ValaList* _tmp353_;
				_tmp350_ = base_type;
				_tmp351_ = vala_data_type_get_type_symbol (_tmp350_);
				_tmp352_ = _tmp351_;
				_tmp353_ = prerequisites;
				vala_class_get_all_prerequisites (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp352_, VALA_TYPE_INTERFACE, ValaInterface), _tmp353_);
			}
			_vala_code_node_unref0 (base_type);
		}
	}
	_tmp354_ = g_str_equal;
	_tmp355_ = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp354_);
	missing_prereqs = (ValaList*) _tmp355_;
	{
		ValaList* _prereq_list = NULL;
		ValaList* _tmp356_;
		gint _prereq_size = 0;
		ValaList* _tmp357_;
		gint _tmp358_;
		gint _tmp359_;
		gint _prereq_index = 0;
		_tmp356_ = prerequisites;
		_prereq_list = _tmp356_;
		_tmp357_ = _prereq_list;
		_tmp358_ = vala_collection_get_size ((ValaCollection*) _tmp357_);
		_tmp359_ = _tmp358_;
		_prereq_size = _tmp359_;
		_prereq_index = -1;
		while (TRUE) {
			gint _tmp360_;
			gint _tmp361_;
			ValaTypeSymbol* prereq = NULL;
			ValaList* _tmp362_;
			gpointer _tmp363_;
			ValaTypeSymbol* _tmp364_;
			_prereq_index = _prereq_index + 1;
			_tmp360_ = _prereq_index;
			_tmp361_ = _prereq_size;
			if (!(_tmp360_ < _tmp361_)) {
				break;
			}
			_tmp362_ = _prereq_list;
			_tmp363_ = vala_list_get (_tmp362_, _prereq_index);
			prereq = (ValaTypeSymbol*) _tmp363_;
			_tmp364_ = prereq;
			if (!vala_class_is_a (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp364_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol))) {
				ValaList* _tmp365_;
				ValaTypeSymbol* _tmp366_;
				gchar* _tmp367_;
				gchar* _tmp368_;
				_tmp365_ = missing_prereqs;
				_tmp366_ = prereq;
				_tmp367_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp366_);
				_tmp368_ = _tmp367_;
				vala_list_insert (_tmp365_, 0, _tmp368_);
				_g_free0 (_tmp368_);
			}
			_vala_code_node_unref0 (prereq);
		}
	}
	_tmp369_ = missing_prereqs;
	_tmp370_ = vala_collection_get_size ((ValaCollection*) _tmp369_);
	_tmp371_ = _tmp370_;
	if (_tmp371_ > 0) {
		gchar* error_string = NULL;
		gchar* _tmp372_;
		gchar* _tmp373_;
		gchar* _tmp374_;
		gchar* _tmp375_;
		gboolean first = FALSE;
		const gchar* _tmp390_;
		gchar* _tmp391_;
		ValaSourceReference* _tmp392_;
		ValaSourceReference* _tmp393_;
		const gchar* _tmp394_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp372_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp373_ = _tmp372_;
		_tmp374_ = g_strdup_printf ("%s: some prerequisites (", _tmp373_);
		_tmp375_ = _tmp374_;
		_g_free0 (_tmp373_);
		error_string = _tmp375_;
		first = TRUE;
		{
			ValaList* _s_list = NULL;
			ValaList* _tmp376_;
			gint _s_size = 0;
			ValaList* _tmp377_;
			gint _tmp378_;
			gint _tmp379_;
			gint _s_index = 0;
			_tmp376_ = missing_prereqs;
			_s_list = _tmp376_;
			_tmp377_ = _s_list;
			_tmp378_ = vala_collection_get_size ((ValaCollection*) _tmp377_);
			_tmp379_ = _tmp378_;
			_s_size = _tmp379_;
			_s_index = -1;
			while (TRUE) {
				gint _tmp380_;
				gint _tmp381_;
				gchar* s = NULL;
				ValaList* _tmp382_;
				gpointer _tmp383_;
				_s_index = _s_index + 1;
				_tmp380_ = _s_index;
				_tmp381_ = _s_size;
				if (!(_tmp380_ < _tmp381_)) {
					break;
				}
				_tmp382_ = _s_list;
				_tmp383_ = vala_list_get (_tmp382_, _s_index);
				s = (gchar*) _tmp383_;
				if (first) {
					const gchar* _tmp384_;
					const gchar* _tmp385_;
					gchar* _tmp386_;
					_tmp384_ = error_string;
					_tmp385_ = s;
					_tmp386_ = g_strdup_printf ("%s`%s'", _tmp384_, _tmp385_);
					_g_free0 (error_string);
					error_string = _tmp386_;
					first = FALSE;
				} else {
					const gchar* _tmp387_;
					const gchar* _tmp388_;
					gchar* _tmp389_;
					_tmp387_ = error_string;
					_tmp388_ = s;
					_tmp389_ = g_strdup_printf ("%s, `%s'", _tmp387_, _tmp388_);
					_g_free0 (error_string);
					error_string = _tmp389_;
				}
				_g_free0 (s);
			}
		}
		_tmp390_ = error_string;
		_tmp391_ = g_strconcat (_tmp390_, ") are not met", NULL);
		_g_free0 (error_string);
		error_string = _tmp391_;
		_tmp392_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp393_ = _tmp392_;
		_tmp394_ = error_string;
		vala_report_error (_tmp393_, "%s", _tmp394_);
		_g_free0 (error_string);
	}
	_tmp395_ = vala_symbol_get_source_type ((ValaSymbol*) self);
	_tmp396_ = _tmp395_;
	if (_tmp396_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
		gboolean _tmp547_;
		{
			ValaList* _base_type_list = NULL;
			ValaList* _tmp397_;
			gint _base_type_size = 0;
			ValaList* _tmp398_;
			gint _tmp399_;
			gint _tmp400_;
			gint _base_type_index = 0;
			_tmp397_ = vala_class_get_base_types (self);
			_base_type_list = _tmp397_;
			_tmp398_ = _base_type_list;
			_tmp399_ = vala_collection_get_size ((ValaCollection*) _tmp398_);
			_tmp400_ = _tmp399_;
			_base_type_size = _tmp400_;
			_base_type_index = -1;
			while (TRUE) {
				gint _tmp401_;
				gint _tmp402_;
				ValaDataType* base_type = NULL;
				ValaList* _tmp403_;
				gpointer _tmp404_;
				ValaDataType* _tmp405_;
				ValaTypeSymbol* _tmp406_;
				ValaTypeSymbol* _tmp407_;
				_base_type_index = _base_type_index + 1;
				_tmp401_ = _base_type_index;
				_tmp402_ = _base_type_size;
				if (!(_tmp401_ < _tmp402_)) {
					break;
				}
				_tmp403_ = _base_type_list;
				_tmp404_ = vala_list_get (_tmp403_, _base_type_index);
				base_type = (ValaDataType*) _tmp404_;
				_tmp405_ = base_type;
				_tmp406_ = vala_data_type_get_type_symbol (_tmp405_);
				_tmp407_ = _tmp406_;
				if (VALA_IS_INTERFACE (_tmp407_)) {
					ValaInterface* iface = NULL;
					ValaDataType* _tmp408_;
					ValaTypeSymbol* _tmp409_;
					ValaTypeSymbol* _tmp410_;
					gboolean _tmp411_ = FALSE;
					ValaClass* _tmp412_;
					_tmp408_ = base_type;
					_tmp409_ = vala_data_type_get_type_symbol (_tmp408_);
					_tmp410_ = _tmp409_;
					iface = G_TYPE_CHECK_INSTANCE_CAST (_tmp410_, VALA_TYPE_INTERFACE, ValaInterface);
					_tmp412_ = self->priv->_base_class;
					if (_tmp412_ != NULL) {
						ValaClass* _tmp413_;
						ValaInterface* _tmp414_;
						_tmp413_ = self->priv->_base_class;
						_tmp414_ = iface;
						_tmp411_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp413_, (ValaTypeSymbol*) _tmp414_);
					} else {
						_tmp411_ = FALSE;
					}
					if (_tmp411_) {
						_vala_code_node_unref0 (base_type);
						break;
					}
					{
						ValaList* _m_list = NULL;
						ValaInterface* _tmp415_;
						ValaList* _tmp416_;
						gint _m_size = 0;
						ValaList* _tmp417_;
						gint _tmp418_;
						gint _tmp419_;
						gint _m_index = 0;
						_tmp415_ = iface;
						_tmp416_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp415_);
						_m_list = _tmp416_;
						_tmp417_ = _m_list;
						_tmp418_ = vala_collection_get_size ((ValaCollection*) _tmp417_);
						_tmp419_ = _tmp418_;
						_m_size = _tmp419_;
						_m_index = -1;
						while (TRUE) {
							gint _tmp420_;
							gint _tmp421_;
							ValaMethod* m = NULL;
							ValaList* _tmp422_;
							gpointer _tmp423_;
							ValaMethod* _tmp424_;
							gboolean _tmp425_;
							gboolean _tmp426_;
							_m_index = _m_index + 1;
							_tmp420_ = _m_index;
							_tmp421_ = _m_size;
							if (!(_tmp420_ < _tmp421_)) {
								break;
							}
							_tmp422_ = _m_list;
							_tmp423_ = vala_list_get (_tmp422_, _m_index);
							m = (ValaMethod*) _tmp423_;
							_tmp424_ = m;
							_tmp425_ = vala_method_get_is_abstract (_tmp424_);
							_tmp426_ = _tmp425_;
							if (_tmp426_) {
								gboolean implemented = FALSE;
								ValaClass* base_class = NULL;
								implemented = FALSE;
								base_class = self;
								while (TRUE) {
									gboolean _tmp427_ = FALSE;
									ValaClass* _tmp428_;
									ValaClass* _tmp481_;
									ValaClass* _tmp482_;
									_tmp428_ = base_class;
									if (_tmp428_ != NULL) {
										_tmp427_ = !implemented;
									} else {
										_tmp427_ = FALSE;
									}
									if (!_tmp427_) {
										break;
									}
									{
										ValaList* _impl_list = NULL;
										ValaClass* _tmp429_;
										ValaList* _tmp430_;
										gint _impl_size = 0;
										ValaList* _tmp431_;
										gint _tmp432_;
										gint _tmp433_;
										gint _impl_index = 0;
										_tmp429_ = base_class;
										_tmp430_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp429_);
										_impl_list = _tmp430_;
										_tmp431_ = _impl_list;
										_tmp432_ = vala_collection_get_size ((ValaCollection*) _tmp431_);
										_tmp433_ = _tmp432_;
										_impl_size = _tmp433_;
										_impl_index = -1;
										while (TRUE) {
											gint _tmp434_;
											gint _tmp435_;
											ValaMethod* impl = NULL;
											ValaList* _tmp436_;
											gpointer _tmp437_;
											gboolean _tmp438_ = FALSE;
											ValaMethod* _tmp439_;
											ValaMethod* _tmp440_;
											ValaMethod* _tmp441_;
											ValaMethod* _tmp442_;
											_impl_index = _impl_index + 1;
											_tmp434_ = _impl_index;
											_tmp435_ = _impl_size;
											if (!(_tmp434_ < _tmp435_)) {
												break;
											}
											_tmp436_ = _impl_list;
											_tmp437_ = vala_list_get (_tmp436_, _impl_index);
											impl = (ValaMethod*) _tmp437_;
											_tmp439_ = impl;
											_tmp440_ = vala_method_get_base_interface_method (_tmp439_);
											_tmp441_ = _tmp440_;
											_tmp442_ = m;
											if (_tmp441_ == _tmp442_) {
												_tmp438_ = TRUE;
											} else {
												gboolean _tmp443_ = FALSE;
												gboolean _tmp444_ = FALSE;
												gboolean _tmp445_ = FALSE;
												gboolean _tmp446_ = FALSE;
												ValaClass* _tmp447_;
												_tmp447_ = base_class;
												if (_tmp447_ != self) {
													ValaMethod* _tmp448_;
													ValaMethod* _tmp449_;
													ValaMethod* _tmp450_;
													_tmp448_ = impl;
													_tmp449_ = vala_method_get_base_interface_method (_tmp448_);
													_tmp450_ = _tmp449_;
													_tmp446_ = _tmp450_ == NULL;
												} else {
													_tmp446_ = FALSE;
												}
												if (_tmp446_) {
													ValaMethod* _tmp451_;
													const gchar* _tmp452_;
													const gchar* _tmp453_;
													ValaMethod* _tmp454_;
													const gchar* _tmp455_;
													const gchar* _tmp456_;
													_tmp451_ = impl;
													_tmp452_ = vala_symbol_get_name ((ValaSymbol*) _tmp451_);
													_tmp453_ = _tmp452_;
													_tmp454_ = m;
													_tmp455_ = vala_symbol_get_name ((ValaSymbol*) _tmp454_);
													_tmp456_ = _tmp455_;
													_tmp445_ = g_strcmp0 (_tmp453_, _tmp456_) == 0;
												} else {
													_tmp445_ = FALSE;
												}
												if (_tmp445_) {
													gboolean _tmp457_ = FALSE;
													ValaMethod* _tmp458_;
													ValaDataType* _tmp459_;
													ValaDataType* _tmp460_;
													_tmp458_ = impl;
													_tmp459_ = vala_method_get_base_interface_type (_tmp458_);
													_tmp460_ = _tmp459_;
													if (_tmp460_ == NULL) {
														_tmp457_ = TRUE;
													} else {
														ValaMethod* _tmp461_;
														ValaDataType* _tmp462_;
														ValaDataType* _tmp463_;
														ValaTypeSymbol* _tmp464_;
														ValaTypeSymbol* _tmp465_;
														ValaInterface* _tmp466_;
														_tmp461_ = impl;
														_tmp462_ = vala_method_get_base_interface_type (_tmp461_);
														_tmp463_ = _tmp462_;
														_tmp464_ = vala_data_type_get_type_symbol (_tmp463_);
														_tmp465_ = _tmp464_;
														_tmp466_ = iface;
														_tmp457_ = _tmp465_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp466_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
													}
													_tmp444_ = _tmp457_;
												} else {
													_tmp444_ = FALSE;
												}
												if (_tmp444_) {
													ValaMethod* _tmp467_;
													ValaMethod* _tmp468_;
													_tmp467_ = impl;
													_tmp468_ = m;
													_tmp443_ = vala_method_compatible_no_error (_tmp467_, _tmp468_);
												} else {
													_tmp443_ = FALSE;
												}
												_tmp438_ = _tmp443_;
											}
											if (_tmp438_) {
												ValaMethod* _tmp469_;
												ValaVersionAttribute* _tmp470_;
												ValaVersionAttribute* _tmp471_;
												ValaSourceReference* _tmp472_;
												ValaSourceReference* _tmp473_;
												ValaMethod* _tmp474_;
												ValaMethod* _tmp475_;
												ValaMethod* _tmp476_;
												ValaMethod* _tmp477_;
												_tmp469_ = impl;
												_tmp470_ = vala_symbol_get_version ((ValaSymbol*) _tmp469_);
												_tmp471_ = _tmp470_;
												_tmp472_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
												_tmp473_ = _tmp472_;
												vala_version_attribute_check (_tmp471_, context, _tmp473_);
												_tmp474_ = impl;
												vala_symbol_set_used ((ValaSymbol*) _tmp474_, TRUE);
												implemented = TRUE;
												_tmp475_ = impl;
												_tmp476_ = vala_method_get_base_interface_method (_tmp475_);
												_tmp477_ = _tmp476_;
												if (_tmp477_ == NULL) {
													ValaHashMap* _tmp478_;
													ValaMethod* _tmp479_;
													ValaMethod* _tmp480_;
													_tmp478_ = self->priv->implicit_implementations;
													_tmp479_ = m;
													_tmp480_ = impl;
													vala_map_set ((ValaMap*) _tmp478_, _tmp479_, _tmp480_);
												}
												_vala_code_node_unref0 (impl);
												break;
											}
											_vala_code_node_unref0 (impl);
										}
									}
									_tmp481_ = base_class;
									_tmp482_ = _tmp481_->priv->_base_class;
									base_class = _tmp482_;
								}
								if (!implemented) {
									ValaSourceReference* _tmp483_;
									ValaSourceReference* _tmp484_;
									gchar* _tmp485_;
									gchar* _tmp486_;
									ValaMethod* _tmp487_;
									gchar* _tmp488_;
									gchar* _tmp489_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp483_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp484_ = _tmp483_;
									_tmp485_ = vala_symbol_get_full_name ((ValaSymbol*) self);
									_tmp486_ = _tmp485_;
									_tmp487_ = m;
									_tmp488_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp487_);
									_tmp489_ = _tmp488_;
									vala_report_error (_tmp484_, "`%s' does not implement interface method `%s'", _tmp486_, _tmp489_);
									_g_free0 (_tmp489_);
									_g_free0 (_tmp486_);
								}
							}
							_vala_code_node_unref0 (m);
						}
					}
					{
						ValaList* _prop_list = NULL;
						ValaInterface* _tmp490_;
						ValaList* _tmp491_;
						gint _prop_size = 0;
						ValaList* _tmp492_;
						gint _tmp493_;
						gint _tmp494_;
						gint _prop_index = 0;
						_tmp490_ = iface;
						_tmp491_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) _tmp490_);
						_prop_list = _tmp491_;
						_tmp492_ = _prop_list;
						_tmp493_ = vala_collection_get_size ((ValaCollection*) _tmp492_);
						_tmp494_ = _tmp493_;
						_prop_size = _tmp494_;
						_prop_index = -1;
						while (TRUE) {
							gint _tmp495_;
							gint _tmp496_;
							ValaProperty* prop = NULL;
							ValaList* _tmp497_;
							gpointer _tmp498_;
							ValaProperty* _tmp499_;
							gboolean _tmp500_;
							gboolean _tmp501_;
							_prop_index = _prop_index + 1;
							_tmp495_ = _prop_index;
							_tmp496_ = _prop_size;
							if (!(_tmp495_ < _tmp496_)) {
								break;
							}
							_tmp497_ = _prop_list;
							_tmp498_ = vala_list_get (_tmp497_, _prop_index);
							prop = (ValaProperty*) _tmp498_;
							_tmp499_ = prop;
							_tmp500_ = vala_property_get_is_abstract (_tmp499_);
							_tmp501_ = _tmp500_;
							if (_tmp501_) {
								ValaSymbol* sym = NULL;
								ValaClass* base_class = NULL;
								ValaSymbol* _tmp514_;
								sym = NULL;
								base_class = self;
								while (TRUE) {
									gboolean _tmp502_ = FALSE;
									ValaClass* _tmp503_;
									ValaClass* _tmp505_;
									ValaScope* _tmp506_;
									ValaScope* _tmp507_;
									ValaProperty* _tmp508_;
									const gchar* _tmp509_;
									const gchar* _tmp510_;
									ValaSymbol* _tmp511_;
									ValaClass* _tmp512_;
									ValaClass* _tmp513_;
									_tmp503_ = base_class;
									if (_tmp503_ != NULL) {
										ValaSymbol* _tmp504_;
										_tmp504_ = sym;
										_tmp502_ = !VALA_IS_PROPERTY (_tmp504_);
									} else {
										_tmp502_ = FALSE;
									}
									if (!_tmp502_) {
										break;
									}
									_tmp505_ = base_class;
									_tmp506_ = vala_symbol_get_scope ((ValaSymbol*) _tmp505_);
									_tmp507_ = _tmp506_;
									_tmp508_ = prop;
									_tmp509_ = vala_symbol_get_name ((ValaSymbol*) _tmp508_);
									_tmp510_ = _tmp509_;
									_tmp511_ = vala_scope_lookup (_tmp507_, _tmp510_);
									_vala_code_node_unref0 (sym);
									sym = _tmp511_;
									_tmp512_ = base_class;
									_tmp513_ = _tmp512_->priv->_base_class;
									base_class = _tmp513_;
								}
								_tmp514_ = sym;
								if (VALA_IS_PROPERTY (_tmp514_)) {
									ValaProperty* base_prop = NULL;
									ValaSymbol* _tmp515_;
									ValaProperty* _tmp516_;
									gchar* invalid_match = NULL;
									gboolean _tmp517_ = FALSE;
									ValaProperty* _tmp518_;
									gboolean _tmp519_;
									gboolean _tmp520_;
									ValaSymbol* _tmp534_;
									ValaVersionAttribute* _tmp535_;
									ValaVersionAttribute* _tmp536_;
									ValaSourceReference* _tmp537_;
									ValaSourceReference* _tmp538_;
									ValaSymbol* _tmp539_;
									_tmp515_ = sym;
									_tmp516_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp515_, VALA_TYPE_PROPERTY, ValaProperty));
									base_prop = _tmp516_;
									invalid_match = NULL;
									_tmp518_ = base_prop;
									_tmp519_ = vala_symbol_get_hides ((ValaSymbol*) _tmp518_);
									_tmp520_ = _tmp519_;
									if (!_tmp520_) {
										ValaProperty* _tmp521_;
										ValaProperty* _tmp522_;
										gchar* _tmp523_ = NULL;
										gboolean _tmp524_;
										_tmp521_ = base_prop;
										_tmp522_ = prop;
										_tmp524_ = vala_property_compatible (_tmp521_, _tmp522_, &_tmp523_);
										_g_free0 (invalid_match);
										invalid_match = _tmp523_;
										_tmp517_ = !_tmp524_;
									} else {
										_tmp517_ = FALSE;
									}
									if (_tmp517_) {
										ValaSourceReference* _tmp525_;
										ValaSourceReference* _tmp526_;
										ValaProperty* _tmp527_;
										gchar* _tmp528_;
										gchar* _tmp529_;
										ValaProperty* _tmp530_;
										gchar* _tmp531_;
										gchar* _tmp532_;
										const gchar* _tmp533_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp525_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
										_tmp526_ = _tmp525_;
										_tmp527_ = prop;
										_tmp528_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp527_);
										_tmp529_ = _tmp528_;
										_tmp530_ = base_prop;
										_tmp531_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp530_);
										_tmp532_ = _tmp531_;
										_tmp533_ = invalid_match;
										vala_report_error (_tmp526_, "Type and/or accessors of inherited properties `%s' and `%s' do not mat" \
"ch: %s.", _tmp529_, _tmp532_, _tmp533_);
										_g_free0 (_tmp532_);
										_g_free0 (_tmp529_);
									}
									_tmp534_ = sym;
									_tmp535_ = vala_symbol_get_version (_tmp534_);
									_tmp536_ = _tmp535_;
									_tmp537_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp538_ = _tmp537_;
									vala_version_attribute_check (_tmp536_, context, _tmp538_);
									_tmp539_ = sym;
									vala_symbol_set_used (_tmp539_, TRUE);
									_g_free0 (invalid_match);
									_vala_code_node_unref0 (base_prop);
								} else {
									ValaSourceReference* _tmp540_;
									ValaSourceReference* _tmp541_;
									gchar* _tmp542_;
									gchar* _tmp543_;
									ValaProperty* _tmp544_;
									gchar* _tmp545_;
									gchar* _tmp546_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp540_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp541_ = _tmp540_;
									_tmp542_ = vala_symbol_get_full_name ((ValaSymbol*) self);
									_tmp543_ = _tmp542_;
									_tmp544_ = prop;
									_tmp545_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp544_);
									_tmp546_ = _tmp545_;
									vala_report_error (_tmp541_, "`%s' does not implement interface property `%s'", _tmp543_, _tmp546_);
									_g_free0 (_tmp546_);
									_g_free0 (_tmp543_);
								}
								_vala_code_node_unref0 (sym);
							}
							_vala_code_node_unref0 (prop);
						}
					}
				}
				_vala_code_node_unref0 (base_type);
			}
		}
		_tmp547_ = self->priv->_is_abstract;
		if (!_tmp547_) {
			ValaClass* base_class = NULL;
			ValaClass* _tmp548_;
			_tmp548_ = self->priv->_base_class;
			base_class = _tmp548_;
			while (TRUE) {
				gboolean _tmp549_ = FALSE;
				ValaClass* _tmp550_;
				ValaClass* _tmp611_;
				ValaClass* _tmp612_;
				_tmp550_ = base_class;
				if (_tmp550_ != NULL) {
					ValaClass* _tmp551_;
					gboolean _tmp552_;
					_tmp551_ = base_class;
					_tmp552_ = _tmp551_->priv->_is_abstract;
					_tmp549_ = _tmp552_;
				} else {
					_tmp549_ = FALSE;
				}
				if (!_tmp549_) {
					break;
				}
				{
					ValaList* _base_method_list = NULL;
					ValaClass* _tmp553_;
					ValaList* _tmp554_;
					gint _base_method_size = 0;
					ValaList* _tmp555_;
					gint _tmp556_;
					gint _tmp557_;
					gint _base_method_index = 0;
					_tmp553_ = base_class;
					_tmp554_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp553_);
					_base_method_list = _tmp554_;
					_tmp555_ = _base_method_list;
					_tmp556_ = vala_collection_get_size ((ValaCollection*) _tmp555_);
					_tmp557_ = _tmp556_;
					_base_method_size = _tmp557_;
					_base_method_index = -1;
					while (TRUE) {
						gint _tmp558_;
						gint _tmp559_;
						ValaMethod* base_method = NULL;
						ValaList* _tmp560_;
						gpointer _tmp561_;
						ValaMethod* _tmp562_;
						gboolean _tmp563_;
						gboolean _tmp564_;
						_base_method_index = _base_method_index + 1;
						_tmp558_ = _base_method_index;
						_tmp559_ = _base_method_size;
						if (!(_tmp558_ < _tmp559_)) {
							break;
						}
						_tmp560_ = _base_method_list;
						_tmp561_ = vala_list_get (_tmp560_, _base_method_index);
						base_method = (ValaMethod*) _tmp561_;
						_tmp562_ = base_method;
						_tmp563_ = vala_method_get_is_abstract (_tmp562_);
						_tmp564_ = _tmp563_;
						if (_tmp564_) {
							ValaMethod* override_method = NULL;
							ValaMethod* _tmp565_;
							const gchar* _tmp566_;
							const gchar* _tmp567_;
							ValaSymbol* _tmp568_;
							ValaMethod* _tmp569_;
							gboolean _tmp570_ = FALSE;
							ValaMethod* _tmp571_;
							_tmp565_ = base_method;
							_tmp566_ = vala_symbol_get_name ((ValaSymbol*) _tmp565_);
							_tmp567_ = _tmp566_;
							_tmp568_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) self, _tmp567_);
							_tmp569_ = VALA_IS_METHOD (_tmp568_) ? ((ValaMethod*) _tmp568_) : NULL;
							if (_tmp569_ == NULL) {
								_vala_code_node_unref0 (_tmp568_);
							}
							override_method = _tmp569_;
							_tmp571_ = override_method;
							if (_tmp571_ == NULL) {
								_tmp570_ = TRUE;
							} else {
								ValaMethod* _tmp572_;
								gboolean _tmp573_;
								gboolean _tmp574_;
								_tmp572_ = override_method;
								_tmp573_ = vala_method_get_overrides (_tmp572_);
								_tmp574_ = _tmp573_;
								_tmp570_ = !_tmp574_;
							}
							if (_tmp570_) {
								ValaSourceReference* _tmp575_;
								ValaSourceReference* _tmp576_;
								gchar* _tmp577_;
								gchar* _tmp578_;
								ValaMethod* _tmp579_;
								gchar* _tmp580_;
								gchar* _tmp581_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp575_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp576_ = _tmp575_;
								_tmp577_ = vala_symbol_get_full_name ((ValaSymbol*) self);
								_tmp578_ = _tmp577_;
								_tmp579_ = base_method;
								_tmp580_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp579_);
								_tmp581_ = _tmp580_;
								vala_report_error (_tmp576_, "`%s' does not implement abstract method `%s'", _tmp578_, _tmp581_);
								_g_free0 (_tmp581_);
								_g_free0 (_tmp578_);
							}
							_vala_code_node_unref0 (override_method);
						}
						_vala_code_node_unref0 (base_method);
					}
				}
				{
					ValaList* _base_property_list = NULL;
					ValaClass* _tmp582_;
					ValaList* _tmp583_;
					gint _base_property_size = 0;
					ValaList* _tmp584_;
					gint _tmp585_;
					gint _tmp586_;
					gint _base_property_index = 0;
					_tmp582_ = base_class;
					_tmp583_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) _tmp582_);
					_base_property_list = _tmp583_;
					_tmp584_ = _base_property_list;
					_tmp585_ = vala_collection_get_size ((ValaCollection*) _tmp584_);
					_tmp586_ = _tmp585_;
					_base_property_size = _tmp586_;
					_base_property_index = -1;
					while (TRUE) {
						gint _tmp587_;
						gint _tmp588_;
						ValaProperty* base_property = NULL;
						ValaList* _tmp589_;
						gpointer _tmp590_;
						ValaProperty* _tmp591_;
						gboolean _tmp592_;
						gboolean _tmp593_;
						_base_property_index = _base_property_index + 1;
						_tmp587_ = _base_property_index;
						_tmp588_ = _base_property_size;
						if (!(_tmp587_ < _tmp588_)) {
							break;
						}
						_tmp589_ = _base_property_list;
						_tmp590_ = vala_list_get (_tmp589_, _base_property_index);
						base_property = (ValaProperty*) _tmp590_;
						_tmp591_ = base_property;
						_tmp592_ = vala_property_get_is_abstract (_tmp591_);
						_tmp593_ = _tmp592_;
						if (_tmp593_) {
							ValaProperty* override_property = NULL;
							ValaProperty* _tmp594_;
							const gchar* _tmp595_;
							const gchar* _tmp596_;
							ValaSymbol* _tmp597_;
							ValaProperty* _tmp598_;
							gboolean _tmp599_ = FALSE;
							ValaProperty* _tmp600_;
							_tmp594_ = base_property;
							_tmp595_ = vala_symbol_get_name ((ValaSymbol*) _tmp594_);
							_tmp596_ = _tmp595_;
							_tmp597_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) self, _tmp596_);
							_tmp598_ = VALA_IS_PROPERTY (_tmp597_) ? ((ValaProperty*) _tmp597_) : NULL;
							if (_tmp598_ == NULL) {
								_vala_code_node_unref0 (_tmp597_);
							}
							override_property = _tmp598_;
							_tmp600_ = override_property;
							if (_tmp600_ == NULL) {
								_tmp599_ = TRUE;
							} else {
								ValaProperty* _tmp601_;
								gboolean _tmp602_;
								gboolean _tmp603_;
								_tmp601_ = override_property;
								_tmp602_ = vala_property_get_overrides (_tmp601_);
								_tmp603_ = _tmp602_;
								_tmp599_ = !_tmp603_;
							}
							if (_tmp599_) {
								ValaSourceReference* _tmp604_;
								ValaSourceReference* _tmp605_;
								gchar* _tmp606_;
								gchar* _tmp607_;
								ValaProperty* _tmp608_;
								gchar* _tmp609_;
								gchar* _tmp610_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp604_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp605_ = _tmp604_;
								_tmp606_ = vala_symbol_get_full_name ((ValaSymbol*) self);
								_tmp607_ = _tmp606_;
								_tmp608_ = base_property;
								_tmp609_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp608_);
								_tmp610_ = _tmp609_;
								vala_report_error (_tmp605_, "`%s' does not implement abstract property `%s'", _tmp607_, _tmp610_);
								_g_free0 (_tmp610_);
								_g_free0 (_tmp607_);
							}
							_vala_code_node_unref0 (override_property);
						}
						_vala_code_node_unref0 (base_property);
					}
				}
				_tmp611_ = base_class;
				_tmp612_ = _tmp611_->priv->_base_class;
				base_class = _tmp612_;
			}
		}
	}
	_tmp613_ = vala_code_context_get_analyzer (context);
	_tmp614_ = _tmp613_;
	_tmp615_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp614_, _tmp615_);
	_tmp616_ = vala_code_context_get_analyzer (context);
	_tmp617_ = _tmp616_;
	_tmp618_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp617_, _tmp618_);
	_tmp619_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp620_ = _tmp619_;
	result = !_tmp620_;
	_vala_iterable_unref0 (missing_prereqs);
	_vala_iterable_unref0 (prerequisites);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

static void
vala_class_class_init (ValaClassClass * klass,
                       gpointer klass_data)
{
	vala_class_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_class_finalize;
	g_type_class_adjust_private_offset (klass, &ValaClass_private_offset);
	((ValaSymbolClass *) klass)->add_field = (void (*) (ValaSymbol*, ValaField*)) vala_class_real_add_field;
	((ValaSymbolClass *) klass)->add_method = (void (*) (ValaSymbol*, ValaMethod*)) vala_class_real_add_method;
	((ValaSymbolClass *) klass)->add_property = (void (*) (ValaSymbol*, ValaProperty*)) vala_class_real_add_property;
	((ValaSymbolClass *) klass)->add_constructor = (void (*) (ValaSymbol*, ValaConstructor*)) vala_class_real_add_constructor;
	((ValaSymbolClass *) klass)->add_destructor = (void (*) (ValaSymbol*, ValaDestructor*)) vala_class_real_add_destructor;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_class_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_class_real_accept_children;
	((ValaTypeSymbolClass *) klass)->is_reference_type = (gboolean (*) (ValaTypeSymbol*)) vala_class_real_is_reference_type;
	((ValaTypeSymbolClass *) klass)->is_subtype_of = (gboolean (*) (ValaTypeSymbol*, ValaTypeSymbol*)) vala_class_real_is_subtype_of;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_class_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_class_real_check;
}

static void
vala_class_instance_init (ValaClass * self,
                          gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashMap* _tmp3_;
	self->priv = vala_class_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->base_types = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_map_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _vala_symbol_hash_func_ghash_func, _vala_symbol_equal_func_gequal_func, _tmp2_);
	self->priv->implicit_implementations = _tmp3_;
}

static void
vala_class_finalize (ValaCodeNode * obj)
{
	ValaClass * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CLASS, ValaClass);
	_vala_code_node_unref0 (self->priv->_base_class);
	_g_free0 (self->priv->_is_compact);
	_g_free0 (self->priv->_is_opaque);
	_g_free0 (self->priv->_is_immutable);
	_g_free0 (self->priv->_is_singleton);
	_vala_iterable_unref0 (self->priv->base_types);
	_vala_map_unref0 (self->priv->implicit_implementations);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	_vala_code_node_unref0 (self->priv->_constructor);
	_vala_code_node_unref0 (self->priv->_class_constructor);
	_vala_code_node_unref0 (self->priv->_static_constructor);
	_vala_code_node_unref0 (self->priv->_destructor);
	_vala_code_node_unref0 (self->priv->_class_destructor);
	_vala_code_node_unref0 (self->priv->_static_destructor);
	VALA_CODE_NODE_CLASS (vala_class_parent_class)->finalize (obj);
}

/**
 * Represents a class declaration in the source code.
 */
static GType
vala_class_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaClassClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_class_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaClass), 0, (GInstanceInitFunc) vala_class_instance_init, NULL };
	GType vala_class_type_id;
	vala_class_type_id = g_type_register_static (VALA_TYPE_OBJECT_TYPE_SYMBOL, "ValaClass", &g_define_type_info, 0);
	ValaClass_private_offset = g_type_add_instance_private (vala_class_type_id, sizeof (ValaClassPrivate));
	return vala_class_type_id;
}

GType
vala_class_get_type (void)
{
	static volatile gsize vala_class_type_id__once = 0;
	if (g_once_init_enter (&vala_class_type_id__once)) {
		GType vala_class_type_id;
		vala_class_type_id = vala_class_get_type_once ();
		g_once_init_leave (&vala_class_type_id__once, vala_class_type_id);
	}
	return vala_class_type_id__once;
}

